/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.xml;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.PDQDB2Types;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class XmlTags {
    public static final String INTERFACE_NAME = "interface";
    public static final String INTERFACENAME = "name";
    public static final String INTERFACE_RESULT = "result";
    public static final String INTERFACE_DETAILS = "details";
    public static final String INTERFACE_ROOT_PATH = "rootPath";
    public static final String INTERFACE_OPTIONS_FILE = "optionsFile";
    public static final String INTERFACE_URL = "url";
    public static final String INTERFACE_USERCLASS_PATH = "userClasspath";
    public static final String INTERFACE_COLLECTION = "collection";
    public static final String INTERFACE_ROOT = "pureQueryGeneratorLog";
    public static final String RESULT = "result";
    public static final String RESULT_VALUE = "value";
    public static final String BATCH_RESULT = "batchResult";
    public static final String BATCH_RESULT_SUCCESS = "success";
    public static final String BATCH_RESULT_FAILURE = "failure";
    public static final String EXCEPTION = "exception";
    public static final String EXCEPTION_SQLCODE = "sqlCode";
    public static final String EXCEPTION_SQLSTATE = "sqlState";
    public static final String EXCEPTION_SQLMESSAGE = "message";
    public static final String EXCEPTION_SQLSTATEMENT_TEXT = "sqlStatement";
    public static final String EXCEPTION_CAUSEDBY = "causedBy";
    public static final String CRLF = XmlTags.getCrLf();
    public static final String PDQ_NAMESPACE_v3 = "http://www.ibm.com/xmlns/prod/optim/pureQuery/programSetV3";
    public static final String PDQ_NAMESPACE_v4 = "http://www.ibm.com/xmlns/prod/optim/pureQuery/programSetV4";
    public static final String PDQ_CURRENT_NAMESPACE = "http://www.ibm.com/xmlns/prod/optim/pureQuery/programSetV4";
    public static final String XMLNS = "xmlns";
    public static final String ID = "id";
    public static final String STATEMENT_DESCRIPTOR = "statementDescriptor";
    public static final String STATEMENT = "statement";
    public static final String STATEMENT_METADATA = "statementMetadata";
    public static final String STATEMENTS = "statements";
    public static final String STATEMENT_SET = "statementSet";
    public static final String SQL = "sql";
    public static final String PREPARE_SQL = "prepareSql";
    public static final String METHOD_NAME = "methodName";
    public static final String METHOD_SIGNATURE = "signature";
    public static final String STATEMENT_TYPE = "statementType";
    public static final String AUTO_GEN_COLUMNS = "autoGeneratedColumnNames";
    public static final String COLUMN_NAME = "columnName";
    public static final String PARAMETER_HANDLER_NAME = "parameterHandlerName";
    public static final String PARAMETER_METADATA = "parameterMetadata";
    public static final String RESULT_HANDLER_NAME = "resultHandlerName";
    public static final String ROW_HANDLER_NAME = "rowHandlerName";
    public static final String CALL_HANDLER_NAME = "callHandlerName";
    public static final String CAPTURE_RECORD = "captureRecord";
    public static final String PARAMETER = "parameter";
    public static final String PRECISION = "precision";
    public static final String JDBC_TYPE = "jdbcType";
    public static final String SCALE = "scale";
    public static final String PARAMETER_MODE = "parameterMode";
    public static final String NULLABLE = "nullable";
    public static final String LENGTH = "length";
    public static final String STRING_UNITS = "maxStringUnitBits";
    public static final String PROGRAMSET = "programSet";
    public static final String VERSION = "version";
    public static final String PACKAGE = "package";
    public static final String COLLECTION = "collection";
    public static final String BIND_OPTIONS = "bindOptions";
    public static final String LAST_CURSOR_INDEX = "lastCursorIndex";
    public static final String LAST_SQL_INDEX = "lastSqlIndex";
    public static final String NON_PARMETERIZED_SQL_COUNT = "nonParameterizedSqlCount";
    public static final String NON_CAPTURED_NON_PARMETER_SQL_COUNT = "nonCapturedNonParameterSqlCount";
    public static final String PROCESSED_SQL = "processedSql";
    public static final String QUERY = "QUERY";
    @Deprecated
    public static final String SINGLE_ROW_QUERY = "SINGLE_ROW_QUERY";
    public static final String INSERT = "INSERT";
    public static final String DELETE = "DELETE";
    public static final String UPDATE = "UPDATE";
    public static final String MERGE = "MERGE";
    public static final String CALL = "CALL";
    public static final String DECLARE_GLOBAL_TEMP_TABLE = "DECLAREGLOBALTEMPTABLE";
    public static final String CREATE = "CREATE";
    public static final String DROP = "DROP";
    public static final String ALTER = "ALTER";
    public static final String GRANT = "GRANT";
    public static final String REVOKE = "REVOKE";
    public static final String COMMENT = "COMMENT";
    public static final String LABEL = "LABEL";
    public static final String RENAME = "RENAME";
    public static final String XQUERY = "XQUERY";
    public static final String OTHER_SQL = "OTHERSQL";
    public static final String SET = "SET";
    public static final String VALUES = "VALUES";
    public static final String COMPOUND = "COMPOUND";
    public static final String SET_METHOD = "SET_METHOD";
    private static final HashMap<String, SqlStatementType> xmlTagToSqlStatementTypeMap_ = new HashMap();
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String PREPARE_OPTIONS = "prepareOptions";
    public static final String MULTI_ROW_PARAMETERS = "MULTI_ROW_PARAMETERS";
    public static final String SINGLE_ROW_PARAMETERS = "SINGLE_ROW_PARAMETERS";
    public static final String ISARRAY = "isArray";
    public static final String SQLX_UPDATABLE = "updatable";
    public static final String SQLX_RDBNAM = "databaseName";
    public static final String SQLX_SCHEMA = "databaseSchema";
    public static final String SQLX_BASENAME = "tableName";
    public static final String SQLX_OPTLCK = "optimisticLock";
    public static final String COLUMN_LABEL = "columnLabel";
    public static final String COLUMN_NAMEX = "columnNameX";
    public static final String SQLUNNAMEDS = "unnamedColumn";
    public static final String POSITIONED_UPDATE_CURSOR = "positionedUpdateCursor";
    public static final String REFERENCED_QUERY = "referencedQuery";
    public static final String EXECUTION_COUNT = "executionCount";
    public static final String DB2_TYPE = "db2type";
    public static final String CAPTURE_STATISTICS = "captureStatistics";
    public static final String FIRST_USED_TS = "firstUsedTimestamp";
    public static final String STMT_EXEC_TIME = "maxStmtExecutionTime";
    public static final String BATCH_EXEC_TIME = "batchExecutionTime";
    public static final String BATCH_COUNT = "maxBatchCount";
    public static final String AUTO_GENERATED_COLUMN_INDEXES = "autoGeneratedColumnIndexes";
    public static final String COLUMN_INDEX = "columnIndex";
    public static final String AUTO_GENERATED_COLUMN_INDICATOR = "autoGeneratedcolumnIndicator";
    public static final int GENERATED_KEYS_NOT_MENTIONED_IN_METHOD_SIGNATURE = 0;
    public static final int GENERATED_KEYS_REQUESTED_WITH_ARRAY = -1;
    public static final String TRACEINFO = "traceInfo";
    public static final String CLASSFILE = "classFile";
    public static final String METHOD = "method";
    public static final String LINENO = "lineNo";
    public static final String TRACEENTRY = "traceEntry";
    public static final String CONTAININGPKG = "containingPkg";
    public static final String FILENAME = "fileName";
    public static final String ISNATIVE = "isNative";
    public static final String TRACEENTRY_VALUE_UNKNOWN_SOURCE = "Unknown Source";
    public static final String CONSISTENCY_TOKEN = "consistencyToken";
    public static final String GREATEST_SECTION_NUMBER_USED_WHEN_CONSISTENCY_TOKEN_SET = "greatestSectionNumberUsed";
    public static final String SECTION_NUMBER = "sectionNumber";
    public static final String RESERVED_SECTION_COUNT = "numReservedSections";
    public static final String RESULTSET_METADATA = "resultSetMetadata";
    public static final String COLUMN = "column";
    public static final String CCSID = "ccsid";
    public static final String RESULTSET_HOLDABILITY = "resultSetHoldability";
    public static final String RESULTSET_CONCURRENCY = "resultSetConcurrency";
    public static final String RESULTSET_TYPE = "resultSetType";
    public static final String FORCE_HOLD_CURSOR = "forceHoldCursor";
    public static final String NAME = "name";
    public static final String STATEMENT_ATTRIBUTES = "statementAttributes";
    public static final String ORIGIN_ENVIRONMENT = "originEnvironment";
    public static final String ORIGIN = "origin";
    public static final String DRIVER = "driver";
    public static final String DATABASE = "database";
    public static final String ORIGIN_TYPE = "originType";
    public static final String ORIGIN_VERSION = "originVersion";
    public static final String ORIGIN_TYPE_PUREQUERY_API = "pureQueryAPI";
    public static final String ORIGIN_TYPE_OPEN_JPA = "OpenJPA";
    public static final String ORIGIN_TYPE_DWS = "DWS";
    public static final String ORIGIN_TYPE_CLIENT_OPTIMIZER = "ClientOptimizer";
    public static final String ORIGIN_TYPE_PUREQUERY_CAPTURE = "pureQueryCapture";
    public static final String ORIGIN_TYPE_CLI = "pureQueryCaptureCLI";
    public static final String ORIGIN_TYPE_NET = "pureQueryCaptureDotNET";
    public static final String BASE_INCREMENTS = "baseIncrements";
    public static final String SQL_INCREMENTS = "sqlIncrements";
    public static final String BASE_SQLID = "baseSqlID";
    public static final String DEFINITION_TRACE = "defTrace";
    public static final String EXECUTION_TRACE = "exeTrace";
    public static final String DELTAEXECUTION_COUNT = "deltaExecutionCount";
    public static final String MRI_INDICATOR = "mriIndicator";
    public static final String LAST_TIMESTAMP = "lastUsedTimestamp";
    public static final String LAST_TIMESTAMP_ATTR = "lastExecutionTime";
    public static final String PUREQUERYXML = "pureQueryXml";
    public static final String RUNTIME_GROUP_ID = "runtimeGroupID";
    public static final String INCREMENTAL_SPECIAL_REGISTER_VALUE_USED = "incrementalSpecialRegValuesUsed";
    public static final String SPECIAL_REGISTER_VALUES_USED = "specialRegValuesUsed";
    public static final String ORIGIN_TYPE_SIMULATED_CAPTURE = "pureQuerySimulatedCapture";
    public static final String IS_SET_USED_AFTER_CONNECTION_INIT = "isSETUsedAfterConnectionInit";
    public static final String DRIVER_TYPE = "driverType";
    public static final String DRIVER_NAME = "driverName";
    public static final String DRIVER_VERSION = "driverVersion";
    public static final String DRIVER_MAJOR_VERSION = "driverMajorVersion";
    public static final String DRIVER_MINOR_VERSION = "driverMinorVersion";
    public static final String DB_PRODUCT_NAME = "dbProductName";
    public static final String DB_PRODUCT_VERSION = "dbProductVersion";
    public static final String DB_PRODUCT_MAJOR_VERSION = "dbProductMajorVersion";
    public static final String DB_PRODUCT_MINOR_VERSION = "dbProductMinorVersion";
    public static final String CONNECTION = "connection";
    public static final String SR_VALUE_SET = "specialRegValuesSet";
    public static final String SR_VALUE_ELEMENT = "specialRegValue";
    public static final String SR_VALUE_ID = "specialRegValueId";
    public static final String SR_VALUE_VECTOR = "specialRegisterVectorValue";
    public static final String CONNECTION_URL = "url";
    public static final String CONNECTION_URL_STRING = "urlString";
    public static final String CONNECTION_USER_NAME = "connectionUserName";
    public static final String CONNECTION_SCHEMA = "connectionSchema";
    public static final String IPNAME = "ipName";
    public static final String PORT = "port";
    public static final String DBNAME = "databaseName";
    public static final String PROPERTIES = "properties";
    public static final String SQL_LITERAL_SUBSTITUTION = "sqlLiteralSubstitution";
    public static final String SQL_LITERAL_SUBSTITUTION_NOT_SET = "NOT_SET";
    public static final String SQL_LITERAL_SUBSTITUTION_ENABLE = "ENABLE";
    public static final String SQL_LITERAL_SUBSTITUTION_ENABLE_PARAMETERS = "ENABLE_WITH_PARAMETERS";
    public static final String SQL_LITERAL_SUBSTITUTION_DISABLE = "DISABLE";
    public static final String CAPTURE_TIME_PROPERTIES = "captureTimeProperties";
    public static final String JAVA_METHOD = "javaMethod";
    public static final String SOURCE_CODE_LINE_NUMBER = "sourceCodeLineNumber";
    public static final String ANNOTATION = "annotation";
    public static final String ORM_FILE_METHOD_INFO = "ormFileMethodInfo";
    public static final String NAMED_NATIVE_QUERY = "namedNativeQuery";
    public static final String NAMED_QUERY = "namedQuery";
    public static final String DEFINED_IN_FILE = "definedInFile";
    public static final String DEFINED_IN_CLASS = "definedInClass";
    public static final String OBJECT_QUERY = "objectQuery";
    public static final String LINE = "line";
    public static final String ENTITY = "entity";
    public static final String EAGER_FIELDS = "eagerFields";
    public static final String OPERATION = "operation";
    public static final String FETCH_GROUP = "fetchGroup";
    public static final String HINTS = "hints";
    public static final String HINT = "hint";
    public static final String VALUE = "value";
    public static final String PATTERN = "pattern";
    public static final String SELECT_ANNOTATION = "Select";
    public static final String UPDATE_ANNOTATION = "Update";
    public static final String CALL_ANNOTATION = "Call";
    public static final String PARAMETER_TYPE = "parameterType";
    public static final String ROW_TYPE = "rowType";
    public static final String CURSOR_NAME = "cursorName";
    public static final String CREATION_TIME = "creationTime";
    public static final String ALLOW_STATIC_ROWSET_CURSORS = "allowStaticRowsetCursors";
    public static final String SOURCE_FILE = "sourceFile";
    public static final String CONTAINER = "container";
    public static final String COMPLETE_PATH = "completePath";
    public static final String JAVA_INTERFACE = "javaInterface";
    public static final String STATEMENT_SET_METADATA = "statementSetMetaData";
    public static final String ORM_FILE = "ormFile";
    public static final String ORM_FILE_NAME = "ormFileName";
    public static final String ORM_FILE_DATE = "ormFileDate";
    public static final String ANNOTATION_TYPE = "type";
    public static final String IS_BINDABLE = "isBindable";
    public static final String IS_VALID = "isValid";
    public static final String IS_DDLPACKAGE = "isDDLPackage";
    public static final String SQLDEFINITIONSTACKTRACES = "sqlDefinitionStackTraces";
    public static final String SQLEXECUTIONSTACKTRACES = "sqlExecutionStackTraces";
    public static final String TRACE = "trace";
    public static final String SQL_GROUPED_BY_SPECIAL_REGISTERS = "SQLGroupedBySpecialRegisters";
    public static final String ATTR_NO_SRINFO = "NO_SRINFO";
    public static final String ATTR_MULTI_SRINFO = "MULTI_SRINFO";
    public static final String ATTR_INCONSISTENT_SRINFO = "INCONSISTENT_SRINFO";
    public static final String SQL_GROUPED_BY_STRINGS = "SQLGroupedByStrings";
    public static final String SQL_GROUPED_BY_JAVAPACKAGES = "SQLGroupedByJavaPackages";
    public static final String MAX_ROWS = "maxRows";
    public static final String INCREMENTAL_MAX_ROWS = "incrementalMaxRows";
    public static final String CONFIGURE_STATUS = "configureStatus";
    public static final String REQUIRED = "REQUIRED";
    public static final String FINAL = "FINAL";
    public static final String AUTO = "AUTO";
    public static final String INCREMENTAL_CAPTURE_TOOL = "IncrementalCapture";
    public static final String CONFIGURE_TOOL = "Configure";
    public static final String MERGE_TOOL = "Merge";
    public static final String FORCE_SINGLE_BIND_ISOLATION = "forceSingleBindIsolation";
    public static final boolean DEFAULT_ALLOW_STATIC_ROWSET_CURSORS = false;
    public static final int DEFAULT_RESULTSET_CONCURRENCY = 1007;
    public static final int DEFAULT_RESULTSET_TYPE = 1003;
    public static final int DEFAULT_RESULTSET_HOLDABILITY_CLIENT_OPTIMIZER = 1;
    public static final int DEFAULT_RESULTSET_HOLDABILITY_PDQ_API = 2;
    public static final int DEFAULT_AGK_INDICATOR = 0;
    public static final int DEFAULT_GREATEST_SECTION_NUMBER_USED = 0;
    public static final long DEFAULT_CONSISTENCY_TOKEN_LONG = 0L;
    public static HashMap<Integer, String> spaceCache;
    private static final String holdCursorsOverCommit = "HOLD_CURSORS_OVER_COMMIT";
    private static final String closeCursorsAtCommit = "CLOSE_CURSORS_AT_COMMIT";
    private static final String concurUpdatable = "CONCUR_UPDATABLE";
    private static final String concurReadOnly = "CONCUR_READ_ONLY";
    private static final String typeForwardOnly = "TYPE_FORWARD_ONLY";
    private static final String typeScrollSensitive = "TYPE_SCROLL_SENSITIVE";
    private static final String typeScrollInsensitive = "TYPE_SCROLL_INSENSITIVE";

    public static String getStatementTypeXmlTag(SqlStatementType sqlStatementType) {
        switch (sqlStatementType) {
            case QUERY: {
                return QUERY;
            }
            case INSERT: {
                return INSERT;
            }
            case DELETE: {
                return DELETE;
            }
            case UPDATE: {
                return UPDATE;
            }
            case MERGE: {
                return MERGE;
            }
            case CALL: {
                return CALL;
            }
            case DECLAREGLOBALTEMPTABLE: {
                return DECLARE_GLOBAL_TEMP_TABLE;
            }
            case CREATE: {
                return CREATE;
            }
            case DROP: {
                return DROP;
            }
            case ALTER: {
                return ALTER;
            }
            case GRANT: {
                return GRANT;
            }
            case REVOKE: {
                return REVOKE;
            }
            case COMMENT: {
                return COMMENT;
            }
            case LABEL: {
                return LABEL;
            }
            case RENAME: {
                return RENAME;
            }
            case XQUERY: {
                return XQUERY;
            }
            case SET: {
                return SET;
            }
            case VALUES: {
                return VALUES;
            }
            case COMPOUND: {
                return COMPOUND;
            }
            case OTHERSQL: {
                return OTHER_SQL;
            }
            case SET_METHOD: {
                return SET_METHOD;
            }
        }
        return OTHER_SQL;
    }

    public static SqlStatementType getStatementTypeFromXmlTag(String string) {
        SqlStatementType sqlStatementType = xmlTagToSqlStatementTypeMap_.get(string);
        if (null == sqlStatementType) {
            sqlStatementType = SqlStatementType.OTHERSQL;
        }
        return sqlStatementType;
    }

    private static String getCrLf() {
        return XmlTags.getSystemProperty("line.separator");
    }

    public static String space(int n2) {
        if (n2 == 0) {
            return "";
        }
        String string = spaceCache.get(n2);
        if (string != null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i10 = 0; i10 < n2; ++i10) {
            stringBuilder.append(' ');
        }
        string = stringBuilder.toString();
        spaceCache.put(n2, string);
        return string;
    }

    public static String escapeElement(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("&", "&amp;").replace("<", "&lt;").replace("\r\n", "&#13;\r\n");
    }

    public static String unescapeElement(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(38) == -1) {
            return string;
        }
        return string.replace("&lt;", "<").replace("&amp;", "&");
    }

    public static String escapeAttrib(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("&", "&amp;").replace("<", "&lt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    public static String unescapeAttrib(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(38) == -1) {
            return string;
        }
        return string.replace("&apos;", "'").replace("&quot;", "\"").replace("&lt;", "<").replace("&", "&amp;");
    }

    public static boolean getValueOfBoolean(String string, boolean bl2) {
        if (null == string || 0 == string.length()) {
            return bl2;
        }
        if (TRUE.equalsIgnoreCase(string)) {
            return true;
        }
        if (FALSE.equalsIgnoreCase(string)) {
            return false;
        }
        return false;
    }

    public static String getStringValueOfBoolean(boolean bl2) {
        return bl2 ? TRUE : FALSE;
    }

    public static String getDB2NameFromDB2TypeNumber(int n2) {
        String string = PDQDB2Types.mapDriverTypeToSqlTypeName(n2);
        if (string == null) {
            return String.valueOf(n2);
        }
        return string;
    }

    public static int getDB2TypeNumber(String string) throws NumberFormatException {
        Integer n2 = PDQDB2Types.sqlTypeNameToDriverTypeMap.get(string);
        if (n2 != null) {
            return n2;
        }
        return Integer.parseInt(string);
    }

    public static int getDB2TypeNumberFromJdbcType(int n2, String string) {
        switch (n2) {
            case 1111: {
                if ("XML".equalsIgnoreCase(string)) {
                    return 2009;
                }
                if ("ROWID".equalsIgnoreCase(string)) {
                    return -8;
                }
                if (!"DECFLOAT".equalsIgnoreCase(string)) break;
                return -100001;
            }
            case 1: {
                if (!"GRAPHIC".equalsIgnoreCase(string)) break;
                return 503;
            }
            case 2005: {
                if (!"DBCLOB".equalsIgnoreCase(string)) break;
                return 502;
            }
            case 12: {
                if (!"VARGRAPHIC".equalsIgnoreCase(string)) break;
                return 504;
            }
            case -1: {
                if (!"LONG VARGRAPHIC".equalsIgnoreCase(string)) break;
                return 505;
            }
        }
        return n2;
    }

    public static String getHoldabilityName(int n2) {
        if (1 == n2) {
            return holdCursorsOverCommit;
        }
        if (2 == n2) {
            return closeCursorsAtCommit;
        }
        String string = ResultSet.class.getCanonicalName() + ".";
        String string2 = string + holdCursorsOverCommit + ", " + string + closeCursorsAtCommit;
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_GETHOLDABILITY_INVALID", n2, string2), null, 10686);
    }

    public static int getHoldabilityNumber(String string, int n2) {
        if (holdCursorsOverCommit.equals(string)) {
            return 1;
        }
        if (closeCursorsAtCommit.equals(string)) {
            return 2;
        }
        if (!StaticProfileConstants.isValueSet(string)) {
            return n2;
        }
        String string2 = "HOLD_CURSORS_OVER_COMMIT, CLOSE_CURSORS_AT_COMMIT";
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_GETHOLDABILITY_INVALID", string, string2), null, 10685);
    }

    public static String getConcurrencyName(int n2) {
        if (1008 == n2) {
            return concurUpdatable;
        }
        if (1007 == n2) {
            return concurReadOnly;
        }
        String string = ResultSet.class.getCanonicalName() + ".";
        String string2 = string + concurReadOnly + ", " + string + concurUpdatable;
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_GETHOLDABILITY_INVALID", n2, string2), null, 10684);
    }

    public static int getConcurrencyNumber(String string) {
        if (concurUpdatable.equals(string)) {
            return 1008;
        }
        if (concurReadOnly.equals(string)) {
            return 1007;
        }
        if (!StaticProfileConstants.isValueSet(string)) {
            return 1007;
        }
        String string2 = "CONCUR_READ_ONLY, CONCUR_UPDATABLE";
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_GETHOLDABILITY_INVALID", string, string2), null, 10683);
    }

    public static final String getCursorTypeName(int n2) {
        if (1005 == n2) {
            return typeScrollSensitive;
        }
        if (1004 == n2) {
            return typeScrollInsensitive;
        }
        if (1003 == n2) {
            return typeForwardOnly;
        }
        String string = ResultSet.class.getCanonicalName() + ".";
        String string2 = string + typeForwardOnly + ", " + string + typeScrollSensitive + ", " + string + typeScrollInsensitive;
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_GETHOLDABILITY_INVALID", n2, string2), null, 10682);
    }

    public static int getCursorTypeNumber(String string) {
        if (typeScrollSensitive.equals(string)) {
            return 1005;
        }
        if (typeScrollInsensitive.equals(string)) {
            return 1004;
        }
        if (typeForwardOnly.equals(string)) {
            return 1003;
        }
        if (!StaticProfileConstants.isValueSet(string)) {
            return 1003;
        }
        String string2 = "TYPE_FORWARD_ONLY, TYPE_SCROLL_SENSITIVE, TYPE_SCROLL_INSENSITIVE";
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_GETTYPE_INVALID", string, string2), null, 10681);
    }

    public static int getCursorAttributeNumber(PossibleArgs.PredefinedOptionValues predefinedOptionValues) {
        switch (predefinedOptionValues) {
            case TYPE_FORWARD_ONLY: {
                return 1003;
            }
            case TYPE_SCROLL_SENSITIVE: {
                return 1005;
            }
            case TYPE_SCROLL_INSENSITIVE: {
                return 1004;
            }
            case CONCUR_READ_ONLY: {
                return 1007;
            }
            case CONCUR_UPDATABLE: {
                return 1008;
            }
            case HOLD_CURSORS_OVER_COMMIT: {
                return 1;
            }
            case CLOSE_CURSORS_AT_COMMIT: {
                return 2;
            }
        }
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11155);
    }

    public static String getParameterDirectionName(int n2) {
        if (1 == n2) {
            return "IN";
        }
        if (4 == n2) {
            return "OUT";
        }
        if (2 == n2) {
            return "INOUT";
        }
        return String.valueOf(n2);
    }

    public static int getParameterDirectionNumber(String string) {
        if (string == null || string.length() == 0) {
            return 1;
        }
        if ("IN".equals(string)) {
            return 1;
        }
        if ("OUT".equals(string)) {
            return 4;
        }
        if ("INOUT".equals(string)) {
            return 2;
        }
        return Integer.parseInt(string);
    }

    public static String[] explode(String string, String string2) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String implode(String[] stringArray, String string) {
        if (stringArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 0) {
            stringBuilder.append(stringArray[0]);
            for (int i10 = 1; i10 < stringArray.length; ++i10) {
                stringBuilder.append(string);
                stringBuilder.append(stringArray[i10]);
            }
        }
        return stringBuilder.toString();
    }

    public static String getStatementAttributesParameterTypeName(int n2) {
        switch (n2) {
            case 1: {
                return SINGLE_ROW_PARAMETERS;
            }
            case 2: {
                return MULTI_ROW_PARAMETERS;
            }
            case 3: {
                return "NO_PARAMETERS";
            }
        }
        return String.valueOf(n2);
    }

    public static int getStatementAttributesParameterTypeNumber(String string) {
        if (SINGLE_ROW_PARAMETERS.equals(string)) {
            return 1;
        }
        if (MULTI_ROW_PARAMETERS.equals(string)) {
            return 2;
        }
        if ("NO_PARAMETERS".equals(string)) {
            return 3;
        }
        return Integer.parseInt(string);
    }

    public static String getStatementAttributesRowTypeName(int n2) {
        switch (n2) {
            case 4: {
                return "SINGLE_ROW_RESULT";
            }
            case 5: {
                return "MULTI_ROW_RESULT";
            }
        }
        return String.valueOf(n2);
    }

    public static int getStatementAttributesRowTypeNumber(String string) {
        if ("SINGLE_ROW_RESULT".equals(string)) {
            return 4;
        }
        if ("MULTI_ROW_RESULT".equals(string)) {
            return 5;
        }
        return Integer.parseInt(string);
    }

    private static String getSystemProperty(String string) {
        return System.getProperty(string);
    }

    static {
        xmlTagToSqlStatementTypeMap_.put(ALTER, SqlStatementType.ALTER);
        xmlTagToSqlStatementTypeMap_.put(CALL, SqlStatementType.CALL);
        xmlTagToSqlStatementTypeMap_.put(COMMENT, SqlStatementType.COMMENT);
        xmlTagToSqlStatementTypeMap_.put(COMPOUND, SqlStatementType.COMPOUND);
        xmlTagToSqlStatementTypeMap_.put(CREATE, SqlStatementType.CREATE);
        xmlTagToSqlStatementTypeMap_.put(DECLARE_GLOBAL_TEMP_TABLE, SqlStatementType.DECLAREGLOBALTEMPTABLE);
        xmlTagToSqlStatementTypeMap_.put(DELETE, SqlStatementType.DELETE);
        xmlTagToSqlStatementTypeMap_.put(DROP, SqlStatementType.DROP);
        xmlTagToSqlStatementTypeMap_.put(GRANT, SqlStatementType.GRANT);
        xmlTagToSqlStatementTypeMap_.put(INSERT, SqlStatementType.INSERT);
        xmlTagToSqlStatementTypeMap_.put(LABEL, SqlStatementType.LABEL);
        xmlTagToSqlStatementTypeMap_.put(MERGE, SqlStatementType.MERGE);
        xmlTagToSqlStatementTypeMap_.put(OTHER_SQL, SqlStatementType.OTHERSQL);
        xmlTagToSqlStatementTypeMap_.put(QUERY, SqlStatementType.QUERY);
        xmlTagToSqlStatementTypeMap_.put(RENAME, SqlStatementType.RENAME);
        xmlTagToSqlStatementTypeMap_.put(REVOKE, SqlStatementType.REVOKE);
        xmlTagToSqlStatementTypeMap_.put(SET, SqlStatementType.SET);
        xmlTagToSqlStatementTypeMap_.put(SET_METHOD, SqlStatementType.SET_METHOD);
        xmlTagToSqlStatementTypeMap_.put(SINGLE_ROW_QUERY, SqlStatementType.SINGLE_ROW_QUERY);
        xmlTagToSqlStatementTypeMap_.put(UPDATE, SqlStatementType.UPDATE);
        xmlTagToSqlStatementTypeMap_.put(VALUES, SqlStatementType.VALUES);
        xmlTagToSqlStatementTypeMap_.put(XQUERY, SqlStatementType.XQUERY);
        spaceCache = new HashMap();
    }
}

