/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import org.beetl.core.ByteWriter;
import org.beetl.core.Configuration;
import org.beetl.core.Context;
import org.beetl.core.ErrorHandler;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.cache.ContextBuffer;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.io.ByteWriter_Byte;
import org.beetl.core.io.ByteWriter_Char;
import org.beetl.core.io.NoLockStringWriter;
import org.beetl.core.misc.BeetlUtil;
import org.beetl.core.statement.AjaxStatement;
import org.beetl.core.statement.ErrorGrammarProgram;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Program;
import org.beetl.core.statement.ProgramMetaData;

public class Template {
    public Program program;
    public Configuration cf;
    public GroupTemplate gt;
    public boolean isRoot = true;
    public String ajaxId = null;
    public Context ctx = null;
    public Resource resource = null;

    protected Template(GroupTemplate gt, Program program, Resource resource, Configuration cf) {
        this.program = program;
        this.cf = cf;
        this.gt = gt;
        this.ctx = new Context(gt);
        if (cf.safeOutput) {
            this.ctx.safeOutput = true;
        }
        this.resource = resource;
    }

    protected Template(GroupTemplate gt, Program program, Resource resource, Configuration cf, ContextBuffer buffer) {
        this.program = program;
        this.cf = cf;
        this.gt = gt;
        this.ctx = new Context(gt, buffer);
        if (cf.safeOutput) {
            this.ctx.safeOutput = true;
        }
        this.resource = resource;
    }

    public String render() throws BeetlException {
        NoLockStringWriter sw = new NoLockStringWriter();
        this.renderTo(sw);
        return sw.toString();
    }

    public void renderTo(Writer writer) throws BeetlException {
        ByteWriter_Char byteWriter = new ByteWriter_Char(writer, this.cf.charset, this.ctx);
        this.renderTo(byteWriter);
    }

    public void renderTo(OutputStream os) throws BeetlException {
        ByteWriter_Byte byteWriter = new ByteWriter_Byte(os, this.cf.charset, this.ctx);
        this.renderTo(byteWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderTo(ByteWriter byteWriter) {
        try {
            this.ctx.byteWriter = byteWriter;
            this.ctx.byteOutputMode = this.cf.directByteOutput;
            this.ctx.gt = this.gt;
            this.ctx.template = this;
            if (this.gt.sharedVars != null) {
                for (Map.Entry<String, Object> entry : this.gt.sharedVars.entrySet()) {
                    this.ctx.set(entry.getKey(), entry.getValue());
                }
            }
            if (this.ajaxId != null) {
                if (!(this.program instanceof ErrorGrammarProgram)) {
                    AjaxStatement ajax = this.program.metaData.getAjax(this.ajaxId);
                    if (ajax == null) {
                        BeetlException be = new BeetlException("AJAX_NOT_FOUND");
                        be.pushToken(new GrammarToken(this.ajaxId, 0, 0));
                        throw be;
                    }
                    ProgramMetaData localMetaData = ajax.getLocalProgramMetaData();
                    localMetaData.initContext(this.ctx);
                    Program ajaxProgram = new Program();
                    ajaxProgram.metaData = localMetaData;
                    ajaxProgram.resourceId = this.program.resourceId;
                    ajaxProgram.execute(this.ctx);
                } else {
                    this.program.metaData.initContext(this.ctx);
                    this.program.execute(this.ctx);
                }
            } else {
                this.program.metaData.initContext(this.ctx);
                this.program.execute(this.ctx);
            }
            if (this.isRoot) {
                byteWriter.flush();
            }
        }
        catch (BeetlException e) {
            if (!(this.program instanceof ErrorGrammarProgram)) {
                e.pushResource(this.resource);
            }
            if (!this.isRoot) {
                throw e;
            }
            if (e.detailCode == "CLIENT_IO_ERROR_ERROR" && this.ctx.gt.conf.isIgnoreClientIOError) {
                return;
            }
            Writer w = BeetlUtil.getWriterByByteWriter(this.ctx.byteWriter);
            e.cr = this.program.metaData.lineSeparator;
            ErrorHandler errorHandler = this.gt.getErrorHandler();
            if (errorHandler == null) {
                throw e;
            }
            errorHandler.processException(e, this.gt, w);
            try {
                this.ctx.byteWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            if (!this.ctx.gt.conf.isIgnoreClientIOError) {
                BeetlException be = new BeetlException("CLIENT_IO_ERROR_ERROR", e.getMessage(), e);
                be.pushResource(this.resource);
                be.pushToken(new GrammarToken(this.resource.id.toString(), 0, 0));
                ErrorHandler errorHandler = this.gt.getErrorHandler();
                if (errorHandler == null) {
                    throw be;
                }
                Writer w = BeetlUtil.getWriterByByteWriter(this.ctx.byteWriter);
                errorHandler.processException(be, this.gt, w);
                try {
                    this.ctx.byteWriter.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (this.isRoot) {
                this.ctx.destroy();
            }
        }
    }

    @Deprecated
    public void binding(String varName, Object o, boolean dynamic) {
        this.ctx.set(varName, o);
    }

    public void binding(String varName, Object o) {
        this.ctx.set(varName, o);
    }

    public void binding(Map map) {
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            this.binding((String)entry.getKey(), entry.getValue());
        }
    }

    public void fastBinding(Map map) {
        this.ctx.globalVar = map;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public BeetlException validate() {
        if (!(this.program instanceof ErrorGrammarProgram)) {
            return null;
        }
        ErrorGrammarProgram error = (ErrorGrammarProgram)this.program;
        return error.getException();
    }
}

