/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.beetl.core.BlockEnvContext;
import org.beetl.core.VarDescription;
import org.beetl.core.statement.ASTNode;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.IVarIndex;
import org.beetl.core.statement.Statement;

public class ProgramBuilderContext {
    public BlockEnvContext root;
    public BlockEnvContext current;
    protected List<Object> listNodeEval;
    protected Map<String, VarDescription> globalVar;
    protected int varIndexSize;
    public Map<String, Integer> globalIndexMap;
    protected boolean isSafeOutput;
    public Map<String, Integer> rootIndexMap;

    public ProgramBuilderContext() {
        this.current = this.root = this.newBlockEnvContext();
        this.listNodeEval = new LinkedList<Object>();
        this.globalVar = new HashMap<String, VarDescription>();
        this.varIndexSize = 0;
        this.globalIndexMap = new HashMap<String, Integer>();
        this.isSafeOutput = false;
        this.rootIndexMap = new HashMap<String, Integer>();
    }

    public void enterBlock(ParserRuleContext ruleContext) {
        BlockEnvContext blockVar = this.newBlockEnvContext();
        blockVar.setParent(this.current);
        this.current = blockVar;
    }

    public void exitBlock(Statement statement) {
        this.current.setBlockRef(statement);
        this.current = this.current.parent;
    }

    public void addVarAndPostion(ASTNode first) {
        this.addVar(first);
        this.setVarPosition(first.token.text, first);
    }

    public boolean addRootVarAdnPosition(ASTNode first) {
        String varName = first.token.text;
        if (this.searchVar(this.root, varName) != null) {
            return true;
        }
        VarDescription varDesc = this.newVarDescription();
        varDesc.setVarName(varName);
        varDesc.where.add(first);
        this.root.getVars().put(varName, varDesc);
        return false;
    }

    public ASTNode searchVar(BlockEnvContext ctx, String name) {
        if (ctx.getVarDescrption(name) != null) {
            return ctx.getVarDescrption((String)name).where.get(0);
        }
        for (BlockEnvContext child : ctx.blockList) {
            ASTNode node = this.searchVar(child, name);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public VarDescription addVar(ASTNode varNode) {
        VarDescription varDesc = this.newVarDescription();
        varDesc.setVarName(varNode.token.text);
        this.current.getVars().put(varDesc.getVarName(), varDesc);
        return varDesc;
    }

    public ASTNode contain(String varName) {
        VarDescription varDesc = this.current.getVars().get(varName);
        if (varDesc == null) {
            return null;
        }
        return varDesc.where.get(0);
    }

    public void setVarAttr(String varName, String attrName) {
        VarDescription varDesc = this.findVar(varName);
        varDesc.attrList.add(attrName);
    }

    public void setVarPosition(String varName, ASTNode where) {
        VarDescription varDesc = this.findVar(varName);
        varDesc.where.add(where);
    }

    protected GrammarToken hasDefined(String varName) {
        BlockEnvContext scope = this.current;
        while (scope != null) {
            VarDescription varDesc = scope.getVarDescrption(varName);
            if (varDesc != null) {
                return varDesc.where.get((int)0).token;
            }
            scope = scope.parent;
        }
        return null;
    }

    protected VarDescription findVar(String varName) {
        BlockEnvContext scope = this.current;
        while (scope != null) {
            VarDescription varDesc = scope.getVarDescrption(varName);
            if (varDesc != null) {
                return varDesc;
            }
            scope = scope.parent;
        }
        VarDescription desc = this.globalVar.get(varName);
        if (desc == null) {
            desc = this.newVarDescription();
            desc.setVarName(varName);
            this.globalVar.put(varName, desc);
        }
        return desc;
    }

    public int setNodeEvalObject(Object o) {
        this.listNodeEval.add(o);
        return this.listNodeEval.size() - 1;
    }

    public void anzlyszeGlobal() {
        int index = 0;
        for (Map.Entry<String, VarDescription> entry : this.globalVar.entrySet()) {
            this.globalIndexMap.put(entry.getKey(), index);
            this.varIndexPoint(this.current, entry.getValue(), index);
            VarDescription vd = entry.getValue();
            for (ASTNode node : vd.where) {
                ((IVarIndex)((Object)node)).setVarIndex(index);
            }
            ++index;
        }
    }

    protected void varIndexPoint(BlockEnvContext blockEnvContext, VarDescription vd, int index) {
    }

    public void anzlyszeLocal() {
        this.anzlysze(this.root, this.globalVar.size(), true);
    }

    protected void anzlysze(BlockEnvContext block, int nextIndex, boolean isRoot) {
        for (Map.Entry<String, VarDescription> entry : block.vars.entrySet()) {
            VarDescription vd = entry.getValue();
            for (ASTNode node : vd.where) {
                ((IVarIndex)((Object)node)).setVarIndex(nextIndex);
                this.varIndexPoint(block, vd, nextIndex);
                if (!isRoot) continue;
                this.rootIndexMap.put(vd.getVarName(), nextIndex);
            }
            ++nextIndex;
        }
        this.varIndexSize = Math.max(this.varIndexSize, nextIndex);
        for (BlockEnvContext subBlock : block.blockList) {
            this.anzlysze(subBlock, nextIndex, false);
            int inc = subBlock.vars.size();
            this.varIndexSize = Math.max(this.varIndexSize, nextIndex + inc);
        }
    }

    public BlockEnvContext newBlockEnvContext() {
        return new BlockEnvContext();
    }

    public VarDescription newVarDescription() {
        return new VarDescription();
    }
}

