/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.truth.extensions.proto.FieldDescriptorOrUnknown;
import com.google.common.truth.extensions.proto.FieldDescriptorValidator;
import com.google.common.truth.extensions.proto.FieldNumberTree;
import com.google.common.truth.extensions.proto.FieldScopeLogicContainer;
import com.google.common.truth.extensions.proto.FieldScopeResult;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.errorprone.annotations.ForOverride;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;

abstract class FieldScopeLogic
implements FieldScopeLogicContainer<FieldScopeLogic> {
    private static final FieldScopeLogic ALL = new FieldScopeLogic(){

        @Override
        public String toString() {
            return "FieldScopes.all()";
        }

        @Override
        final FieldScopeResult policyFor(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return FieldScopeResult.INCLUDED_RECURSIVELY;
        }

        @Override
        final boolean isAll() {
            return true;
        }
    };
    private static final FieldScopeLogic NONE = new FieldScopeLogic(){

        @Override
        public String toString() {
            return "FieldScopes.none()";
        }

        @Override
        final FieldScopeResult policyFor(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return FieldScopeResult.EXCLUDED_RECURSIVELY;
        }
    };

    FieldScopeLogic() {
    }

    abstract FieldScopeResult policyFor(Descriptors.Descriptor var1, FieldDescriptorOrUnknown var2);

    final boolean contains(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
        return this.policyFor(rootDescriptor, fieldDescriptorOrUnknown).included();
    }

    @Override
    public final FieldScopeLogic subScope(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
        FieldScopeResult result = this.policyFor(rootDescriptor, fieldDescriptorOrUnknown);
        if (result.recursive()) {
            return result.included() ? FieldScopeLogic.all() : FieldScopeLogic.none();
        }
        return this.subScopeImpl(rootDescriptor, fieldDescriptorOrUnknown);
    }

    @ForOverride
    FieldScopeLogic subScopeImpl(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
        String string = String.valueOf(this.getClass());
        throw new UnsupportedOperationException(new StringBuilder(33 + String.valueOf(string).length()).append("subScopeImpl not implemented for ").append(string).toString());
    }

    public abstract String toString();

    @Override
    public void validate(Descriptors.Descriptor rootDescriptor, FieldDescriptorValidator fieldDescriptorValidator) {
    }

    private static boolean isEmpty(Iterable<?> container) {
        boolean isEmpty = true;
        for (Object element : container) {
            Preconditions.checkNotNull(element);
            isEmpty = false;
        }
        return isEmpty;
    }

    FieldScopeLogic ignoringFields(Iterable<Integer> fieldNumbers) {
        if (FieldScopeLogic.isEmpty(fieldNumbers)) {
            return this;
        }
        return FieldScopeLogic.and(this, new NegationFieldScopeLogic(new FieldNumbersLogic(fieldNumbers, true)));
    }

    FieldScopeLogic ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        if (FieldScopeLogic.isEmpty(fieldDescriptors)) {
            return this;
        }
        return FieldScopeLogic.and(this, new NegationFieldScopeLogic(new FieldDescriptorsLogic(fieldDescriptors, true)));
    }

    FieldScopeLogic allowingFields(Iterable<Integer> fieldNumbers) {
        if (FieldScopeLogic.isEmpty(fieldNumbers)) {
            return this;
        }
        return FieldScopeLogic.or(this, new FieldNumbersLogic(fieldNumbers, true));
    }

    FieldScopeLogic allowingFieldsNonRecursive(Iterable<Integer> fieldNumbers) {
        if (FieldScopeLogic.isEmpty(fieldNumbers)) {
            return this;
        }
        return FieldScopeLogic.or(this, new FieldNumbersLogic(fieldNumbers, false));
    }

    FieldScopeLogic allowingFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        if (FieldScopeLogic.isEmpty(fieldDescriptors)) {
            return this;
        }
        return FieldScopeLogic.or(this, new FieldDescriptorsLogic(fieldDescriptors, true));
    }

    FieldScopeLogic allowingFieldDescriptorsNonRecursive(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        if (FieldScopeLogic.isEmpty(fieldDescriptors)) {
            return this;
        }
        return FieldScopeLogic.or(this, new FieldDescriptorsLogic(fieldDescriptors, false));
    }

    boolean isAll() {
        return false;
    }

    static FieldScopeLogic all() {
        return ALL;
    }

    static FieldScopeLogic none() {
        return NONE;
    }

    static FieldScopeLogic partialScope(Message message) {
        return new RootPartialScopeLogic(message);
    }

    static FieldScopeLogic and(FieldScopeLogic fieldScopeLogic1, FieldScopeLogic fieldScopeLogic2) {
        return new IntersectionFieldScopeLogic(fieldScopeLogic1, fieldScopeLogic2);
    }

    static FieldScopeLogic or(FieldScopeLogic fieldScopeLogic1, FieldScopeLogic fieldScopeLogic2) {
        return new UnionFieldScopeLogic(fieldScopeLogic1, fieldScopeLogic2);
    }

    static FieldScopeLogic not(FieldScopeLogic fieldScopeLogic) {
        return new NegationFieldScopeLogic(fieldScopeLogic);
    }

    private static final class NegationFieldScopeLogic
    extends CompoundFieldScopeLogic<NegationFieldScopeLogic> {
        NegationFieldScopeLogic(FieldScopeLogic subject) {
            super(subject);
        }

        @Override
        NegationFieldScopeLogic newLogicOfSameType(List<FieldScopeLogic> newElements) {
            Preconditions.checkArgument((newElements.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 element: %s", newElements);
            return new NegationFieldScopeLogic(newElements.get(0));
        }

        @Override
        FieldScopeResult policyFor(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            FieldScopeResult result = ((FieldScopeLogic)this.elements.get(0)).policyFor(rootDescriptor, fieldDescriptorOrUnknown);
            return FieldScopeResult.of(!result.included(), result.recursive());
        }

        @Override
        public String toString() {
            return String.format("!(%s)", this.elements.get(0));
        }
    }

    private static final class UnionFieldScopeLogic
    extends CompoundFieldScopeLogic<UnionFieldScopeLogic> {
        UnionFieldScopeLogic(FieldScopeLogic subject1, FieldScopeLogic subject2) {
            super(subject1, subject2);
        }

        @Override
        UnionFieldScopeLogic newLogicOfSameType(List<FieldScopeLogic> newElements) {
            Preconditions.checkArgument((newElements.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 elements: %s", newElements);
            return new UnionFieldScopeLogic(newElements.get(0), newElements.get(1));
        }

        @Override
        FieldScopeResult policyFor(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return UnionFieldScopeLogic.union(((FieldScopeLogic)this.elements.get(0)).policyFor(rootDescriptor, fieldDescriptorOrUnknown), ((FieldScopeLogic)this.elements.get(1)).policyFor(rootDescriptor, fieldDescriptorOrUnknown));
        }

        private static FieldScopeResult union(FieldScopeResult result1, FieldScopeResult result2) {
            if (result1 == FieldScopeResult.INCLUDED_RECURSIVELY || result2 == FieldScopeResult.INCLUDED_RECURSIVELY) {
                return FieldScopeResult.INCLUDED_RECURSIVELY;
            }
            if (result1.included() || result2.included()) {
                return FieldScopeResult.INCLUDED_NONRECURSIVELY;
            }
            if (result1.recursive() && result2.recursive()) {
                return FieldScopeResult.EXCLUDED_RECURSIVELY;
            }
            return FieldScopeResult.EXCLUDED_NONRECURSIVELY;
        }

        @Override
        public String toString() {
            return String.format("(%s || %s)", this.elements.get(0), this.elements.get(1));
        }
    }

    private static final class IntersectionFieldScopeLogic
    extends CompoundFieldScopeLogic<IntersectionFieldScopeLogic> {
        IntersectionFieldScopeLogic(FieldScopeLogic subject1, FieldScopeLogic subject2) {
            super(subject1, subject2);
        }

        @Override
        IntersectionFieldScopeLogic newLogicOfSameType(List<FieldScopeLogic> newElements) {
            Preconditions.checkArgument((newElements.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 elements: %s", newElements);
            return new IntersectionFieldScopeLogic(newElements.get(0), newElements.get(1));
        }

        @Override
        FieldScopeResult policyFor(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return IntersectionFieldScopeLogic.intersection(((FieldScopeLogic)this.elements.get(0)).policyFor(rootDescriptor, fieldDescriptorOrUnknown), ((FieldScopeLogic)this.elements.get(1)).policyFor(rootDescriptor, fieldDescriptorOrUnknown));
        }

        private static FieldScopeResult intersection(FieldScopeResult result1, FieldScopeResult result2) {
            if (result1 == FieldScopeResult.EXCLUDED_RECURSIVELY || result2 == FieldScopeResult.EXCLUDED_RECURSIVELY) {
                return FieldScopeResult.EXCLUDED_RECURSIVELY;
            }
            if (!result1.included() || !result2.included()) {
                return FieldScopeResult.EXCLUDED_NONRECURSIVELY;
            }
            if (result1.recursive() && result2.recursive()) {
                return FieldScopeResult.INCLUDED_RECURSIVELY;
            }
            return FieldScopeResult.INCLUDED_NONRECURSIVELY;
        }

        @Override
        public String toString() {
            return String.format("(%s && %s)", this.elements.get(0), this.elements.get(1));
        }
    }

    private static abstract class CompoundFieldScopeLogic<T extends CompoundFieldScopeLogic<T>>
    extends FieldScopeLogic {
        final ImmutableList<FieldScopeLogic> elements;

        CompoundFieldScopeLogic(FieldScopeLogic singleElem) {
            this.elements = ImmutableList.of((Object)singleElem);
        }

        CompoundFieldScopeLogic(FieldScopeLogic firstElem, FieldScopeLogic secondElem) {
            this.elements = ImmutableList.of((Object)firstElem, (Object)secondElem);
        }

        @Override
        public final void validate(Descriptors.Descriptor rootDescriptor, FieldDescriptorValidator fieldDescriptorValidator) {
            for (FieldScopeLogic elem : this.elements) {
                elem.validate(rootDescriptor, fieldDescriptorValidator);
            }
        }

        abstract T newLogicOfSameType(List<FieldScopeLogic> var1);

        @Override
        final FieldScopeLogic subScopeImpl(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.elements.size());
            for (FieldScopeLogic elem : this.elements) {
                builder.add((Object)elem.subScope(rootDescriptor, fieldDescriptorOrUnknown));
            }
            return this.newLogicOfSameType((List<FieldScopeLogic>)builder.build());
        }
    }

    private static final class FieldDescriptorsLogic
    extends FieldMatcherLogicBase {
        private final ImmutableSet<Descriptors.FieldDescriptor> fieldDescriptors;

        FieldDescriptorsLogic(Iterable<Descriptors.FieldDescriptor> fieldDescriptors, boolean isRecursive) {
            super(isRecursive);
            this.fieldDescriptors = ImmutableSet.copyOf(fieldDescriptors);
        }

        @Override
        boolean matchesFieldDescriptor(Descriptors.Descriptor descriptor, Descriptors.FieldDescriptor fieldDescriptor) {
            return this.fieldDescriptors.contains((Object)fieldDescriptor);
        }

        @Override
        public void validate(Descriptors.Descriptor rootDescriptor, FieldDescriptorValidator fieldDescriptorValidator) {
            super.validate(rootDescriptor, fieldDescriptorValidator);
            for (Descriptors.FieldDescriptor fieldDescriptor : this.fieldDescriptors) {
                fieldDescriptorValidator.validate(fieldDescriptor);
            }
        }

        @Override
        public String toString() {
            return String.format("FieldScopes.allowingFieldDescriptors(%s)", FieldScopeUtil.join(this.fieldDescriptors));
        }
    }

    private static final class FieldNumbersLogic
    extends FieldMatcherLogicBase {
        private final ImmutableSet<Integer> fieldNumbers;

        FieldNumbersLogic(Iterable<Integer> fieldNumbers, boolean isRecursive) {
            super(isRecursive);
            this.fieldNumbers = ImmutableSet.copyOf(fieldNumbers);
        }

        @Override
        public void validate(Descriptors.Descriptor rootDescriptor, FieldDescriptorValidator fieldDescriptorValidator) {
            super.validate(rootDescriptor, fieldDescriptorValidator);
            UnmodifiableIterator unmodifiableIterator = this.fieldNumbers.iterator();
            while (unmodifiableIterator.hasNext()) {
                int fieldNumber = (Integer)unmodifiableIterator.next();
                Descriptors.FieldDescriptor fieldDescriptor = rootDescriptor.findFieldByNumber(fieldNumber);
                Preconditions.checkArgument((fieldDescriptor != null ? 1 : 0) != 0, (String)"Message type %s has no field with number %s.", (Object)rootDescriptor.getFullName(), (int)fieldNumber);
                fieldDescriptorValidator.validate(fieldDescriptor);
            }
        }

        @Override
        boolean matchesFieldDescriptor(Descriptors.Descriptor descriptor, Descriptors.FieldDescriptor fieldDescriptor) {
            return fieldDescriptor.getContainingType() == descriptor && this.fieldNumbers.contains((Object)fieldDescriptor.getNumber());
        }

        @Override
        public String toString() {
            return String.format("FieldScopes.allowingFields(%s)", FieldScopeUtil.join(this.fieldNumbers));
        }
    }

    private static abstract class FieldMatcherLogicBase
    extends FieldScopeLogic {
        private final boolean isRecursive;

        protected FieldMatcherLogicBase(boolean isRecursive) {
            this.isRecursive = isRecursive;
        }

        abstract boolean matchesFieldDescriptor(Descriptors.Descriptor var1, Descriptors.FieldDescriptor var2);

        @Override
        final FieldScopeResult policyFor(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            if (fieldDescriptorOrUnknown.unknownFieldDescriptor().isPresent()) {
                return FieldScopeResult.EXCLUDED_RECURSIVELY;
            }
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)fieldDescriptorOrUnknown.fieldDescriptor().get();
            if (this.matchesFieldDescriptor(rootDescriptor, fieldDescriptor)) {
                return FieldScopeResult.of(true, this.isRecursive);
            }
            return FieldScopeResult.EXCLUDED_NONRECURSIVELY;
        }

        @Override
        final FieldScopeLogic subScopeImpl(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return this;
        }

        @Override
        public void validate(Descriptors.Descriptor rootDescriptor, FieldDescriptorValidator fieldDescriptorValidator) {
            if (this.isRecursive) {
                Verify.verify((fieldDescriptorValidator == FieldDescriptorValidator.ALLOW_ALL ? 1 : 0) != 0, (String)"Field descriptor validators are not supported for non-recursive field matcher logics.", (Object[])new Object[0]);
            }
        }
    }

    private static final class RootPartialScopeLogic
    extends PartialScopeLogic {
        private final Message message;
        private final Descriptors.Descriptor expectedDescriptor;

        RootPartialScopeLogic(Message message) {
            super(FieldNumberTree.fromMessage(message));
            this.message = message;
            this.expectedDescriptor = message.getDescriptorForType();
        }

        @Override
        public void validate(Descriptors.Descriptor rootDescriptor, FieldDescriptorValidator fieldDescriptorValidator) {
            Verify.verify((fieldDescriptorValidator == FieldDescriptorValidator.ALLOW_ALL ? 1 : 0) != 0, (String)"PartialScopeLogic doesn't support custom field validators.", (Object[])new Object[0]);
            Preconditions.checkArgument((boolean)this.expectedDescriptor.equals(rootDescriptor), (String)"Message given to FieldScopes.fromSetFields() does not have the same descriptor as the message being tested. Expected %s, got %s.", (Object)this.expectedDescriptor.getFullName(), (Object)rootDescriptor.getFullName());
        }

        @Override
        public String toString() {
            return String.format("FieldScopes.fromSetFields(%s)", this.message);
        }
    }

    private static class PartialScopeLogic
    extends FieldScopeLogic {
        private static final PartialScopeLogic EMPTY = new PartialScopeLogic(FieldNumberTree.empty());
        private final FieldNumberTree fieldNumberTree;

        PartialScopeLogic(FieldNumberTree fieldNumberTree) {
            this.fieldNumberTree = fieldNumberTree;
        }

        @Override
        public String toString() {
            return String.format("PartialScopeLogic(%s)", this.fieldNumberTree);
        }

        @Override
        final FieldScopeResult policyFor(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return this.fieldNumberTree.hasChild(fieldDescriptorOrUnknown) ? FieldScopeResult.INCLUDED_NONRECURSIVELY : FieldScopeResult.EXCLUDED_RECURSIVELY;
        }

        @Override
        final FieldScopeLogic subScopeImpl(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return PartialScopeLogic.newPartialScopeLogic(this.fieldNumberTree.child(fieldDescriptorOrUnknown));
        }

        private static PartialScopeLogic newPartialScopeLogic(FieldNumberTree fieldNumberTree) {
            return fieldNumberTree.isEmpty() ? EMPTY : new PartialScopeLogic(fieldNumberTree);
        }
    }
}

