/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/rpc/context/attribute_context.proto

package com.google.rpc.context;

/**
 *
 *
 * <pre>
 * This message defines the standard attribute vocabulary for Google APIs.
 * An attribute is a piece of metadata that describes an activity on a network
 * service. For example, the size of an HTTP request, or the status code of
 * an HTTP response.
 * Each attribute has a type and a name, which is logically defined as
 * a proto message field in `AttributeContext`. The field type becomes the
 * attribute type, and the field path becomes the attribute name. For example,
 * the attribute `source.ip` maps to field `AttributeContext.source.ip`.
 * This message definition is guaranteed not to have any wire breaking change.
 * So you can use it directly for passing attributes across different systems.
 * NOTE: Different system may generate different subset of attributes. Please
 * verify the system specification before relying on an attribute generated
 * a system.
 * </pre>
 *
 * Protobuf type {@code google.rpc.context.AttributeContext}
 */
public final class AttributeContext extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.rpc.context.AttributeContext)
    AttributeContextOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AttributeContext.newBuilder() to construct.
  private AttributeContext(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AttributeContext() {
    extensions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AttributeContext();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AttributeContext(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.rpc.context.AttributeContext.Peer.Builder subBuilder = null;
              if (source_ != null) {
                subBuilder = source_.toBuilder();
              }
              source_ =
                  input.readMessage(
                      com.google.rpc.context.AttributeContext.Peer.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(source_);
                source_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              com.google.rpc.context.AttributeContext.Peer.Builder subBuilder = null;
              if (destination_ != null) {
                subBuilder = destination_.toBuilder();
              }
              destination_ =
                  input.readMessage(
                      com.google.rpc.context.AttributeContext.Peer.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(destination_);
                destination_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.rpc.context.AttributeContext.Request.Builder subBuilder = null;
              if (request_ != null) {
                subBuilder = request_.toBuilder();
              }
              request_ =
                  input.readMessage(
                      com.google.rpc.context.AttributeContext.Request.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(request_);
                request_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.rpc.context.AttributeContext.Response.Builder subBuilder = null;
              if (response_ != null) {
                subBuilder = response_.toBuilder();
              }
              response_ =
                  input.readMessage(
                      com.google.rpc.context.AttributeContext.Response.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(response_);
                response_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.rpc.context.AttributeContext.Resource.Builder subBuilder = null;
              if (resource_ != null) {
                subBuilder = resource_.toBuilder();
              }
              resource_ =
                  input.readMessage(
                      com.google.rpc.context.AttributeContext.Resource.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(resource_);
                resource_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.rpc.context.AttributeContext.Api.Builder subBuilder = null;
              if (api_ != null) {
                subBuilder = api_.toBuilder();
              }
              api_ =
                  input.readMessage(
                      com.google.rpc.context.AttributeContext.Api.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(api_);
                api_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              com.google.rpc.context.AttributeContext.Peer.Builder subBuilder = null;
              if (origin_ != null) {
                subBuilder = origin_.toBuilder();
              }
              origin_ =
                  input.readMessage(
                      com.google.rpc.context.AttributeContext.Peer.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(origin_);
                origin_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                extensions_ = new java.util.ArrayList<com.google.protobuf.Any>();
                mutable_bitField0_ |= 0x00000001;
              }
              extensions_.add(
                  input.readMessage(com.google.protobuf.Any.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        extensions_ = java.util.Collections.unmodifiableList(extensions_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.rpc.context.AttributeContextProto
        .internal_static_google_rpc_context_AttributeContext_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.rpc.context.AttributeContextProto
        .internal_static_google_rpc_context_AttributeContext_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.rpc.context.AttributeContext.class,
            com.google.rpc.context.AttributeContext.Builder.class);
  }

  public interface PeerOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.rpc.context.AttributeContext.Peer)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The IP address of the peer.
     * </pre>
     *
     * <code>string ip = 1;</code>
     *
     * @return The ip.
     */
    java.lang.String getIp();
    /**
     *
     *
     * <pre>
     * The IP address of the peer.
     * </pre>
     *
     * <code>string ip = 1;</code>
     *
     * @return The bytes for ip.
     */
    com.google.protobuf.ByteString getIpBytes();

    /**
     *
     *
     * <pre>
     * The network port of the peer.
     * </pre>
     *
     * <code>int64 port = 2;</code>
     *
     * @return The port.
     */
    long getPort();

    /**
     *
     *
     * <pre>
     * The labels associated with the peer.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    int getLabelsCount();
    /**
     *
     *
     * <pre>
     * The labels associated with the peer.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    boolean containsLabels(java.lang.String key);
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getLabels();
    /**
     *
     *
     * <pre>
     * The labels associated with the peer.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
    /**
     *
     *
     * <pre>
     * The labels associated with the peer.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */

    /* nullable */
    java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * The labels associated with the peer.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    java.lang.String getLabelsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * The identity of this peer. Similar to `Request.auth.principal`, but
     * relative to the peer instead of the request. For example, the
     * idenity associated with a load balancer that forwared the request.
     * </pre>
     *
     * <code>string principal = 7;</code>
     *
     * @return The principal.
     */
    java.lang.String getPrincipal();
    /**
     *
     *
     * <pre>
     * The identity of this peer. Similar to `Request.auth.principal`, but
     * relative to the peer instead of the request. For example, the
     * idenity associated with a load balancer that forwared the request.
     * </pre>
     *
     * <code>string principal = 7;</code>
     *
     * @return The bytes for principal.
     */
    com.google.protobuf.ByteString getPrincipalBytes();

    /**
     *
     *
     * <pre>
     * The CLDR country/region code associated with the above IP address.
     * If the IP address is private, the `region_code` should reflect the
     * physical location where this peer is running.
     * </pre>
     *
     * <code>string region_code = 8;</code>
     *
     * @return The regionCode.
     */
    java.lang.String getRegionCode();
    /**
     *
     *
     * <pre>
     * The CLDR country/region code associated with the above IP address.
     * If the IP address is private, the `region_code` should reflect the
     * physical location where this peer is running.
     * </pre>
     *
     * <code>string region_code = 8;</code>
     *
     * @return The bytes for regionCode.
     */
    com.google.protobuf.ByteString getRegionCodeBytes();
  }
  /**
   *
   *
   * <pre>
   * This message defines attributes for a node that handles a network request.
   * The node can be either a service or an application that sends, forwards,
   * or receives the request. Service peers should fill in
   * `principal` and `labels` as appropriate.
   * </pre>
   *
   * Protobuf type {@code google.rpc.context.AttributeContext.Peer}
   */
  public static final class Peer extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.rpc.context.AttributeContext.Peer)
      PeerOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Peer.newBuilder() to construct.
    private Peer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Peer() {
      ip_ = "";
      principal_ = "";
      regionCode_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Peer();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Peer(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                ip_ = s;
                break;
              }
            case 16:
              {
                port_ = input.readInt64();
                break;
              }
            case 50:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  labels_ =
                      com.google.protobuf.MapField.newMapField(
                          LabelsDefaultEntryHolder.defaultEntry);
                  mutable_bitField0_ |= 0x00000001;
                }
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
                break;
              }
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();

                principal_ = s;
                break;
              }
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();

                regionCode_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_Peer_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_Peer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.rpc.context.AttributeContext.Peer.class,
              com.google.rpc.context.AttributeContext.Peer.Builder.class);
    }

    public static final int IP_FIELD_NUMBER = 1;
    private volatile java.lang.Object ip_;
    /**
     *
     *
     * <pre>
     * The IP address of the peer.
     * </pre>
     *
     * <code>string ip = 1;</code>
     *
     * @return The ip.
     */
    @java.lang.Override
    public java.lang.String getIp() {
      java.lang.Object ref = ip_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ip_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address of the peer.
     * </pre>
     *
     * <code>string ip = 1;</code>
     *
     * @return The bytes for ip.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIpBytes() {
      java.lang.Object ref = ip_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ip_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PORT_FIELD_NUMBER = 2;
    private long port_;
    /**
     *
     *
     * <pre>
     * The network port of the peer.
     * </pre>
     *
     * <code>int64 port = 2;</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public long getPort() {
      return port_;
    }

    public static final int LABELS_FIELD_NUMBER = 6;

    private static final class LabelsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.rpc.context.AttributeContextProto
                  .internal_static_google_rpc_context_AttributeContext_Peer_LabelsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with the peer.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with the peer.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with the peer.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels associated with the peer.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int PRINCIPAL_FIELD_NUMBER = 7;
    private volatile java.lang.Object principal_;
    /**
     *
     *
     * <pre>
     * The identity of this peer. Similar to `Request.auth.principal`, but
     * relative to the peer instead of the request. For example, the
     * idenity associated with a load balancer that forwared the request.
     * </pre>
     *
     * <code>string principal = 7;</code>
     *
     * @return The principal.
     */
    @java.lang.Override
    public java.lang.String getPrincipal() {
      java.lang.Object ref = principal_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        principal_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The identity of this peer. Similar to `Request.auth.principal`, but
     * relative to the peer instead of the request. For example, the
     * idenity associated with a load balancer that forwared the request.
     * </pre>
     *
     * <code>string principal = 7;</code>
     *
     * @return The bytes for principal.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPrincipalBytes() {
      java.lang.Object ref = principal_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        principal_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REGION_CODE_FIELD_NUMBER = 8;
    private volatile java.lang.Object regionCode_;
    /**
     *
     *
     * <pre>
     * The CLDR country/region code associated with the above IP address.
     * If the IP address is private, the `region_code` should reflect the
     * physical location where this peer is running.
     * </pre>
     *
     * <code>string region_code = 8;</code>
     *
     * @return The regionCode.
     */
    @java.lang.Override
    public java.lang.String getRegionCode() {
      java.lang.Object ref = regionCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        regionCode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The CLDR country/region code associated with the above IP address.
     * If the IP address is private, the `region_code` should reflect the
     * physical location where this peer is running.
     * </pre>
     *
     * <code>string region_code = 8;</code>
     *
     * @return The bytes for regionCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRegionCodeBytes() {
      java.lang.Object ref = regionCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        regionCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ip_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ip_);
      }
      if (port_ != 0L) {
        output.writeInt64(2, port_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principal_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, principal_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, regionCode_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ip_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, ip_);
      }
      if (port_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, port_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetLabels().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
            LabelsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principal_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, principal_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, regionCode_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.rpc.context.AttributeContext.Peer)) {
        return super.equals(obj);
      }
      com.google.rpc.context.AttributeContext.Peer other =
          (com.google.rpc.context.AttributeContext.Peer) obj;

      if (!getIp().equals(other.getIp())) return false;
      if (getPort() != other.getPort()) return false;
      if (!internalGetLabels().equals(other.internalGetLabels())) return false;
      if (!getPrincipal().equals(other.getPrincipal())) return false;
      if (!getRegionCode().equals(other.getRegionCode())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + IP_FIELD_NUMBER;
      hash = (53 * hash) + getIp().hashCode();
      hash = (37 * hash) + PORT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPort());
      if (!internalGetLabels().getMap().isEmpty()) {
        hash = (37 * hash) + LABELS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetLabels().hashCode();
      }
      hash = (37 * hash) + PRINCIPAL_FIELD_NUMBER;
      hash = (53 * hash) + getPrincipal().hashCode();
      hash = (37 * hash) + REGION_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getRegionCode().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.rpc.context.AttributeContext.Peer parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Peer parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Peer parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Peer parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Peer parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Peer parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Peer parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Peer parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Peer parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Peer parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Peer parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Peer parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.rpc.context.AttributeContext.Peer prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * This message defines attributes for a node that handles a network request.
     * The node can be either a service or an application that sends, forwards,
     * or receives the request. Service peers should fill in
     * `principal` and `labels` as appropriate.
     * </pre>
     *
     * Protobuf type {@code google.rpc.context.AttributeContext.Peer}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.rpc.context.AttributeContext.Peer)
        com.google.rpc.context.AttributeContext.PeerOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Peer_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 6:
            return internalGetLabels();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 6:
            return internalGetMutableLabels();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Peer_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.rpc.context.AttributeContext.Peer.class,
                com.google.rpc.context.AttributeContext.Peer.Builder.class);
      }

      // Construct using com.google.rpc.context.AttributeContext.Peer.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        ip_ = "";

        port_ = 0L;

        internalGetMutableLabels().clear();
        principal_ = "";

        regionCode_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Peer_descriptor;
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Peer getDefaultInstanceForType() {
        return com.google.rpc.context.AttributeContext.Peer.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Peer build() {
        com.google.rpc.context.AttributeContext.Peer result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Peer buildPartial() {
        com.google.rpc.context.AttributeContext.Peer result =
            new com.google.rpc.context.AttributeContext.Peer(this);
        int from_bitField0_ = bitField0_;
        result.ip_ = ip_;
        result.port_ = port_;
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
        result.principal_ = principal_;
        result.regionCode_ = regionCode_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.rpc.context.AttributeContext.Peer) {
          return mergeFrom((com.google.rpc.context.AttributeContext.Peer) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.rpc.context.AttributeContext.Peer other) {
        if (other == com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()) return this;
        if (!other.getIp().isEmpty()) {
          ip_ = other.ip_;
          onChanged();
        }
        if (other.getPort() != 0L) {
          setPort(other.getPort());
        }
        internalGetMutableLabels().mergeFrom(other.internalGetLabels());
        if (!other.getPrincipal().isEmpty()) {
          principal_ = other.principal_;
          onChanged();
        }
        if (!other.getRegionCode().isEmpty()) {
          regionCode_ = other.regionCode_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.rpc.context.AttributeContext.Peer parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.rpc.context.AttributeContext.Peer) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object ip_ = "";
      /**
       *
       *
       * <pre>
       * The IP address of the peer.
       * </pre>
       *
       * <code>string ip = 1;</code>
       *
       * @return The ip.
       */
      public java.lang.String getIp() {
        java.lang.Object ref = ip_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ip_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The IP address of the peer.
       * </pre>
       *
       * <code>string ip = 1;</code>
       *
       * @return The bytes for ip.
       */
      public com.google.protobuf.ByteString getIpBytes() {
        java.lang.Object ref = ip_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ip_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The IP address of the peer.
       * </pre>
       *
       * <code>string ip = 1;</code>
       *
       * @param value The ip to set.
       * @return This builder for chaining.
       */
      public Builder setIp(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        ip_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The IP address of the peer.
       * </pre>
       *
       * <code>string ip = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIp() {

        ip_ = getDefaultInstance().getIp();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The IP address of the peer.
       * </pre>
       *
       * <code>string ip = 1;</code>
       *
       * @param value The bytes for ip to set.
       * @return This builder for chaining.
       */
      public Builder setIpBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        ip_ = value;
        onChanged();
        return this;
      }

      private long port_;
      /**
       *
       *
       * <pre>
       * The network port of the peer.
       * </pre>
       *
       * <code>int64 port = 2;</code>
       *
       * @return The port.
       */
      @java.lang.Override
      public long getPort() {
        return port_;
      }
      /**
       *
       *
       * <pre>
       * The network port of the peer.
       * </pre>
       *
       * <code>int64 port = 2;</code>
       *
       * @param value The port to set.
       * @return This builder for chaining.
       */
      public Builder setPort(long value) {

        port_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The network port of the peer.
       * </pre>
       *
       * <code>int64 port = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPort() {

        port_ = 0L;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
        if (labels_ == null) {
          return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return labels_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableLabels() {
        onChanged();
        ;
        if (labels_ == null) {
          labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        if (!labels_.isMutable()) {
          labels_ = labels_.copy();
        }
        return labels_;
      }

      public int getLabelsCount() {
        return internalGetLabels().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * The labels associated with the peer.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 6;</code>
       */
      @java.lang.Override
      public boolean containsLabels(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetLabels().getMap().containsKey(key);
      }
      /** Use {@link #getLabelsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return getLabelsMap();
      }
      /**
       *
       *
       * <pre>
       * The labels associated with the peer.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 6;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
        return internalGetLabels().getMap();
      }
      /**
       *
       *
       * <pre>
       * The labels associated with the peer.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 6;</code>
       */
      @java.lang.Override
      public java.lang.String getLabelsOrDefault(
          java.lang.String key, java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * The labels associated with the peer.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 6;</code>
       */
      @java.lang.Override
      public java.lang.String getLabelsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearLabels() {
        internalGetMutableLabels().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The labels associated with the peer.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 6;</code>
       */
      public Builder removeLabels(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableLabels().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
        return internalGetMutableLabels().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * The labels associated with the peer.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 6;</code>
       */
      public Builder putLabels(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }

        internalGetMutableLabels().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The labels associated with the peer.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 6;</code>
       */
      public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableLabels().getMutableMap().putAll(values);
        return this;
      }

      private java.lang.Object principal_ = "";
      /**
       *
       *
       * <pre>
       * The identity of this peer. Similar to `Request.auth.principal`, but
       * relative to the peer instead of the request. For example, the
       * idenity associated with a load balancer that forwared the request.
       * </pre>
       *
       * <code>string principal = 7;</code>
       *
       * @return The principal.
       */
      public java.lang.String getPrincipal() {
        java.lang.Object ref = principal_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          principal_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The identity of this peer. Similar to `Request.auth.principal`, but
       * relative to the peer instead of the request. For example, the
       * idenity associated with a load balancer that forwared the request.
       * </pre>
       *
       * <code>string principal = 7;</code>
       *
       * @return The bytes for principal.
       */
      public com.google.protobuf.ByteString getPrincipalBytes() {
        java.lang.Object ref = principal_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          principal_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The identity of this peer. Similar to `Request.auth.principal`, but
       * relative to the peer instead of the request. For example, the
       * idenity associated with a load balancer that forwared the request.
       * </pre>
       *
       * <code>string principal = 7;</code>
       *
       * @param value The principal to set.
       * @return This builder for chaining.
       */
      public Builder setPrincipal(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        principal_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The identity of this peer. Similar to `Request.auth.principal`, but
       * relative to the peer instead of the request. For example, the
       * idenity associated with a load balancer that forwared the request.
       * </pre>
       *
       * <code>string principal = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrincipal() {

        principal_ = getDefaultInstance().getPrincipal();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The identity of this peer. Similar to `Request.auth.principal`, but
       * relative to the peer instead of the request. For example, the
       * idenity associated with a load balancer that forwared the request.
       * </pre>
       *
       * <code>string principal = 7;</code>
       *
       * @param value The bytes for principal to set.
       * @return This builder for chaining.
       */
      public Builder setPrincipalBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        principal_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object regionCode_ = "";
      /**
       *
       *
       * <pre>
       * The CLDR country/region code associated with the above IP address.
       * If the IP address is private, the `region_code` should reflect the
       * physical location where this peer is running.
       * </pre>
       *
       * <code>string region_code = 8;</code>
       *
       * @return The regionCode.
       */
      public java.lang.String getRegionCode() {
        java.lang.Object ref = regionCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          regionCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The CLDR country/region code associated with the above IP address.
       * If the IP address is private, the `region_code` should reflect the
       * physical location where this peer is running.
       * </pre>
       *
       * <code>string region_code = 8;</code>
       *
       * @return The bytes for regionCode.
       */
      public com.google.protobuf.ByteString getRegionCodeBytes() {
        java.lang.Object ref = regionCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          regionCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The CLDR country/region code associated with the above IP address.
       * If the IP address is private, the `region_code` should reflect the
       * physical location where this peer is running.
       * </pre>
       *
       * <code>string region_code = 8;</code>
       *
       * @param value The regionCode to set.
       * @return This builder for chaining.
       */
      public Builder setRegionCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        regionCode_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The CLDR country/region code associated with the above IP address.
       * If the IP address is private, the `region_code` should reflect the
       * physical location where this peer is running.
       * </pre>
       *
       * <code>string region_code = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRegionCode() {

        regionCode_ = getDefaultInstance().getRegionCode();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The CLDR country/region code associated with the above IP address.
       * If the IP address is private, the `region_code` should reflect the
       * physical location where this peer is running.
       * </pre>
       *
       * <code>string region_code = 8;</code>
       *
       * @param value The bytes for regionCode to set.
       * @return This builder for chaining.
       */
      public Builder setRegionCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        regionCode_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.rpc.context.AttributeContext.Peer)
    }

    // @@protoc_insertion_point(class_scope:google.rpc.context.AttributeContext.Peer)
    private static final com.google.rpc.context.AttributeContext.Peer DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.rpc.context.AttributeContext.Peer();
    }

    public static com.google.rpc.context.AttributeContext.Peer getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Peer> PARSER =
        new com.google.protobuf.AbstractParser<Peer>() {
          @java.lang.Override
          public Peer parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Peer(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Peer> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Peer> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.rpc.context.AttributeContext.Peer getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ApiOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.rpc.context.AttributeContext.Api)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The API service name. It is a logical identifier for a networked API,
     * such as "pubsub.googleapis.com". The naming syntax depends on the
     * API management system being used for handling the request.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The service.
     */
    java.lang.String getService();
    /**
     *
     *
     * <pre>
     * The API service name. It is a logical identifier for a networked API,
     * such as "pubsub.googleapis.com". The naming syntax depends on the
     * API management system being used for handling the request.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The bytes for service.
     */
    com.google.protobuf.ByteString getServiceBytes();

    /**
     *
     *
     * <pre>
     * The API operation name. For gRPC requests, it is the fully qualified API
     * method name, such as "google.pubsub.v1.Publisher.Publish". For OpenAPI
     * requests, it is the `operationId`, such as "getPet".
     * </pre>
     *
     * <code>string operation = 2;</code>
     *
     * @return The operation.
     */
    java.lang.String getOperation();
    /**
     *
     *
     * <pre>
     * The API operation name. For gRPC requests, it is the fully qualified API
     * method name, such as "google.pubsub.v1.Publisher.Publish". For OpenAPI
     * requests, it is the `operationId`, such as "getPet".
     * </pre>
     *
     * <code>string operation = 2;</code>
     *
     * @return The bytes for operation.
     */
    com.google.protobuf.ByteString getOperationBytes();

    /**
     *
     *
     * <pre>
     * The API protocol used for sending the request, such as "http", "https",
     * "grpc", or "internal".
     * </pre>
     *
     * <code>string protocol = 3;</code>
     *
     * @return The protocol.
     */
    java.lang.String getProtocol();
    /**
     *
     *
     * <pre>
     * The API protocol used for sending the request, such as "http", "https",
     * "grpc", or "internal".
     * </pre>
     *
     * <code>string protocol = 3;</code>
     *
     * @return The bytes for protocol.
     */
    com.google.protobuf.ByteString getProtocolBytes();

    /**
     *
     *
     * <pre>
     * The API version associated with the API operation above, such as "v1" or
     * "v1alpha1".
     * </pre>
     *
     * <code>string version = 4;</code>
     *
     * @return The version.
     */
    java.lang.String getVersion();
    /**
     *
     *
     * <pre>
     * The API version associated with the API operation above, such as "v1" or
     * "v1alpha1".
     * </pre>
     *
     * <code>string version = 4;</code>
     *
     * @return The bytes for version.
     */
    com.google.protobuf.ByteString getVersionBytes();
  }
  /**
   *
   *
   * <pre>
   * This message defines attributes associated with API operations, such as
   * a network API request. The terminology is based on the conventions used
   * by Google APIs, Istio, and OpenAPI.
   * </pre>
   *
   * Protobuf type {@code google.rpc.context.AttributeContext.Api}
   */
  public static final class Api extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.rpc.context.AttributeContext.Api)
      ApiOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Api.newBuilder() to construct.
    private Api(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Api() {
      service_ = "";
      operation_ = "";
      protocol_ = "";
      version_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Api();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Api(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                service_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                operation_ = s;
                break;
              }
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();

                protocol_ = s;
                break;
              }
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();

                version_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_Api_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_Api_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.rpc.context.AttributeContext.Api.class,
              com.google.rpc.context.AttributeContext.Api.Builder.class);
    }

    public static final int SERVICE_FIELD_NUMBER = 1;
    private volatile java.lang.Object service_;
    /**
     *
     *
     * <pre>
     * The API service name. It is a logical identifier for a networked API,
     * such as "pubsub.googleapis.com". The naming syntax depends on the
     * API management system being used for handling the request.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The service.
     */
    @java.lang.Override
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The API service name. It is a logical identifier for a networked API,
     * such as "pubsub.googleapis.com". The naming syntax depends on the
     * API management system being used for handling the request.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The bytes for service.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OPERATION_FIELD_NUMBER = 2;
    private volatile java.lang.Object operation_;
    /**
     *
     *
     * <pre>
     * The API operation name. For gRPC requests, it is the fully qualified API
     * method name, such as "google.pubsub.v1.Publisher.Publish". For OpenAPI
     * requests, it is the `operationId`, such as "getPet".
     * </pre>
     *
     * <code>string operation = 2;</code>
     *
     * @return The operation.
     */
    @java.lang.Override
    public java.lang.String getOperation() {
      java.lang.Object ref = operation_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operation_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The API operation name. For gRPC requests, it is the fully qualified API
     * method name, such as "google.pubsub.v1.Publisher.Publish". For OpenAPI
     * requests, it is the `operationId`, such as "getPet".
     * </pre>
     *
     * <code>string operation = 2;</code>
     *
     * @return The bytes for operation.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOperationBytes() {
      java.lang.Object ref = operation_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PROTOCOL_FIELD_NUMBER = 3;
    private volatile java.lang.Object protocol_;
    /**
     *
     *
     * <pre>
     * The API protocol used for sending the request, such as "http", "https",
     * "grpc", or "internal".
     * </pre>
     *
     * <code>string protocol = 3;</code>
     *
     * @return The protocol.
     */
    @java.lang.Override
    public java.lang.String getProtocol() {
      java.lang.Object ref = protocol_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        protocol_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The API protocol used for sending the request, such as "http", "https",
     * "grpc", or "internal".
     * </pre>
     *
     * <code>string protocol = 3;</code>
     *
     * @return The bytes for protocol.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProtocolBytes() {
      java.lang.Object ref = protocol_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        protocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VERSION_FIELD_NUMBER = 4;
    private volatile java.lang.Object version_;
    /**
     *
     *
     * <pre>
     * The API version associated with the API operation above, such as "v1" or
     * "v1alpha1".
     * </pre>
     *
     * <code>string version = 4;</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The API version associated with the API operation above, such as "v1" or
     * "v1alpha1".
     * </pre>
     *
     * <code>string version = 4;</code>
     *
     * @return The bytes for version.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operation_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, operation_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, protocol_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, version_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operation_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, operation_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, protocol_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, version_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.rpc.context.AttributeContext.Api)) {
        return super.equals(obj);
      }
      com.google.rpc.context.AttributeContext.Api other =
          (com.google.rpc.context.AttributeContext.Api) obj;

      if (!getService().equals(other.getService())) return false;
      if (!getOperation().equals(other.getOperation())) return false;
      if (!getProtocol().equals(other.getProtocol())) return false;
      if (!getVersion().equals(other.getVersion())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getService().hashCode();
      hash = (37 * hash) + OPERATION_FIELD_NUMBER;
      hash = (53 * hash) + getOperation().hashCode();
      hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
      hash = (53 * hash) + getProtocol().hashCode();
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.rpc.context.AttributeContext.Api parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Api parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Api parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Api parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Api parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Api parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Api parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Api parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Api parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Api parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Api parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Api parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.rpc.context.AttributeContext.Api prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * This message defines attributes associated with API operations, such as
     * a network API request. The terminology is based on the conventions used
     * by Google APIs, Istio, and OpenAPI.
     * </pre>
     *
     * Protobuf type {@code google.rpc.context.AttributeContext.Api}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.rpc.context.AttributeContext.Api)
        com.google.rpc.context.AttributeContext.ApiOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Api_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Api_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.rpc.context.AttributeContext.Api.class,
                com.google.rpc.context.AttributeContext.Api.Builder.class);
      }

      // Construct using com.google.rpc.context.AttributeContext.Api.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        service_ = "";

        operation_ = "";

        protocol_ = "";

        version_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Api_descriptor;
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Api getDefaultInstanceForType() {
        return com.google.rpc.context.AttributeContext.Api.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Api build() {
        com.google.rpc.context.AttributeContext.Api result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Api buildPartial() {
        com.google.rpc.context.AttributeContext.Api result =
            new com.google.rpc.context.AttributeContext.Api(this);
        result.service_ = service_;
        result.operation_ = operation_;
        result.protocol_ = protocol_;
        result.version_ = version_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.rpc.context.AttributeContext.Api) {
          return mergeFrom((com.google.rpc.context.AttributeContext.Api) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.rpc.context.AttributeContext.Api other) {
        if (other == com.google.rpc.context.AttributeContext.Api.getDefaultInstance()) return this;
        if (!other.getService().isEmpty()) {
          service_ = other.service_;
          onChanged();
        }
        if (!other.getOperation().isEmpty()) {
          operation_ = other.operation_;
          onChanged();
        }
        if (!other.getProtocol().isEmpty()) {
          protocol_ = other.protocol_;
          onChanged();
        }
        if (!other.getVersion().isEmpty()) {
          version_ = other.version_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.rpc.context.AttributeContext.Api parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.rpc.context.AttributeContext.Api) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object service_ = "";
      /**
       *
       *
       * <pre>
       * The API service name. It is a logical identifier for a networked API,
       * such as "pubsub.googleapis.com". The naming syntax depends on the
       * API management system being used for handling the request.
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @return The service.
       */
      public java.lang.String getService() {
        java.lang.Object ref = service_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          service_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The API service name. It is a logical identifier for a networked API,
       * such as "pubsub.googleapis.com". The naming syntax depends on the
       * API management system being used for handling the request.
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @return The bytes for service.
       */
      public com.google.protobuf.ByteString getServiceBytes() {
        java.lang.Object ref = service_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          service_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The API service name. It is a logical identifier for a networked API,
       * such as "pubsub.googleapis.com". The naming syntax depends on the
       * API management system being used for handling the request.
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @param value The service to set.
       * @return This builder for chaining.
       */
      public Builder setService(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        service_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The API service name. It is a logical identifier for a networked API,
       * such as "pubsub.googleapis.com". The naming syntax depends on the
       * API management system being used for handling the request.
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearService() {

        service_ = getDefaultInstance().getService();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The API service name. It is a logical identifier for a networked API,
       * such as "pubsub.googleapis.com". The naming syntax depends on the
       * API management system being used for handling the request.
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @param value The bytes for service to set.
       * @return This builder for chaining.
       */
      public Builder setServiceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        service_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object operation_ = "";
      /**
       *
       *
       * <pre>
       * The API operation name. For gRPC requests, it is the fully qualified API
       * method name, such as "google.pubsub.v1.Publisher.Publish". For OpenAPI
       * requests, it is the `operationId`, such as "getPet".
       * </pre>
       *
       * <code>string operation = 2;</code>
       *
       * @return The operation.
       */
      public java.lang.String getOperation() {
        java.lang.Object ref = operation_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          operation_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The API operation name. For gRPC requests, it is the fully qualified API
       * method name, such as "google.pubsub.v1.Publisher.Publish". For OpenAPI
       * requests, it is the `operationId`, such as "getPet".
       * </pre>
       *
       * <code>string operation = 2;</code>
       *
       * @return The bytes for operation.
       */
      public com.google.protobuf.ByteString getOperationBytes() {
        java.lang.Object ref = operation_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          operation_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The API operation name. For gRPC requests, it is the fully qualified API
       * method name, such as "google.pubsub.v1.Publisher.Publish". For OpenAPI
       * requests, it is the `operationId`, such as "getPet".
       * </pre>
       *
       * <code>string operation = 2;</code>
       *
       * @param value The operation to set.
       * @return This builder for chaining.
       */
      public Builder setOperation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        operation_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The API operation name. For gRPC requests, it is the fully qualified API
       * method name, such as "google.pubsub.v1.Publisher.Publish". For OpenAPI
       * requests, it is the `operationId`, such as "getPet".
       * </pre>
       *
       * <code>string operation = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOperation() {

        operation_ = getDefaultInstance().getOperation();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The API operation name. For gRPC requests, it is the fully qualified API
       * method name, such as "google.pubsub.v1.Publisher.Publish". For OpenAPI
       * requests, it is the `operationId`, such as "getPet".
       * </pre>
       *
       * <code>string operation = 2;</code>
       *
       * @param value The bytes for operation to set.
       * @return This builder for chaining.
       */
      public Builder setOperationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        operation_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object protocol_ = "";
      /**
       *
       *
       * <pre>
       * The API protocol used for sending the request, such as "http", "https",
       * "grpc", or "internal".
       * </pre>
       *
       * <code>string protocol = 3;</code>
       *
       * @return The protocol.
       */
      public java.lang.String getProtocol() {
        java.lang.Object ref = protocol_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          protocol_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The API protocol used for sending the request, such as "http", "https",
       * "grpc", or "internal".
       * </pre>
       *
       * <code>string protocol = 3;</code>
       *
       * @return The bytes for protocol.
       */
      public com.google.protobuf.ByteString getProtocolBytes() {
        java.lang.Object ref = protocol_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          protocol_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The API protocol used for sending the request, such as "http", "https",
       * "grpc", or "internal".
       * </pre>
       *
       * <code>string protocol = 3;</code>
       *
       * @param value The protocol to set.
       * @return This builder for chaining.
       */
      public Builder setProtocol(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        protocol_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The API protocol used for sending the request, such as "http", "https",
       * "grpc", or "internal".
       * </pre>
       *
       * <code>string protocol = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProtocol() {

        protocol_ = getDefaultInstance().getProtocol();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The API protocol used for sending the request, such as "http", "https",
       * "grpc", or "internal".
       * </pre>
       *
       * <code>string protocol = 3;</code>
       *
       * @param value The bytes for protocol to set.
       * @return This builder for chaining.
       */
      public Builder setProtocolBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        protocol_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object version_ = "";
      /**
       *
       *
       * <pre>
       * The API version associated with the API operation above, such as "v1" or
       * "v1alpha1".
       * </pre>
       *
       * <code>string version = 4;</code>
       *
       * @return The version.
       */
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          version_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The API version associated with the API operation above, such as "v1" or
       * "v1alpha1".
       * </pre>
       *
       * <code>string version = 4;</code>
       *
       * @return The bytes for version.
       */
      public com.google.protobuf.ByteString getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The API version associated with the API operation above, such as "v1" or
       * "v1alpha1".
       * </pre>
       *
       * <code>string version = 4;</code>
       *
       * @param value The version to set.
       * @return This builder for chaining.
       */
      public Builder setVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        version_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The API version associated with the API operation above, such as "v1" or
       * "v1alpha1".
       * </pre>
       *
       * <code>string version = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVersion() {

        version_ = getDefaultInstance().getVersion();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The API version associated with the API operation above, such as "v1" or
       * "v1alpha1".
       * </pre>
       *
       * <code>string version = 4;</code>
       *
       * @param value The bytes for version to set.
       * @return This builder for chaining.
       */
      public Builder setVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        version_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.rpc.context.AttributeContext.Api)
    }

    // @@protoc_insertion_point(class_scope:google.rpc.context.AttributeContext.Api)
    private static final com.google.rpc.context.AttributeContext.Api DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.rpc.context.AttributeContext.Api();
    }

    public static com.google.rpc.context.AttributeContext.Api getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Api> PARSER =
        new com.google.protobuf.AbstractParser<Api>() {
          @java.lang.Override
          public Api parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Api(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Api> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Api> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.rpc.context.AttributeContext.Api getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AuthOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.rpc.context.AttributeContext.Auth)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The authenticated principal. Reflects the issuer (`iss`) and subject
     * (`sub`) claims within a JWT. The issuer and subject should be `/`
     * delimited, with `/` percent-encoded within the subject fragment. For
     * Google accounts, the principal format is:
     * "https://accounts.google.com/{id}"
     * </pre>
     *
     * <code>string principal = 1;</code>
     *
     * @return The principal.
     */
    java.lang.String getPrincipal();
    /**
     *
     *
     * <pre>
     * The authenticated principal. Reflects the issuer (`iss`) and subject
     * (`sub`) claims within a JWT. The issuer and subject should be `/`
     * delimited, with `/` percent-encoded within the subject fragment. For
     * Google accounts, the principal format is:
     * "https://accounts.google.com/{id}"
     * </pre>
     *
     * <code>string principal = 1;</code>
     *
     * @return The bytes for principal.
     */
    com.google.protobuf.ByteString getPrincipalBytes();

    /**
     *
     *
     * <pre>
     * The intended audience(s) for this authentication information. Reflects
     * the audience (`aud`) claim within a JWT. The audience
     * value(s) depends on the `issuer`, but typically include one or more of
     * the following pieces of information:
     * *  The services intended to receive the credential. For example,
     *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
     * *  A set of service-based scopes. For example,
     *    ["https://www.googleapis.com/auth/cloud-platform"].
     * *  The client id of an app, such as the Firebase project id for JWTs
     *    from Firebase Auth.
     * Consult the documentation for the credential issuer to determine the
     * information provided.
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     *
     * @return A list containing the audiences.
     */
    java.util.List<java.lang.String> getAudiencesList();
    /**
     *
     *
     * <pre>
     * The intended audience(s) for this authentication information. Reflects
     * the audience (`aud`) claim within a JWT. The audience
     * value(s) depends on the `issuer`, but typically include one or more of
     * the following pieces of information:
     * *  The services intended to receive the credential. For example,
     *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
     * *  A set of service-based scopes. For example,
     *    ["https://www.googleapis.com/auth/cloud-platform"].
     * *  The client id of an app, such as the Firebase project id for JWTs
     *    from Firebase Auth.
     * Consult the documentation for the credential issuer to determine the
     * information provided.
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     *
     * @return The count of audiences.
     */
    int getAudiencesCount();
    /**
     *
     *
     * <pre>
     * The intended audience(s) for this authentication information. Reflects
     * the audience (`aud`) claim within a JWT. The audience
     * value(s) depends on the `issuer`, but typically include one or more of
     * the following pieces of information:
     * *  The services intended to receive the credential. For example,
     *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
     * *  A set of service-based scopes. For example,
     *    ["https://www.googleapis.com/auth/cloud-platform"].
     * *  The client id of an app, such as the Firebase project id for JWTs
     *    from Firebase Auth.
     * Consult the documentation for the credential issuer to determine the
     * information provided.
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The audiences at the given index.
     */
    java.lang.String getAudiences(int index);
    /**
     *
     *
     * <pre>
     * The intended audience(s) for this authentication information. Reflects
     * the audience (`aud`) claim within a JWT. The audience
     * value(s) depends on the `issuer`, but typically include one or more of
     * the following pieces of information:
     * *  The services intended to receive the credential. For example,
     *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
     * *  A set of service-based scopes. For example,
     *    ["https://www.googleapis.com/auth/cloud-platform"].
     * *  The client id of an app, such as the Firebase project id for JWTs
     *    from Firebase Auth.
     * Consult the documentation for the credential issuer to determine the
     * information provided.
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the audiences at the given index.
     */
    com.google.protobuf.ByteString getAudiencesBytes(int index);

    /**
     *
     *
     * <pre>
     * The authorized presenter of the credential. Reflects the optional
     * Authorized Presenter (`azp`) claim within a JWT or the
     * OAuth client id. For example, a Google Cloud Platform client id looks
     * as follows: "123456789012.apps.googleusercontent.com".
     * </pre>
     *
     * <code>string presenter = 3;</code>
     *
     * @return The presenter.
     */
    java.lang.String getPresenter();
    /**
     *
     *
     * <pre>
     * The authorized presenter of the credential. Reflects the optional
     * Authorized Presenter (`azp`) claim within a JWT or the
     * OAuth client id. For example, a Google Cloud Platform client id looks
     * as follows: "123456789012.apps.googleusercontent.com".
     * </pre>
     *
     * <code>string presenter = 3;</code>
     *
     * @return The bytes for presenter.
     */
    com.google.protobuf.ByteString getPresenterBytes();

    /**
     *
     *
     * <pre>
     * Structured claims presented with the credential. JWTs include
     * `{key: value}` pairs for standard and private claims. The following
     * is a subset of the standard required and optional claims that would
     * typically be presented for a Google-based JWT:
     *    {'iss': 'accounts.google.com',
     *     'sub': '113289723416554971153',
     *     'aud': ['123456789012', 'pubsub.googleapis.com'],
     *     'azp': '123456789012.apps.googleusercontent.com',
     *     'email': 'jsmith&#64;example.com',
     *     'iat': 1353601026,
     *     'exp': 1353604926}
     * SAML assertions are similarly specified, but with an identity provider
     * dependent structure.
     * </pre>
     *
     * <code>.google.protobuf.Struct claims = 4;</code>
     *
     * @return Whether the claims field is set.
     */
    boolean hasClaims();
    /**
     *
     *
     * <pre>
     * Structured claims presented with the credential. JWTs include
     * `{key: value}` pairs for standard and private claims. The following
     * is a subset of the standard required and optional claims that would
     * typically be presented for a Google-based JWT:
     *    {'iss': 'accounts.google.com',
     *     'sub': '113289723416554971153',
     *     'aud': ['123456789012', 'pubsub.googleapis.com'],
     *     'azp': '123456789012.apps.googleusercontent.com',
     *     'email': 'jsmith&#64;example.com',
     *     'iat': 1353601026,
     *     'exp': 1353604926}
     * SAML assertions are similarly specified, but with an identity provider
     * dependent structure.
     * </pre>
     *
     * <code>.google.protobuf.Struct claims = 4;</code>
     *
     * @return The claims.
     */
    com.google.protobuf.Struct getClaims();
    /**
     *
     *
     * <pre>
     * Structured claims presented with the credential. JWTs include
     * `{key: value}` pairs for standard and private claims. The following
     * is a subset of the standard required and optional claims that would
     * typically be presented for a Google-based JWT:
     *    {'iss': 'accounts.google.com',
     *     'sub': '113289723416554971153',
     *     'aud': ['123456789012', 'pubsub.googleapis.com'],
     *     'azp': '123456789012.apps.googleusercontent.com',
     *     'email': 'jsmith&#64;example.com',
     *     'iat': 1353601026,
     *     'exp': 1353604926}
     * SAML assertions are similarly specified, but with an identity provider
     * dependent structure.
     * </pre>
     *
     * <code>.google.protobuf.Struct claims = 4;</code>
     */
    com.google.protobuf.StructOrBuilder getClaimsOrBuilder();

    /**
     *
     *
     * <pre>
     * A list of access level resource names that allow resources to be
     * accessed by authenticated requester. It is part of Secure GCP processing
     * for the incoming request. An access level string has the format:
     * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
     * Example:
     * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
     * </pre>
     *
     * <code>repeated string access_levels = 5;</code>
     *
     * @return A list containing the accessLevels.
     */
    java.util.List<java.lang.String> getAccessLevelsList();
    /**
     *
     *
     * <pre>
     * A list of access level resource names that allow resources to be
     * accessed by authenticated requester. It is part of Secure GCP processing
     * for the incoming request. An access level string has the format:
     * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
     * Example:
     * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
     * </pre>
     *
     * <code>repeated string access_levels = 5;</code>
     *
     * @return The count of accessLevels.
     */
    int getAccessLevelsCount();
    /**
     *
     *
     * <pre>
     * A list of access level resource names that allow resources to be
     * accessed by authenticated requester. It is part of Secure GCP processing
     * for the incoming request. An access level string has the format:
     * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
     * Example:
     * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
     * </pre>
     *
     * <code>repeated string access_levels = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The accessLevels at the given index.
     */
    java.lang.String getAccessLevels(int index);
    /**
     *
     *
     * <pre>
     * A list of access level resource names that allow resources to be
     * accessed by authenticated requester. It is part of Secure GCP processing
     * for the incoming request. An access level string has the format:
     * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
     * Example:
     * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
     * </pre>
     *
     * <code>repeated string access_levels = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the accessLevels at the given index.
     */
    com.google.protobuf.ByteString getAccessLevelsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * This message defines request authentication attributes. Terminology is
   * based on the JSON Web Token (JWT) standard, but the terms also
   * correlate to concepts in other standards.
   * </pre>
   *
   * Protobuf type {@code google.rpc.context.AttributeContext.Auth}
   */
  public static final class Auth extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.rpc.context.AttributeContext.Auth)
      AuthOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Auth.newBuilder() to construct.
    private Auth(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Auth() {
      principal_ = "";
      audiences_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      presenter_ = "";
      accessLevels_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Auth();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Auth(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                principal_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  audiences_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000001;
                }
                audiences_.add(s);
                break;
              }
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();

                presenter_ = s;
                break;
              }
            case 34:
              {
                com.google.protobuf.Struct.Builder subBuilder = null;
                if (claims_ != null) {
                  subBuilder = claims_.toBuilder();
                }
                claims_ = input.readMessage(com.google.protobuf.Struct.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(claims_);
                  claims_ = subBuilder.buildPartial();
                }

                break;
              }
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                  accessLevels_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000002;
                }
                accessLevels_.add(s);
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          audiences_ = audiences_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          accessLevels_ = accessLevels_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_Auth_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_Auth_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.rpc.context.AttributeContext.Auth.class,
              com.google.rpc.context.AttributeContext.Auth.Builder.class);
    }

    public static final int PRINCIPAL_FIELD_NUMBER = 1;
    private volatile java.lang.Object principal_;
    /**
     *
     *
     * <pre>
     * The authenticated principal. Reflects the issuer (`iss`) and subject
     * (`sub`) claims within a JWT. The issuer and subject should be `/`
     * delimited, with `/` percent-encoded within the subject fragment. For
     * Google accounts, the principal format is:
     * "https://accounts.google.com/{id}"
     * </pre>
     *
     * <code>string principal = 1;</code>
     *
     * @return The principal.
     */
    @java.lang.Override
    public java.lang.String getPrincipal() {
      java.lang.Object ref = principal_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        principal_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The authenticated principal. Reflects the issuer (`iss`) and subject
     * (`sub`) claims within a JWT. The issuer and subject should be `/`
     * delimited, with `/` percent-encoded within the subject fragment. For
     * Google accounts, the principal format is:
     * "https://accounts.google.com/{id}"
     * </pre>
     *
     * <code>string principal = 1;</code>
     *
     * @return The bytes for principal.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPrincipalBytes() {
      java.lang.Object ref = principal_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        principal_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AUDIENCES_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList audiences_;
    /**
     *
     *
     * <pre>
     * The intended audience(s) for this authentication information. Reflects
     * the audience (`aud`) claim within a JWT. The audience
     * value(s) depends on the `issuer`, but typically include one or more of
     * the following pieces of information:
     * *  The services intended to receive the credential. For example,
     *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
     * *  A set of service-based scopes. For example,
     *    ["https://www.googleapis.com/auth/cloud-platform"].
     * *  The client id of an app, such as the Firebase project id for JWTs
     *    from Firebase Auth.
     * Consult the documentation for the credential issuer to determine the
     * information provided.
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     *
     * @return A list containing the audiences.
     */
    public com.google.protobuf.ProtocolStringList getAudiencesList() {
      return audiences_;
    }
    /**
     *
     *
     * <pre>
     * The intended audience(s) for this authentication information. Reflects
     * the audience (`aud`) claim within a JWT. The audience
     * value(s) depends on the `issuer`, but typically include one or more of
     * the following pieces of information:
     * *  The services intended to receive the credential. For example,
     *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
     * *  A set of service-based scopes. For example,
     *    ["https://www.googleapis.com/auth/cloud-platform"].
     * *  The client id of an app, such as the Firebase project id for JWTs
     *    from Firebase Auth.
     * Consult the documentation for the credential issuer to determine the
     * information provided.
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     *
     * @return The count of audiences.
     */
    public int getAudiencesCount() {
      return audiences_.size();
    }
    /**
     *
     *
     * <pre>
     * The intended audience(s) for this authentication information. Reflects
     * the audience (`aud`) claim within a JWT. The audience
     * value(s) depends on the `issuer`, but typically include one or more of
     * the following pieces of information:
     * *  The services intended to receive the credential. For example,
     *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
     * *  A set of service-based scopes. For example,
     *    ["https://www.googleapis.com/auth/cloud-platform"].
     * *  The client id of an app, such as the Firebase project id for JWTs
     *    from Firebase Auth.
     * Consult the documentation for the credential issuer to determine the
     * information provided.
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The audiences at the given index.
     */
    public java.lang.String getAudiences(int index) {
      return audiences_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The intended audience(s) for this authentication information. Reflects
     * the audience (`aud`) claim within a JWT. The audience
     * value(s) depends on the `issuer`, but typically include one or more of
     * the following pieces of information:
     * *  The services intended to receive the credential. For example,
     *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
     * *  A set of service-based scopes. For example,
     *    ["https://www.googleapis.com/auth/cloud-platform"].
     * *  The client id of an app, such as the Firebase project id for JWTs
     *    from Firebase Auth.
     * Consult the documentation for the credential issuer to determine the
     * information provided.
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the audiences at the given index.
     */
    public com.google.protobuf.ByteString getAudiencesBytes(int index) {
      return audiences_.getByteString(index);
    }

    public static final int PRESENTER_FIELD_NUMBER = 3;
    private volatile java.lang.Object presenter_;
    /**
     *
     *
     * <pre>
     * The authorized presenter of the credential. Reflects the optional
     * Authorized Presenter (`azp`) claim within a JWT or the
     * OAuth client id. For example, a Google Cloud Platform client id looks
     * as follows: "123456789012.apps.googleusercontent.com".
     * </pre>
     *
     * <code>string presenter = 3;</code>
     *
     * @return The presenter.
     */
    @java.lang.Override
    public java.lang.String getPresenter() {
      java.lang.Object ref = presenter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        presenter_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The authorized presenter of the credential. Reflects the optional
     * Authorized Presenter (`azp`) claim within a JWT or the
     * OAuth client id. For example, a Google Cloud Platform client id looks
     * as follows: "123456789012.apps.googleusercontent.com".
     * </pre>
     *
     * <code>string presenter = 3;</code>
     *
     * @return The bytes for presenter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPresenterBytes() {
      java.lang.Object ref = presenter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        presenter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CLAIMS_FIELD_NUMBER = 4;
    private com.google.protobuf.Struct claims_;
    /**
     *
     *
     * <pre>
     * Structured claims presented with the credential. JWTs include
     * `{key: value}` pairs for standard and private claims. The following
     * is a subset of the standard required and optional claims that would
     * typically be presented for a Google-based JWT:
     *    {'iss': 'accounts.google.com',
     *     'sub': '113289723416554971153',
     *     'aud': ['123456789012', 'pubsub.googleapis.com'],
     *     'azp': '123456789012.apps.googleusercontent.com',
     *     'email': 'jsmith&#64;example.com',
     *     'iat': 1353601026,
     *     'exp': 1353604926}
     * SAML assertions are similarly specified, but with an identity provider
     * dependent structure.
     * </pre>
     *
     * <code>.google.protobuf.Struct claims = 4;</code>
     *
     * @return Whether the claims field is set.
     */
    @java.lang.Override
    public boolean hasClaims() {
      return claims_ != null;
    }
    /**
     *
     *
     * <pre>
     * Structured claims presented with the credential. JWTs include
     * `{key: value}` pairs for standard and private claims. The following
     * is a subset of the standard required and optional claims that would
     * typically be presented for a Google-based JWT:
     *    {'iss': 'accounts.google.com',
     *     'sub': '113289723416554971153',
     *     'aud': ['123456789012', 'pubsub.googleapis.com'],
     *     'azp': '123456789012.apps.googleusercontent.com',
     *     'email': 'jsmith&#64;example.com',
     *     'iat': 1353601026,
     *     'exp': 1353604926}
     * SAML assertions are similarly specified, but with an identity provider
     * dependent structure.
     * </pre>
     *
     * <code>.google.protobuf.Struct claims = 4;</code>
     *
     * @return The claims.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getClaims() {
      return claims_ == null ? com.google.protobuf.Struct.getDefaultInstance() : claims_;
    }
    /**
     *
     *
     * <pre>
     * Structured claims presented with the credential. JWTs include
     * `{key: value}` pairs for standard and private claims. The following
     * is a subset of the standard required and optional claims that would
     * typically be presented for a Google-based JWT:
     *    {'iss': 'accounts.google.com',
     *     'sub': '113289723416554971153',
     *     'aud': ['123456789012', 'pubsub.googleapis.com'],
     *     'azp': '123456789012.apps.googleusercontent.com',
     *     'email': 'jsmith&#64;example.com',
     *     'iat': 1353601026,
     *     'exp': 1353604926}
     * SAML assertions are similarly specified, but with an identity provider
     * dependent structure.
     * </pre>
     *
     * <code>.google.protobuf.Struct claims = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getClaimsOrBuilder() {
      return getClaims();
    }

    public static final int ACCESS_LEVELS_FIELD_NUMBER = 5;
    private com.google.protobuf.LazyStringList accessLevels_;
    /**
     *
     *
     * <pre>
     * A list of access level resource names that allow resources to be
     * accessed by authenticated requester. It is part of Secure GCP processing
     * for the incoming request. An access level string has the format:
     * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
     * Example:
     * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
     * </pre>
     *
     * <code>repeated string access_levels = 5;</code>
     *
     * @return A list containing the accessLevels.
     */
    public com.google.protobuf.ProtocolStringList getAccessLevelsList() {
      return accessLevels_;
    }
    /**
     *
     *
     * <pre>
     * A list of access level resource names that allow resources to be
     * accessed by authenticated requester. It is part of Secure GCP processing
     * for the incoming request. An access level string has the format:
     * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
     * Example:
     * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
     * </pre>
     *
     * <code>repeated string access_levels = 5;</code>
     *
     * @return The count of accessLevels.
     */
    public int getAccessLevelsCount() {
      return accessLevels_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of access level resource names that allow resources to be
     * accessed by authenticated requester. It is part of Secure GCP processing
     * for the incoming request. An access level string has the format:
     * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
     * Example:
     * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
     * </pre>
     *
     * <code>repeated string access_levels = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The accessLevels at the given index.
     */
    public java.lang.String getAccessLevels(int index) {
      return accessLevels_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of access level resource names that allow resources to be
     * accessed by authenticated requester. It is part of Secure GCP processing
     * for the incoming request. An access level string has the format:
     * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
     * Example:
     * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
     * </pre>
     *
     * <code>repeated string access_levels = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the accessLevels at the given index.
     */
    public com.google.protobuf.ByteString getAccessLevelsBytes(int index) {
      return accessLevels_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principal_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, principal_);
      }
      for (int i = 0; i < audiences_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, audiences_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(presenter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, presenter_);
      }
      if (claims_ != null) {
        output.writeMessage(4, getClaims());
      }
      for (int i = 0; i < accessLevels_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, accessLevels_.getRaw(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principal_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, principal_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < audiences_.size(); i++) {
          dataSize += computeStringSizeNoTag(audiences_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAudiencesList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(presenter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, presenter_);
      }
      if (claims_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getClaims());
      }
      {
        int dataSize = 0;
        for (int i = 0; i < accessLevels_.size(); i++) {
          dataSize += computeStringSizeNoTag(accessLevels_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAccessLevelsList().size();
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.rpc.context.AttributeContext.Auth)) {
        return super.equals(obj);
      }
      com.google.rpc.context.AttributeContext.Auth other =
          (com.google.rpc.context.AttributeContext.Auth) obj;

      if (!getPrincipal().equals(other.getPrincipal())) return false;
      if (!getAudiencesList().equals(other.getAudiencesList())) return false;
      if (!getPresenter().equals(other.getPresenter())) return false;
      if (hasClaims() != other.hasClaims()) return false;
      if (hasClaims()) {
        if (!getClaims().equals(other.getClaims())) return false;
      }
      if (!getAccessLevelsList().equals(other.getAccessLevelsList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PRINCIPAL_FIELD_NUMBER;
      hash = (53 * hash) + getPrincipal().hashCode();
      if (getAudiencesCount() > 0) {
        hash = (37 * hash) + AUDIENCES_FIELD_NUMBER;
        hash = (53 * hash) + getAudiencesList().hashCode();
      }
      hash = (37 * hash) + PRESENTER_FIELD_NUMBER;
      hash = (53 * hash) + getPresenter().hashCode();
      if (hasClaims()) {
        hash = (37 * hash) + CLAIMS_FIELD_NUMBER;
        hash = (53 * hash) + getClaims().hashCode();
      }
      if (getAccessLevelsCount() > 0) {
        hash = (37 * hash) + ACCESS_LEVELS_FIELD_NUMBER;
        hash = (53 * hash) + getAccessLevelsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.rpc.context.AttributeContext.Auth parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Auth parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Auth parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Auth parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Auth parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Auth parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Auth parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Auth parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Auth parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Auth parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Auth parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Auth parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.rpc.context.AttributeContext.Auth prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * This message defines request authentication attributes. Terminology is
     * based on the JSON Web Token (JWT) standard, but the terms also
     * correlate to concepts in other standards.
     * </pre>
     *
     * Protobuf type {@code google.rpc.context.AttributeContext.Auth}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.rpc.context.AttributeContext.Auth)
        com.google.rpc.context.AttributeContext.AuthOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Auth_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Auth_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.rpc.context.AttributeContext.Auth.class,
                com.google.rpc.context.AttributeContext.Auth.Builder.class);
      }

      // Construct using com.google.rpc.context.AttributeContext.Auth.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        principal_ = "";

        audiences_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        presenter_ = "";

        if (claimsBuilder_ == null) {
          claims_ = null;
        } else {
          claims_ = null;
          claimsBuilder_ = null;
        }
        accessLevels_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Auth_descriptor;
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Auth getDefaultInstanceForType() {
        return com.google.rpc.context.AttributeContext.Auth.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Auth build() {
        com.google.rpc.context.AttributeContext.Auth result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Auth buildPartial() {
        com.google.rpc.context.AttributeContext.Auth result =
            new com.google.rpc.context.AttributeContext.Auth(this);
        int from_bitField0_ = bitField0_;
        result.principal_ = principal_;
        if (((bitField0_ & 0x00000001) != 0)) {
          audiences_ = audiences_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.audiences_ = audiences_;
        result.presenter_ = presenter_;
        if (claimsBuilder_ == null) {
          result.claims_ = claims_;
        } else {
          result.claims_ = claimsBuilder_.build();
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          accessLevels_ = accessLevels_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.accessLevels_ = accessLevels_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.rpc.context.AttributeContext.Auth) {
          return mergeFrom((com.google.rpc.context.AttributeContext.Auth) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.rpc.context.AttributeContext.Auth other) {
        if (other == com.google.rpc.context.AttributeContext.Auth.getDefaultInstance()) return this;
        if (!other.getPrincipal().isEmpty()) {
          principal_ = other.principal_;
          onChanged();
        }
        if (!other.audiences_.isEmpty()) {
          if (audiences_.isEmpty()) {
            audiences_ = other.audiences_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAudiencesIsMutable();
            audiences_.addAll(other.audiences_);
          }
          onChanged();
        }
        if (!other.getPresenter().isEmpty()) {
          presenter_ = other.presenter_;
          onChanged();
        }
        if (other.hasClaims()) {
          mergeClaims(other.getClaims());
        }
        if (!other.accessLevels_.isEmpty()) {
          if (accessLevels_.isEmpty()) {
            accessLevels_ = other.accessLevels_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAccessLevelsIsMutable();
            accessLevels_.addAll(other.accessLevels_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.rpc.context.AttributeContext.Auth parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.rpc.context.AttributeContext.Auth) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object principal_ = "";
      /**
       *
       *
       * <pre>
       * The authenticated principal. Reflects the issuer (`iss`) and subject
       * (`sub`) claims within a JWT. The issuer and subject should be `/`
       * delimited, with `/` percent-encoded within the subject fragment. For
       * Google accounts, the principal format is:
       * "https://accounts.google.com/{id}"
       * </pre>
       *
       * <code>string principal = 1;</code>
       *
       * @return The principal.
       */
      public java.lang.String getPrincipal() {
        java.lang.Object ref = principal_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          principal_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The authenticated principal. Reflects the issuer (`iss`) and subject
       * (`sub`) claims within a JWT. The issuer and subject should be `/`
       * delimited, with `/` percent-encoded within the subject fragment. For
       * Google accounts, the principal format is:
       * "https://accounts.google.com/{id}"
       * </pre>
       *
       * <code>string principal = 1;</code>
       *
       * @return The bytes for principal.
       */
      public com.google.protobuf.ByteString getPrincipalBytes() {
        java.lang.Object ref = principal_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          principal_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The authenticated principal. Reflects the issuer (`iss`) and subject
       * (`sub`) claims within a JWT. The issuer and subject should be `/`
       * delimited, with `/` percent-encoded within the subject fragment. For
       * Google accounts, the principal format is:
       * "https://accounts.google.com/{id}"
       * </pre>
       *
       * <code>string principal = 1;</code>
       *
       * @param value The principal to set.
       * @return This builder for chaining.
       */
      public Builder setPrincipal(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        principal_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The authenticated principal. Reflects the issuer (`iss`) and subject
       * (`sub`) claims within a JWT. The issuer and subject should be `/`
       * delimited, with `/` percent-encoded within the subject fragment. For
       * Google accounts, the principal format is:
       * "https://accounts.google.com/{id}"
       * </pre>
       *
       * <code>string principal = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrincipal() {

        principal_ = getDefaultInstance().getPrincipal();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The authenticated principal. Reflects the issuer (`iss`) and subject
       * (`sub`) claims within a JWT. The issuer and subject should be `/`
       * delimited, with `/` percent-encoded within the subject fragment. For
       * Google accounts, the principal format is:
       * "https://accounts.google.com/{id}"
       * </pre>
       *
       * <code>string principal = 1;</code>
       *
       * @param value The bytes for principal to set.
       * @return This builder for chaining.
       */
      public Builder setPrincipalBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        principal_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList audiences_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureAudiencesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          audiences_ = new com.google.protobuf.LazyStringArrayList(audiences_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * The intended audience(s) for this authentication information. Reflects
       * the audience (`aud`) claim within a JWT. The audience
       * value(s) depends on the `issuer`, but typically include one or more of
       * the following pieces of information:
       * *  The services intended to receive the credential. For example,
       *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
       * *  A set of service-based scopes. For example,
       *    ["https://www.googleapis.com/auth/cloud-platform"].
       * *  The client id of an app, such as the Firebase project id for JWTs
       *    from Firebase Auth.
       * Consult the documentation for the credential issuer to determine the
       * information provided.
       * </pre>
       *
       * <code>repeated string audiences = 2;</code>
       *
       * @return A list containing the audiences.
       */
      public com.google.protobuf.ProtocolStringList getAudiencesList() {
        return audiences_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * The intended audience(s) for this authentication information. Reflects
       * the audience (`aud`) claim within a JWT. The audience
       * value(s) depends on the `issuer`, but typically include one or more of
       * the following pieces of information:
       * *  The services intended to receive the credential. For example,
       *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
       * *  A set of service-based scopes. For example,
       *    ["https://www.googleapis.com/auth/cloud-platform"].
       * *  The client id of an app, such as the Firebase project id for JWTs
       *    from Firebase Auth.
       * Consult the documentation for the credential issuer to determine the
       * information provided.
       * </pre>
       *
       * <code>repeated string audiences = 2;</code>
       *
       * @return The count of audiences.
       */
      public int getAudiencesCount() {
        return audiences_.size();
      }
      /**
       *
       *
       * <pre>
       * The intended audience(s) for this authentication information. Reflects
       * the audience (`aud`) claim within a JWT. The audience
       * value(s) depends on the `issuer`, but typically include one or more of
       * the following pieces of information:
       * *  The services intended to receive the credential. For example,
       *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
       * *  A set of service-based scopes. For example,
       *    ["https://www.googleapis.com/auth/cloud-platform"].
       * *  The client id of an app, such as the Firebase project id for JWTs
       *    from Firebase Auth.
       * Consult the documentation for the credential issuer to determine the
       * information provided.
       * </pre>
       *
       * <code>repeated string audiences = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The audiences at the given index.
       */
      public java.lang.String getAudiences(int index) {
        return audiences_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The intended audience(s) for this authentication information. Reflects
       * the audience (`aud`) claim within a JWT. The audience
       * value(s) depends on the `issuer`, but typically include one or more of
       * the following pieces of information:
       * *  The services intended to receive the credential. For example,
       *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
       * *  A set of service-based scopes. For example,
       *    ["https://www.googleapis.com/auth/cloud-platform"].
       * *  The client id of an app, such as the Firebase project id for JWTs
       *    from Firebase Auth.
       * Consult the documentation for the credential issuer to determine the
       * information provided.
       * </pre>
       *
       * <code>repeated string audiences = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the audiences at the given index.
       */
      public com.google.protobuf.ByteString getAudiencesBytes(int index) {
        return audiences_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The intended audience(s) for this authentication information. Reflects
       * the audience (`aud`) claim within a JWT. The audience
       * value(s) depends on the `issuer`, but typically include one or more of
       * the following pieces of information:
       * *  The services intended to receive the credential. For example,
       *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
       * *  A set of service-based scopes. For example,
       *    ["https://www.googleapis.com/auth/cloud-platform"].
       * *  The client id of an app, such as the Firebase project id for JWTs
       *    from Firebase Auth.
       * Consult the documentation for the credential issuer to determine the
       * information provided.
       * </pre>
       *
       * <code>repeated string audiences = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The audiences to set.
       * @return This builder for chaining.
       */
      public Builder setAudiences(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAudiencesIsMutable();
        audiences_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The intended audience(s) for this authentication information. Reflects
       * the audience (`aud`) claim within a JWT. The audience
       * value(s) depends on the `issuer`, but typically include one or more of
       * the following pieces of information:
       * *  The services intended to receive the credential. For example,
       *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
       * *  A set of service-based scopes. For example,
       *    ["https://www.googleapis.com/auth/cloud-platform"].
       * *  The client id of an app, such as the Firebase project id for JWTs
       *    from Firebase Auth.
       * Consult the documentation for the credential issuer to determine the
       * information provided.
       * </pre>
       *
       * <code>repeated string audiences = 2;</code>
       *
       * @param value The audiences to add.
       * @return This builder for chaining.
       */
      public Builder addAudiences(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAudiencesIsMutable();
        audiences_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The intended audience(s) for this authentication information. Reflects
       * the audience (`aud`) claim within a JWT. The audience
       * value(s) depends on the `issuer`, but typically include one or more of
       * the following pieces of information:
       * *  The services intended to receive the credential. For example,
       *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
       * *  A set of service-based scopes. For example,
       *    ["https://www.googleapis.com/auth/cloud-platform"].
       * *  The client id of an app, such as the Firebase project id for JWTs
       *    from Firebase Auth.
       * Consult the documentation for the credential issuer to determine the
       * information provided.
       * </pre>
       *
       * <code>repeated string audiences = 2;</code>
       *
       * @param values The audiences to add.
       * @return This builder for chaining.
       */
      public Builder addAllAudiences(java.lang.Iterable<java.lang.String> values) {
        ensureAudiencesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, audiences_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The intended audience(s) for this authentication information. Reflects
       * the audience (`aud`) claim within a JWT. The audience
       * value(s) depends on the `issuer`, but typically include one or more of
       * the following pieces of information:
       * *  The services intended to receive the credential. For example,
       *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
       * *  A set of service-based scopes. For example,
       *    ["https://www.googleapis.com/auth/cloud-platform"].
       * *  The client id of an app, such as the Firebase project id for JWTs
       *    from Firebase Auth.
       * Consult the documentation for the credential issuer to determine the
       * information provided.
       * </pre>
       *
       * <code>repeated string audiences = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAudiences() {
        audiences_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The intended audience(s) for this authentication information. Reflects
       * the audience (`aud`) claim within a JWT. The audience
       * value(s) depends on the `issuer`, but typically include one or more of
       * the following pieces of information:
       * *  The services intended to receive the credential. For example,
       *    ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
       * *  A set of service-based scopes. For example,
       *    ["https://www.googleapis.com/auth/cloud-platform"].
       * *  The client id of an app, such as the Firebase project id for JWTs
       *    from Firebase Auth.
       * Consult the documentation for the credential issuer to determine the
       * information provided.
       * </pre>
       *
       * <code>repeated string audiences = 2;</code>
       *
       * @param value The bytes of the audiences to add.
       * @return This builder for chaining.
       */
      public Builder addAudiencesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAudiencesIsMutable();
        audiences_.add(value);
        onChanged();
        return this;
      }

      private java.lang.Object presenter_ = "";
      /**
       *
       *
       * <pre>
       * The authorized presenter of the credential. Reflects the optional
       * Authorized Presenter (`azp`) claim within a JWT or the
       * OAuth client id. For example, a Google Cloud Platform client id looks
       * as follows: "123456789012.apps.googleusercontent.com".
       * </pre>
       *
       * <code>string presenter = 3;</code>
       *
       * @return The presenter.
       */
      public java.lang.String getPresenter() {
        java.lang.Object ref = presenter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          presenter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The authorized presenter of the credential. Reflects the optional
       * Authorized Presenter (`azp`) claim within a JWT or the
       * OAuth client id. For example, a Google Cloud Platform client id looks
       * as follows: "123456789012.apps.googleusercontent.com".
       * </pre>
       *
       * <code>string presenter = 3;</code>
       *
       * @return The bytes for presenter.
       */
      public com.google.protobuf.ByteString getPresenterBytes() {
        java.lang.Object ref = presenter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          presenter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The authorized presenter of the credential. Reflects the optional
       * Authorized Presenter (`azp`) claim within a JWT or the
       * OAuth client id. For example, a Google Cloud Platform client id looks
       * as follows: "123456789012.apps.googleusercontent.com".
       * </pre>
       *
       * <code>string presenter = 3;</code>
       *
       * @param value The presenter to set.
       * @return This builder for chaining.
       */
      public Builder setPresenter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        presenter_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The authorized presenter of the credential. Reflects the optional
       * Authorized Presenter (`azp`) claim within a JWT or the
       * OAuth client id. For example, a Google Cloud Platform client id looks
       * as follows: "123456789012.apps.googleusercontent.com".
       * </pre>
       *
       * <code>string presenter = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPresenter() {

        presenter_ = getDefaultInstance().getPresenter();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The authorized presenter of the credential. Reflects the optional
       * Authorized Presenter (`azp`) claim within a JWT or the
       * OAuth client id. For example, a Google Cloud Platform client id looks
       * as follows: "123456789012.apps.googleusercontent.com".
       * </pre>
       *
       * <code>string presenter = 3;</code>
       *
       * @param value The bytes for presenter to set.
       * @return This builder for chaining.
       */
      public Builder setPresenterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        presenter_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.Struct claims_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          claimsBuilder_;
      /**
       *
       *
       * <pre>
       * Structured claims presented with the credential. JWTs include
       * `{key: value}` pairs for standard and private claims. The following
       * is a subset of the standard required and optional claims that would
       * typically be presented for a Google-based JWT:
       *    {'iss': 'accounts.google.com',
       *     'sub': '113289723416554971153',
       *     'aud': ['123456789012', 'pubsub.googleapis.com'],
       *     'azp': '123456789012.apps.googleusercontent.com',
       *     'email': 'jsmith&#64;example.com',
       *     'iat': 1353601026,
       *     'exp': 1353604926}
       * SAML assertions are similarly specified, but with an identity provider
       * dependent structure.
       * </pre>
       *
       * <code>.google.protobuf.Struct claims = 4;</code>
       *
       * @return Whether the claims field is set.
       */
      public boolean hasClaims() {
        return claimsBuilder_ != null || claims_ != null;
      }
      /**
       *
       *
       * <pre>
       * Structured claims presented with the credential. JWTs include
       * `{key: value}` pairs for standard and private claims. The following
       * is a subset of the standard required and optional claims that would
       * typically be presented for a Google-based JWT:
       *    {'iss': 'accounts.google.com',
       *     'sub': '113289723416554971153',
       *     'aud': ['123456789012', 'pubsub.googleapis.com'],
       *     'azp': '123456789012.apps.googleusercontent.com',
       *     'email': 'jsmith&#64;example.com',
       *     'iat': 1353601026,
       *     'exp': 1353604926}
       * SAML assertions are similarly specified, but with an identity provider
       * dependent structure.
       * </pre>
       *
       * <code>.google.protobuf.Struct claims = 4;</code>
       *
       * @return The claims.
       */
      public com.google.protobuf.Struct getClaims() {
        if (claimsBuilder_ == null) {
          return claims_ == null ? com.google.protobuf.Struct.getDefaultInstance() : claims_;
        } else {
          return claimsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Structured claims presented with the credential. JWTs include
       * `{key: value}` pairs for standard and private claims. The following
       * is a subset of the standard required and optional claims that would
       * typically be presented for a Google-based JWT:
       *    {'iss': 'accounts.google.com',
       *     'sub': '113289723416554971153',
       *     'aud': ['123456789012', 'pubsub.googleapis.com'],
       *     'azp': '123456789012.apps.googleusercontent.com',
       *     'email': 'jsmith&#64;example.com',
       *     'iat': 1353601026,
       *     'exp': 1353604926}
       * SAML assertions are similarly specified, but with an identity provider
       * dependent structure.
       * </pre>
       *
       * <code>.google.protobuf.Struct claims = 4;</code>
       */
      public Builder setClaims(com.google.protobuf.Struct value) {
        if (claimsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          claims_ = value;
          onChanged();
        } else {
          claimsBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Structured claims presented with the credential. JWTs include
       * `{key: value}` pairs for standard and private claims. The following
       * is a subset of the standard required and optional claims that would
       * typically be presented for a Google-based JWT:
       *    {'iss': 'accounts.google.com',
       *     'sub': '113289723416554971153',
       *     'aud': ['123456789012', 'pubsub.googleapis.com'],
       *     'azp': '123456789012.apps.googleusercontent.com',
       *     'email': 'jsmith&#64;example.com',
       *     'iat': 1353601026,
       *     'exp': 1353604926}
       * SAML assertions are similarly specified, but with an identity provider
       * dependent structure.
       * </pre>
       *
       * <code>.google.protobuf.Struct claims = 4;</code>
       */
      public Builder setClaims(com.google.protobuf.Struct.Builder builderForValue) {
        if (claimsBuilder_ == null) {
          claims_ = builderForValue.build();
          onChanged();
        } else {
          claimsBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Structured claims presented with the credential. JWTs include
       * `{key: value}` pairs for standard and private claims. The following
       * is a subset of the standard required and optional claims that would
       * typically be presented for a Google-based JWT:
       *    {'iss': 'accounts.google.com',
       *     'sub': '113289723416554971153',
       *     'aud': ['123456789012', 'pubsub.googleapis.com'],
       *     'azp': '123456789012.apps.googleusercontent.com',
       *     'email': 'jsmith&#64;example.com',
       *     'iat': 1353601026,
       *     'exp': 1353604926}
       * SAML assertions are similarly specified, but with an identity provider
       * dependent structure.
       * </pre>
       *
       * <code>.google.protobuf.Struct claims = 4;</code>
       */
      public Builder mergeClaims(com.google.protobuf.Struct value) {
        if (claimsBuilder_ == null) {
          if (claims_ != null) {
            claims_ =
                com.google.protobuf.Struct.newBuilder(claims_).mergeFrom(value).buildPartial();
          } else {
            claims_ = value;
          }
          onChanged();
        } else {
          claimsBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Structured claims presented with the credential. JWTs include
       * `{key: value}` pairs for standard and private claims. The following
       * is a subset of the standard required and optional claims that would
       * typically be presented for a Google-based JWT:
       *    {'iss': 'accounts.google.com',
       *     'sub': '113289723416554971153',
       *     'aud': ['123456789012', 'pubsub.googleapis.com'],
       *     'azp': '123456789012.apps.googleusercontent.com',
       *     'email': 'jsmith&#64;example.com',
       *     'iat': 1353601026,
       *     'exp': 1353604926}
       * SAML assertions are similarly specified, but with an identity provider
       * dependent structure.
       * </pre>
       *
       * <code>.google.protobuf.Struct claims = 4;</code>
       */
      public Builder clearClaims() {
        if (claimsBuilder_ == null) {
          claims_ = null;
          onChanged();
        } else {
          claims_ = null;
          claimsBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Structured claims presented with the credential. JWTs include
       * `{key: value}` pairs for standard and private claims. The following
       * is a subset of the standard required and optional claims that would
       * typically be presented for a Google-based JWT:
       *    {'iss': 'accounts.google.com',
       *     'sub': '113289723416554971153',
       *     'aud': ['123456789012', 'pubsub.googleapis.com'],
       *     'azp': '123456789012.apps.googleusercontent.com',
       *     'email': 'jsmith&#64;example.com',
       *     'iat': 1353601026,
       *     'exp': 1353604926}
       * SAML assertions are similarly specified, but with an identity provider
       * dependent structure.
       * </pre>
       *
       * <code>.google.protobuf.Struct claims = 4;</code>
       */
      public com.google.protobuf.Struct.Builder getClaimsBuilder() {

        onChanged();
        return getClaimsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Structured claims presented with the credential. JWTs include
       * `{key: value}` pairs for standard and private claims. The following
       * is a subset of the standard required and optional claims that would
       * typically be presented for a Google-based JWT:
       *    {'iss': 'accounts.google.com',
       *     'sub': '113289723416554971153',
       *     'aud': ['123456789012', 'pubsub.googleapis.com'],
       *     'azp': '123456789012.apps.googleusercontent.com',
       *     'email': 'jsmith&#64;example.com',
       *     'iat': 1353601026,
       *     'exp': 1353604926}
       * SAML assertions are similarly specified, but with an identity provider
       * dependent structure.
       * </pre>
       *
       * <code>.google.protobuf.Struct claims = 4;</code>
       */
      public com.google.protobuf.StructOrBuilder getClaimsOrBuilder() {
        if (claimsBuilder_ != null) {
          return claimsBuilder_.getMessageOrBuilder();
        } else {
          return claims_ == null ? com.google.protobuf.Struct.getDefaultInstance() : claims_;
        }
      }
      /**
       *
       *
       * <pre>
       * Structured claims presented with the credential. JWTs include
       * `{key: value}` pairs for standard and private claims. The following
       * is a subset of the standard required and optional claims that would
       * typically be presented for a Google-based JWT:
       *    {'iss': 'accounts.google.com',
       *     'sub': '113289723416554971153',
       *     'aud': ['123456789012', 'pubsub.googleapis.com'],
       *     'azp': '123456789012.apps.googleusercontent.com',
       *     'email': 'jsmith&#64;example.com',
       *     'iat': 1353601026,
       *     'exp': 1353604926}
       * SAML assertions are similarly specified, but with an identity provider
       * dependent structure.
       * </pre>
       *
       * <code>.google.protobuf.Struct claims = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          getClaimsFieldBuilder() {
        if (claimsBuilder_ == null) {
          claimsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>(
                  getClaims(), getParentForChildren(), isClean());
          claims_ = null;
        }
        return claimsBuilder_;
      }

      private com.google.protobuf.LazyStringList accessLevels_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureAccessLevelsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          accessLevels_ = new com.google.protobuf.LazyStringArrayList(accessLevels_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * A list of access level resource names that allow resources to be
       * accessed by authenticated requester. It is part of Secure GCP processing
       * for the incoming request. An access level string has the format:
       * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
       * Example:
       * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
       * </pre>
       *
       * <code>repeated string access_levels = 5;</code>
       *
       * @return A list containing the accessLevels.
       */
      public com.google.protobuf.ProtocolStringList getAccessLevelsList() {
        return accessLevels_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * A list of access level resource names that allow resources to be
       * accessed by authenticated requester. It is part of Secure GCP processing
       * for the incoming request. An access level string has the format:
       * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
       * Example:
       * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
       * </pre>
       *
       * <code>repeated string access_levels = 5;</code>
       *
       * @return The count of accessLevels.
       */
      public int getAccessLevelsCount() {
        return accessLevels_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of access level resource names that allow resources to be
       * accessed by authenticated requester. It is part of Secure GCP processing
       * for the incoming request. An access level string has the format:
       * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
       * Example:
       * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
       * </pre>
       *
       * <code>repeated string access_levels = 5;</code>
       *
       * @param index The index of the element to return.
       * @return The accessLevels at the given index.
       */
      public java.lang.String getAccessLevels(int index) {
        return accessLevels_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of access level resource names that allow resources to be
       * accessed by authenticated requester. It is part of Secure GCP processing
       * for the incoming request. An access level string has the format:
       * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
       * Example:
       * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
       * </pre>
       *
       * <code>repeated string access_levels = 5;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the accessLevels at the given index.
       */
      public com.google.protobuf.ByteString getAccessLevelsBytes(int index) {
        return accessLevels_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * A list of access level resource names that allow resources to be
       * accessed by authenticated requester. It is part of Secure GCP processing
       * for the incoming request. An access level string has the format:
       * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
       * Example:
       * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
       * </pre>
       *
       * <code>repeated string access_levels = 5;</code>
       *
       * @param index The index to set the value at.
       * @param value The accessLevels to set.
       * @return This builder for chaining.
       */
      public Builder setAccessLevels(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAccessLevelsIsMutable();
        accessLevels_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of access level resource names that allow resources to be
       * accessed by authenticated requester. It is part of Secure GCP processing
       * for the incoming request. An access level string has the format:
       * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
       * Example:
       * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
       * </pre>
       *
       * <code>repeated string access_levels = 5;</code>
       *
       * @param value The accessLevels to add.
       * @return This builder for chaining.
       */
      public Builder addAccessLevels(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAccessLevelsIsMutable();
        accessLevels_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of access level resource names that allow resources to be
       * accessed by authenticated requester. It is part of Secure GCP processing
       * for the incoming request. An access level string has the format:
       * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
       * Example:
       * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
       * </pre>
       *
       * <code>repeated string access_levels = 5;</code>
       *
       * @param values The accessLevels to add.
       * @return This builder for chaining.
       */
      public Builder addAllAccessLevels(java.lang.Iterable<java.lang.String> values) {
        ensureAccessLevelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accessLevels_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of access level resource names that allow resources to be
       * accessed by authenticated requester. It is part of Secure GCP processing
       * for the incoming request. An access level string has the format:
       * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
       * Example:
       * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
       * </pre>
       *
       * <code>repeated string access_levels = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAccessLevels() {
        accessLevels_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of access level resource names that allow resources to be
       * accessed by authenticated requester. It is part of Secure GCP processing
       * for the incoming request. An access level string has the format:
       * "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
       * Example:
       * "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
       * </pre>
       *
       * <code>repeated string access_levels = 5;</code>
       *
       * @param value The bytes of the accessLevels to add.
       * @return This builder for chaining.
       */
      public Builder addAccessLevelsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAccessLevelsIsMutable();
        accessLevels_.add(value);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.rpc.context.AttributeContext.Auth)
    }

    // @@protoc_insertion_point(class_scope:google.rpc.context.AttributeContext.Auth)
    private static final com.google.rpc.context.AttributeContext.Auth DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.rpc.context.AttributeContext.Auth();
    }

    public static com.google.rpc.context.AttributeContext.Auth getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Auth> PARSER =
        new com.google.protobuf.AbstractParser<Auth>() {
          @java.lang.Override
          public Auth parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Auth(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Auth> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Auth> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.rpc.context.AttributeContext.Auth getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.rpc.context.AttributeContext.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The unique ID for a request, which can be propagated to downstream
     * systems. The ID should have low probability of collision
     * within a single day for a specific service.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * The unique ID for a request, which can be propagated to downstream
     * systems. The ID should have low probability of collision
     * within a single day for a specific service.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * The HTTP request method, such as `GET`, `POST`.
     * </pre>
     *
     * <code>string method = 2;</code>
     *
     * @return The method.
     */
    java.lang.String getMethod();
    /**
     *
     *
     * <pre>
     * The HTTP request method, such as `GET`, `POST`.
     * </pre>
     *
     * <code>string method = 2;</code>
     *
     * @return The bytes for method.
     */
    com.google.protobuf.ByteString getMethodBytes();

    /**
     *
     *
     * <pre>
     * The HTTP request headers. If multiple headers share the same key, they
     * must be merged according to the HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    int getHeadersCount();
    /**
     *
     *
     * <pre>
     * The HTTP request headers. If multiple headers share the same key, they
     * must be merged according to the HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    boolean containsHeaders(java.lang.String key);
    /** Use {@link #getHeadersMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getHeaders();
    /**
     *
     *
     * <pre>
     * The HTTP request headers. If multiple headers share the same key, they
     * must be merged according to the HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getHeadersMap();
    /**
     *
     *
     * <pre>
     * The HTTP request headers. If multiple headers share the same key, they
     * must be merged according to the HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */

    /* nullable */
    java.lang.String getHeadersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * The HTTP request headers. If multiple headers share the same key, they
     * must be merged according to the HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    java.lang.String getHeadersOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * The HTTP URL path.
     * </pre>
     *
     * <code>string path = 4;</code>
     *
     * @return The path.
     */
    java.lang.String getPath();
    /**
     *
     *
     * <pre>
     * The HTTP URL path.
     * </pre>
     *
     * <code>string path = 4;</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();

    /**
     *
     *
     * <pre>
     * The HTTP request `Host` header value.
     * </pre>
     *
     * <code>string host = 5;</code>
     *
     * @return The host.
     */
    java.lang.String getHost();
    /**
     *
     *
     * <pre>
     * The HTTP request `Host` header value.
     * </pre>
     *
     * <code>string host = 5;</code>
     *
     * @return The bytes for host.
     */
    com.google.protobuf.ByteString getHostBytes();

    /**
     *
     *
     * <pre>
     * The HTTP URL scheme, such as `http` and `https`.
     * </pre>
     *
     * <code>string scheme = 6;</code>
     *
     * @return The scheme.
     */
    java.lang.String getScheme();
    /**
     *
     *
     * <pre>
     * The HTTP URL scheme, such as `http` and `https`.
     * </pre>
     *
     * <code>string scheme = 6;</code>
     *
     * @return The bytes for scheme.
     */
    com.google.protobuf.ByteString getSchemeBytes();

    /**
     *
     *
     * <pre>
     * The HTTP URL query in the format of `name1=value1&amp;name2=value2`, as it
     * appears in the first line of the HTTP request. No decoding is performed.
     * </pre>
     *
     * <code>string query = 7;</code>
     *
     * @return The query.
     */
    java.lang.String getQuery();
    /**
     *
     *
     * <pre>
     * The HTTP URL query in the format of `name1=value1&amp;name2=value2`, as it
     * appears in the first line of the HTTP request. No decoding is performed.
     * </pre>
     *
     * <code>string query = 7;</code>
     *
     * @return The bytes for query.
     */
    com.google.protobuf.ByteString getQueryBytes();

    /**
     *
     *
     * <pre>
     * The timestamp when the `destination` service receives the last byte of
     * the request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp time = 9;</code>
     *
     * @return Whether the time field is set.
     */
    boolean hasTime();
    /**
     *
     *
     * <pre>
     * The timestamp when the `destination` service receives the last byte of
     * the request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp time = 9;</code>
     *
     * @return The time.
     */
    com.google.protobuf.Timestamp getTime();
    /**
     *
     *
     * <pre>
     * The timestamp when the `destination` service receives the last byte of
     * the request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp time = 9;</code>
     */
    com.google.protobuf.TimestampOrBuilder getTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The HTTP request size in bytes. If unknown, it must be -1.
     * </pre>
     *
     * <code>int64 size = 10;</code>
     *
     * @return The size.
     */
    long getSize();

    /**
     *
     *
     * <pre>
     * The network protocol used with the request, such as "http/1.1",
     * "spdy/3", "h2", "h2c", "webrtc", "tcp", "udp", "quic". See
     * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
     * for details.
     * </pre>
     *
     * <code>string protocol = 11;</code>
     *
     * @return The protocol.
     */
    java.lang.String getProtocol();
    /**
     *
     *
     * <pre>
     * The network protocol used with the request, such as "http/1.1",
     * "spdy/3", "h2", "h2c", "webrtc", "tcp", "udp", "quic". See
     * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
     * for details.
     * </pre>
     *
     * <code>string protocol = 11;</code>
     *
     * @return The bytes for protocol.
     */
    com.google.protobuf.ByteString getProtocolBytes();

    /**
     *
     *
     * <pre>
     * A special parameter for request reason. It is used by security systems
     * to associate auditing information with a request.
     * </pre>
     *
     * <code>string reason = 12;</code>
     *
     * @return The reason.
     */
    java.lang.String getReason();
    /**
     *
     *
     * <pre>
     * A special parameter for request reason. It is used by security systems
     * to associate auditing information with a request.
     * </pre>
     *
     * <code>string reason = 12;</code>
     *
     * @return The bytes for reason.
     */
    com.google.protobuf.ByteString getReasonBytes();

    /**
     *
     *
     * <pre>
     * The request authentication. May be absent for unauthenticated requests.
     * Derived from the HTTP request `Authorization` header or equivalent.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
     *
     * @return Whether the auth field is set.
     */
    boolean hasAuth();
    /**
     *
     *
     * <pre>
     * The request authentication. May be absent for unauthenticated requests.
     * Derived from the HTTP request `Authorization` header or equivalent.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
     *
     * @return The auth.
     */
    com.google.rpc.context.AttributeContext.Auth getAuth();
    /**
     *
     *
     * <pre>
     * The request authentication. May be absent for unauthenticated requests.
     * Derived from the HTTP request `Authorization` header or equivalent.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
     */
    com.google.rpc.context.AttributeContext.AuthOrBuilder getAuthOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * This message defines attributes for an HTTP request. If the actual
   * request is not an HTTP request, the runtime system should try to map
   * the actual request to an equivalent HTTP request.
   * </pre>
   *
   * Protobuf type {@code google.rpc.context.AttributeContext.Request}
   */
  public static final class Request extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.rpc.context.AttributeContext.Request)
      RequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Request() {
      id_ = "";
      method_ = "";
      path_ = "";
      host_ = "";
      scheme_ = "";
      query_ = "";
      protocol_ = "";
      reason_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Request();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                id_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                method_ = s;
                break;
              }
            case 26:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  headers_ =
                      com.google.protobuf.MapField.newMapField(
                          HeadersDefaultEntryHolder.defaultEntry);
                  mutable_bitField0_ |= 0x00000001;
                }
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
                    input.readMessage(
                        HeadersDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                headers_.getMutableMap().put(headers__.getKey(), headers__.getValue());
                break;
              }
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();

                path_ = s;
                break;
              }
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();

                host_ = s;
                break;
              }
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();

                scheme_ = s;
                break;
              }
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();

                query_ = s;
                break;
              }
            case 74:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (time_ != null) {
                  subBuilder = time_.toBuilder();
                }
                time_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(time_);
                  time_ = subBuilder.buildPartial();
                }

                break;
              }
            case 80:
              {
                size_ = input.readInt64();
                break;
              }
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();

                protocol_ = s;
                break;
              }
            case 98:
              {
                java.lang.String s = input.readStringRequireUtf8();

                reason_ = s;
                break;
              }
            case 106:
              {
                com.google.rpc.context.AttributeContext.Auth.Builder subBuilder = null;
                if (auth_ != null) {
                  subBuilder = auth_.toBuilder();
                }
                auth_ =
                    input.readMessage(
                        com.google.rpc.context.AttributeContext.Auth.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(auth_);
                  auth_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_Request_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.rpc.context.AttributeContext.Request.class,
              com.google.rpc.context.AttributeContext.Request.Builder.class);
    }

    public static final int ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object id_;
    /**
     *
     *
     * <pre>
     * The unique ID for a request, which can be propagated to downstream
     * systems. The ID should have low probability of collision
     * within a single day for a specific service.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique ID for a request, which can be propagated to downstream
     * systems. The ID should have low probability of collision
     * within a single day for a specific service.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int METHOD_FIELD_NUMBER = 2;
    private volatile java.lang.Object method_;
    /**
     *
     *
     * <pre>
     * The HTTP request method, such as `GET`, `POST`.
     * </pre>
     *
     * <code>string method = 2;</code>
     *
     * @return The method.
     */
    @java.lang.Override
    public java.lang.String getMethod() {
      java.lang.Object ref = method_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        method_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The HTTP request method, such as `GET`, `POST`.
     * </pre>
     *
     * <code>string method = 2;</code>
     *
     * @return The bytes for method.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMethodBytes() {
      java.lang.Object ref = method_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        method_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int HEADERS_FIELD_NUMBER = 3;

    private static final class HeadersDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.rpc.context.AttributeContextProto
                  .internal_static_google_rpc_context_AttributeContext_Request_HeadersEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetHeaders() {
      if (headers_ == null) {
        return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
      }
      return headers_;
    }

    public int getHeadersCount() {
      return internalGetHeaders().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers. If multiple headers share the same key, they
     * must be merged according to the HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    @java.lang.Override
    public boolean containsHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetHeaders().getMap().containsKey(key);
    }
    /** Use {@link #getHeadersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
      return getHeadersMap();
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers. If multiple headers share the same key, they
     * must be merged according to the HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
      return internalGetHeaders().getMap();
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers. If multiple headers share the same key, they
     * must be merged according to the HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getHeadersOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers. If multiple headers share the same key, they
     * must be merged according to the HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getHeadersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int PATH_FIELD_NUMBER = 4;
    private volatile java.lang.Object path_;
    /**
     *
     *
     * <pre>
     * The HTTP URL path.
     * </pre>
     *
     * <code>string path = 4;</code>
     *
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The HTTP URL path.
     * </pre>
     *
     * <code>string path = 4;</code>
     *
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int HOST_FIELD_NUMBER = 5;
    private volatile java.lang.Object host_;
    /**
     *
     *
     * <pre>
     * The HTTP request `Host` header value.
     * </pre>
     *
     * <code>string host = 5;</code>
     *
     * @return The host.
     */
    @java.lang.Override
    public java.lang.String getHost() {
      java.lang.Object ref = host_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        host_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The HTTP request `Host` header value.
     * </pre>
     *
     * <code>string host = 5;</code>
     *
     * @return The bytes for host.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHostBytes() {
      java.lang.Object ref = host_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        host_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEME_FIELD_NUMBER = 6;
    private volatile java.lang.Object scheme_;
    /**
     *
     *
     * <pre>
     * The HTTP URL scheme, such as `http` and `https`.
     * </pre>
     *
     * <code>string scheme = 6;</code>
     *
     * @return The scheme.
     */
    @java.lang.Override
    public java.lang.String getScheme() {
      java.lang.Object ref = scheme_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        scheme_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The HTTP URL scheme, such as `http` and `https`.
     * </pre>
     *
     * <code>string scheme = 6;</code>
     *
     * @return The bytes for scheme.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSchemeBytes() {
      java.lang.Object ref = scheme_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        scheme_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int QUERY_FIELD_NUMBER = 7;
    private volatile java.lang.Object query_;
    /**
     *
     *
     * <pre>
     * The HTTP URL query in the format of `name1=value1&amp;name2=value2`, as it
     * appears in the first line of the HTTP request. No decoding is performed.
     * </pre>
     *
     * <code>string query = 7;</code>
     *
     * @return The query.
     */
    @java.lang.Override
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The HTTP URL query in the format of `name1=value1&amp;name2=value2`, as it
     * appears in the first line of the HTTP request. No decoding is performed.
     * </pre>
     *
     * <code>string query = 7;</code>
     *
     * @return The bytes for query.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TIME_FIELD_NUMBER = 9;
    private com.google.protobuf.Timestamp time_;
    /**
     *
     *
     * <pre>
     * The timestamp when the `destination` service receives the last byte of
     * the request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp time = 9;</code>
     *
     * @return Whether the time field is set.
     */
    @java.lang.Override
    public boolean hasTime() {
      return time_ != null;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the `destination` service receives the last byte of
     * the request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp time = 9;</code>
     *
     * @return The time.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getTime() {
      return time_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : time_;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the `destination` service receives the last byte of
     * the request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp time = 9;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getTimeOrBuilder() {
      return getTime();
    }

    public static final int SIZE_FIELD_NUMBER = 10;
    private long size_;
    /**
     *
     *
     * <pre>
     * The HTTP request size in bytes. If unknown, it must be -1.
     * </pre>
     *
     * <code>int64 size = 10;</code>
     *
     * @return The size.
     */
    @java.lang.Override
    public long getSize() {
      return size_;
    }

    public static final int PROTOCOL_FIELD_NUMBER = 11;
    private volatile java.lang.Object protocol_;
    /**
     *
     *
     * <pre>
     * The network protocol used with the request, such as "http/1.1",
     * "spdy/3", "h2", "h2c", "webrtc", "tcp", "udp", "quic". See
     * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
     * for details.
     * </pre>
     *
     * <code>string protocol = 11;</code>
     *
     * @return The protocol.
     */
    @java.lang.Override
    public java.lang.String getProtocol() {
      java.lang.Object ref = protocol_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        protocol_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The network protocol used with the request, such as "http/1.1",
     * "spdy/3", "h2", "h2c", "webrtc", "tcp", "udp", "quic". See
     * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
     * for details.
     * </pre>
     *
     * <code>string protocol = 11;</code>
     *
     * @return The bytes for protocol.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProtocolBytes() {
      java.lang.Object ref = protocol_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        protocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REASON_FIELD_NUMBER = 12;
    private volatile java.lang.Object reason_;
    /**
     *
     *
     * <pre>
     * A special parameter for request reason. It is used by security systems
     * to associate auditing information with a request.
     * </pre>
     *
     * <code>string reason = 12;</code>
     *
     * @return The reason.
     */
    @java.lang.Override
    public java.lang.String getReason() {
      java.lang.Object ref = reason_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reason_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A special parameter for request reason. It is used by security systems
     * to associate auditing information with a request.
     * </pre>
     *
     * <code>string reason = 12;</code>
     *
     * @return The bytes for reason.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getReasonBytes() {
      java.lang.Object ref = reason_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AUTH_FIELD_NUMBER = 13;
    private com.google.rpc.context.AttributeContext.Auth auth_;
    /**
     *
     *
     * <pre>
     * The request authentication. May be absent for unauthenticated requests.
     * Derived from the HTTP request `Authorization` header or equivalent.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
     *
     * @return Whether the auth field is set.
     */
    @java.lang.Override
    public boolean hasAuth() {
      return auth_ != null;
    }
    /**
     *
     *
     * <pre>
     * The request authentication. May be absent for unauthenticated requests.
     * Derived from the HTTP request `Authorization` header or equivalent.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
     *
     * @return The auth.
     */
    @java.lang.Override
    public com.google.rpc.context.AttributeContext.Auth getAuth() {
      return auth_ == null
          ? com.google.rpc.context.AttributeContext.Auth.getDefaultInstance()
          : auth_;
    }
    /**
     *
     *
     * <pre>
     * The request authentication. May be absent for unauthenticated requests.
     * Derived from the HTTP request `Authorization` header or equivalent.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
     */
    @java.lang.Override
    public com.google.rpc.context.AttributeContext.AuthOrBuilder getAuthOrBuilder() {
      return getAuth();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(method_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, method_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetHeaders(), HeadersDefaultEntryHolder.defaultEntry, 3);
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, path_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, host_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(scheme_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, scheme_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, query_);
      }
      if (time_ != null) {
        output.writeMessage(9, getTime());
      }
      if (size_ != 0L) {
        output.writeInt64(10, size_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 11, protocol_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reason_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 12, reason_);
      }
      if (auth_ != null) {
        output.writeMessage(13, getAuth());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(method_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, method_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetHeaders().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
            HeadersDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, headers__);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, path_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, host_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(scheme_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, scheme_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, query_);
      }
      if (time_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getTime());
      }
      if (size_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(10, size_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, protocol_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reason_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, reason_);
      }
      if (auth_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getAuth());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.rpc.context.AttributeContext.Request)) {
        return super.equals(obj);
      }
      com.google.rpc.context.AttributeContext.Request other =
          (com.google.rpc.context.AttributeContext.Request) obj;

      if (!getId().equals(other.getId())) return false;
      if (!getMethod().equals(other.getMethod())) return false;
      if (!internalGetHeaders().equals(other.internalGetHeaders())) return false;
      if (!getPath().equals(other.getPath())) return false;
      if (!getHost().equals(other.getHost())) return false;
      if (!getScheme().equals(other.getScheme())) return false;
      if (!getQuery().equals(other.getQuery())) return false;
      if (hasTime() != other.hasTime()) return false;
      if (hasTime()) {
        if (!getTime().equals(other.getTime())) return false;
      }
      if (getSize() != other.getSize()) return false;
      if (!getProtocol().equals(other.getProtocol())) return false;
      if (!getReason().equals(other.getReason())) return false;
      if (hasAuth() != other.hasAuth()) return false;
      if (hasAuth()) {
        if (!getAuth().equals(other.getAuth())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      hash = (37 * hash) + METHOD_FIELD_NUMBER;
      hash = (53 * hash) + getMethod().hashCode();
      if (!internalGetHeaders().getMap().isEmpty()) {
        hash = (37 * hash) + HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetHeaders().hashCode();
      }
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
      hash = (37 * hash) + HOST_FIELD_NUMBER;
      hash = (53 * hash) + getHost().hashCode();
      hash = (37 * hash) + SCHEME_FIELD_NUMBER;
      hash = (53 * hash) + getScheme().hashCode();
      hash = (37 * hash) + QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getQuery().hashCode();
      if (hasTime()) {
        hash = (37 * hash) + TIME_FIELD_NUMBER;
        hash = (53 * hash) + getTime().hashCode();
      }
      hash = (37 * hash) + SIZE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSize());
      hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
      hash = (53 * hash) + getProtocol().hashCode();
      hash = (37 * hash) + REASON_FIELD_NUMBER;
      hash = (53 * hash) + getReason().hashCode();
      if (hasAuth()) {
        hash = (37 * hash) + AUTH_FIELD_NUMBER;
        hash = (53 * hash) + getAuth().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.rpc.context.AttributeContext.Request parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Request parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Request parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Request parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Request parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Request parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Request parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Request parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.rpc.context.AttributeContext.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * This message defines attributes for an HTTP request. If the actual
     * request is not an HTTP request, the runtime system should try to map
     * the actual request to an equivalent HTTP request.
     * </pre>
     *
     * Protobuf type {@code google.rpc.context.AttributeContext.Request}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.rpc.context.AttributeContext.Request)
        com.google.rpc.context.AttributeContext.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Request_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 3:
            return internalGetHeaders();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 3:
            return internalGetMutableHeaders();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.rpc.context.AttributeContext.Request.class,
                com.google.rpc.context.AttributeContext.Request.Builder.class);
      }

      // Construct using com.google.rpc.context.AttributeContext.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        id_ = "";

        method_ = "";

        internalGetMutableHeaders().clear();
        path_ = "";

        host_ = "";

        scheme_ = "";

        query_ = "";

        if (timeBuilder_ == null) {
          time_ = null;
        } else {
          time_ = null;
          timeBuilder_ = null;
        }
        size_ = 0L;

        protocol_ = "";

        reason_ = "";

        if (authBuilder_ == null) {
          auth_ = null;
        } else {
          auth_ = null;
          authBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Request_descriptor;
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Request getDefaultInstanceForType() {
        return com.google.rpc.context.AttributeContext.Request.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Request build() {
        com.google.rpc.context.AttributeContext.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Request buildPartial() {
        com.google.rpc.context.AttributeContext.Request result =
            new com.google.rpc.context.AttributeContext.Request(this);
        int from_bitField0_ = bitField0_;
        result.id_ = id_;
        result.method_ = method_;
        result.headers_ = internalGetHeaders();
        result.headers_.makeImmutable();
        result.path_ = path_;
        result.host_ = host_;
        result.scheme_ = scheme_;
        result.query_ = query_;
        if (timeBuilder_ == null) {
          result.time_ = time_;
        } else {
          result.time_ = timeBuilder_.build();
        }
        result.size_ = size_;
        result.protocol_ = protocol_;
        result.reason_ = reason_;
        if (authBuilder_ == null) {
          result.auth_ = auth_;
        } else {
          result.auth_ = authBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.rpc.context.AttributeContext.Request) {
          return mergeFrom((com.google.rpc.context.AttributeContext.Request) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.rpc.context.AttributeContext.Request other) {
        if (other == com.google.rpc.context.AttributeContext.Request.getDefaultInstance())
          return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          onChanged();
        }
        if (!other.getMethod().isEmpty()) {
          method_ = other.method_;
          onChanged();
        }
        internalGetMutableHeaders().mergeFrom(other.internalGetHeaders());
        if (!other.getPath().isEmpty()) {
          path_ = other.path_;
          onChanged();
        }
        if (!other.getHost().isEmpty()) {
          host_ = other.host_;
          onChanged();
        }
        if (!other.getScheme().isEmpty()) {
          scheme_ = other.scheme_;
          onChanged();
        }
        if (!other.getQuery().isEmpty()) {
          query_ = other.query_;
          onChanged();
        }
        if (other.hasTime()) {
          mergeTime(other.getTime());
        }
        if (other.getSize() != 0L) {
          setSize(other.getSize());
        }
        if (!other.getProtocol().isEmpty()) {
          protocol_ = other.protocol_;
          onChanged();
        }
        if (!other.getReason().isEmpty()) {
          reason_ = other.reason_;
          onChanged();
        }
        if (other.hasAuth()) {
          mergeAuth(other.getAuth());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.rpc.context.AttributeContext.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.rpc.context.AttributeContext.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * The unique ID for a request, which can be propagated to downstream
       * systems. The ID should have low probability of collision
       * within a single day for a specific service.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The unique ID for a request, which can be propagated to downstream
       * systems. The ID should have low probability of collision
       * within a single day for a specific service.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The unique ID for a request, which can be propagated to downstream
       * systems. The ID should have low probability of collision
       * within a single day for a specific service.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        id_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique ID for a request, which can be propagated to downstream
       * systems. The ID should have low probability of collision
       * within a single day for a specific service.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {

        id_ = getDefaultInstance().getId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique ID for a request, which can be propagated to downstream
       * systems. The ID should have low probability of collision
       * within a single day for a specific service.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        id_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object method_ = "";
      /**
       *
       *
       * <pre>
       * The HTTP request method, such as `GET`, `POST`.
       * </pre>
       *
       * <code>string method = 2;</code>
       *
       * @return The method.
       */
      public java.lang.String getMethod() {
        java.lang.Object ref = method_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          method_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The HTTP request method, such as `GET`, `POST`.
       * </pre>
       *
       * <code>string method = 2;</code>
       *
       * @return The bytes for method.
       */
      public com.google.protobuf.ByteString getMethodBytes() {
        java.lang.Object ref = method_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          method_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The HTTP request method, such as `GET`, `POST`.
       * </pre>
       *
       * <code>string method = 2;</code>
       *
       * @param value The method to set.
       * @return This builder for chaining.
       */
      public Builder setMethod(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        method_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request method, such as `GET`, `POST`.
       * </pre>
       *
       * <code>string method = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMethod() {

        method_ = getDefaultInstance().getMethod();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request method, such as `GET`, `POST`.
       * </pre>
       *
       * <code>string method = 2;</code>
       *
       * @param value The bytes for method to set.
       * @return This builder for chaining.
       */
      public Builder setMethodBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        method_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetHeaders() {
        if (headers_ == null) {
          return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
        }
        return headers_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableHeaders() {
        onChanged();
        ;
        if (headers_ == null) {
          headers_ =
              com.google.protobuf.MapField.newMapField(HeadersDefaultEntryHolder.defaultEntry);
        }
        if (!headers_.isMutable()) {
          headers_ = headers_.copy();
        }
        return headers_;
      }

      public int getHeadersCount() {
        return internalGetHeaders().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers. If multiple headers share the same key, they
       * must be merged according to the HTTP spec. All header keys must be
       * lowercased, because HTTP header keys are case-insensitive.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 3;</code>
       */
      @java.lang.Override
      public boolean containsHeaders(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetHeaders().getMap().containsKey(key);
      }
      /** Use {@link #getHeadersMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
        return getHeadersMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers. If multiple headers share the same key, they
       * must be merged according to the HTTP spec. All header keys must be
       * lowercased, because HTTP header keys are case-insensitive.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 3;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
        return internalGetHeaders().getMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers. If multiple headers share the same key, they
       * must be merged according to the HTTP spec. All header keys must be
       * lowercased, because HTTP header keys are case-insensitive.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 3;</code>
       */
      @java.lang.Override
      public java.lang.String getHeadersOrDefault(
          java.lang.String key, java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers. If multiple headers share the same key, they
       * must be merged according to the HTTP spec. All header keys must be
       * lowercased, because HTTP header keys are case-insensitive.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 3;</code>
       */
      @java.lang.Override
      public java.lang.String getHeadersOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearHeaders() {
        internalGetMutableHeaders().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers. If multiple headers share the same key, they
       * must be merged according to the HTTP spec. All header keys must be
       * lowercased, because HTTP header keys are case-insensitive.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 3;</code>
       */
      public Builder removeHeaders(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableHeaders().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableHeaders() {
        return internalGetMutableHeaders().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers. If multiple headers share the same key, they
       * must be merged according to the HTTP spec. All header keys must be
       * lowercased, because HTTP header keys are case-insensitive.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 3;</code>
       */
      public Builder putHeaders(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }

        internalGetMutableHeaders().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers. If multiple headers share the same key, they
       * must be merged according to the HTTP spec. All header keys must be
       * lowercased, because HTTP header keys are case-insensitive.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 3;</code>
       */
      public Builder putAllHeaders(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableHeaders().getMutableMap().putAll(values);
        return this;
      }

      private java.lang.Object path_ = "";
      /**
       *
       *
       * <pre>
       * The HTTP URL path.
       * </pre>
       *
       * <code>string path = 4;</code>
       *
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The HTTP URL path.
       * </pre>
       *
       * <code>string path = 4;</code>
       *
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The HTTP URL path.
       * </pre>
       *
       * <code>string path = 4;</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        path_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP URL path.
       * </pre>
       *
       * <code>string path = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {

        path_ = getDefaultInstance().getPath();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP URL path.
       * </pre>
       *
       * <code>string path = 4;</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        path_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object host_ = "";
      /**
       *
       *
       * <pre>
       * The HTTP request `Host` header value.
       * </pre>
       *
       * <code>string host = 5;</code>
       *
       * @return The host.
       */
      public java.lang.String getHost() {
        java.lang.Object ref = host_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          host_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The HTTP request `Host` header value.
       * </pre>
       *
       * <code>string host = 5;</code>
       *
       * @return The bytes for host.
       */
      public com.google.protobuf.ByteString getHostBytes() {
        java.lang.Object ref = host_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          host_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The HTTP request `Host` header value.
       * </pre>
       *
       * <code>string host = 5;</code>
       *
       * @param value The host to set.
       * @return This builder for chaining.
       */
      public Builder setHost(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        host_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request `Host` header value.
       * </pre>
       *
       * <code>string host = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHost() {

        host_ = getDefaultInstance().getHost();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request `Host` header value.
       * </pre>
       *
       * <code>string host = 5;</code>
       *
       * @param value The bytes for host to set.
       * @return This builder for chaining.
       */
      public Builder setHostBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        host_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object scheme_ = "";
      /**
       *
       *
       * <pre>
       * The HTTP URL scheme, such as `http` and `https`.
       * </pre>
       *
       * <code>string scheme = 6;</code>
       *
       * @return The scheme.
       */
      public java.lang.String getScheme() {
        java.lang.Object ref = scheme_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          scheme_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The HTTP URL scheme, such as `http` and `https`.
       * </pre>
       *
       * <code>string scheme = 6;</code>
       *
       * @return The bytes for scheme.
       */
      public com.google.protobuf.ByteString getSchemeBytes() {
        java.lang.Object ref = scheme_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          scheme_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The HTTP URL scheme, such as `http` and `https`.
       * </pre>
       *
       * <code>string scheme = 6;</code>
       *
       * @param value The scheme to set.
       * @return This builder for chaining.
       */
      public Builder setScheme(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        scheme_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP URL scheme, such as `http` and `https`.
       * </pre>
       *
       * <code>string scheme = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScheme() {

        scheme_ = getDefaultInstance().getScheme();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP URL scheme, such as `http` and `https`.
       * </pre>
       *
       * <code>string scheme = 6;</code>
       *
       * @param value The bytes for scheme to set.
       * @return This builder for chaining.
       */
      public Builder setSchemeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        scheme_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object query_ = "";
      /**
       *
       *
       * <pre>
       * The HTTP URL query in the format of `name1=value1&amp;name2=value2`, as it
       * appears in the first line of the HTTP request. No decoding is performed.
       * </pre>
       *
       * <code>string query = 7;</code>
       *
       * @return The query.
       */
      public java.lang.String getQuery() {
        java.lang.Object ref = query_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          query_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The HTTP URL query in the format of `name1=value1&amp;name2=value2`, as it
       * appears in the first line of the HTTP request. No decoding is performed.
       * </pre>
       *
       * <code>string query = 7;</code>
       *
       * @return The bytes for query.
       */
      public com.google.protobuf.ByteString getQueryBytes() {
        java.lang.Object ref = query_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          query_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The HTTP URL query in the format of `name1=value1&amp;name2=value2`, as it
       * appears in the first line of the HTTP request. No decoding is performed.
       * </pre>
       *
       * <code>string query = 7;</code>
       *
       * @param value The query to set.
       * @return This builder for chaining.
       */
      public Builder setQuery(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        query_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP URL query in the format of `name1=value1&amp;name2=value2`, as it
       * appears in the first line of the HTTP request. No decoding is performed.
       * </pre>
       *
       * <code>string query = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQuery() {

        query_ = getDefaultInstance().getQuery();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP URL query in the format of `name1=value1&amp;name2=value2`, as it
       * appears in the first line of the HTTP request. No decoding is performed.
       * </pre>
       *
       * <code>string query = 7;</code>
       *
       * @param value The bytes for query to set.
       * @return This builder for chaining.
       */
      public Builder setQueryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        query_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp time_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          timeBuilder_;
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service receives the last byte of
       * the request.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 9;</code>
       *
       * @return Whether the time field is set.
       */
      public boolean hasTime() {
        return timeBuilder_ != null || time_ != null;
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service receives the last byte of
       * the request.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 9;</code>
       *
       * @return The time.
       */
      public com.google.protobuf.Timestamp getTime() {
        if (timeBuilder_ == null) {
          return time_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : time_;
        } else {
          return timeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service receives the last byte of
       * the request.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 9;</code>
       */
      public Builder setTime(com.google.protobuf.Timestamp value) {
        if (timeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          time_ = value;
          onChanged();
        } else {
          timeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service receives the last byte of
       * the request.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 9;</code>
       */
      public Builder setTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (timeBuilder_ == null) {
          time_ = builderForValue.build();
          onChanged();
        } else {
          timeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service receives the last byte of
       * the request.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 9;</code>
       */
      public Builder mergeTime(com.google.protobuf.Timestamp value) {
        if (timeBuilder_ == null) {
          if (time_ != null) {
            time_ = com.google.protobuf.Timestamp.newBuilder(time_).mergeFrom(value).buildPartial();
          } else {
            time_ = value;
          }
          onChanged();
        } else {
          timeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service receives the last byte of
       * the request.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 9;</code>
       */
      public Builder clearTime() {
        if (timeBuilder_ == null) {
          time_ = null;
          onChanged();
        } else {
          time_ = null;
          timeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service receives the last byte of
       * the request.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 9;</code>
       */
      public com.google.protobuf.Timestamp.Builder getTimeBuilder() {

        onChanged();
        return getTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service receives the last byte of
       * the request.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 9;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getTimeOrBuilder() {
        if (timeBuilder_ != null) {
          return timeBuilder_.getMessageOrBuilder();
        } else {
          return time_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : time_;
        }
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service receives the last byte of
       * the request.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getTimeFieldBuilder() {
        if (timeBuilder_ == null) {
          timeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getTime(), getParentForChildren(), isClean());
          time_ = null;
        }
        return timeBuilder_;
      }

      private long size_;
      /**
       *
       *
       * <pre>
       * The HTTP request size in bytes. If unknown, it must be -1.
       * </pre>
       *
       * <code>int64 size = 10;</code>
       *
       * @return The size.
       */
      @java.lang.Override
      public long getSize() {
        return size_;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request size in bytes. If unknown, it must be -1.
       * </pre>
       *
       * <code>int64 size = 10;</code>
       *
       * @param value The size to set.
       * @return This builder for chaining.
       */
      public Builder setSize(long value) {

        size_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request size in bytes. If unknown, it must be -1.
       * </pre>
       *
       * <code>int64 size = 10;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSize() {

        size_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object protocol_ = "";
      /**
       *
       *
       * <pre>
       * The network protocol used with the request, such as "http/1.1",
       * "spdy/3", "h2", "h2c", "webrtc", "tcp", "udp", "quic". See
       * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
       * for details.
       * </pre>
       *
       * <code>string protocol = 11;</code>
       *
       * @return The protocol.
       */
      public java.lang.String getProtocol() {
        java.lang.Object ref = protocol_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          protocol_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The network protocol used with the request, such as "http/1.1",
       * "spdy/3", "h2", "h2c", "webrtc", "tcp", "udp", "quic". See
       * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
       * for details.
       * </pre>
       *
       * <code>string protocol = 11;</code>
       *
       * @return The bytes for protocol.
       */
      public com.google.protobuf.ByteString getProtocolBytes() {
        java.lang.Object ref = protocol_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          protocol_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The network protocol used with the request, such as "http/1.1",
       * "spdy/3", "h2", "h2c", "webrtc", "tcp", "udp", "quic". See
       * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
       * for details.
       * </pre>
       *
       * <code>string protocol = 11;</code>
       *
       * @param value The protocol to set.
       * @return This builder for chaining.
       */
      public Builder setProtocol(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        protocol_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The network protocol used with the request, such as "http/1.1",
       * "spdy/3", "h2", "h2c", "webrtc", "tcp", "udp", "quic". See
       * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
       * for details.
       * </pre>
       *
       * <code>string protocol = 11;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProtocol() {

        protocol_ = getDefaultInstance().getProtocol();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The network protocol used with the request, such as "http/1.1",
       * "spdy/3", "h2", "h2c", "webrtc", "tcp", "udp", "quic". See
       * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
       * for details.
       * </pre>
       *
       * <code>string protocol = 11;</code>
       *
       * @param value The bytes for protocol to set.
       * @return This builder for chaining.
       */
      public Builder setProtocolBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        protocol_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object reason_ = "";
      /**
       *
       *
       * <pre>
       * A special parameter for request reason. It is used by security systems
       * to associate auditing information with a request.
       * </pre>
       *
       * <code>string reason = 12;</code>
       *
       * @return The reason.
       */
      public java.lang.String getReason() {
        java.lang.Object ref = reason_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          reason_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A special parameter for request reason. It is used by security systems
       * to associate auditing information with a request.
       * </pre>
       *
       * <code>string reason = 12;</code>
       *
       * @return The bytes for reason.
       */
      public com.google.protobuf.ByteString getReasonBytes() {
        java.lang.Object ref = reason_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          reason_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A special parameter for request reason. It is used by security systems
       * to associate auditing information with a request.
       * </pre>
       *
       * <code>string reason = 12;</code>
       *
       * @param value The reason to set.
       * @return This builder for chaining.
       */
      public Builder setReason(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        reason_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A special parameter for request reason. It is used by security systems
       * to associate auditing information with a request.
       * </pre>
       *
       * <code>string reason = 12;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearReason() {

        reason_ = getDefaultInstance().getReason();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A special parameter for request reason. It is used by security systems
       * to associate auditing information with a request.
       * </pre>
       *
       * <code>string reason = 12;</code>
       *
       * @param value The bytes for reason to set.
       * @return This builder for chaining.
       */
      public Builder setReasonBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        reason_ = value;
        onChanged();
        return this;
      }

      private com.google.rpc.context.AttributeContext.Auth auth_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.context.AttributeContext.Auth,
              com.google.rpc.context.AttributeContext.Auth.Builder,
              com.google.rpc.context.AttributeContext.AuthOrBuilder>
          authBuilder_;
      /**
       *
       *
       * <pre>
       * The request authentication. May be absent for unauthenticated requests.
       * Derived from the HTTP request `Authorization` header or equivalent.
       * </pre>
       *
       * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
       *
       * @return Whether the auth field is set.
       */
      public boolean hasAuth() {
        return authBuilder_ != null || auth_ != null;
      }
      /**
       *
       *
       * <pre>
       * The request authentication. May be absent for unauthenticated requests.
       * Derived from the HTTP request `Authorization` header or equivalent.
       * </pre>
       *
       * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
       *
       * @return The auth.
       */
      public com.google.rpc.context.AttributeContext.Auth getAuth() {
        if (authBuilder_ == null) {
          return auth_ == null
              ? com.google.rpc.context.AttributeContext.Auth.getDefaultInstance()
              : auth_;
        } else {
          return authBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The request authentication. May be absent for unauthenticated requests.
       * Derived from the HTTP request `Authorization` header or equivalent.
       * </pre>
       *
       * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
       */
      public Builder setAuth(com.google.rpc.context.AttributeContext.Auth value) {
        if (authBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          auth_ = value;
          onChanged();
        } else {
          authBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The request authentication. May be absent for unauthenticated requests.
       * Derived from the HTTP request `Authorization` header or equivalent.
       * </pre>
       *
       * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
       */
      public Builder setAuth(com.google.rpc.context.AttributeContext.Auth.Builder builderForValue) {
        if (authBuilder_ == null) {
          auth_ = builderForValue.build();
          onChanged();
        } else {
          authBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The request authentication. May be absent for unauthenticated requests.
       * Derived from the HTTP request `Authorization` header or equivalent.
       * </pre>
       *
       * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
       */
      public Builder mergeAuth(com.google.rpc.context.AttributeContext.Auth value) {
        if (authBuilder_ == null) {
          if (auth_ != null) {
            auth_ =
                com.google.rpc.context.AttributeContext.Auth.newBuilder(auth_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            auth_ = value;
          }
          onChanged();
        } else {
          authBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The request authentication. May be absent for unauthenticated requests.
       * Derived from the HTTP request `Authorization` header or equivalent.
       * </pre>
       *
       * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
       */
      public Builder clearAuth() {
        if (authBuilder_ == null) {
          auth_ = null;
          onChanged();
        } else {
          auth_ = null;
          authBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The request authentication. May be absent for unauthenticated requests.
       * Derived from the HTTP request `Authorization` header or equivalent.
       * </pre>
       *
       * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
       */
      public com.google.rpc.context.AttributeContext.Auth.Builder getAuthBuilder() {

        onChanged();
        return getAuthFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The request authentication. May be absent for unauthenticated requests.
       * Derived from the HTTP request `Authorization` header or equivalent.
       * </pre>
       *
       * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
       */
      public com.google.rpc.context.AttributeContext.AuthOrBuilder getAuthOrBuilder() {
        if (authBuilder_ != null) {
          return authBuilder_.getMessageOrBuilder();
        } else {
          return auth_ == null
              ? com.google.rpc.context.AttributeContext.Auth.getDefaultInstance()
              : auth_;
        }
      }
      /**
       *
       *
       * <pre>
       * The request authentication. May be absent for unauthenticated requests.
       * Derived from the HTTP request `Authorization` header or equivalent.
       * </pre>
       *
       * <code>.google.rpc.context.AttributeContext.Auth auth = 13;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.context.AttributeContext.Auth,
              com.google.rpc.context.AttributeContext.Auth.Builder,
              com.google.rpc.context.AttributeContext.AuthOrBuilder>
          getAuthFieldBuilder() {
        if (authBuilder_ == null) {
          authBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.context.AttributeContext.Auth,
                  com.google.rpc.context.AttributeContext.Auth.Builder,
                  com.google.rpc.context.AttributeContext.AuthOrBuilder>(
                  getAuth(), getParentForChildren(), isClean());
          auth_ = null;
        }
        return authBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.rpc.context.AttributeContext.Request)
    }

    // @@protoc_insertion_point(class_scope:google.rpc.context.AttributeContext.Request)
    private static final com.google.rpc.context.AttributeContext.Request DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.rpc.context.AttributeContext.Request();
    }

    public static com.google.rpc.context.AttributeContext.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request> PARSER =
        new com.google.protobuf.AbstractParser<Request>() {
          @java.lang.Override
          public Request parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Request(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.rpc.context.AttributeContext.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.rpc.context.AttributeContext.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The HTTP response status code, such as `200` and `404`.
     * </pre>
     *
     * <code>int64 code = 1;</code>
     *
     * @return The code.
     */
    long getCode();

    /**
     *
     *
     * <pre>
     * The HTTP response size in bytes. If unknown, it must be -1.
     * </pre>
     *
     * <code>int64 size = 2;</code>
     *
     * @return The size.
     */
    long getSize();

    /**
     *
     *
     * <pre>
     * The HTTP response headers. If multiple headers share the same key, they
     * must be merged according to HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    int getHeadersCount();
    /**
     *
     *
     * <pre>
     * The HTTP response headers. If multiple headers share the same key, they
     * must be merged according to HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    boolean containsHeaders(java.lang.String key);
    /** Use {@link #getHeadersMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getHeaders();
    /**
     *
     *
     * <pre>
     * The HTTP response headers. If multiple headers share the same key, they
     * must be merged according to HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getHeadersMap();
    /**
     *
     *
     * <pre>
     * The HTTP response headers. If multiple headers share the same key, they
     * must be merged according to HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */

    /* nullable */
    java.lang.String getHeadersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * The HTTP response headers. If multiple headers share the same key, they
     * must be merged according to HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    java.lang.String getHeadersOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * The timestamp when the `destination` service sends the last byte of
     * the response.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp time = 4;</code>
     *
     * @return Whether the time field is set.
     */
    boolean hasTime();
    /**
     *
     *
     * <pre>
     * The timestamp when the `destination` service sends the last byte of
     * the response.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp time = 4;</code>
     *
     * @return The time.
     */
    com.google.protobuf.Timestamp getTime();
    /**
     *
     *
     * <pre>
     * The timestamp when the `destination` service sends the last byte of
     * the response.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp time = 4;</code>
     */
    com.google.protobuf.TimestampOrBuilder getTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The length of time it takes the backend service to fully respond to a
     * request. Measured from when the destination service starts to send the
     * request to the backend until when the destination service receives the
     * complete response from the backend.
     * </pre>
     *
     * <code>.google.protobuf.Duration backend_latency = 5;</code>
     *
     * @return Whether the backendLatency field is set.
     */
    boolean hasBackendLatency();
    /**
     *
     *
     * <pre>
     * The length of time it takes the backend service to fully respond to a
     * request. Measured from when the destination service starts to send the
     * request to the backend until when the destination service receives the
     * complete response from the backend.
     * </pre>
     *
     * <code>.google.protobuf.Duration backend_latency = 5;</code>
     *
     * @return The backendLatency.
     */
    com.google.protobuf.Duration getBackendLatency();
    /**
     *
     *
     * <pre>
     * The length of time it takes the backend service to fully respond to a
     * request. Measured from when the destination service starts to send the
     * request to the backend until when the destination service receives the
     * complete response from the backend.
     * </pre>
     *
     * <code>.google.protobuf.Duration backend_latency = 5;</code>
     */
    com.google.protobuf.DurationOrBuilder getBackendLatencyOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * This message defines attributes for a typical network response. It
   * generally models semantics of an HTTP response.
   * </pre>
   *
   * Protobuf type {@code google.rpc.context.AttributeContext.Response}
   */
  public static final class Response extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.rpc.context.AttributeContext.Response)
      ResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Response() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Response();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                code_ = input.readInt64();
                break;
              }
            case 16:
              {
                size_ = input.readInt64();
                break;
              }
            case 26:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  headers_ =
                      com.google.protobuf.MapField.newMapField(
                          HeadersDefaultEntryHolder.defaultEntry);
                  mutable_bitField0_ |= 0x00000001;
                }
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
                    input.readMessage(
                        HeadersDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                headers_.getMutableMap().put(headers__.getKey(), headers__.getValue());
                break;
              }
            case 34:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (time_ != null) {
                  subBuilder = time_.toBuilder();
                }
                time_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(time_);
                  time_ = subBuilder.buildPartial();
                }

                break;
              }
            case 42:
              {
                com.google.protobuf.Duration.Builder subBuilder = null;
                if (backendLatency_ != null) {
                  subBuilder = backendLatency_.toBuilder();
                }
                backendLatency_ =
                    input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(backendLatency_);
                  backendLatency_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_Response_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.rpc.context.AttributeContext.Response.class,
              com.google.rpc.context.AttributeContext.Response.Builder.class);
    }

    public static final int CODE_FIELD_NUMBER = 1;
    private long code_;
    /**
     *
     *
     * <pre>
     * The HTTP response status code, such as `200` and `404`.
     * </pre>
     *
     * <code>int64 code = 1;</code>
     *
     * @return The code.
     */
    @java.lang.Override
    public long getCode() {
      return code_;
    }

    public static final int SIZE_FIELD_NUMBER = 2;
    private long size_;
    /**
     *
     *
     * <pre>
     * The HTTP response size in bytes. If unknown, it must be -1.
     * </pre>
     *
     * <code>int64 size = 2;</code>
     *
     * @return The size.
     */
    @java.lang.Override
    public long getSize() {
      return size_;
    }

    public static final int HEADERS_FIELD_NUMBER = 3;

    private static final class HeadersDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.rpc.context.AttributeContextProto
                  .internal_static_google_rpc_context_AttributeContext_Response_HeadersEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetHeaders() {
      if (headers_ == null) {
        return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
      }
      return headers_;
    }

    public int getHeadersCount() {
      return internalGetHeaders().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The HTTP response headers. If multiple headers share the same key, they
     * must be merged according to HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    @java.lang.Override
    public boolean containsHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetHeaders().getMap().containsKey(key);
    }
    /** Use {@link #getHeadersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
      return getHeadersMap();
    }
    /**
     *
     *
     * <pre>
     * The HTTP response headers. If multiple headers share the same key, they
     * must be merged according to HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
      return internalGetHeaders().getMap();
    }
    /**
     *
     *
     * <pre>
     * The HTTP response headers. If multiple headers share the same key, they
     * must be merged according to HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getHeadersOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The HTTP response headers. If multiple headers share the same key, they
     * must be merged according to HTTP spec. All header keys must be
     * lowercased, because HTTP header keys are case-insensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getHeadersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.Timestamp time_;
    /**
     *
     *
     * <pre>
     * The timestamp when the `destination` service sends the last byte of
     * the response.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp time = 4;</code>
     *
     * @return Whether the time field is set.
     */
    @java.lang.Override
    public boolean hasTime() {
      return time_ != null;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the `destination` service sends the last byte of
     * the response.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp time = 4;</code>
     *
     * @return The time.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getTime() {
      return time_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : time_;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the `destination` service sends the last byte of
     * the response.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp time = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getTimeOrBuilder() {
      return getTime();
    }

    public static final int BACKEND_LATENCY_FIELD_NUMBER = 5;
    private com.google.protobuf.Duration backendLatency_;
    /**
     *
     *
     * <pre>
     * The length of time it takes the backend service to fully respond to a
     * request. Measured from when the destination service starts to send the
     * request to the backend until when the destination service receives the
     * complete response from the backend.
     * </pre>
     *
     * <code>.google.protobuf.Duration backend_latency = 5;</code>
     *
     * @return Whether the backendLatency field is set.
     */
    @java.lang.Override
    public boolean hasBackendLatency() {
      return backendLatency_ != null;
    }
    /**
     *
     *
     * <pre>
     * The length of time it takes the backend service to fully respond to a
     * request. Measured from when the destination service starts to send the
     * request to the backend until when the destination service receives the
     * complete response from the backend.
     * </pre>
     *
     * <code>.google.protobuf.Duration backend_latency = 5;</code>
     *
     * @return The backendLatency.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getBackendLatency() {
      return backendLatency_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : backendLatency_;
    }
    /**
     *
     *
     * <pre>
     * The length of time it takes the backend service to fully respond to a
     * request. Measured from when the destination service starts to send the
     * request to the backend until when the destination service receives the
     * complete response from the backend.
     * </pre>
     *
     * <code>.google.protobuf.Duration backend_latency = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getBackendLatencyOrBuilder() {
      return getBackendLatency();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (code_ != 0L) {
        output.writeInt64(1, code_);
      }
      if (size_ != 0L) {
        output.writeInt64(2, size_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetHeaders(), HeadersDefaultEntryHolder.defaultEntry, 3);
      if (time_ != null) {
        output.writeMessage(4, getTime());
      }
      if (backendLatency_ != null) {
        output.writeMessage(5, getBackendLatency());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (code_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, code_);
      }
      if (size_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, size_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetHeaders().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
            HeadersDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, headers__);
      }
      if (time_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTime());
      }
      if (backendLatency_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getBackendLatency());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.rpc.context.AttributeContext.Response)) {
        return super.equals(obj);
      }
      com.google.rpc.context.AttributeContext.Response other =
          (com.google.rpc.context.AttributeContext.Response) obj;

      if (getCode() != other.getCode()) return false;
      if (getSize() != other.getSize()) return false;
      if (!internalGetHeaders().equals(other.internalGetHeaders())) return false;
      if (hasTime() != other.hasTime()) return false;
      if (hasTime()) {
        if (!getTime().equals(other.getTime())) return false;
      }
      if (hasBackendLatency() != other.hasBackendLatency()) return false;
      if (hasBackendLatency()) {
        if (!getBackendLatency().equals(other.getBackendLatency())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CODE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCode());
      hash = (37 * hash) + SIZE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSize());
      if (!internalGetHeaders().getMap().isEmpty()) {
        hash = (37 * hash) + HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetHeaders().hashCode();
      }
      if (hasTime()) {
        hash = (37 * hash) + TIME_FIELD_NUMBER;
        hash = (53 * hash) + getTime().hashCode();
      }
      if (hasBackendLatency()) {
        hash = (37 * hash) + BACKEND_LATENCY_FIELD_NUMBER;
        hash = (53 * hash) + getBackendLatency().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.rpc.context.AttributeContext.Response parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Response parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Response parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Response parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Response parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Response parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Response parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Response parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.rpc.context.AttributeContext.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * This message defines attributes for a typical network response. It
     * generally models semantics of an HTTP response.
     * </pre>
     *
     * Protobuf type {@code google.rpc.context.AttributeContext.Response}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.rpc.context.AttributeContext.Response)
        com.google.rpc.context.AttributeContext.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Response_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 3:
            return internalGetHeaders();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 3:
            return internalGetMutableHeaders();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.rpc.context.AttributeContext.Response.class,
                com.google.rpc.context.AttributeContext.Response.Builder.class);
      }

      // Construct using com.google.rpc.context.AttributeContext.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        code_ = 0L;

        size_ = 0L;

        internalGetMutableHeaders().clear();
        if (timeBuilder_ == null) {
          time_ = null;
        } else {
          time_ = null;
          timeBuilder_ = null;
        }
        if (backendLatencyBuilder_ == null) {
          backendLatency_ = null;
        } else {
          backendLatency_ = null;
          backendLatencyBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Response_descriptor;
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Response getDefaultInstanceForType() {
        return com.google.rpc.context.AttributeContext.Response.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Response build() {
        com.google.rpc.context.AttributeContext.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Response buildPartial() {
        com.google.rpc.context.AttributeContext.Response result =
            new com.google.rpc.context.AttributeContext.Response(this);
        int from_bitField0_ = bitField0_;
        result.code_ = code_;
        result.size_ = size_;
        result.headers_ = internalGetHeaders();
        result.headers_.makeImmutable();
        if (timeBuilder_ == null) {
          result.time_ = time_;
        } else {
          result.time_ = timeBuilder_.build();
        }
        if (backendLatencyBuilder_ == null) {
          result.backendLatency_ = backendLatency_;
        } else {
          result.backendLatency_ = backendLatencyBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.rpc.context.AttributeContext.Response) {
          return mergeFrom((com.google.rpc.context.AttributeContext.Response) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.rpc.context.AttributeContext.Response other) {
        if (other == com.google.rpc.context.AttributeContext.Response.getDefaultInstance())
          return this;
        if (other.getCode() != 0L) {
          setCode(other.getCode());
        }
        if (other.getSize() != 0L) {
          setSize(other.getSize());
        }
        internalGetMutableHeaders().mergeFrom(other.internalGetHeaders());
        if (other.hasTime()) {
          mergeTime(other.getTime());
        }
        if (other.hasBackendLatency()) {
          mergeBackendLatency(other.getBackendLatency());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.rpc.context.AttributeContext.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.rpc.context.AttributeContext.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private long code_;
      /**
       *
       *
       * <pre>
       * The HTTP response status code, such as `200` and `404`.
       * </pre>
       *
       * <code>int64 code = 1;</code>
       *
       * @return The code.
       */
      @java.lang.Override
      public long getCode() {
        return code_;
      }
      /**
       *
       *
       * <pre>
       * The HTTP response status code, such as `200` and `404`.
       * </pre>
       *
       * <code>int64 code = 1;</code>
       *
       * @param value The code to set.
       * @return This builder for chaining.
       */
      public Builder setCode(long value) {

        code_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP response status code, such as `200` and `404`.
       * </pre>
       *
       * <code>int64 code = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCode() {

        code_ = 0L;
        onChanged();
        return this;
      }

      private long size_;
      /**
       *
       *
       * <pre>
       * The HTTP response size in bytes. If unknown, it must be -1.
       * </pre>
       *
       * <code>int64 size = 2;</code>
       *
       * @return The size.
       */
      @java.lang.Override
      public long getSize() {
        return size_;
      }
      /**
       *
       *
       * <pre>
       * The HTTP response size in bytes. If unknown, it must be -1.
       * </pre>
       *
       * <code>int64 size = 2;</code>
       *
       * @param value The size to set.
       * @return This builder for chaining.
       */
      public Builder setSize(long value) {

        size_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP response size in bytes. If unknown, it must be -1.
       * </pre>
       *
       * <code>int64 size = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSize() {

        size_ = 0L;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetHeaders() {
        if (headers_ == null) {
          return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
        }
        return headers_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableHeaders() {
        onChanged();
        ;
        if (headers_ == null) {
          headers_ =
              com.google.protobuf.MapField.newMapField(HeadersDefaultEntryHolder.defaultEntry);
        }
        if (!headers_.isMutable()) {
          headers_ = headers_.copy();
        }
        return headers_;
      }

      public int getHeadersCount() {
        return internalGetHeaders().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * The HTTP response headers. If multiple headers share the same key, they
       * must be merged according to HTTP spec. All header keys must be
       * lowercased, because HTTP header keys are case-insensitive.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 3;</code>
       */
      @java.lang.Override
      public boolean containsHeaders(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetHeaders().getMap().containsKey(key);
      }
      /** Use {@link #getHeadersMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
        return getHeadersMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP response headers. If multiple headers share the same key, they
       * must be merged according to HTTP spec. All header keys must be
       * lowercased, because HTTP header keys are case-insensitive.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 3;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
        return internalGetHeaders().getMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP response headers. If multiple headers share the same key, they
       * must be merged according to HTTP spec. All header keys must be
       * lowercased, because HTTP header keys are case-insensitive.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 3;</code>
       */
      @java.lang.Override
      public java.lang.String getHeadersOrDefault(
          java.lang.String key, java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * The HTTP response headers. If multiple headers share the same key, they
       * must be merged according to HTTP spec. All header keys must be
       * lowercased, because HTTP header keys are case-insensitive.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 3;</code>
       */
      @java.lang.Override
      public java.lang.String getHeadersOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearHeaders() {
        internalGetMutableHeaders().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP response headers. If multiple headers share the same key, they
       * must be merged according to HTTP spec. All header keys must be
       * lowercased, because HTTP header keys are case-insensitive.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 3;</code>
       */
      public Builder removeHeaders(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableHeaders().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableHeaders() {
        return internalGetMutableHeaders().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP response headers. If multiple headers share the same key, they
       * must be merged according to HTTP spec. All header keys must be
       * lowercased, because HTTP header keys are case-insensitive.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 3;</code>
       */
      public Builder putHeaders(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }

        internalGetMutableHeaders().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP response headers. If multiple headers share the same key, they
       * must be merged according to HTTP spec. All header keys must be
       * lowercased, because HTTP header keys are case-insensitive.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 3;</code>
       */
      public Builder putAllHeaders(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableHeaders().getMutableMap().putAll(values);
        return this;
      }

      private com.google.protobuf.Timestamp time_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          timeBuilder_;
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service sends the last byte of
       * the response.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 4;</code>
       *
       * @return Whether the time field is set.
       */
      public boolean hasTime() {
        return timeBuilder_ != null || time_ != null;
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service sends the last byte of
       * the response.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 4;</code>
       *
       * @return The time.
       */
      public com.google.protobuf.Timestamp getTime() {
        if (timeBuilder_ == null) {
          return time_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : time_;
        } else {
          return timeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service sends the last byte of
       * the response.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 4;</code>
       */
      public Builder setTime(com.google.protobuf.Timestamp value) {
        if (timeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          time_ = value;
          onChanged();
        } else {
          timeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service sends the last byte of
       * the response.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 4;</code>
       */
      public Builder setTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (timeBuilder_ == null) {
          time_ = builderForValue.build();
          onChanged();
        } else {
          timeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service sends the last byte of
       * the response.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 4;</code>
       */
      public Builder mergeTime(com.google.protobuf.Timestamp value) {
        if (timeBuilder_ == null) {
          if (time_ != null) {
            time_ = com.google.protobuf.Timestamp.newBuilder(time_).mergeFrom(value).buildPartial();
          } else {
            time_ = value;
          }
          onChanged();
        } else {
          timeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service sends the last byte of
       * the response.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 4;</code>
       */
      public Builder clearTime() {
        if (timeBuilder_ == null) {
          time_ = null;
          onChanged();
        } else {
          time_ = null;
          timeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service sends the last byte of
       * the response.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 4;</code>
       */
      public com.google.protobuf.Timestamp.Builder getTimeBuilder() {

        onChanged();
        return getTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service sends the last byte of
       * the response.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 4;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getTimeOrBuilder() {
        if (timeBuilder_ != null) {
          return timeBuilder_.getMessageOrBuilder();
        } else {
          return time_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : time_;
        }
      }
      /**
       *
       *
       * <pre>
       * The timestamp when the `destination` service sends the last byte of
       * the response.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp time = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getTimeFieldBuilder() {
        if (timeBuilder_ == null) {
          timeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getTime(), getParentForChildren(), isClean());
          time_ = null;
        }
        return timeBuilder_;
      }

      private com.google.protobuf.Duration backendLatency_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          backendLatencyBuilder_;
      /**
       *
       *
       * <pre>
       * The length of time it takes the backend service to fully respond to a
       * request. Measured from when the destination service starts to send the
       * request to the backend until when the destination service receives the
       * complete response from the backend.
       * </pre>
       *
       * <code>.google.protobuf.Duration backend_latency = 5;</code>
       *
       * @return Whether the backendLatency field is set.
       */
      public boolean hasBackendLatency() {
        return backendLatencyBuilder_ != null || backendLatency_ != null;
      }
      /**
       *
       *
       * <pre>
       * The length of time it takes the backend service to fully respond to a
       * request. Measured from when the destination service starts to send the
       * request to the backend until when the destination service receives the
       * complete response from the backend.
       * </pre>
       *
       * <code>.google.protobuf.Duration backend_latency = 5;</code>
       *
       * @return The backendLatency.
       */
      public com.google.protobuf.Duration getBackendLatency() {
        if (backendLatencyBuilder_ == null) {
          return backendLatency_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : backendLatency_;
        } else {
          return backendLatencyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The length of time it takes the backend service to fully respond to a
       * request. Measured from when the destination service starts to send the
       * request to the backend until when the destination service receives the
       * complete response from the backend.
       * </pre>
       *
       * <code>.google.protobuf.Duration backend_latency = 5;</code>
       */
      public Builder setBackendLatency(com.google.protobuf.Duration value) {
        if (backendLatencyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          backendLatency_ = value;
          onChanged();
        } else {
          backendLatencyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The length of time it takes the backend service to fully respond to a
       * request. Measured from when the destination service starts to send the
       * request to the backend until when the destination service receives the
       * complete response from the backend.
       * </pre>
       *
       * <code>.google.protobuf.Duration backend_latency = 5;</code>
       */
      public Builder setBackendLatency(com.google.protobuf.Duration.Builder builderForValue) {
        if (backendLatencyBuilder_ == null) {
          backendLatency_ = builderForValue.build();
          onChanged();
        } else {
          backendLatencyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The length of time it takes the backend service to fully respond to a
       * request. Measured from when the destination service starts to send the
       * request to the backend until when the destination service receives the
       * complete response from the backend.
       * </pre>
       *
       * <code>.google.protobuf.Duration backend_latency = 5;</code>
       */
      public Builder mergeBackendLatency(com.google.protobuf.Duration value) {
        if (backendLatencyBuilder_ == null) {
          if (backendLatency_ != null) {
            backendLatency_ =
                com.google.protobuf.Duration.newBuilder(backendLatency_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            backendLatency_ = value;
          }
          onChanged();
        } else {
          backendLatencyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The length of time it takes the backend service to fully respond to a
       * request. Measured from when the destination service starts to send the
       * request to the backend until when the destination service receives the
       * complete response from the backend.
       * </pre>
       *
       * <code>.google.protobuf.Duration backend_latency = 5;</code>
       */
      public Builder clearBackendLatency() {
        if (backendLatencyBuilder_ == null) {
          backendLatency_ = null;
          onChanged();
        } else {
          backendLatency_ = null;
          backendLatencyBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The length of time it takes the backend service to fully respond to a
       * request. Measured from when the destination service starts to send the
       * request to the backend until when the destination service receives the
       * complete response from the backend.
       * </pre>
       *
       * <code>.google.protobuf.Duration backend_latency = 5;</code>
       */
      public com.google.protobuf.Duration.Builder getBackendLatencyBuilder() {

        onChanged();
        return getBackendLatencyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The length of time it takes the backend service to fully respond to a
       * request. Measured from when the destination service starts to send the
       * request to the backend until when the destination service receives the
       * complete response from the backend.
       * </pre>
       *
       * <code>.google.protobuf.Duration backend_latency = 5;</code>
       */
      public com.google.protobuf.DurationOrBuilder getBackendLatencyOrBuilder() {
        if (backendLatencyBuilder_ != null) {
          return backendLatencyBuilder_.getMessageOrBuilder();
        } else {
          return backendLatency_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : backendLatency_;
        }
      }
      /**
       *
       *
       * <pre>
       * The length of time it takes the backend service to fully respond to a
       * request. Measured from when the destination service starts to send the
       * request to the backend until when the destination service receives the
       * complete response from the backend.
       * </pre>
       *
       * <code>.google.protobuf.Duration backend_latency = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getBackendLatencyFieldBuilder() {
        if (backendLatencyBuilder_ == null) {
          backendLatencyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getBackendLatency(), getParentForChildren(), isClean());
          backendLatency_ = null;
        }
        return backendLatencyBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.rpc.context.AttributeContext.Response)
    }

    // @@protoc_insertion_point(class_scope:google.rpc.context.AttributeContext.Response)
    private static final com.google.rpc.context.AttributeContext.Response DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.rpc.context.AttributeContext.Response();
    }

    public static com.google.rpc.context.AttributeContext.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response> PARSER =
        new com.google.protobuf.AbstractParser<Response>() {
          @java.lang.Override
          public Response parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Response(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.rpc.context.AttributeContext.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ResourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.rpc.context.AttributeContext.Resource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the service that this resource belongs to, such as
     * `pubsub.googleapis.com`. The service may be different from the DNS
     * hostname that actually serves the request.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The service.
     */
    java.lang.String getService();
    /**
     *
     *
     * <pre>
     * The name of the service that this resource belongs to, such as
     * `pubsub.googleapis.com`. The service may be different from the DNS
     * hostname that actually serves the request.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The bytes for service.
     */
    com.google.protobuf.ByteString getServiceBytes();

    /**
     *
     *
     * <pre>
     * The stable identifier (name) of a resource on the `service`. A resource
     * can be logically identified as "//{resource.service}/{resource.name}".
     * The differences between a resource name and a URI are:
     * *   Resource name is a logical identifier, independent of network
     *     protocol and API version. For example,
     *     `//pubsub.googleapis.com/projects/123/topics/news-feed`.
     * *   URI often includes protocol and version information, so it can
     *     be used directly by applications. For example,
     *     `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`.
     * See https://cloud.google.com/apis/design/resource_names for details.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * The stable identifier (name) of a resource on the `service`. A resource
     * can be logically identified as "//{resource.service}/{resource.name}".
     * The differences between a resource name and a URI are:
     * *   Resource name is a logical identifier, independent of network
     *     protocol and API version. For example,
     *     `//pubsub.googleapis.com/projects/123/topics/news-feed`.
     * *   URI often includes protocol and version information, so it can
     *     be used directly by applications. For example,
     *     `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`.
     * See https://cloud.google.com/apis/design/resource_names for details.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * The type of the resource. The syntax is platform-specific because
     * different platforms define their resources differently.
     * For Google APIs, the type format must be "{service}/{kind}".
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The type.
     */
    java.lang.String getType();
    /**
     *
     *
     * <pre>
     * The type of the resource. The syntax is platform-specific because
     * different platforms define their resources differently.
     * For Google APIs, the type format must be "{service}/{kind}".
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The bytes for type.
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * The labels or tags on the resource, such as AWS resource tags and
     * Kubernetes resource labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    int getLabelsCount();
    /**
     *
     *
     * <pre>
     * The labels or tags on the resource, such as AWS resource tags and
     * Kubernetes resource labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    boolean containsLabels(java.lang.String key);
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getLabels();
    /**
     *
     *
     * <pre>
     * The labels or tags on the resource, such as AWS resource tags and
     * Kubernetes resource labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
    /**
     *
     *
     * <pre>
     * The labels or tags on the resource, such as AWS resource tags and
     * Kubernetes resource labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */

    /* nullable */
    java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * The labels or tags on the resource, such as AWS resource tags and
     * Kubernetes resource labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    java.lang.String getLabelsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * The unique identifier of the resource. UID is unique in the time
     * and space for this resource within the scope of the service. It is
     * typically generated by the server on successful creation of a resource
     * and must not be changed. UID is used to uniquely identify resources
     * with resource name reuses. This should be a UUID4.
     * </pre>
     *
     * <code>string uid = 5;</code>
     *
     * @return The uid.
     */
    java.lang.String getUid();
    /**
     *
     *
     * <pre>
     * The unique identifier of the resource. UID is unique in the time
     * and space for this resource within the scope of the service. It is
     * typically generated by the server on successful creation of a resource
     * and must not be changed. UID is used to uniquely identify resources
     * with resource name reuses. This should be a UUID4.
     * </pre>
     *
     * <code>string uid = 5;</code>
     *
     * @return The bytes for uid.
     */
    com.google.protobuf.ByteString getUidBytes();

    /**
     *
     *
     * <pre>
     * Annotations is an unstructured key-value map stored with a resource that
     * may be set by external tools to store and retrieve arbitrary metadata.
     * They are not queryable and should be preserved when modifying objects.
     * More info: https://kubernetes.io/docs/user-guide/annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6;</code>
     */
    int getAnnotationsCount();
    /**
     *
     *
     * <pre>
     * Annotations is an unstructured key-value map stored with a resource that
     * may be set by external tools to store and retrieve arbitrary metadata.
     * They are not queryable and should be preserved when modifying objects.
     * More info: https://kubernetes.io/docs/user-guide/annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6;</code>
     */
    boolean containsAnnotations(java.lang.String key);
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getAnnotations();
    /**
     *
     *
     * <pre>
     * Annotations is an unstructured key-value map stored with a resource that
     * may be set by external tools to store and retrieve arbitrary metadata.
     * They are not queryable and should be preserved when modifying objects.
     * More info: https://kubernetes.io/docs/user-guide/annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap();
    /**
     *
     *
     * <pre>
     * Annotations is an unstructured key-value map stored with a resource that
     * may be set by external tools to store and retrieve arbitrary metadata.
     * They are not queryable and should be preserved when modifying objects.
     * More info: https://kubernetes.io/docs/user-guide/annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6;</code>
     */

    /* nullable */
    java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * Annotations is an unstructured key-value map stored with a resource that
     * may be set by external tools to store and retrieve arbitrary metadata.
     * They are not queryable and should be preserved when modifying objects.
     * More info: https://kubernetes.io/docs/user-guide/annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6;</code>
     */
    java.lang.String getAnnotationsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Mutable. The display name set by clients. Must be &lt;= 63 characters.
     * </pre>
     *
     * <code>string display_name = 7;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * Mutable. The display name set by clients. Must be &lt;= 63 characters.
     * </pre>
     *
     * <code>string display_name = 7;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created. This may
     * be either the time creation was initiated or when it was completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 8;</code>
     *
     * @return Whether the createTime field is set.
     */
    boolean hasCreateTime();
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created. This may
     * be either the time creation was initiated or when it was completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 8;</code>
     *
     * @return The createTime.
     */
    com.google.protobuf.Timestamp getCreateTime();
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created. This may
     * be either the time creation was initiated or when it was completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 8;</code>
     */
    com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated. Any
     * change to the resource made by users must refresh this value.
     * Changes to a resource made by the service should refresh this value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 9;</code>
     *
     * @return Whether the updateTime field is set.
     */
    boolean hasUpdateTime();
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated. Any
     * change to the resource made by users must refresh this value.
     * Changes to a resource made by the service should refresh this value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 9;</code>
     *
     * @return The updateTime.
     */
    com.google.protobuf.Timestamp getUpdateTime();
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated. Any
     * change to the resource made by users must refresh this value.
     * Changes to a resource made by the service should refresh this value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 9;</code>
     */
    com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was deleted.
     * If the resource is not deleted, this must be empty.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 10;</code>
     *
     * @return Whether the deleteTime field is set.
     */
    boolean hasDeleteTime();
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was deleted.
     * If the resource is not deleted, this must be empty.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 10;</code>
     *
     * @return The deleteTime.
     */
    com.google.protobuf.Timestamp getDeleteTime();
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was deleted.
     * If the resource is not deleted, this must be empty.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 10;</code>
     */
    com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. An opaque value that uniquely identifies a version or
     * generation of a resource. It can be used to confirm that the client
     * and server agree on the ordering of a resource being written.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return The etag.
     */
    java.lang.String getEtag();
    /**
     *
     *
     * <pre>
     * Output only. An opaque value that uniquely identifies a version or
     * generation of a resource. It can be used to confirm that the client
     * and server agree on the ordering of a resource being written.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return The bytes for etag.
     */
    com.google.protobuf.ByteString getEtagBytes();

    /**
     *
     *
     * <pre>
     * Immutable. The location of the resource. The location encoding is
     * specific to the service provider, and new encoding may be introduced
     * as the service evolves.
     * For Google Cloud products, the encoding is what is used by Google Cloud
     * APIs, such as `us-east1`, `aws-us-east-1`, and `azure-eastus2`. The
     * semantics of `location` is identical to the
     * `cloud.googleapis.com/location` label used by some Google Cloud APIs.
     * </pre>
     *
     * <code>string location = 12;</code>
     *
     * @return The location.
     */
    java.lang.String getLocation();
    /**
     *
     *
     * <pre>
     * Immutable. The location of the resource. The location encoding is
     * specific to the service provider, and new encoding may be introduced
     * as the service evolves.
     * For Google Cloud products, the encoding is what is used by Google Cloud
     * APIs, such as `us-east1`, `aws-us-east-1`, and `azure-eastus2`. The
     * semantics of `location` is identical to the
     * `cloud.googleapis.com/location` label used by some Google Cloud APIs.
     * </pre>
     *
     * <code>string location = 12;</code>
     *
     * @return The bytes for location.
     */
    com.google.protobuf.ByteString getLocationBytes();
  }
  /**
   *
   *
   * <pre>
   * This message defines core attributes for a resource. A resource is an
   * addressable (named) entity provided by the destination service. For
   * example, a file stored on a network storage service.
   * </pre>
   *
   * Protobuf type {@code google.rpc.context.AttributeContext.Resource}
   */
  public static final class Resource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.rpc.context.AttributeContext.Resource)
      ResourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Resource.newBuilder() to construct.
    private Resource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Resource() {
      service_ = "";
      name_ = "";
      type_ = "";
      uid_ = "";
      displayName_ = "";
      etag_ = "";
      location_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Resource();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Resource(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                service_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                name_ = s;
                break;
              }
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();

                type_ = s;
                break;
              }
            case 34:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  labels_ =
                      com.google.protobuf.MapField.newMapField(
                          LabelsDefaultEntryHolder.defaultEntry);
                  mutable_bitField0_ |= 0x00000001;
                }
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
                break;
              }
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();

                uid_ = s;
                break;
              }
            case 50:
              {
                if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                  annotations_ =
                      com.google.protobuf.MapField.newMapField(
                          AnnotationsDefaultEntryHolder.defaultEntry);
                  mutable_bitField0_ |= 0x00000002;
                }
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                annotations_.getMutableMap().put(annotations__.getKey(), annotations__.getValue());
                break;
              }
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();

                displayName_ = s;
                break;
              }
            case 66:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (createTime_ != null) {
                  subBuilder = createTime_.toBuilder();
                }
                createTime_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(createTime_);
                  createTime_ = subBuilder.buildPartial();
                }

                break;
              }
            case 74:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (updateTime_ != null) {
                  subBuilder = updateTime_.toBuilder();
                }
                updateTime_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(updateTime_);
                  updateTime_ = subBuilder.buildPartial();
                }

                break;
              }
            case 82:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (deleteTime_ != null) {
                  subBuilder = deleteTime_.toBuilder();
                }
                deleteTime_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(deleteTime_);
                  deleteTime_ = subBuilder.buildPartial();
                }

                break;
              }
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();

                etag_ = s;
                break;
              }
            case 98:
              {
                java.lang.String s = input.readStringRequireUtf8();

                location_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_Resource_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        case 6:
          return internalGetAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_Resource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.rpc.context.AttributeContext.Resource.class,
              com.google.rpc.context.AttributeContext.Resource.Builder.class);
    }

    public static final int SERVICE_FIELD_NUMBER = 1;
    private volatile java.lang.Object service_;
    /**
     *
     *
     * <pre>
     * The name of the service that this resource belongs to, such as
     * `pubsub.googleapis.com`. The service may be different from the DNS
     * hostname that actually serves the request.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The service.
     */
    @java.lang.Override
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the service that this resource belongs to, such as
     * `pubsub.googleapis.com`. The service may be different from the DNS
     * hostname that actually serves the request.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The bytes for service.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * The stable identifier (name) of a resource on the `service`. A resource
     * can be logically identified as "//{resource.service}/{resource.name}".
     * The differences between a resource name and a URI are:
     * *   Resource name is a logical identifier, independent of network
     *     protocol and API version. For example,
     *     `//pubsub.googleapis.com/projects/123/topics/news-feed`.
     * *   URI often includes protocol and version information, so it can
     *     be used directly by applications. For example,
     *     `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`.
     * See https://cloud.google.com/apis/design/resource_names for details.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The stable identifier (name) of a resource on the `service`. A resource
     * can be logically identified as "//{resource.service}/{resource.name}".
     * The differences between a resource name and a URI are:
     * *   Resource name is a logical identifier, independent of network
     *     protocol and API version. For example,
     *     `//pubsub.googleapis.com/projects/123/topics/news-feed`.
     * *   URI often includes protocol and version information, so it can
     *     be used directly by applications. For example,
     *     `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`.
     * See https://cloud.google.com/apis/design/resource_names for details.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 3;
    private volatile java.lang.Object type_;
    /**
     *
     *
     * <pre>
     * The type of the resource. The syntax is platform-specific because
     * different platforms define their resources differently.
     * For Google APIs, the type format must be "{service}/{kind}".
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the resource. The syntax is platform-specific because
     * different platforms define their resources differently.
     * For Google APIs, the type format must be "{service}/{kind}".
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The bytes for type.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LABELS_FIELD_NUMBER = 4;

    private static final class LabelsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.rpc.context.AttributeContextProto
                  .internal_static_google_rpc_context_AttributeContext_Resource_LabelsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels or tags on the resource, such as AWS resource tags and
     * Kubernetes resource labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels or tags on the resource, such as AWS resource tags and
     * Kubernetes resource labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels or tags on the resource, such as AWS resource tags and
     * Kubernetes resource labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels or tags on the resource, such as AWS resource tags and
     * Kubernetes resource labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int UID_FIELD_NUMBER = 5;
    private volatile java.lang.Object uid_;
    /**
     *
     *
     * <pre>
     * The unique identifier of the resource. UID is unique in the time
     * and space for this resource within the scope of the service. It is
     * typically generated by the server on successful creation of a resource
     * and must not be changed. UID is used to uniquely identify resources
     * with resource name reuses. This should be a UUID4.
     * </pre>
     *
     * <code>string uid = 5;</code>
     *
     * @return The uid.
     */
    @java.lang.Override
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the resource. UID is unique in the time
     * and space for this resource within the scope of the service. It is
     * typically generated by the server on successful creation of a resource
     * and must not be changed. UID is used to uniquely identify resources
     * with resource name reuses. This should be a UUID4.
     * </pre>
     *
     * <code>string uid = 5;</code>
     *
     * @return The bytes for uid.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ANNOTATIONS_FIELD_NUMBER = 6;

    private static final class AnnotationsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.rpc.context.AttributeContextProto
                  .internal_static_google_rpc_context_AttributeContext_Resource_AnnotationsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Annotations is an unstructured key-value map stored with a resource that
     * may be set by external tools to store and retrieve arbitrary metadata.
     * They are not queryable and should be preserved when modifying objects.
     * More info: https://kubernetes.io/docs/user-guide/annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6;</code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * Annotations is an unstructured key-value map stored with a resource that
     * may be set by external tools to store and retrieve arbitrary metadata.
     * They are not queryable and should be preserved when modifying objects.
     * More info: https://kubernetes.io/docs/user-guide/annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * Annotations is an unstructured key-value map stored with a resource that
     * may be set by external tools to store and retrieve arbitrary metadata.
     * They are not queryable and should be preserved when modifying objects.
     * More info: https://kubernetes.io/docs/user-guide/annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Annotations is an unstructured key-value map stored with a resource that
     * may be set by external tools to store and retrieve arbitrary metadata.
     * They are not queryable and should be preserved when modifying objects.
     * More info: https://kubernetes.io/docs/user-guide/annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 7;
    private volatile java.lang.Object displayName_;
    /**
     *
     *
     * <pre>
     * Mutable. The display name set by clients. Must be &lt;= 63 characters.
     * </pre>
     *
     * <code>string display_name = 7;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Mutable. The display name set by clients. Must be &lt;= 63 characters.
     * </pre>
     *
     * <code>string display_name = 7;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CREATE_TIME_FIELD_NUMBER = 8;
    private com.google.protobuf.Timestamp createTime_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created. This may
     * be either the time creation was initiated or when it was completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 8;</code>
     *
     * @return Whether the createTime field is set.
     */
    @java.lang.Override
    public boolean hasCreateTime() {
      return createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created. This may
     * be either the time creation was initiated or when it was completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 8;</code>
     *
     * @return The createTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getCreateTime() {
      return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created. This may
     * be either the time creation was initiated or when it was completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 8;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      return getCreateTime();
    }

    public static final int UPDATE_TIME_FIELD_NUMBER = 9;
    private com.google.protobuf.Timestamp updateTime_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated. Any
     * change to the resource made by users must refresh this value.
     * Changes to a resource made by the service should refresh this value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 9;</code>
     *
     * @return Whether the updateTime field is set.
     */
    @java.lang.Override
    public boolean hasUpdateTime() {
      return updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated. Any
     * change to the resource made by users must refresh this value.
     * Changes to a resource made by the service should refresh this value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 9;</code>
     *
     * @return The updateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getUpdateTime() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated. Any
     * change to the resource made by users must refresh this value.
     * Changes to a resource made by the service should refresh this value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 9;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      return getUpdateTime();
    }

    public static final int DELETE_TIME_FIELD_NUMBER = 10;
    private com.google.protobuf.Timestamp deleteTime_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was deleted.
     * If the resource is not deleted, this must be empty.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 10;</code>
     *
     * @return Whether the deleteTime field is set.
     */
    @java.lang.Override
    public boolean hasDeleteTime() {
      return deleteTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was deleted.
     * If the resource is not deleted, this must be empty.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 10;</code>
     *
     * @return The deleteTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getDeleteTime() {
      return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was deleted.
     * If the resource is not deleted, this must be empty.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 10;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      return getDeleteTime();
    }

    public static final int ETAG_FIELD_NUMBER = 11;
    private volatile java.lang.Object etag_;
    /**
     *
     *
     * <pre>
     * Output only. An opaque value that uniquely identifies a version or
     * generation of a resource. It can be used to confirm that the client
     * and server agree on the ordering of a resource being written.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return The etag.
     */
    @java.lang.Override
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An opaque value that uniquely identifies a version or
     * generation of a resource. It can be used to confirm that the client
     * and server agree on the ordering of a resource being written.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return The bytes for etag.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOCATION_FIELD_NUMBER = 12;
    private volatile java.lang.Object location_;
    /**
     *
     *
     * <pre>
     * Immutable. The location of the resource. The location encoding is
     * specific to the service provider, and new encoding may be introduced
     * as the service evolves.
     * For Google Cloud products, the encoding is what is used by Google Cloud
     * APIs, such as `us-east1`, `aws-us-east-1`, and `azure-eastus2`. The
     * semantics of `location` is identical to the
     * `cloud.googleapis.com/location` label used by some Google Cloud APIs.
     * </pre>
     *
     * <code>string location = 12;</code>
     *
     * @return The location.
     */
    @java.lang.Override
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The location of the resource. The location encoding is
     * specific to the service provider, and new encoding may be introduced
     * as the service evolves.
     * For Google Cloud products, the encoding is what is used by Google Cloud
     * APIs, such as `us-east1`, `aws-us-east-1`, and `azure-eastus2`. The
     * semantics of `location` is identical to the
     * `cloud.googleapis.com/location` label used by some Google Cloud APIs.
     * </pre>
     *
     * <code>string location = 12;</code>
     *
     * @return The bytes for location.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, type_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, uid_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 6);
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, displayName_);
      }
      if (createTime_ != null) {
        output.writeMessage(8, getCreateTime());
      }
      if (updateTime_ != null) {
        output.writeMessage(9, getUpdateTime());
      }
      if (deleteTime_ != null) {
        output.writeMessage(10, getDeleteTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 11, etag_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 12, location_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, type_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetLabels().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
            LabelsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, uid_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetAnnotations().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
            AnnotationsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, annotations__);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, displayName_);
      }
      if (createTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCreateTime());
      }
      if (updateTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
      }
      if (deleteTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDeleteTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, etag_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, location_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.rpc.context.AttributeContext.Resource)) {
        return super.equals(obj);
      }
      com.google.rpc.context.AttributeContext.Resource other =
          (com.google.rpc.context.AttributeContext.Resource) obj;

      if (!getService().equals(other.getService())) return false;
      if (!getName().equals(other.getName())) return false;
      if (!getType().equals(other.getType())) return false;
      if (!internalGetLabels().equals(other.internalGetLabels())) return false;
      if (!getUid().equals(other.getUid())) return false;
      if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (hasCreateTime() != other.hasCreateTime()) return false;
      if (hasCreateTime()) {
        if (!getCreateTime().equals(other.getCreateTime())) return false;
      }
      if (hasUpdateTime() != other.hasUpdateTime()) return false;
      if (hasUpdateTime()) {
        if (!getUpdateTime().equals(other.getUpdateTime())) return false;
      }
      if (hasDeleteTime() != other.hasDeleteTime()) return false;
      if (hasDeleteTime()) {
        if (!getDeleteTime().equals(other.getDeleteTime())) return false;
      }
      if (!getEtag().equals(other.getEtag())) return false;
      if (!getLocation().equals(other.getLocation())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getService().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
      if (!internalGetLabels().getMap().isEmpty()) {
        hash = (37 * hash) + LABELS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetLabels().hashCode();
      }
      hash = (37 * hash) + UID_FIELD_NUMBER;
      hash = (53 * hash) + getUid().hashCode();
      if (!internalGetAnnotations().getMap().isEmpty()) {
        hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetAnnotations().hashCode();
      }
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      if (hasCreateTime()) {
        hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getCreateTime().hashCode();
      }
      if (hasUpdateTime()) {
        hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateTime().hashCode();
      }
      if (hasDeleteTime()) {
        hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getDeleteTime().hashCode();
      }
      hash = (37 * hash) + ETAG_FIELD_NUMBER;
      hash = (53 * hash) + getEtag().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.rpc.context.AttributeContext.Resource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Resource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Resource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Resource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Resource parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.context.AttributeContext.Resource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Resource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Resource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Resource parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Resource parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.context.AttributeContext.Resource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.rpc.context.AttributeContext.Resource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.rpc.context.AttributeContext.Resource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * This message defines core attributes for a resource. A resource is an
     * addressable (named) entity provided by the destination service. For
     * example, a file stored on a network storage service.
     * </pre>
     *
     * Protobuf type {@code google.rpc.context.AttributeContext.Resource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.rpc.context.AttributeContext.Resource)
        com.google.rpc.context.AttributeContext.ResourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Resource_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 4:
            return internalGetLabels();
          case 6:
            return internalGetAnnotations();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 4:
            return internalGetMutableLabels();
          case 6:
            return internalGetMutableAnnotations();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Resource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.rpc.context.AttributeContext.Resource.class,
                com.google.rpc.context.AttributeContext.Resource.Builder.class);
      }

      // Construct using com.google.rpc.context.AttributeContext.Resource.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        service_ = "";

        name_ = "";

        type_ = "";

        internalGetMutableLabels().clear();
        uid_ = "";

        internalGetMutableAnnotations().clear();
        displayName_ = "";

        if (createTimeBuilder_ == null) {
          createTime_ = null;
        } else {
          createTime_ = null;
          createTimeBuilder_ = null;
        }
        if (updateTimeBuilder_ == null) {
          updateTime_ = null;
        } else {
          updateTime_ = null;
          updateTimeBuilder_ = null;
        }
        if (deleteTimeBuilder_ == null) {
          deleteTime_ = null;
        } else {
          deleteTime_ = null;
          deleteTimeBuilder_ = null;
        }
        etag_ = "";

        location_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.rpc.context.AttributeContextProto
            .internal_static_google_rpc_context_AttributeContext_Resource_descriptor;
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Resource getDefaultInstanceForType() {
        return com.google.rpc.context.AttributeContext.Resource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Resource build() {
        com.google.rpc.context.AttributeContext.Resource result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.rpc.context.AttributeContext.Resource buildPartial() {
        com.google.rpc.context.AttributeContext.Resource result =
            new com.google.rpc.context.AttributeContext.Resource(this);
        int from_bitField0_ = bitField0_;
        result.service_ = service_;
        result.name_ = name_;
        result.type_ = type_;
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
        result.uid_ = uid_;
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
        result.displayName_ = displayName_;
        if (createTimeBuilder_ == null) {
          result.createTime_ = createTime_;
        } else {
          result.createTime_ = createTimeBuilder_.build();
        }
        if (updateTimeBuilder_ == null) {
          result.updateTime_ = updateTime_;
        } else {
          result.updateTime_ = updateTimeBuilder_.build();
        }
        if (deleteTimeBuilder_ == null) {
          result.deleteTime_ = deleteTime_;
        } else {
          result.deleteTime_ = deleteTimeBuilder_.build();
        }
        result.etag_ = etag_;
        result.location_ = location_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.rpc.context.AttributeContext.Resource) {
          return mergeFrom((com.google.rpc.context.AttributeContext.Resource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.rpc.context.AttributeContext.Resource other) {
        if (other == com.google.rpc.context.AttributeContext.Resource.getDefaultInstance())
          return this;
        if (!other.getService().isEmpty()) {
          service_ = other.service_;
          onChanged();
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (!other.getType().isEmpty()) {
          type_ = other.type_;
          onChanged();
        }
        internalGetMutableLabels().mergeFrom(other.internalGetLabels());
        if (!other.getUid().isEmpty()) {
          uid_ = other.uid_;
          onChanged();
        }
        internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          onChanged();
        }
        if (other.hasCreateTime()) {
          mergeCreateTime(other.getCreateTime());
        }
        if (other.hasUpdateTime()) {
          mergeUpdateTime(other.getUpdateTime());
        }
        if (other.hasDeleteTime()) {
          mergeDeleteTime(other.getDeleteTime());
        }
        if (!other.getEtag().isEmpty()) {
          etag_ = other.etag_;
          onChanged();
        }
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.rpc.context.AttributeContext.Resource parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.rpc.context.AttributeContext.Resource) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object service_ = "";
      /**
       *
       *
       * <pre>
       * The name of the service that this resource belongs to, such as
       * `pubsub.googleapis.com`. The service may be different from the DNS
       * hostname that actually serves the request.
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @return The service.
       */
      public java.lang.String getService() {
        java.lang.Object ref = service_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          service_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the service that this resource belongs to, such as
       * `pubsub.googleapis.com`. The service may be different from the DNS
       * hostname that actually serves the request.
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @return The bytes for service.
       */
      public com.google.protobuf.ByteString getServiceBytes() {
        java.lang.Object ref = service_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          service_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the service that this resource belongs to, such as
       * `pubsub.googleapis.com`. The service may be different from the DNS
       * hostname that actually serves the request.
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @param value The service to set.
       * @return This builder for chaining.
       */
      public Builder setService(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        service_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the service that this resource belongs to, such as
       * `pubsub.googleapis.com`. The service may be different from the DNS
       * hostname that actually serves the request.
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearService() {

        service_ = getDefaultInstance().getService();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the service that this resource belongs to, such as
       * `pubsub.googleapis.com`. The service may be different from the DNS
       * hostname that actually serves the request.
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @param value The bytes for service to set.
       * @return This builder for chaining.
       */
      public Builder setServiceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        service_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The stable identifier (name) of a resource on the `service`. A resource
       * can be logically identified as "//{resource.service}/{resource.name}".
       * The differences between a resource name and a URI are:
       * *   Resource name is a logical identifier, independent of network
       *     protocol and API version. For example,
       *     `//pubsub.googleapis.com/projects/123/topics/news-feed`.
       * *   URI often includes protocol and version information, so it can
       *     be used directly by applications. For example,
       *     `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`.
       * See https://cloud.google.com/apis/design/resource_names for details.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The stable identifier (name) of a resource on the `service`. A resource
       * can be logically identified as "//{resource.service}/{resource.name}".
       * The differences between a resource name and a URI are:
       * *   Resource name is a logical identifier, independent of network
       *     protocol and API version. For example,
       *     `//pubsub.googleapis.com/projects/123/topics/news-feed`.
       * *   URI often includes protocol and version information, so it can
       *     be used directly by applications. For example,
       *     `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`.
       * See https://cloud.google.com/apis/design/resource_names for details.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The stable identifier (name) of a resource on the `service`. A resource
       * can be logically identified as "//{resource.service}/{resource.name}".
       * The differences between a resource name and a URI are:
       * *   Resource name is a logical identifier, independent of network
       *     protocol and API version. For example,
       *     `//pubsub.googleapis.com/projects/123/topics/news-feed`.
       * *   URI often includes protocol and version information, so it can
       *     be used directly by applications. For example,
       *     `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`.
       * See https://cloud.google.com/apis/design/resource_names for details.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The stable identifier (name) of a resource on the `service`. A resource
       * can be logically identified as "//{resource.service}/{resource.name}".
       * The differences between a resource name and a URI are:
       * *   Resource name is a logical identifier, independent of network
       *     protocol and API version. For example,
       *     `//pubsub.googleapis.com/projects/123/topics/news-feed`.
       * *   URI often includes protocol and version information, so it can
       *     be used directly by applications. For example,
       *     `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`.
       * See https://cloud.google.com/apis/design/resource_names for details.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The stable identifier (name) of a resource on the `service`. A resource
       * can be logically identified as "//{resource.service}/{resource.name}".
       * The differences between a resource name and a URI are:
       * *   Resource name is a logical identifier, independent of network
       *     protocol and API version. For example,
       *     `//pubsub.googleapis.com/projects/123/topics/news-feed`.
       * *   URI often includes protocol and version information, so it can
       *     be used directly by applications. For example,
       *     `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`.
       * See https://cloud.google.com/apis/design/resource_names for details.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object type_ = "";
      /**
       *
       *
       * <pre>
       * The type of the resource. The syntax is platform-specific because
       * different platforms define their resources differently.
       * For Google APIs, the type format must be "{service}/{kind}".
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @return The type.
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          type_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The type of the resource. The syntax is platform-specific because
       * different platforms define their resources differently.
       * For Google APIs, the type format must be "{service}/{kind}".
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @return The bytes for type.
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The type of the resource. The syntax is platform-specific because
       * different platforms define their resources differently.
       * For Google APIs, the type format must be "{service}/{kind}".
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the resource. The syntax is platform-specific because
       * different platforms define their resources differently.
       * For Google APIs, the type format must be "{service}/{kind}".
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {

        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the resource. The syntax is platform-specific because
       * different platforms define their resources differently.
       * For Google APIs, the type format must be "{service}/{kind}".
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @param value The bytes for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        type_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
        if (labels_ == null) {
          return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return labels_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableLabels() {
        onChanged();
        ;
        if (labels_ == null) {
          labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        if (!labels_.isMutable()) {
          labels_ = labels_.copy();
        }
        return labels_;
      }

      public int getLabelsCount() {
        return internalGetLabels().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * The labels or tags on the resource, such as AWS resource tags and
       * Kubernetes resource labels.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4;</code>
       */
      @java.lang.Override
      public boolean containsLabels(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetLabels().getMap().containsKey(key);
      }
      /** Use {@link #getLabelsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return getLabelsMap();
      }
      /**
       *
       *
       * <pre>
       * The labels or tags on the resource, such as AWS resource tags and
       * Kubernetes resource labels.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
        return internalGetLabels().getMap();
      }
      /**
       *
       *
       * <pre>
       * The labels or tags on the resource, such as AWS resource tags and
       * Kubernetes resource labels.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4;</code>
       */
      @java.lang.Override
      public java.lang.String getLabelsOrDefault(
          java.lang.String key, java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * The labels or tags on the resource, such as AWS resource tags and
       * Kubernetes resource labels.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4;</code>
       */
      @java.lang.Override
      public java.lang.String getLabelsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearLabels() {
        internalGetMutableLabels().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The labels or tags on the resource, such as AWS resource tags and
       * Kubernetes resource labels.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4;</code>
       */
      public Builder removeLabels(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableLabels().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
        return internalGetMutableLabels().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * The labels or tags on the resource, such as AWS resource tags and
       * Kubernetes resource labels.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4;</code>
       */
      public Builder putLabels(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }

        internalGetMutableLabels().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The labels or tags on the resource, such as AWS resource tags and
       * Kubernetes resource labels.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4;</code>
       */
      public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableLabels().getMutableMap().putAll(values);
        return this;
      }

      private java.lang.Object uid_ = "";
      /**
       *
       *
       * <pre>
       * The unique identifier of the resource. UID is unique in the time
       * and space for this resource within the scope of the service. It is
       * typically generated by the server on successful creation of a resource
       * and must not be changed. UID is used to uniquely identify resources
       * with resource name reuses. This should be a UUID4.
       * </pre>
       *
       * <code>string uid = 5;</code>
       *
       * @return The uid.
       */
      public java.lang.String getUid() {
        java.lang.Object ref = uid_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uid_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The unique identifier of the resource. UID is unique in the time
       * and space for this resource within the scope of the service. It is
       * typically generated by the server on successful creation of a resource
       * and must not be changed. UID is used to uniquely identify resources
       * with resource name reuses. This should be a UUID4.
       * </pre>
       *
       * <code>string uid = 5;</code>
       *
       * @return The bytes for uid.
       */
      public com.google.protobuf.ByteString getUidBytes() {
        java.lang.Object ref = uid_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uid_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The unique identifier of the resource. UID is unique in the time
       * and space for this resource within the scope of the service. It is
       * typically generated by the server on successful creation of a resource
       * and must not be changed. UID is used to uniquely identify resources
       * with resource name reuses. This should be a UUID4.
       * </pre>
       *
       * <code>string uid = 5;</code>
       *
       * @param value The uid to set.
       * @return This builder for chaining.
       */
      public Builder setUid(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        uid_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique identifier of the resource. UID is unique in the time
       * and space for this resource within the scope of the service. It is
       * typically generated by the server on successful creation of a resource
       * and must not be changed. UID is used to uniquely identify resources
       * with resource name reuses. This should be a UUID4.
       * </pre>
       *
       * <code>string uid = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUid() {

        uid_ = getDefaultInstance().getUid();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique identifier of the resource. UID is unique in the time
       * and space for this resource within the scope of the service. It is
       * typically generated by the server on successful creation of a resource
       * and must not be changed. UID is used to uniquely identify resources
       * with resource name reuses. This should be a UUID4.
       * </pre>
       *
       * <code>string uid = 5;</code>
       *
       * @param value The bytes for uid to set.
       * @return This builder for chaining.
       */
      public Builder setUidBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        uid_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetAnnotations() {
        if (annotations_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              AnnotationsDefaultEntryHolder.defaultEntry);
        }
        return annotations_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableAnnotations() {
        onChanged();
        ;
        if (annotations_ == null) {
          annotations_ =
              com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
        }
        if (!annotations_.isMutable()) {
          annotations_ = annotations_.copy();
        }
        return annotations_;
      }

      public int getAnnotationsCount() {
        return internalGetAnnotations().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Annotations is an unstructured key-value map stored with a resource that
       * may be set by external tools to store and retrieve arbitrary metadata.
       * They are not queryable and should be preserved when modifying objects.
       * More info: https://kubernetes.io/docs/user-guide/annotations
       * </pre>
       *
       * <code>map&lt;string, string&gt; annotations = 6;</code>
       */
      @java.lang.Override
      public boolean containsAnnotations(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetAnnotations().getMap().containsKey(key);
      }
      /** Use {@link #getAnnotationsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
        return getAnnotationsMap();
      }
      /**
       *
       *
       * <pre>
       * Annotations is an unstructured key-value map stored with a resource that
       * may be set by external tools to store and retrieve arbitrary metadata.
       * They are not queryable and should be preserved when modifying objects.
       * More info: https://kubernetes.io/docs/user-guide/annotations
       * </pre>
       *
       * <code>map&lt;string, string&gt; annotations = 6;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
        return internalGetAnnotations().getMap();
      }
      /**
       *
       *
       * <pre>
       * Annotations is an unstructured key-value map stored with a resource that
       * may be set by external tools to store and retrieve arbitrary metadata.
       * They are not queryable and should be preserved when modifying objects.
       * More info: https://kubernetes.io/docs/user-guide/annotations
       * </pre>
       *
       * <code>map&lt;string, string&gt; annotations = 6;</code>
       */
      @java.lang.Override
      public java.lang.String getAnnotationsOrDefault(
          java.lang.String key, java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Annotations is an unstructured key-value map stored with a resource that
       * may be set by external tools to store and retrieve arbitrary metadata.
       * They are not queryable and should be preserved when modifying objects.
       * More info: https://kubernetes.io/docs/user-guide/annotations
       * </pre>
       *
       * <code>map&lt;string, string&gt; annotations = 6;</code>
       */
      @java.lang.Override
      public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearAnnotations() {
        internalGetMutableAnnotations().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Annotations is an unstructured key-value map stored with a resource that
       * may be set by external tools to store and retrieve arbitrary metadata.
       * They are not queryable and should be preserved when modifying objects.
       * More info: https://kubernetes.io/docs/user-guide/annotations
       * </pre>
       *
       * <code>map&lt;string, string&gt; annotations = 6;</code>
       */
      public Builder removeAnnotations(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableAnnotations().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
        return internalGetMutableAnnotations().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Annotations is an unstructured key-value map stored with a resource that
       * may be set by external tools to store and retrieve arbitrary metadata.
       * They are not queryable and should be preserved when modifying objects.
       * More info: https://kubernetes.io/docs/user-guide/annotations
       * </pre>
       *
       * <code>map&lt;string, string&gt; annotations = 6;</code>
       */
      public Builder putAnnotations(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }

        internalGetMutableAnnotations().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Annotations is an unstructured key-value map stored with a resource that
       * may be set by external tools to store and retrieve arbitrary metadata.
       * They are not queryable and should be preserved when modifying objects.
       * More info: https://kubernetes.io/docs/user-guide/annotations
       * </pre>
       *
       * <code>map&lt;string, string&gt; annotations = 6;</code>
       */
      public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableAnnotations().getMutableMap().putAll(values);
        return this;
      }

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * Mutable. The display name set by clients. Must be &lt;= 63 characters.
       * </pre>
       *
       * <code>string display_name = 7;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Mutable. The display name set by clients. Must be &lt;= 63 characters.
       * </pre>
       *
       * <code>string display_name = 7;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Mutable. The display name set by clients. Must be &lt;= 63 characters.
       * </pre>
       *
       * <code>string display_name = 7;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        displayName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Mutable. The display name set by clients. Must be &lt;= 63 characters.
       * </pre>
       *
       * <code>string display_name = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {

        displayName_ = getDefaultInstance().getDisplayName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Mutable. The display name set by clients. Must be &lt;= 63 characters.
       * </pre>
       *
       * <code>string display_name = 7;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        displayName_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp createTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          createTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was created. This may
       * be either the time creation was initiated or when it was completed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       *
       * @return Whether the createTime field is set.
       */
      public boolean hasCreateTime() {
        return createTimeBuilder_ != null || createTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was created. This may
       * be either the time creation was initiated or when it was completed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       *
       * @return The createTime.
       */
      public com.google.protobuf.Timestamp getCreateTime() {
        if (createTimeBuilder_ == null) {
          return createTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : createTime_;
        } else {
          return createTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was created. This may
       * be either the time creation was initiated or when it was completed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       */
      public Builder setCreateTime(com.google.protobuf.Timestamp value) {
        if (createTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          createTime_ = value;
          onChanged();
        } else {
          createTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was created. This may
       * be either the time creation was initiated or when it was completed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       */
      public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (createTimeBuilder_ == null) {
          createTime_ = builderForValue.build();
          onChanged();
        } else {
          createTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was created. This may
       * be either the time creation was initiated or when it was completed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       */
      public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
        if (createTimeBuilder_ == null) {
          if (createTime_ != null) {
            createTime_ =
                com.google.protobuf.Timestamp.newBuilder(createTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            createTime_ = value;
          }
          onChanged();
        } else {
          createTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was created. This may
       * be either the time creation was initiated or when it was completed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       */
      public Builder clearCreateTime() {
        if (createTimeBuilder_ == null) {
          createTime_ = null;
          onChanged();
        } else {
          createTime_ = null;
          createTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was created. This may
       * be either the time creation was initiated or when it was completed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       */
      public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

        onChanged();
        return getCreateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was created. This may
       * be either the time creation was initiated or when it was completed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
        if (createTimeBuilder_ != null) {
          return createTimeBuilder_.getMessageOrBuilder();
        } else {
          return createTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : createTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was created. This may
       * be either the time creation was initiated or when it was completed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getCreateTimeFieldBuilder() {
        if (createTimeBuilder_ == null) {
          createTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getCreateTime(), getParentForChildren(), isClean());
          createTime_ = null;
        }
        return createTimeBuilder_;
      }

      private com.google.protobuf.Timestamp updateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          updateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was last updated. Any
       * change to the resource made by users must refresh this value.
       * Changes to a resource made by the service should refresh this value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       *
       * @return Whether the updateTime field is set.
       */
      public boolean hasUpdateTime() {
        return updateTimeBuilder_ != null || updateTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was last updated. Any
       * change to the resource made by users must refresh this value.
       * Changes to a resource made by the service should refresh this value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       *
       * @return The updateTime.
       */
      public com.google.protobuf.Timestamp getUpdateTime() {
        if (updateTimeBuilder_ == null) {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        } else {
          return updateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was last updated. Any
       * change to the resource made by users must refresh this value.
       * Changes to a resource made by the service should refresh this value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateTime_ = value;
          onChanged();
        } else {
          updateTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was last updated. Any
       * change to the resource made by users must refresh this value.
       * Changes to a resource made by the service should refresh this value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (updateTimeBuilder_ == null) {
          updateTime_ = builderForValue.build();
          onChanged();
        } else {
          updateTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was last updated. Any
       * change to the resource made by users must refresh this value.
       * Changes to a resource made by the service should refresh this value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       */
      public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (updateTime_ != null) {
            updateTime_ =
                com.google.protobuf.Timestamp.newBuilder(updateTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            updateTime_ = value;
          }
          onChanged();
        } else {
          updateTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was last updated. Any
       * change to the resource made by users must refresh this value.
       * Changes to a resource made by the service should refresh this value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       */
      public Builder clearUpdateTime() {
        if (updateTimeBuilder_ == null) {
          updateTime_ = null;
          onChanged();
        } else {
          updateTime_ = null;
          updateTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was last updated. Any
       * change to the resource made by users must refresh this value.
       * Changes to a resource made by the service should refresh this value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       */
      public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

        onChanged();
        return getUpdateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was last updated. Any
       * change to the resource made by users must refresh this value.
       * Changes to a resource made by the service should refresh this value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
        if (updateTimeBuilder_ != null) {
          return updateTimeBuilder_.getMessageOrBuilder();
        } else {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was last updated. Any
       * change to the resource made by users must refresh this value.
       * Changes to a resource made by the service should refresh this value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getUpdateTimeFieldBuilder() {
        if (updateTimeBuilder_ == null) {
          updateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getUpdateTime(), getParentForChildren(), isClean());
          updateTime_ = null;
        }
        return updateTimeBuilder_;
      }

      private com.google.protobuf.Timestamp deleteTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          deleteTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was deleted.
       * If the resource is not deleted, this must be empty.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp delete_time = 10;</code>
       *
       * @return Whether the deleteTime field is set.
       */
      public boolean hasDeleteTime() {
        return deleteTimeBuilder_ != null || deleteTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was deleted.
       * If the resource is not deleted, this must be empty.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp delete_time = 10;</code>
       *
       * @return The deleteTime.
       */
      public com.google.protobuf.Timestamp getDeleteTime() {
        if (deleteTimeBuilder_ == null) {
          return deleteTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : deleteTime_;
        } else {
          return deleteTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was deleted.
       * If the resource is not deleted, this must be empty.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp delete_time = 10;</code>
       */
      public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
        if (deleteTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          deleteTime_ = value;
          onChanged();
        } else {
          deleteTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was deleted.
       * If the resource is not deleted, this must be empty.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp delete_time = 10;</code>
       */
      public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (deleteTimeBuilder_ == null) {
          deleteTime_ = builderForValue.build();
          onChanged();
        } else {
          deleteTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was deleted.
       * If the resource is not deleted, this must be empty.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp delete_time = 10;</code>
       */
      public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
        if (deleteTimeBuilder_ == null) {
          if (deleteTime_ != null) {
            deleteTime_ =
                com.google.protobuf.Timestamp.newBuilder(deleteTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            deleteTime_ = value;
          }
          onChanged();
        } else {
          deleteTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was deleted.
       * If the resource is not deleted, this must be empty.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp delete_time = 10;</code>
       */
      public Builder clearDeleteTime() {
        if (deleteTimeBuilder_ == null) {
          deleteTime_ = null;
          onChanged();
        } else {
          deleteTime_ = null;
          deleteTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was deleted.
       * If the resource is not deleted, this must be empty.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp delete_time = 10;</code>
       */
      public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {

        onChanged();
        return getDeleteTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was deleted.
       * If the resource is not deleted, this must be empty.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp delete_time = 10;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
        if (deleteTimeBuilder_ != null) {
          return deleteTimeBuilder_.getMessageOrBuilder();
        } else {
          return deleteTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : deleteTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The timestamp when the resource was deleted.
       * If the resource is not deleted, this must be empty.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp delete_time = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getDeleteTimeFieldBuilder() {
        if (deleteTimeBuilder_ == null) {
          deleteTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getDeleteTime(), getParentForChildren(), isClean());
          deleteTime_ = null;
        }
        return deleteTimeBuilder_;
      }

      private java.lang.Object etag_ = "";
      /**
       *
       *
       * <pre>
       * Output only. An opaque value that uniquely identifies a version or
       * generation of a resource. It can be used to confirm that the client
       * and server agree on the ordering of a resource being written.
       * </pre>
       *
       * <code>string etag = 11;</code>
       *
       * @return The etag.
       */
      public java.lang.String getEtag() {
        java.lang.Object ref = etag_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          etag_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. An opaque value that uniquely identifies a version or
       * generation of a resource. It can be used to confirm that the client
       * and server agree on the ordering of a resource being written.
       * </pre>
       *
       * <code>string etag = 11;</code>
       *
       * @return The bytes for etag.
       */
      public com.google.protobuf.ByteString getEtagBytes() {
        java.lang.Object ref = etag_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          etag_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. An opaque value that uniquely identifies a version or
       * generation of a resource. It can be used to confirm that the client
       * and server agree on the ordering of a resource being written.
       * </pre>
       *
       * <code>string etag = 11;</code>
       *
       * @param value The etag to set.
       * @return This builder for chaining.
       */
      public Builder setEtag(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        etag_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. An opaque value that uniquely identifies a version or
       * generation of a resource. It can be used to confirm that the client
       * and server agree on the ordering of a resource being written.
       * </pre>
       *
       * <code>string etag = 11;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEtag() {

        etag_ = getDefaultInstance().getEtag();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. An opaque value that uniquely identifies a version or
       * generation of a resource. It can be used to confirm that the client
       * and server agree on the ordering of a resource being written.
       * </pre>
       *
       * <code>string etag = 11;</code>
       *
       * @param value The bytes for etag to set.
       * @return This builder for chaining.
       */
      public Builder setEtagBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        etag_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object location_ = "";
      /**
       *
       *
       * <pre>
       * Immutable. The location of the resource. The location encoding is
       * specific to the service provider, and new encoding may be introduced
       * as the service evolves.
       * For Google Cloud products, the encoding is what is used by Google Cloud
       * APIs, such as `us-east1`, `aws-us-east-1`, and `azure-eastus2`. The
       * semantics of `location` is identical to the
       * `cloud.googleapis.com/location` label used by some Google Cloud APIs.
       * </pre>
       *
       * <code>string location = 12;</code>
       *
       * @return The location.
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Immutable. The location of the resource. The location encoding is
       * specific to the service provider, and new encoding may be introduced
       * as the service evolves.
       * For Google Cloud products, the encoding is what is used by Google Cloud
       * APIs, such as `us-east1`, `aws-us-east-1`, and `azure-eastus2`. The
       * semantics of `location` is identical to the
       * `cloud.googleapis.com/location` label used by some Google Cloud APIs.
       * </pre>
       *
       * <code>string location = 12;</code>
       *
       * @return The bytes for location.
       */
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Immutable. The location of the resource. The location encoding is
       * specific to the service provider, and new encoding may be introduced
       * as the service evolves.
       * For Google Cloud products, the encoding is what is used by Google Cloud
       * APIs, such as `us-east1`, `aws-us-east-1`, and `azure-eastus2`. The
       * semantics of `location` is identical to the
       * `cloud.googleapis.com/location` label used by some Google Cloud APIs.
       * </pre>
       *
       * <code>string location = 12;</code>
       *
       * @param value The location to set.
       * @return This builder for chaining.
       */
      public Builder setLocation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        location_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The location of the resource. The location encoding is
       * specific to the service provider, and new encoding may be introduced
       * as the service evolves.
       * For Google Cloud products, the encoding is what is used by Google Cloud
       * APIs, such as `us-east1`, `aws-us-east-1`, and `azure-eastus2`. The
       * semantics of `location` is identical to the
       * `cloud.googleapis.com/location` label used by some Google Cloud APIs.
       * </pre>
       *
       * <code>string location = 12;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocation() {

        location_ = getDefaultInstance().getLocation();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The location of the resource. The location encoding is
       * specific to the service provider, and new encoding may be introduced
       * as the service evolves.
       * For Google Cloud products, the encoding is what is used by Google Cloud
       * APIs, such as `us-east1`, `aws-us-east-1`, and `azure-eastus2`. The
       * semantics of `location` is identical to the
       * `cloud.googleapis.com/location` label used by some Google Cloud APIs.
       * </pre>
       *
       * <code>string location = 12;</code>
       *
       * @param value The bytes for location to set.
       * @return This builder for chaining.
       */
      public Builder setLocationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        location_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.rpc.context.AttributeContext.Resource)
    }

    // @@protoc_insertion_point(class_scope:google.rpc.context.AttributeContext.Resource)
    private static final com.google.rpc.context.AttributeContext.Resource DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.rpc.context.AttributeContext.Resource();
    }

    public static com.google.rpc.context.AttributeContext.Resource getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Resource> PARSER =
        new com.google.protobuf.AbstractParser<Resource>() {
          @java.lang.Override
          public Resource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Resource(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Resource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Resource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.rpc.context.AttributeContext.Resource getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ORIGIN_FIELD_NUMBER = 7;
  private com.google.rpc.context.AttributeContext.Peer origin_;
  /**
   *
   *
   * <pre>
   * The origin of a network activity. In a multi hop network activity,
   * the origin represents the sender of the first hop. For the first hop,
   * the `source` and the `origin` must have the same content.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Peer origin = 7;</code>
   *
   * @return Whether the origin field is set.
   */
  @java.lang.Override
  public boolean hasOrigin() {
    return origin_ != null;
  }
  /**
   *
   *
   * <pre>
   * The origin of a network activity. In a multi hop network activity,
   * the origin represents the sender of the first hop. For the first hop,
   * the `source` and the `origin` must have the same content.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Peer origin = 7;</code>
   *
   * @return The origin.
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.Peer getOrigin() {
    return origin_ == null
        ? com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()
        : origin_;
  }
  /**
   *
   *
   * <pre>
   * The origin of a network activity. In a multi hop network activity,
   * the origin represents the sender of the first hop. For the first hop,
   * the `source` and the `origin` must have the same content.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Peer origin = 7;</code>
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.PeerOrBuilder getOriginOrBuilder() {
    return getOrigin();
  }

  public static final int SOURCE_FIELD_NUMBER = 1;
  private com.google.rpc.context.AttributeContext.Peer source_;
  /**
   *
   *
   * <pre>
   * The source of a network activity, such as starting a TCP connection.
   * In a multi hop network activity, the source represents the sender of the
   * last hop.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Peer source = 1;</code>
   *
   * @return Whether the source field is set.
   */
  @java.lang.Override
  public boolean hasSource() {
    return source_ != null;
  }
  /**
   *
   *
   * <pre>
   * The source of a network activity, such as starting a TCP connection.
   * In a multi hop network activity, the source represents the sender of the
   * last hop.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Peer source = 1;</code>
   *
   * @return The source.
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.Peer getSource() {
    return source_ == null
        ? com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()
        : source_;
  }
  /**
   *
   *
   * <pre>
   * The source of a network activity, such as starting a TCP connection.
   * In a multi hop network activity, the source represents the sender of the
   * last hop.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Peer source = 1;</code>
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.PeerOrBuilder getSourceOrBuilder() {
    return getSource();
  }

  public static final int DESTINATION_FIELD_NUMBER = 2;
  private com.google.rpc.context.AttributeContext.Peer destination_;
  /**
   *
   *
   * <pre>
   * The destination of a network activity, such as accepting a TCP connection.
   * In a multi hop network activity, the destination represents the receiver of
   * the last hop.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Peer destination = 2;</code>
   *
   * @return Whether the destination field is set.
   */
  @java.lang.Override
  public boolean hasDestination() {
    return destination_ != null;
  }
  /**
   *
   *
   * <pre>
   * The destination of a network activity, such as accepting a TCP connection.
   * In a multi hop network activity, the destination represents the receiver of
   * the last hop.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Peer destination = 2;</code>
   *
   * @return The destination.
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.Peer getDestination() {
    return destination_ == null
        ? com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()
        : destination_;
  }
  /**
   *
   *
   * <pre>
   * The destination of a network activity, such as accepting a TCP connection.
   * In a multi hop network activity, the destination represents the receiver of
   * the last hop.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Peer destination = 2;</code>
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.PeerOrBuilder getDestinationOrBuilder() {
    return getDestination();
  }

  public static final int REQUEST_FIELD_NUMBER = 3;
  private com.google.rpc.context.AttributeContext.Request request_;
  /**
   *
   *
   * <pre>
   * Represents a network request, such as an HTTP request.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Request request = 3;</code>
   *
   * @return Whether the request field is set.
   */
  @java.lang.Override
  public boolean hasRequest() {
    return request_ != null;
  }
  /**
   *
   *
   * <pre>
   * Represents a network request, such as an HTTP request.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Request request = 3;</code>
   *
   * @return The request.
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.Request getRequest() {
    return request_ == null
        ? com.google.rpc.context.AttributeContext.Request.getDefaultInstance()
        : request_;
  }
  /**
   *
   *
   * <pre>
   * Represents a network request, such as an HTTP request.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Request request = 3;</code>
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.RequestOrBuilder getRequestOrBuilder() {
    return getRequest();
  }

  public static final int RESPONSE_FIELD_NUMBER = 4;
  private com.google.rpc.context.AttributeContext.Response response_;
  /**
   *
   *
   * <pre>
   * Represents a network response, such as an HTTP response.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Response response = 4;</code>
   *
   * @return Whether the response field is set.
   */
  @java.lang.Override
  public boolean hasResponse() {
    return response_ != null;
  }
  /**
   *
   *
   * <pre>
   * Represents a network response, such as an HTTP response.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Response response = 4;</code>
   *
   * @return The response.
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.Response getResponse() {
    return response_ == null
        ? com.google.rpc.context.AttributeContext.Response.getDefaultInstance()
        : response_;
  }
  /**
   *
   *
   * <pre>
   * Represents a network response, such as an HTTP response.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Response response = 4;</code>
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.ResponseOrBuilder getResponseOrBuilder() {
    return getResponse();
  }

  public static final int RESOURCE_FIELD_NUMBER = 5;
  private com.google.rpc.context.AttributeContext.Resource resource_;
  /**
   *
   *
   * <pre>
   * Represents a target resource that is involved with a network activity.
   * If multiple resources are involved with an activity, this must be the
   * primary one.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Resource resource = 5;</code>
   *
   * @return Whether the resource field is set.
   */
  @java.lang.Override
  public boolean hasResource() {
    return resource_ != null;
  }
  /**
   *
   *
   * <pre>
   * Represents a target resource that is involved with a network activity.
   * If multiple resources are involved with an activity, this must be the
   * primary one.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Resource resource = 5;</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.Resource getResource() {
    return resource_ == null
        ? com.google.rpc.context.AttributeContext.Resource.getDefaultInstance()
        : resource_;
  }
  /**
   *
   *
   * <pre>
   * Represents a target resource that is involved with a network activity.
   * If multiple resources are involved with an activity, this must be the
   * primary one.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Resource resource = 5;</code>
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.ResourceOrBuilder getResourceOrBuilder() {
    return getResource();
  }

  public static final int API_FIELD_NUMBER = 6;
  private com.google.rpc.context.AttributeContext.Api api_;
  /**
   *
   *
   * <pre>
   * Represents an API operation that is involved to a network activity.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Api api = 6;</code>
   *
   * @return Whether the api field is set.
   */
  @java.lang.Override
  public boolean hasApi() {
    return api_ != null;
  }
  /**
   *
   *
   * <pre>
   * Represents an API operation that is involved to a network activity.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Api api = 6;</code>
   *
   * @return The api.
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.Api getApi() {
    return api_ == null ? com.google.rpc.context.AttributeContext.Api.getDefaultInstance() : api_;
  }
  /**
   *
   *
   * <pre>
   * Represents an API operation that is involved to a network activity.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Api api = 6;</code>
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.ApiOrBuilder getApiOrBuilder() {
    return getApi();
  }

  public static final int EXTENSIONS_FIELD_NUMBER = 8;
  private java.util.List<com.google.protobuf.Any> extensions_;
  /**
   *
   *
   * <pre>
   * Supports extensions for advanced use cases, such as logs and metrics.
   * </pre>
   *
   * <code>repeated .google.protobuf.Any extensions = 8;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Any> getExtensionsList() {
    return extensions_;
  }
  /**
   *
   *
   * <pre>
   * Supports extensions for advanced use cases, such as logs and metrics.
   * </pre>
   *
   * <code>repeated .google.protobuf.Any extensions = 8;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.AnyOrBuilder> getExtensionsOrBuilderList() {
    return extensions_;
  }
  /**
   *
   *
   * <pre>
   * Supports extensions for advanced use cases, such as logs and metrics.
   * </pre>
   *
   * <code>repeated .google.protobuf.Any extensions = 8;</code>
   */
  @java.lang.Override
  public int getExtensionsCount() {
    return extensions_.size();
  }
  /**
   *
   *
   * <pre>
   * Supports extensions for advanced use cases, such as logs and metrics.
   * </pre>
   *
   * <code>repeated .google.protobuf.Any extensions = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Any getExtensions(int index) {
    return extensions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Supports extensions for advanced use cases, such as logs and metrics.
   * </pre>
   *
   * <code>repeated .google.protobuf.Any extensions = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.AnyOrBuilder getExtensionsOrBuilder(int index) {
    return extensions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (source_ != null) {
      output.writeMessage(1, getSource());
    }
    if (destination_ != null) {
      output.writeMessage(2, getDestination());
    }
    if (request_ != null) {
      output.writeMessage(3, getRequest());
    }
    if (response_ != null) {
      output.writeMessage(4, getResponse());
    }
    if (resource_ != null) {
      output.writeMessage(5, getResource());
    }
    if (api_ != null) {
      output.writeMessage(6, getApi());
    }
    if (origin_ != null) {
      output.writeMessage(7, getOrigin());
    }
    for (int i = 0; i < extensions_.size(); i++) {
      output.writeMessage(8, extensions_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (source_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSource());
    }
    if (destination_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDestination());
    }
    if (request_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRequest());
    }
    if (response_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getResponse());
    }
    if (resource_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getResource());
    }
    if (api_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getApi());
    }
    if (origin_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getOrigin());
    }
    for (int i = 0; i < extensions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, extensions_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.rpc.context.AttributeContext)) {
      return super.equals(obj);
    }
    com.google.rpc.context.AttributeContext other = (com.google.rpc.context.AttributeContext) obj;

    if (hasOrigin() != other.hasOrigin()) return false;
    if (hasOrigin()) {
      if (!getOrigin().equals(other.getOrigin())) return false;
    }
    if (hasSource() != other.hasSource()) return false;
    if (hasSource()) {
      if (!getSource().equals(other.getSource())) return false;
    }
    if (hasDestination() != other.hasDestination()) return false;
    if (hasDestination()) {
      if (!getDestination().equals(other.getDestination())) return false;
    }
    if (hasRequest() != other.hasRequest()) return false;
    if (hasRequest()) {
      if (!getRequest().equals(other.getRequest())) return false;
    }
    if (hasResponse() != other.hasResponse()) return false;
    if (hasResponse()) {
      if (!getResponse().equals(other.getResponse())) return false;
    }
    if (hasResource() != other.hasResource()) return false;
    if (hasResource()) {
      if (!getResource().equals(other.getResource())) return false;
    }
    if (hasApi() != other.hasApi()) return false;
    if (hasApi()) {
      if (!getApi().equals(other.getApi())) return false;
    }
    if (!getExtensionsList().equals(other.getExtensionsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasOrigin()) {
      hash = (37 * hash) + ORIGIN_FIELD_NUMBER;
      hash = (53 * hash) + getOrigin().hashCode();
    }
    if (hasSource()) {
      hash = (37 * hash) + SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getSource().hashCode();
    }
    if (hasDestination()) {
      hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getDestination().hashCode();
    }
    if (hasRequest()) {
      hash = (37 * hash) + REQUEST_FIELD_NUMBER;
      hash = (53 * hash) + getRequest().hashCode();
    }
    if (hasResponse()) {
      hash = (37 * hash) + RESPONSE_FIELD_NUMBER;
      hash = (53 * hash) + getResponse().hashCode();
    }
    if (hasResource()) {
      hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getResource().hashCode();
    }
    if (hasApi()) {
      hash = (37 * hash) + API_FIELD_NUMBER;
      hash = (53 * hash) + getApi().hashCode();
    }
    if (getExtensionsCount() > 0) {
      hash = (37 * hash) + EXTENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExtensionsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.rpc.context.AttributeContext parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.rpc.context.AttributeContext parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.rpc.context.AttributeContext parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.rpc.context.AttributeContext parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.rpc.context.AttributeContext parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.rpc.context.AttributeContext parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.rpc.context.AttributeContext parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.rpc.context.AttributeContext parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.rpc.context.AttributeContext parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.rpc.context.AttributeContext parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.rpc.context.AttributeContext parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.rpc.context.AttributeContext parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.rpc.context.AttributeContext prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * This message defines the standard attribute vocabulary for Google APIs.
   * An attribute is a piece of metadata that describes an activity on a network
   * service. For example, the size of an HTTP request, or the status code of
   * an HTTP response.
   * Each attribute has a type and a name, which is logically defined as
   * a proto message field in `AttributeContext`. The field type becomes the
   * attribute type, and the field path becomes the attribute name. For example,
   * the attribute `source.ip` maps to field `AttributeContext.source.ip`.
   * This message definition is guaranteed not to have any wire breaking change.
   * So you can use it directly for passing attributes across different systems.
   * NOTE: Different system may generate different subset of attributes. Please
   * verify the system specification before relying on an attribute generated
   * a system.
   * </pre>
   *
   * Protobuf type {@code google.rpc.context.AttributeContext}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.rpc.context.AttributeContext)
      com.google.rpc.context.AttributeContextOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.rpc.context.AttributeContext.class,
              com.google.rpc.context.AttributeContext.Builder.class);
    }

    // Construct using com.google.rpc.context.AttributeContext.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getExtensionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (originBuilder_ == null) {
        origin_ = null;
      } else {
        origin_ = null;
        originBuilder_ = null;
      }
      if (sourceBuilder_ == null) {
        source_ = null;
      } else {
        source_ = null;
        sourceBuilder_ = null;
      }
      if (destinationBuilder_ == null) {
        destination_ = null;
      } else {
        destination_ = null;
        destinationBuilder_ = null;
      }
      if (requestBuilder_ == null) {
        request_ = null;
      } else {
        request_ = null;
        requestBuilder_ = null;
      }
      if (responseBuilder_ == null) {
        response_ = null;
      } else {
        response_ = null;
        responseBuilder_ = null;
      }
      if (resourceBuilder_ == null) {
        resource_ = null;
      } else {
        resource_ = null;
        resourceBuilder_ = null;
      }
      if (apiBuilder_ == null) {
        api_ = null;
      } else {
        api_ = null;
        apiBuilder_ = null;
      }
      if (extensionsBuilder_ == null) {
        extensions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        extensionsBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.rpc.context.AttributeContextProto
          .internal_static_google_rpc_context_AttributeContext_descriptor;
    }

    @java.lang.Override
    public com.google.rpc.context.AttributeContext getDefaultInstanceForType() {
      return com.google.rpc.context.AttributeContext.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.rpc.context.AttributeContext build() {
      com.google.rpc.context.AttributeContext result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.rpc.context.AttributeContext buildPartial() {
      com.google.rpc.context.AttributeContext result =
          new com.google.rpc.context.AttributeContext(this);
      int from_bitField0_ = bitField0_;
      if (originBuilder_ == null) {
        result.origin_ = origin_;
      } else {
        result.origin_ = originBuilder_.build();
      }
      if (sourceBuilder_ == null) {
        result.source_ = source_;
      } else {
        result.source_ = sourceBuilder_.build();
      }
      if (destinationBuilder_ == null) {
        result.destination_ = destination_;
      } else {
        result.destination_ = destinationBuilder_.build();
      }
      if (requestBuilder_ == null) {
        result.request_ = request_;
      } else {
        result.request_ = requestBuilder_.build();
      }
      if (responseBuilder_ == null) {
        result.response_ = response_;
      } else {
        result.response_ = responseBuilder_.build();
      }
      if (resourceBuilder_ == null) {
        result.resource_ = resource_;
      } else {
        result.resource_ = resourceBuilder_.build();
      }
      if (apiBuilder_ == null) {
        result.api_ = api_;
      } else {
        result.api_ = apiBuilder_.build();
      }
      if (extensionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          extensions_ = java.util.Collections.unmodifiableList(extensions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.extensions_ = extensions_;
      } else {
        result.extensions_ = extensionsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.rpc.context.AttributeContext) {
        return mergeFrom((com.google.rpc.context.AttributeContext) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.rpc.context.AttributeContext other) {
      if (other == com.google.rpc.context.AttributeContext.getDefaultInstance()) return this;
      if (other.hasOrigin()) {
        mergeOrigin(other.getOrigin());
      }
      if (other.hasSource()) {
        mergeSource(other.getSource());
      }
      if (other.hasDestination()) {
        mergeDestination(other.getDestination());
      }
      if (other.hasRequest()) {
        mergeRequest(other.getRequest());
      }
      if (other.hasResponse()) {
        mergeResponse(other.getResponse());
      }
      if (other.hasResource()) {
        mergeResource(other.getResource());
      }
      if (other.hasApi()) {
        mergeApi(other.getApi());
      }
      if (extensionsBuilder_ == null) {
        if (!other.extensions_.isEmpty()) {
          if (extensions_.isEmpty()) {
            extensions_ = other.extensions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureExtensionsIsMutable();
            extensions_.addAll(other.extensions_);
          }
          onChanged();
        }
      } else {
        if (!other.extensions_.isEmpty()) {
          if (extensionsBuilder_.isEmpty()) {
            extensionsBuilder_.dispose();
            extensionsBuilder_ = null;
            extensions_ = other.extensions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            extensionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExtensionsFieldBuilder()
                    : null;
          } else {
            extensionsBuilder_.addAllMessages(other.extensions_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.rpc.context.AttributeContext parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.rpc.context.AttributeContext) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.rpc.context.AttributeContext.Peer origin_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Peer,
            com.google.rpc.context.AttributeContext.Peer.Builder,
            com.google.rpc.context.AttributeContext.PeerOrBuilder>
        originBuilder_;
    /**
     *
     *
     * <pre>
     * The origin of a network activity. In a multi hop network activity,
     * the origin represents the sender of the first hop. For the first hop,
     * the `source` and the `origin` must have the same content.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer origin = 7;</code>
     *
     * @return Whether the origin field is set.
     */
    public boolean hasOrigin() {
      return originBuilder_ != null || origin_ != null;
    }
    /**
     *
     *
     * <pre>
     * The origin of a network activity. In a multi hop network activity,
     * the origin represents the sender of the first hop. For the first hop,
     * the `source` and the `origin` must have the same content.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer origin = 7;</code>
     *
     * @return The origin.
     */
    public com.google.rpc.context.AttributeContext.Peer getOrigin() {
      if (originBuilder_ == null) {
        return origin_ == null
            ? com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()
            : origin_;
      } else {
        return originBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The origin of a network activity. In a multi hop network activity,
     * the origin represents the sender of the first hop. For the first hop,
     * the `source` and the `origin` must have the same content.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer origin = 7;</code>
     */
    public Builder setOrigin(com.google.rpc.context.AttributeContext.Peer value) {
      if (originBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        origin_ = value;
        onChanged();
      } else {
        originBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The origin of a network activity. In a multi hop network activity,
     * the origin represents the sender of the first hop. For the first hop,
     * the `source` and the `origin` must have the same content.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer origin = 7;</code>
     */
    public Builder setOrigin(com.google.rpc.context.AttributeContext.Peer.Builder builderForValue) {
      if (originBuilder_ == null) {
        origin_ = builderForValue.build();
        onChanged();
      } else {
        originBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The origin of a network activity. In a multi hop network activity,
     * the origin represents the sender of the first hop. For the first hop,
     * the `source` and the `origin` must have the same content.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer origin = 7;</code>
     */
    public Builder mergeOrigin(com.google.rpc.context.AttributeContext.Peer value) {
      if (originBuilder_ == null) {
        if (origin_ != null) {
          origin_ =
              com.google.rpc.context.AttributeContext.Peer.newBuilder(origin_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          origin_ = value;
        }
        onChanged();
      } else {
        originBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The origin of a network activity. In a multi hop network activity,
     * the origin represents the sender of the first hop. For the first hop,
     * the `source` and the `origin` must have the same content.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer origin = 7;</code>
     */
    public Builder clearOrigin() {
      if (originBuilder_ == null) {
        origin_ = null;
        onChanged();
      } else {
        origin_ = null;
        originBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The origin of a network activity. In a multi hop network activity,
     * the origin represents the sender of the first hop. For the first hop,
     * the `source` and the `origin` must have the same content.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer origin = 7;</code>
     */
    public com.google.rpc.context.AttributeContext.Peer.Builder getOriginBuilder() {

      onChanged();
      return getOriginFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The origin of a network activity. In a multi hop network activity,
     * the origin represents the sender of the first hop. For the first hop,
     * the `source` and the `origin` must have the same content.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer origin = 7;</code>
     */
    public com.google.rpc.context.AttributeContext.PeerOrBuilder getOriginOrBuilder() {
      if (originBuilder_ != null) {
        return originBuilder_.getMessageOrBuilder();
      } else {
        return origin_ == null
            ? com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()
            : origin_;
      }
    }
    /**
     *
     *
     * <pre>
     * The origin of a network activity. In a multi hop network activity,
     * the origin represents the sender of the first hop. For the first hop,
     * the `source` and the `origin` must have the same content.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer origin = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Peer,
            com.google.rpc.context.AttributeContext.Peer.Builder,
            com.google.rpc.context.AttributeContext.PeerOrBuilder>
        getOriginFieldBuilder() {
      if (originBuilder_ == null) {
        originBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.context.AttributeContext.Peer,
                com.google.rpc.context.AttributeContext.Peer.Builder,
                com.google.rpc.context.AttributeContext.PeerOrBuilder>(
                getOrigin(), getParentForChildren(), isClean());
        origin_ = null;
      }
      return originBuilder_;
    }

    private com.google.rpc.context.AttributeContext.Peer source_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Peer,
            com.google.rpc.context.AttributeContext.Peer.Builder,
            com.google.rpc.context.AttributeContext.PeerOrBuilder>
        sourceBuilder_;
    /**
     *
     *
     * <pre>
     * The source of a network activity, such as starting a TCP connection.
     * In a multi hop network activity, the source represents the sender of the
     * last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer source = 1;</code>
     *
     * @return Whether the source field is set.
     */
    public boolean hasSource() {
      return sourceBuilder_ != null || source_ != null;
    }
    /**
     *
     *
     * <pre>
     * The source of a network activity, such as starting a TCP connection.
     * In a multi hop network activity, the source represents the sender of the
     * last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer source = 1;</code>
     *
     * @return The source.
     */
    public com.google.rpc.context.AttributeContext.Peer getSource() {
      if (sourceBuilder_ == null) {
        return source_ == null
            ? com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()
            : source_;
      } else {
        return sourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The source of a network activity, such as starting a TCP connection.
     * In a multi hop network activity, the source represents the sender of the
     * last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer source = 1;</code>
     */
    public Builder setSource(com.google.rpc.context.AttributeContext.Peer value) {
      if (sourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        sourceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The source of a network activity, such as starting a TCP connection.
     * In a multi hop network activity, the source represents the sender of the
     * last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer source = 1;</code>
     */
    public Builder setSource(com.google.rpc.context.AttributeContext.Peer.Builder builderForValue) {
      if (sourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        sourceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The source of a network activity, such as starting a TCP connection.
     * In a multi hop network activity, the source represents the sender of the
     * last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer source = 1;</code>
     */
    public Builder mergeSource(com.google.rpc.context.AttributeContext.Peer value) {
      if (sourceBuilder_ == null) {
        if (source_ != null) {
          source_ =
              com.google.rpc.context.AttributeContext.Peer.newBuilder(source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        sourceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The source of a network activity, such as starting a TCP connection.
     * In a multi hop network activity, the source represents the sender of the
     * last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer source = 1;</code>
     */
    public Builder clearSource() {
      if (sourceBuilder_ == null) {
        source_ = null;
        onChanged();
      } else {
        source_ = null;
        sourceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The source of a network activity, such as starting a TCP connection.
     * In a multi hop network activity, the source represents the sender of the
     * last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer source = 1;</code>
     */
    public com.google.rpc.context.AttributeContext.Peer.Builder getSourceBuilder() {

      onChanged();
      return getSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The source of a network activity, such as starting a TCP connection.
     * In a multi hop network activity, the source represents the sender of the
     * last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer source = 1;</code>
     */
    public com.google.rpc.context.AttributeContext.PeerOrBuilder getSourceOrBuilder() {
      if (sourceBuilder_ != null) {
        return sourceBuilder_.getMessageOrBuilder();
      } else {
        return source_ == null
            ? com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()
            : source_;
      }
    }
    /**
     *
     *
     * <pre>
     * The source of a network activity, such as starting a TCP connection.
     * In a multi hop network activity, the source represents the sender of the
     * last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer source = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Peer,
            com.google.rpc.context.AttributeContext.Peer.Builder,
            com.google.rpc.context.AttributeContext.PeerOrBuilder>
        getSourceFieldBuilder() {
      if (sourceBuilder_ == null) {
        sourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.context.AttributeContext.Peer,
                com.google.rpc.context.AttributeContext.Peer.Builder,
                com.google.rpc.context.AttributeContext.PeerOrBuilder>(
                getSource(), getParentForChildren(), isClean());
        source_ = null;
      }
      return sourceBuilder_;
    }

    private com.google.rpc.context.AttributeContext.Peer destination_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Peer,
            com.google.rpc.context.AttributeContext.Peer.Builder,
            com.google.rpc.context.AttributeContext.PeerOrBuilder>
        destinationBuilder_;
    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination = 2;</code>
     *
     * @return Whether the destination field is set.
     */
    public boolean hasDestination() {
      return destinationBuilder_ != null || destination_ != null;
    }
    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination = 2;</code>
     *
     * @return The destination.
     */
    public com.google.rpc.context.AttributeContext.Peer getDestination() {
      if (destinationBuilder_ == null) {
        return destination_ == null
            ? com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()
            : destination_;
      } else {
        return destinationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination = 2;</code>
     */
    public Builder setDestination(com.google.rpc.context.AttributeContext.Peer value) {
      if (destinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        destinationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination = 2;</code>
     */
    public Builder setDestination(
        com.google.rpc.context.AttributeContext.Peer.Builder builderForValue) {
      if (destinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        destinationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination = 2;</code>
     */
    public Builder mergeDestination(com.google.rpc.context.AttributeContext.Peer value) {
      if (destinationBuilder_ == null) {
        if (destination_ != null) {
          destination_ =
              com.google.rpc.context.AttributeContext.Peer.newBuilder(destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        destinationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination = 2;</code>
     */
    public Builder clearDestination() {
      if (destinationBuilder_ == null) {
        destination_ = null;
        onChanged();
      } else {
        destination_ = null;
        destinationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination = 2;</code>
     */
    public com.google.rpc.context.AttributeContext.Peer.Builder getDestinationBuilder() {

      onChanged();
      return getDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination = 2;</code>
     */
    public com.google.rpc.context.AttributeContext.PeerOrBuilder getDestinationOrBuilder() {
      if (destinationBuilder_ != null) {
        return destinationBuilder_.getMessageOrBuilder();
      } else {
        return destination_ == null
            ? com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()
            : destination_;
      }
    }
    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Peer,
            com.google.rpc.context.AttributeContext.Peer.Builder,
            com.google.rpc.context.AttributeContext.PeerOrBuilder>
        getDestinationFieldBuilder() {
      if (destinationBuilder_ == null) {
        destinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.context.AttributeContext.Peer,
                com.google.rpc.context.AttributeContext.Peer.Builder,
                com.google.rpc.context.AttributeContext.PeerOrBuilder>(
                getDestination(), getParentForChildren(), isClean());
        destination_ = null;
      }
      return destinationBuilder_;
    }

    private com.google.rpc.context.AttributeContext.Request request_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Request,
            com.google.rpc.context.AttributeContext.Request.Builder,
            com.google.rpc.context.AttributeContext.RequestOrBuilder>
        requestBuilder_;
    /**
     *
     *
     * <pre>
     * Represents a network request, such as an HTTP request.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request = 3;</code>
     *
     * @return Whether the request field is set.
     */
    public boolean hasRequest() {
      return requestBuilder_ != null || request_ != null;
    }
    /**
     *
     *
     * <pre>
     * Represents a network request, such as an HTTP request.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request = 3;</code>
     *
     * @return The request.
     */
    public com.google.rpc.context.AttributeContext.Request getRequest() {
      if (requestBuilder_ == null) {
        return request_ == null
            ? com.google.rpc.context.AttributeContext.Request.getDefaultInstance()
            : request_;
      } else {
        return requestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Represents a network request, such as an HTTP request.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request = 3;</code>
     */
    public Builder setRequest(com.google.rpc.context.AttributeContext.Request value) {
      if (requestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        requestBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a network request, such as an HTTP request.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request = 3;</code>
     */
    public Builder setRequest(
        com.google.rpc.context.AttributeContext.Request.Builder builderForValue) {
      if (requestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        requestBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a network request, such as an HTTP request.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request = 3;</code>
     */
    public Builder mergeRequest(com.google.rpc.context.AttributeContext.Request value) {
      if (requestBuilder_ == null) {
        if (request_ != null) {
          request_ =
              com.google.rpc.context.AttributeContext.Request.newBuilder(request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        requestBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a network request, such as an HTTP request.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request = 3;</code>
     */
    public Builder clearRequest() {
      if (requestBuilder_ == null) {
        request_ = null;
        onChanged();
      } else {
        request_ = null;
        requestBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a network request, such as an HTTP request.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request = 3;</code>
     */
    public com.google.rpc.context.AttributeContext.Request.Builder getRequestBuilder() {

      onChanged();
      return getRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Represents a network request, such as an HTTP request.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request = 3;</code>
     */
    public com.google.rpc.context.AttributeContext.RequestOrBuilder getRequestOrBuilder() {
      if (requestBuilder_ != null) {
        return requestBuilder_.getMessageOrBuilder();
      } else {
        return request_ == null
            ? com.google.rpc.context.AttributeContext.Request.getDefaultInstance()
            : request_;
      }
    }
    /**
     *
     *
     * <pre>
     * Represents a network request, such as an HTTP request.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Request,
            com.google.rpc.context.AttributeContext.Request.Builder,
            com.google.rpc.context.AttributeContext.RequestOrBuilder>
        getRequestFieldBuilder() {
      if (requestBuilder_ == null) {
        requestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.context.AttributeContext.Request,
                com.google.rpc.context.AttributeContext.Request.Builder,
                com.google.rpc.context.AttributeContext.RequestOrBuilder>(
                getRequest(), getParentForChildren(), isClean());
        request_ = null;
      }
      return requestBuilder_;
    }

    private com.google.rpc.context.AttributeContext.Response response_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Response,
            com.google.rpc.context.AttributeContext.Response.Builder,
            com.google.rpc.context.AttributeContext.ResponseOrBuilder>
        responseBuilder_;
    /**
     *
     *
     * <pre>
     * Represents a network response, such as an HTTP response.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Response response = 4;</code>
     *
     * @return Whether the response field is set.
     */
    public boolean hasResponse() {
      return responseBuilder_ != null || response_ != null;
    }
    /**
     *
     *
     * <pre>
     * Represents a network response, such as an HTTP response.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Response response = 4;</code>
     *
     * @return The response.
     */
    public com.google.rpc.context.AttributeContext.Response getResponse() {
      if (responseBuilder_ == null) {
        return response_ == null
            ? com.google.rpc.context.AttributeContext.Response.getDefaultInstance()
            : response_;
      } else {
        return responseBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Represents a network response, such as an HTTP response.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Response response = 4;</code>
     */
    public Builder setResponse(com.google.rpc.context.AttributeContext.Response value) {
      if (responseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        response_ = value;
        onChanged();
      } else {
        responseBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a network response, such as an HTTP response.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Response response = 4;</code>
     */
    public Builder setResponse(
        com.google.rpc.context.AttributeContext.Response.Builder builderForValue) {
      if (responseBuilder_ == null) {
        response_ = builderForValue.build();
        onChanged();
      } else {
        responseBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a network response, such as an HTTP response.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Response response = 4;</code>
     */
    public Builder mergeResponse(com.google.rpc.context.AttributeContext.Response value) {
      if (responseBuilder_ == null) {
        if (response_ != null) {
          response_ =
              com.google.rpc.context.AttributeContext.Response.newBuilder(response_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          response_ = value;
        }
        onChanged();
      } else {
        responseBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a network response, such as an HTTP response.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Response response = 4;</code>
     */
    public Builder clearResponse() {
      if (responseBuilder_ == null) {
        response_ = null;
        onChanged();
      } else {
        response_ = null;
        responseBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a network response, such as an HTTP response.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Response response = 4;</code>
     */
    public com.google.rpc.context.AttributeContext.Response.Builder getResponseBuilder() {

      onChanged();
      return getResponseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Represents a network response, such as an HTTP response.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Response response = 4;</code>
     */
    public com.google.rpc.context.AttributeContext.ResponseOrBuilder getResponseOrBuilder() {
      if (responseBuilder_ != null) {
        return responseBuilder_.getMessageOrBuilder();
      } else {
        return response_ == null
            ? com.google.rpc.context.AttributeContext.Response.getDefaultInstance()
            : response_;
      }
    }
    /**
     *
     *
     * <pre>
     * Represents a network response, such as an HTTP response.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Response response = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Response,
            com.google.rpc.context.AttributeContext.Response.Builder,
            com.google.rpc.context.AttributeContext.ResponseOrBuilder>
        getResponseFieldBuilder() {
      if (responseBuilder_ == null) {
        responseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.context.AttributeContext.Response,
                com.google.rpc.context.AttributeContext.Response.Builder,
                com.google.rpc.context.AttributeContext.ResponseOrBuilder>(
                getResponse(), getParentForChildren(), isClean());
        response_ = null;
      }
      return responseBuilder_;
    }

    private com.google.rpc.context.AttributeContext.Resource resource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Resource,
            com.google.rpc.context.AttributeContext.Resource.Builder,
            com.google.rpc.context.AttributeContext.ResourceOrBuilder>
        resourceBuilder_;
    /**
     *
     *
     * <pre>
     * Represents a target resource that is involved with a network activity.
     * If multiple resources are involved with an activity, this must be the
     * primary one.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Resource resource = 5;</code>
     *
     * @return Whether the resource field is set.
     */
    public boolean hasResource() {
      return resourceBuilder_ != null || resource_ != null;
    }
    /**
     *
     *
     * <pre>
     * Represents a target resource that is involved with a network activity.
     * If multiple resources are involved with an activity, this must be the
     * primary one.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Resource resource = 5;</code>
     *
     * @return The resource.
     */
    public com.google.rpc.context.AttributeContext.Resource getResource() {
      if (resourceBuilder_ == null) {
        return resource_ == null
            ? com.google.rpc.context.AttributeContext.Resource.getDefaultInstance()
            : resource_;
      } else {
        return resourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Represents a target resource that is involved with a network activity.
     * If multiple resources are involved with an activity, this must be the
     * primary one.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Resource resource = 5;</code>
     */
    public Builder setResource(com.google.rpc.context.AttributeContext.Resource value) {
      if (resourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
        onChanged();
      } else {
        resourceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a target resource that is involved with a network activity.
     * If multiple resources are involved with an activity, this must be the
     * primary one.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Resource resource = 5;</code>
     */
    public Builder setResource(
        com.google.rpc.context.AttributeContext.Resource.Builder builderForValue) {
      if (resourceBuilder_ == null) {
        resource_ = builderForValue.build();
        onChanged();
      } else {
        resourceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a target resource that is involved with a network activity.
     * If multiple resources are involved with an activity, this must be the
     * primary one.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Resource resource = 5;</code>
     */
    public Builder mergeResource(com.google.rpc.context.AttributeContext.Resource value) {
      if (resourceBuilder_ == null) {
        if (resource_ != null) {
          resource_ =
              com.google.rpc.context.AttributeContext.Resource.newBuilder(resource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          resource_ = value;
        }
        onChanged();
      } else {
        resourceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a target resource that is involved with a network activity.
     * If multiple resources are involved with an activity, this must be the
     * primary one.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Resource resource = 5;</code>
     */
    public Builder clearResource() {
      if (resourceBuilder_ == null) {
        resource_ = null;
        onChanged();
      } else {
        resource_ = null;
        resourceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a target resource that is involved with a network activity.
     * If multiple resources are involved with an activity, this must be the
     * primary one.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Resource resource = 5;</code>
     */
    public com.google.rpc.context.AttributeContext.Resource.Builder getResourceBuilder() {

      onChanged();
      return getResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Represents a target resource that is involved with a network activity.
     * If multiple resources are involved with an activity, this must be the
     * primary one.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Resource resource = 5;</code>
     */
    public com.google.rpc.context.AttributeContext.ResourceOrBuilder getResourceOrBuilder() {
      if (resourceBuilder_ != null) {
        return resourceBuilder_.getMessageOrBuilder();
      } else {
        return resource_ == null
            ? com.google.rpc.context.AttributeContext.Resource.getDefaultInstance()
            : resource_;
      }
    }
    /**
     *
     *
     * <pre>
     * Represents a target resource that is involved with a network activity.
     * If multiple resources are involved with an activity, this must be the
     * primary one.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Resource resource = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Resource,
            com.google.rpc.context.AttributeContext.Resource.Builder,
            com.google.rpc.context.AttributeContext.ResourceOrBuilder>
        getResourceFieldBuilder() {
      if (resourceBuilder_ == null) {
        resourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.context.AttributeContext.Resource,
                com.google.rpc.context.AttributeContext.Resource.Builder,
                com.google.rpc.context.AttributeContext.ResourceOrBuilder>(
                getResource(), getParentForChildren(), isClean());
        resource_ = null;
      }
      return resourceBuilder_;
    }

    private com.google.rpc.context.AttributeContext.Api api_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Api,
            com.google.rpc.context.AttributeContext.Api.Builder,
            com.google.rpc.context.AttributeContext.ApiOrBuilder>
        apiBuilder_;
    /**
     *
     *
     * <pre>
     * Represents an API operation that is involved to a network activity.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Api api = 6;</code>
     *
     * @return Whether the api field is set.
     */
    public boolean hasApi() {
      return apiBuilder_ != null || api_ != null;
    }
    /**
     *
     *
     * <pre>
     * Represents an API operation that is involved to a network activity.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Api api = 6;</code>
     *
     * @return The api.
     */
    public com.google.rpc.context.AttributeContext.Api getApi() {
      if (apiBuilder_ == null) {
        return api_ == null
            ? com.google.rpc.context.AttributeContext.Api.getDefaultInstance()
            : api_;
      } else {
        return apiBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Represents an API operation that is involved to a network activity.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Api api = 6;</code>
     */
    public Builder setApi(com.google.rpc.context.AttributeContext.Api value) {
      if (apiBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        api_ = value;
        onChanged();
      } else {
        apiBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents an API operation that is involved to a network activity.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Api api = 6;</code>
     */
    public Builder setApi(com.google.rpc.context.AttributeContext.Api.Builder builderForValue) {
      if (apiBuilder_ == null) {
        api_ = builderForValue.build();
        onChanged();
      } else {
        apiBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents an API operation that is involved to a network activity.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Api api = 6;</code>
     */
    public Builder mergeApi(com.google.rpc.context.AttributeContext.Api value) {
      if (apiBuilder_ == null) {
        if (api_ != null) {
          api_ =
              com.google.rpc.context.AttributeContext.Api.newBuilder(api_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          api_ = value;
        }
        onChanged();
      } else {
        apiBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents an API operation that is involved to a network activity.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Api api = 6;</code>
     */
    public Builder clearApi() {
      if (apiBuilder_ == null) {
        api_ = null;
        onChanged();
      } else {
        api_ = null;
        apiBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents an API operation that is involved to a network activity.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Api api = 6;</code>
     */
    public com.google.rpc.context.AttributeContext.Api.Builder getApiBuilder() {

      onChanged();
      return getApiFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Represents an API operation that is involved to a network activity.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Api api = 6;</code>
     */
    public com.google.rpc.context.AttributeContext.ApiOrBuilder getApiOrBuilder() {
      if (apiBuilder_ != null) {
        return apiBuilder_.getMessageOrBuilder();
      } else {
        return api_ == null
            ? com.google.rpc.context.AttributeContext.Api.getDefaultInstance()
            : api_;
      }
    }
    /**
     *
     *
     * <pre>
     * Represents an API operation that is involved to a network activity.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Api api = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Api,
            com.google.rpc.context.AttributeContext.Api.Builder,
            com.google.rpc.context.AttributeContext.ApiOrBuilder>
        getApiFieldBuilder() {
      if (apiBuilder_ == null) {
        apiBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.context.AttributeContext.Api,
                com.google.rpc.context.AttributeContext.Api.Builder,
                com.google.rpc.context.AttributeContext.ApiOrBuilder>(
                getApi(), getParentForChildren(), isClean());
        api_ = null;
      }
      return apiBuilder_;
    }

    private java.util.List<com.google.protobuf.Any> extensions_ = java.util.Collections.emptyList();

    private void ensureExtensionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        extensions_ = new java.util.ArrayList<com.google.protobuf.Any>(extensions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Any,
            com.google.protobuf.Any.Builder,
            com.google.protobuf.AnyOrBuilder>
        extensionsBuilder_;

    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public java.util.List<com.google.protobuf.Any> getExtensionsList() {
      if (extensionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(extensions_);
      } else {
        return extensionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public int getExtensionsCount() {
      if (extensionsBuilder_ == null) {
        return extensions_.size();
      } else {
        return extensionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public com.google.protobuf.Any getExtensions(int index) {
      if (extensionsBuilder_ == null) {
        return extensions_.get(index);
      } else {
        return extensionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public Builder setExtensions(int index, com.google.protobuf.Any value) {
      if (extensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExtensionsIsMutable();
        extensions_.set(index, value);
        onChanged();
      } else {
        extensionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public Builder setExtensions(int index, com.google.protobuf.Any.Builder builderForValue) {
      if (extensionsBuilder_ == null) {
        ensureExtensionsIsMutable();
        extensions_.set(index, builderForValue.build());
        onChanged();
      } else {
        extensionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public Builder addExtensions(com.google.protobuf.Any value) {
      if (extensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExtensionsIsMutable();
        extensions_.add(value);
        onChanged();
      } else {
        extensionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public Builder addExtensions(int index, com.google.protobuf.Any value) {
      if (extensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExtensionsIsMutable();
        extensions_.add(index, value);
        onChanged();
      } else {
        extensionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public Builder addExtensions(com.google.protobuf.Any.Builder builderForValue) {
      if (extensionsBuilder_ == null) {
        ensureExtensionsIsMutable();
        extensions_.add(builderForValue.build());
        onChanged();
      } else {
        extensionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public Builder addExtensions(int index, com.google.protobuf.Any.Builder builderForValue) {
      if (extensionsBuilder_ == null) {
        ensureExtensionsIsMutable();
        extensions_.add(index, builderForValue.build());
        onChanged();
      } else {
        extensionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public Builder addAllExtensions(java.lang.Iterable<? extends com.google.protobuf.Any> values) {
      if (extensionsBuilder_ == null) {
        ensureExtensionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, extensions_);
        onChanged();
      } else {
        extensionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public Builder clearExtensions() {
      if (extensionsBuilder_ == null) {
        extensions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        extensionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public Builder removeExtensions(int index) {
      if (extensionsBuilder_ == null) {
        ensureExtensionsIsMutable();
        extensions_.remove(index);
        onChanged();
      } else {
        extensionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public com.google.protobuf.Any.Builder getExtensionsBuilder(int index) {
      return getExtensionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public com.google.protobuf.AnyOrBuilder getExtensionsOrBuilder(int index) {
      if (extensionsBuilder_ == null) {
        return extensions_.get(index);
      } else {
        return extensionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public java.util.List<? extends com.google.protobuf.AnyOrBuilder> getExtensionsOrBuilderList() {
      if (extensionsBuilder_ != null) {
        return extensionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(extensions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public com.google.protobuf.Any.Builder addExtensionsBuilder() {
      return getExtensionsFieldBuilder().addBuilder(com.google.protobuf.Any.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public com.google.protobuf.Any.Builder addExtensionsBuilder(int index) {
      return getExtensionsFieldBuilder()
          .addBuilder(index, com.google.protobuf.Any.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Supports extensions for advanced use cases, such as logs and metrics.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any extensions = 8;</code>
     */
    public java.util.List<com.google.protobuf.Any.Builder> getExtensionsBuilderList() {
      return getExtensionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Any,
            com.google.protobuf.Any.Builder,
            com.google.protobuf.AnyOrBuilder>
        getExtensionsFieldBuilder() {
      if (extensionsBuilder_ == null) {
        extensionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Any,
                com.google.protobuf.Any.Builder,
                com.google.protobuf.AnyOrBuilder>(
                extensions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        extensions_ = null;
      }
      return extensionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.rpc.context.AttributeContext)
  }

  // @@protoc_insertion_point(class_scope:google.rpc.context.AttributeContext)
  private static final com.google.rpc.context.AttributeContext DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.rpc.context.AttributeContext();
  }

  public static com.google.rpc.context.AttributeContext getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AttributeContext> PARSER =
      new com.google.protobuf.AbstractParser<AttributeContext>() {
        @java.lang.Override
        public AttributeContext parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AttributeContext(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AttributeContext> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AttributeContext> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.rpc.context.AttributeContext getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
