/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.attach.display.impl;

import com.gluonhq.attach.display.DisplayService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;

public class DesktopDisplayService
implements DisplayService {
    private static final Logger LOG = Logger.getLogger(DesktopDisplayService.class.getName());
    private final Dimension2D dimensions;

    public DesktopDisplayService() {
        Rectangle2D bounds = Screen.getPrimary().getBounds();
        this.dimensions = new Dimension2D(bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public boolean isPhone() {
        return false;
    }

    @Override
    public boolean isTablet() {
        return "tablet".equals(System.getProperty("charm-desktop-form"));
    }

    @Override
    public boolean isDesktop() {
        return true;
    }

    @Override
    public Dimension2D getScreenResolution() {
        return this.dimensions;
    }

    @Override
    public Dimension2D getDefaultDimensions() {
        return this.isTablet() ? new Dimension2D(900.0, 600.0) : new Dimension2D(335.0, 600.0);
    }

    @Override
    public float getScreenScale() {
        return (float)Math.min(Screen.getPrimary().getOutputScaleX(), Screen.getPrimary().getOutputScaleY());
    }

    @Override
    public boolean isScreenRound() {
        return false;
    }

    @Override
    public boolean hasNotch() {
        return false;
    }

    @Override
    public ReadOnlyObjectProperty<DisplayService.Notch> notchProperty() {
        return new ReadOnlyObjectWrapper((Object)DisplayService.Notch.UNKNOWN).getReadOnlyProperty();
    }

    private static void log(String message, Throwable cause) {
        LOG.log(Level.FINE, message);
        if (LOG.isLoggable(Level.FINE)) {
            cause.printStackTrace();
        }
    }
}

