/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoRecorders;
import com.github.dreamhead.moco.ResponseElement;
import com.github.dreamhead.moco.parser.deserializer.ReplayContainerDeserializer;
import com.github.dreamhead.moco.parser.model.ReplayModifierContainer;
import com.github.dreamhead.moco.parser.model.TextContainer;
import com.github.dreamhead.moco.recorder.RecorderConfig;
import com.github.dreamhead.moco.resource.ContentResource;
import java.util.ArrayList;

@JsonDeserialize(using=ReplayContainerDeserializer.class)
public class ReplayContainer {
    private String group;
    private TextContainer identifier;
    private ReplayModifierContainer modifier;
    private String tape;

    public ReplayContainer(String group, TextContainer identifier, ReplayModifierContainer modifier, String tape) {
        this.group = group;
        this.identifier = identifier;
        this.modifier = modifier;
        this.tape = tape;
    }

    public final RecorderConfig[] getConfigs() {
        ArrayList<Object> configs = new ArrayList<Object>();
        if (this.group != null) {
            configs.add(Moco.group((String)this.group));
        }
        if (this.identifier != null) {
            configs.add(MocoRecorders.identifier((ContentResource)this.identifier.asResource()));
        }
        if (this.modifier != null) {
            configs.add(MocoRecorders.modifier((ResponseElement)this.modifier.getResponseHandler(), (ResponseElement[])new ResponseElement[0]));
        }
        if (this.tape != null) {
            configs.add(MocoRecorders.tape((String)this.tape));
        }
        return configs.toArray(new RecorderConfig[0]);
    }
}

