/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import com.github.davidmoten.rx.CloseableObservableWithReset;
import com.github.davidmoten.rx.Schedulers;
import com.github.davidmoten.rx.internal.operators.ObservableReverse;
import com.github.davidmoten.rx.internal.operators.OnSubscribeFromQueue;
import com.github.davidmoten.rx.internal.operators.OnSubscribeMatch;
import com.github.davidmoten.rx.internal.operators.OnSubscribeRepeating;
import com.github.davidmoten.rx.internal.operators.OrderedMerge;
import com.github.davidmoten.rx.internal.operators.Permutations;
import com.github.davidmoten.rx.observables.CachedObservable;
import com.github.davidmoten.util.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Action0;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;

public final class Obs {
    public static <T> CachedObservable<T> cache(Observable<T> source) {
        return new CachedObservable<T>(source);
    }

    public static <T> Observable<T> cache(Observable<T> source, final long duration, final TimeUnit unit, final Scheduler.Worker worker) {
        final AtomicReference<CachedObservable<T>> cacheRef = new AtomicReference<CachedObservable<T>>();
        CachedObservable<T> cache = new CachedObservable<T>(source);
        cacheRef.set(cache);
        return cache.doOnSubscribe(new Action0(){

            public void call() {
                Action0 action = new Action0(){

                    public void call() {
                        ((CachedObservable)((Object)cacheRef.get())).reset();
                    }
                };
                worker.schedule(action, duration, unit);
            }
        });
    }

    public static <T> CloseableObservableWithReset<T> cache(Observable<T> source, final long duration, final TimeUnit unit, final Scheduler scheduler) {
        final AtomicReference<CachedObservable<T>> cacheRef = new AtomicReference<CachedObservable<T>>();
        final AtomicReference workerRef = new AtomicReference(Optional.absent());
        CachedObservable<T> cache = new CachedObservable<T>(source);
        cacheRef.set(cache);
        Action0 closeAction = new Action0(){

            public void call() {
                Optional w;
                while ((w = (Optional)workerRef.get()) != null) {
                    if (!workerRef.compareAndSet(w, null)) continue;
                    if (w.isPresent()) {
                        ((Scheduler.Worker)w.get()).unsubscribe();
                    }
                    workerRef.set(null);
                    break;
                }
            }
        };
        Action0 resetAction = new Action0(){

            public void call() {
                Obs.startScheduledResetAgain(duration, unit, scheduler, cacheRef, workerRef);
            }
        };
        return new CloseableObservableWithReset<T>(cache, closeAction, resetAction);
    }

    private static <T> void startScheduledResetAgain(long duration, TimeUnit unit, Scheduler scheduler, final AtomicReference<CachedObservable<T>> cacheRef, AtomicReference<Optional<Scheduler.Worker>> workerRef) {
        Optional<Scheduler.Worker> w;
        Optional<Scheduler.Worker> wOld;
        Action0 action = new Action0(){

            public void call() {
                ((CachedObservable)((Object)cacheRef.get())).reset();
            }
        };
        do {
            if ((wOld = workerRef.get()) != null) continue;
            return;
        } while (!workerRef.compareAndSet(wOld, w = Optional.of(scheduler.createWorker())));
        if (wOld.isPresent()) {
            wOld.get().unsubscribe();
        }
        w.get().schedule(action, duration, unit);
    }

    public static <T> Observable<T> repeating(T t) {
        return Observable.create(new OnSubscribeRepeating<T>(t));
    }

    public static <T extends Comparable<? super T>> Observable<T> create(Collection<Observable<T>> sources) {
        return Obs.create(sources, false);
    }

    public static <T> Observable<T> create(Collection<Observable<T>> sources, Comparator<? super T> comparator) {
        return Obs.create(sources, comparator, false);
    }

    public static <T extends Comparable<? super T>> Observable<T> create(Collection<Observable<T>> sources, boolean delayErrors) {
        return OrderedMerge.create(sources, delayErrors);
    }

    public static <T> Observable<T> create(Collection<Observable<T>> sources, Comparator<? super T> comparator, boolean delayErrors) {
        return OrderedMerge.create(sources, comparator, delayErrors);
    }

    public static <T> Observable<T> fromQueue(Queue<T> queue) {
        return Observable.create(new OnSubscribeFromQueue<T>(queue));
    }

    public static <T> Observable<List<Integer>> permutations(int size) {
        ArrayList<Integer> indexes = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            indexes.add(i);
        }
        return Observable.from(Permutations.iterable(indexes)).scan(indexes, (Func2)new Func2<List<Integer>, Permutations.Swap<Integer>, List<Integer>>(){

            public List<Integer> call(List<Integer> a, Permutations.Swap<Integer> swap) {
                ArrayList<Integer> b = new ArrayList<Integer>(a);
                b.set(swap.left(), a.get(swap.right()));
                b.set(swap.right(), a.get(swap.left()));
                return b;
            }
        });
    }

    public static <T> Observable<List<T>> permutations(final List<T> list) {
        return Obs.permutations(list.size()).map(new Func1<List<Integer>, List<T>>(){

            public List<T> call(List<Integer> a) {
                ArrayList b = new ArrayList(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    b.add(list.get(a.get(i)));
                }
                return b;
            }
        });
    }

    public static Observable<Long> intervalLong(final long duration, final TimeUnit unit, final Scheduler scheduler) {
        return Observable.defer((Func0)new Func0<Observable<Long>>(){
            final long[] count = new long[1];

            public Observable<Long> call() {
                return Observable.interval((long)duration, (TimeUnit)unit, (Scheduler)scheduler).map((Func1)new Func1<Long, Long>(){

                    public Long call(Long t) {
                        long l = count[0];
                        count[0] = l + 1L;
                        return l;
                    }
                });
            }
        });
    }

    public static Observable<Long> intervalLong(long duration, TimeUnit unit) {
        return Obs.intervalLong(duration, unit, Schedulers.computation());
    }

    public static <A, B, K, C> Observable<C> match(Observable<A> a, Observable<B> b, Func1<? super A, ? extends K> aKey, Func1<? super B, ? extends K> bKey, Func2<? super A, ? super B, C> combiner) {
        return Obs.match(a, b, aKey, bKey, combiner, 128L);
    }

    public static <A, B, K, C> Observable<C> match(Observable<A> a, Observable<B> b, Func1<? super A, ? extends K> aKey, Func1<? super B, ? extends K> bKey, Func2<? super A, ? super B, C> combiner, long requestSize) {
        return Observable.create(new OnSubscribeMatch<A, B, K, C>(a, b, aKey, bKey, combiner, requestSize));
    }

    public static <T> Observable<T> reverse(Observable<T> source) {
        return ObservableReverse.reverse(source);
    }
}

