/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.task.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import com.hand.hap.task.ExecuteLogConvertStrategy;
import com.hand.hap.task.dto.TaskExecution;
import com.hand.hap.task.mapper.TaskExecutionMapper;
import com.hand.hap.task.service.ITaskExecutionService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskExecutionServiceImpl
extends BaseServiceImpl<TaskExecution>
implements ITaskExecutionService {
    @Autowired
    private TaskExecutionMapper taskExecutionMapper;
    @Autowired
    private IMessagePublisher messagePublisher;
    @Value(value="${task.execute.logConvert.class:com.hand.hap.task.service.impl.DefaultExecuteLogConvert}")
    private String logConvertClass;

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
    public List<TaskExecution> queryExecutions(IRequest iRequest, TaskExecution dto, boolean isAdmin, int page, int pageSize) {
        PageHelper.startPage((int)page, (int)pageSize);
        return this.taskExecutionMapper.queryExecutions(dto, isAdmin);
    }

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
    public List<TaskExecution> queryExecutionGroup(IRequest iRequest, TaskExecution taskExecution) {
        return this.taskExecutionMapper.queryExecutionGroup(taskExecution);
    }

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
    public List<TaskExecution> queryExecutionDetail(IRequest iRequest, TaskExecution taskExecution) {
        return this.taskExecutionMapper.queryExecutionDetail(taskExecution);
    }

    @Transactional(rollbackFor={Exception.class})
    public void insertExecution(IRequest iRequest, TaskExecution taskExecution) {
        taskExecution.setUserId(iRequest.getUserId());
        taskExecution.setStatus("READY");
        this.taskExecutionMapper.insertSelective((Object)taskExecution);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void updateStatus(Long executionId, String status) {
        this.taskExecutionMapper.updateStatus(executionId, status);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void batchUpdateStatus(Long executionId, String befStatus, String aftStatus) {
        this.taskExecutionMapper.batchUpdateStatus(executionId, befStatus, aftStatus);
    }

    public boolean cancelExecute(TaskExecution dto) {
        this.messagePublisher.publish("task_cancel", (Object)dto);
        return true;
    }

    public String generateString(TaskExecution taskExecution) {
        String logString = "";
        try {
            ExecuteLogConvertStrategy executeLogConvertStrategy = (ExecuteLogConvertStrategy)Class.forName(this.logConvertClass).newInstance();
            logString = executeLogConvertStrategy.convertLog(taskExecution);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logString;
    }
}

