/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.task.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.StringUtil;
import com.hand.hap.code.rule.exception.CodeRuleException;
import com.hand.hap.code.rule.service.ISysCodeRuleProcessService;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.ProxySelf;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.system.mapper.ParameterConfigMapper;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import com.hand.hap.task.dto.TaskDetail;
import com.hand.hap.task.dto.TaskExecution;
import com.hand.hap.task.dto.TaskExecutionDetail;
import com.hand.hap.task.exception.TaskExecuteException;
import com.hand.hap.task.exception.TaskInvalidException;
import com.hand.hap.task.info.ParameterInfo;
import com.hand.hap.task.info.TaskDataInfo;
import com.hand.hap.task.mapper.TaskAssignMapper;
import com.hand.hap.task.mapper.TaskDetailMapper;
import com.hand.hap.task.mapper.TaskExecutionDetailMapper;
import com.hand.hap.task.mapper.TaskExecutionMapper;
import com.hand.hap.task.service.IExecuteService;
import com.hand.hap.task.service.ITaskAssignService;
import com.hand.hap.task.service.ITaskDetailService;
import com.hand.hap.task.service.ITaskExecutionDetailService;
import com.hand.hap.task.service.ITaskExecutionService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskDetailServiceImpl
extends BaseServiceImpl<TaskDetail>
implements ITaskDetailService,
ProxySelf<ITaskDetailService> {
    private static final String TASK_EXECUTION_CODE = "TASK_EXECUTION_CODE";
    private Logger logger = LoggerFactory.getLogger(TaskDetailServiceImpl.class);
    @Autowired
    private TaskDetailMapper taskDetailMapper;
    @Autowired
    private TaskAssignMapper taskAssignMapper;
    @Autowired
    private TaskExecutionMapper taskExecutionMapper;
    @Autowired
    private TaskExecutionDetailMapper taskExecutionDetailMapper;
    @Autowired
    private ParameterConfigMapper parameterConfigMapper;
    @Autowired
    private ITaskExecutionService iTaskExecutionService;
    @Autowired
    private ITaskExecutionDetailService iTaskExecutionDetailService;
    @Autowired
    private IExecuteService iExecuteService;
    @Autowired
    private ISysCodeRuleProcessService iSysCodeRuleProcessService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ITaskAssignService iTaskAssignService;

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
    public List<TaskDetail> queryChildrenByPrimaryKey(List<String> idList) {
        return this.taskDetailMapper.queryChildrenByPrimaryKey(idList);
    }

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
    public List<TaskDetail> queryUnboundTasks(IRequest request, TaskDetail dto, List<String> idList, int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return this.taskDetailMapper.queryUnboundTasks(dto, idList);
    }

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
    public int updateChildrenTasks(IRequest iRequest, TaskDetail data) {
        List children = data.getChildrenTasks();
        ArrayList<Long> ids = new ArrayList<Long>();
        children.sort(Comparator.comparing(TaskDetail::getOrder));
        for (TaskDetail taskDetail : children) {
            ids.add(taskDetail.getTaskId());
        }
        TaskDetail taskDetail = new TaskDetail();
        taskDetail.setIds(StringUtils.join(ids, (String)","));
        taskDetail.setTaskId(data.getTaskId());
        return this.mapper.updateByPrimaryKeySelective((Object)taskDetail);
    }

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
    public TaskDetail getGroupById(IRequest requestContext, TaskDetail taskDetail) {
        TaskDetail group = (TaskDetail)this.mapper.selectByPrimaryKey((Object)taskDetail);
        if (group.getIds() != null) {
            List<String> idList = Arrays.asList(group.getIds().split(","));
            List childrenTasks = this.queryChildrenByPrimaryKey(idList);
            ArrayList childrens = new ArrayList();
            idList.forEach(id -> childrenTasks.forEach(children -> {
                if (children.getTaskId().toString().equals(id)) {
                    childrens.add(children);
                    children.setOrder(childrens.size());
                }
            }));
            group.setChildrenTasks(childrens);
        }
        return group;
    }

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
    public List<TaskDetail> queryTaskDetail(IRequest iRequest, TaskDetail taskDetail) throws BaseException {
        List<Object> idList = new ArrayList();
        if (StringUtil.isNotEmpty((String)taskDetail.getIds())) {
            idList = Arrays.asList(taskDetail.getIds().split(","));
        }
        List taskDetails = this.taskDetailMapper.queryTask(taskDetail, idList);
        TaskDetail task = (TaskDetail)taskDetails.get(0);
        ArrayList msg = new ArrayList();
        this.taskInvalid(task, msg);
        ArrayList subtaskList = new ArrayList();
        int j = idList.size();
        block0: for (int i = 0; i < j; ++i) {
            int m = taskDetails.size();
            for (int n = 1; n < m; ++n) {
                if (!((String)idList.get(i)).equals(((TaskDetail)taskDetails.get(n)).getTaskId() + "")) continue;
                this.taskInvalid((TaskDetail)taskDetails.get(n), msg);
                subtaskList.add(taskDetails.get(n));
                continue block0;
            }
        }
        if (CollectionUtils.isNotEmpty(msg)) {
            String message = StringUtils.join(msg, (String)",");
            throw new TaskInvalidException("error.task.invalid", new Object[]{message});
        }
        task.setChildrenTasks(subtaskList);
        return Arrays.asList(task);
    }

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
    public List<TaskDetail> executeQuery(IRequest iRequest, TaskDetail taskDetail, int page, int pageSize) {
        List taskIds = this.iTaskAssignService.queryTaskId(iRequest, false);
        if (taskIds.size() == 0) {
            return new ArrayList<TaskDetail>();
        }
        PageHelper.startPage((int)page, (int)pageSize);
        return this.taskDetailMapper.queryByTask(taskDetail, taskIds);
    }

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
    public List<String> execute(IRequest iRequest, TaskDataInfo taskDataInfo) throws BaseException {
        try {
            String code = this.getRoleCode();
            Long executionId = ((ITaskDetailService)this.self()).insertExecution(iRequest, taskDataInfo, code);
            taskDataInfo.setUsername(iRequest.getUserName());
            this.iExecuteService.taskExecute(taskDataInfo);
            return Arrays.asList(code, executionId + "");
        }
        catch (CodeRuleException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TaskExecuteException("TASK_EXECUTE_FAIL", "The server resource is busy. Please try again later");
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public Long insertExecution(IRequest iRequest, TaskDataInfo taskData, String code) {
        TaskExecution taskExecution = this.taskExecutionMapper.getLastExecuteDate(taskData.getTaskId());
        Long executionId = taskExecution != null ? this.insertExecutionAndDetail(iRequest, taskData, Long.valueOf(0L), code, null, taskExecution.getStartTime()) : this.insertExecutionAndDetail(iRequest, taskData, Long.valueOf(0L), code, null, null);
        taskData.setExecutionId(executionId);
        List taskItem = taskData.getTaskDatas();
        if (null != taskItem) {
            int j = taskItem.size();
            for (int i = 0; i < j; ++i) {
                TaskDataInfo data = (TaskDataInfo)taskItem.get(i);
                Long id = this.insertExecutionAndDetail(iRequest, data, Long.valueOf((long)i + 1L), null, executionId, null);
                data.setExecutionId(id);
            }
        }
        return executionId;
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(List<TaskDetail> list) {
        this.batchDelete(list);
        list.forEach(taskDetail -> {
            this.taskAssignMapper.deleteByTaskId(taskDetail.getTaskId());
            if (taskDetail.getType().equals("TASK")) {
                this.parameterConfigMapper.deleteByTaskId(taskDetail.getTaskId());
            }
        });
        ArrayList executionList = new ArrayList();
        ArrayList deleteList = new ArrayList();
        list.forEach(taskDetail -> {
            List executions = this.taskExecutionMapper.selectByTaskId(taskDetail.getTaskId());
            executionList.addAll(executions);
        });
        executionList.forEach(execution -> {
            List executions = this.taskExecutionMapper.selectByExeId(execution.getExecutionId());
            deleteList.addAll(executions);
        });
        deleteList.forEach(execution -> this.taskExecutionDetailMapper.deleteByExecutionId(execution.getExecutionId()));
        this.iTaskExecutionService.batchDelete(deleteList);
    }

    private void taskInvalid(TaskDetail taskDetail, List<String> msg) throws TaskInvalidException {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = sdf.format(date);
        try {
            boolean end;
            Long now = sdf.parse(dateString).getTime();
            boolean start = taskDetail.getStartDate() == null || now >= taskDetail.getStartDate().getTime();
            boolean bl = end = taskDetail.getEndDate() == null || now <= taskDetail.getEndDate().getTime();
            if (!start || !end) {
                msg.add(taskDetail.getCode());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getRoleCode() throws CodeRuleException {
        return this.iSysCodeRuleProcessService.getRuleCode(TASK_EXECUTION_CODE);
    }

    private Long insertExecutionAndDetail(IRequest iRequest, TaskDataInfo taskData, Long order, String code, Long executionId, Date lastExecuteDate) {
        TaskExecution taskExecution = new TaskExecution();
        taskExecution.setExecutionNumber(code);
        taskExecution.setTaskId(taskData.getTaskId());
        taskExecution.setExecutionOrder(order);
        taskExecution.setParentId(executionId);
        if (null != taskData.getDescription()) {
            taskExecution.setExecutionDescription(taskData.getDescription());
        }
        if (null != lastExecuteDate) {
            taskExecution.setLastExecuteDate(lastExecuteDate);
        }
        this.iTaskExecutionService.insertExecution(iRequest, taskExecution);
        TaskExecutionDetail taskExecutionDetail = new TaskExecutionDetail();
        taskExecutionDetail.setExecutionId(taskExecution.getExecutionId());
        taskExecutionDetail.setParameter(this.createParam(taskData.getParam()));
        this.iTaskExecutionDetailService.insertSelective(iRequest, (Object)taskExecutionDetail);
        return taskExecution.getExecutionId();
    }

    private String createParam(List<ParameterInfo> params) {
        if (null == params) {
            return "";
        }
        try {
            String paramString = this.objectMapper.writeValueAsString(params);
            return paramString.replaceAll("null", "\"\"");
        }
        catch (JsonProcessingException e) {
            this.logger.error(e.getMessage());
            return "";
        }
    }

    protected boolean useSelectiveUpdate() {
        return false;
    }
}

