/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.cache.impl.LovCache;
import com.hand.hap.system.dto.Lov;
import com.hand.hap.system.dto.LovItem;
import com.hand.hap.system.mapper.LovItemMapper;
import com.hand.hap.system.mapper.LovMapper;
import com.hand.hap.system.service.IKendoLovService;
import com.hand.hap.system.service.impl.KendoLovServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class KendoLovServiceImpl
implements IKendoLovService {
    private final Logger logger = LoggerFactory.getLogger(KendoLovServiceImpl.class);
    @Autowired
    private LovMapper lovMapper;
    @Autowired
    private LovItemMapper lovItemMapper;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private LovCache lovCache;

    public String getLov(String contextPath, Locale locale, String lovCode) {
        LovEditor editor = this.getLovEditor(contextPath, locale, lovCode);
        try {
            return this.objectMapper.writeValueAsString((Object)editor);
        }
        catch (JsonProcessingException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            return "''";
        }
    }

    private LovEditor getLovEditor(String contextPath, Locale locale, String lovCode) {
        Lov lov = this.lovCache.getValue(lovCode);
        if (lov == null && (lov = this.lovMapper.selectByCode(lovCode)) != null) {
            List items = this.lovItemMapper.selectByLovId(lov.getLovId());
            lov.setLovItems(items);
            this.lovCache.setValue(lov.getCode(), lov);
        }
        return lov != null ? this.createLovEditor(contextPath, locale, lov, lov.getLovItems()) : null;
    }

    private LovEditor createLovEditor(String contextPath, Locale locale, Lov lov, List<LovItem> items) {
        LovEditor editor = new LovEditor(this, lov, locale);
        editor.setGrid(new LovGrid(this, contextPath, locale, lov, items));
        this.buildConditionForm(editor, items, contextPath, locale);
        return editor;
    }

    private void buildConditionForm(LovEditor editor, List<LovItem> items, String contextPath, Locale locale) {
        StringBuilder html = new StringBuilder();
        int customCols = editor.getQueryColumns() == null ? 1 : editor.getQueryColumns();
        int colsNum = 0;
        int labelWidth = 3;
        if (customCols < 1) {
            customCols = 1;
        } else if (customCols > 4) {
            customCols = 4;
        }
        ArrayList<LovItem> formItems = new ArrayList<LovItem>();
        if (items != null) {
            for (LovItem item : items) {
                if (!"Y".equalsIgnoreCase(item.getConditionField())) continue;
                formItems.add(item);
                ++colsNum;
            }
        }
        formItems.sort((a, b) -> a.getConditionFieldSequence() - b.getConditionFieldSequence());
        if (customCols > colsNum && colsNum > 0) {
            customCols = colsNum;
        }
        if (customCols >= 3) {
            labelWidth = 2;
        }
        int colCounter = customCols;
        html.append("<div class='form-group' style='width:100%'>");
        if (formItems != null) {
            int overlength = 12;
            for (LovItem item : formItems) {
                int finalLabelWidth = labelWidth;
                int widthValue = (12 - finalLabelWidth * customCols) / customCols;
                if (!"Y".equalsIgnoreCase(item.getConditionField())) continue;
                String field = StringUtils.defaultIfEmpty((String)item.getConditionFieldName(), (String)item.getGridFieldName());
                if (item.getConditionFieldLabelWidth() != null && item.getConditionFieldLabelWidth() > 0) {
                    finalLabelWidth = item.getConditionFieldLabelWidth();
                }
                if (item.getConditionFieldWidth() != null) {
                    if (item.getConditionFieldWidth() <= 12 - finalLabelWidth && item.getConditionFieldWidth() > 0) {
                        widthValue = item.getConditionFieldWidth();
                    } else if (item.getConditionFieldWidth() > 12 - finalLabelWidth) {
                        widthValue = 12 - finalLabelWidth;
                    }
                }
                if (colCounter > 0) {
                    if (overlength - finalLabelWidth >= widthValue) {
                        overlength = overlength - finalLabelWidth - widthValue;
                        item.setConditionFieldNewline("N");
                        --colCounter;
                    } else {
                        overlength = 12 - finalLabelWidth - widthValue;
                        item.setConditionFieldNewline("Y");
                        colCounter = customCols - 1;
                    }
                } else {
                    item.setConditionFieldNewline("Y");
                    colCounter = customCols - 1;
                }
                if (item.getConditionFieldNewline() == "Y") {
                    html.append("</div><div class='form-group' style='width:100%'>");
                }
                html.append("<label class='col-sm-" + finalLabelWidth + " control-label' >").append(this.messageSource.getMessage(item.getDisplay(), null, item.getDisplay(), locale)).append("</label>").append("<div class='col-sm-" + widthValue + " k-lov-input' >").append("<input name='" + field + "' data-bind='value:data." + field + "' style='width:100%'>").append("</div>");
                editor.getFormItemMap().put(field, this.buildConditionFormItem(item, contextPath));
            }
        }
        html.append("</div>");
        editor.setForm(html.toString());
    }

    private LovFormItem buildConditionFormItem(LovItem item, String contextPath) {
        String type;
        LovFormItem formItem = new LovFormItem(this, null);
        switch (type = StringUtils.defaultIfEmpty((String)item.getConditionFieldType(), (String)"text")) {
            case "text": {
                formItem.setType("kendoMaskedTextBox");
                break;
            }
            case "select": {
                formItem.setType("kendoComboBox");
                formItem.setValuePrimitive(Boolean.valueOf(true));
                if (StringUtils.isNotEmpty((String)item.getConditionFieldSelectCode())) {
                    formItem.setDataSource(contextPath + "/common/code/" + item.getConditionFieldSelectCode() + "/");
                    formItem.setDataValueField("value");
                    formItem.setDataTextField("meaning");
                    break;
                }
                if (!StringUtils.isNotEmpty((String)item.getConditionFieldSelectUrl())) break;
                formItem.setDataSource(contextPath + item.getConditionFieldSelectUrl());
                formItem.setDataValueField(item.getConditionFieldSelectVf());
                formItem.setDataTextField(item.getConditionFieldSelectTf());
                break;
            }
            case "int": {
                formItem.setType("kendoNumericTextBox");
                break;
            }
            case "date": {
                formItem.setType("kendoDatePicker");
                break;
            }
        }
        return formItem;
    }

    static /* synthetic */ MessageSource access$100(KendoLovServiceImpl x0) {
        return x0.messageSource;
    }
}

