/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.hand.hap.cache.Cache;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.Form;
import com.hand.hap.system.service.IFormBuilderService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class FormBuilderServiceImpl
extends BaseServiceImpl<Form>
implements IFormBuilderService {
    @Autowired
    @Qualifier(value="formCache")
    private Cache formCache;

    public List<Form> batchUpdate(IRequest request, List<Form> forms) {
        for (Form form : forms) {
            form.setCode(StringUtils.upperCase((String)form.getCode()));
            if (form.getFormId() == null) {
                ((IFormBuilderService)this.self()).insertSelective(request, (Object)form);
            } else if (form.getFormId() != null) {
                ((IFormBuilderService)this.self()).updateByPrimaryKey(request, (Object)form);
            }
            this.formCache.setValue(form.getCode(), (Object)form);
        }
        return forms;
    }

    public int batchDelete(List<Form> forms) {
        int c = 0;
        for (Form form : forms) {
            c += ((IFormBuilderService)this.self()).deleteByPrimaryKey((Object)form);
            this.formCache.remove(form.getCode());
        }
        return c;
    }
}

