/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.DashBoard;
import com.hand.hap.system.dto.UserDashboard;
import com.hand.hap.system.mapper.DashBoardMapper;
import com.hand.hap.system.mapper.UserDashboardMapper;
import com.hand.hap.system.service.IDashBoardService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DashBoardServiceImpl
extends BaseServiceImpl<DashBoard>
implements IDashBoardService {
    @Autowired
    private DashBoardMapper dashBoardMapper;
    @Autowired
    private UserDashboardMapper userDashboardMapper;

    public List<DashBoard> selectDashBoard(IRequest request, DashBoard dashBoard, int page, int pageSize) {
        PageHelper.startPage((int)page, (int)pageSize);
        List dashBoardDisplays = this.dashBoardMapper.selectDashBoards(dashBoard);
        return dashBoardDisplays;
    }

    public List<UserDashboard> selectMyDashboardConfig(IRequest request, UserDashboard dashboard) {
        return this.userDashboardMapper.selectMyDashboardConfig(dashboard);
    }

    public void updateMyDashboardConfig(IRequest request, List<UserDashboard> dashboards) {
        dashboards.forEach(d -> {
            int count = this.userDashboardMapper.updateByPrimaryKeySelective(d);
            this.checkOvn(count, d);
        });
    }

    public void removeDashboard(IRequest request, UserDashboard dashboard) {
        int count = this.userDashboardMapper.deleteByPrimaryKey((Object)dashboard);
        this.checkOvn(count, (Object)dashboard);
    }

    public UserDashboard insertMyDashboard(IRequest request, UserDashboard dashboard) {
        this.userDashboardMapper.insert((Object)dashboard);
        return dashboard;
    }
}

