/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.cache.impl.SysCodeCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.Code;
import com.hand.hap.system.dto.CodeValue;
import com.hand.hap.system.mapper.CodeMapper;
import com.hand.hap.system.mapper.CodeValueMapper;
import com.hand.hap.system.service.ICodeService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CodeServiceImpl
extends BaseServiceImpl<Code>
implements ICodeService {
    @Autowired
    private CodeMapper codeMapper;
    @Autowired
    private CodeValueMapper codeValueMapper;
    @Autowired
    private SysCodeCache codeCache;

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<Code> selectCodes(IRequest request, Code code, int page, int pagesize) {
        PageHelper.startPage((int)page, (int)pagesize);
        List codes = this.codeMapper.selectCodes(code);
        return codes;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<CodeValue> selectCodeValues(IRequest request, CodeValue value) {
        return this.codeValueMapper.selectCodeValuesByCodeId(value);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<CodeValue> selectCodeValuesByCodeName(IRequest request, String codeName) {
        Code code = this.getValue(request, codeName);
        if (code != null) {
            return code.getCodeValues();
        }
        return this.codeValueMapper.selectCodeValuesByCodeName(codeName);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public CodeValue getCodeValue(IRequest request, String codeName, String value) {
        Code code = this.getValue(request, codeName);
        if (code == null) {
            return null;
        }
        if (code.getCodeValues() == null) {
            return null;
        }
        for (CodeValue v : code.getCodeValues()) {
            if (!v.getValue().equals(value)) continue;
            return v;
        }
        return null;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public String getCodeValueByMeaning(IRequest request, String codeName, String meaning) {
        Code code = this.getValue(request, codeName);
        if (code == null) {
            return null;
        }
        if (code.getCodeValues() == null) {
            return null;
        }
        for (CodeValue v : code.getCodeValues()) {
            if (!v.getMeaning().equals(meaning)) continue;
            return v.getValue();
        }
        return null;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public String getCodeMeaningByValue(IRequest request, String codeName, String value) {
        Code code = this.getValue(request, codeName);
        if (code == null) {
            return null;
        }
        if (code.getCodeValues() == null) {
            return null;
        }
        for (CodeValue v : code.getCodeValues()) {
            if (!v.getValue().equals(value)) continue;
            return v.getMeaning();
        }
        return null;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public String getCodeDescByValue(IRequest request, String codeName, String value) {
        Code code = this.getValue(request, codeName);
        if (code == null) {
            return null;
        }
        if (code.getCodeValues() == null) {
            return null;
        }
        for (CodeValue v : code.getCodeValues()) {
            if (!v.getValue().equals(value)) continue;
            return v.getDescription();
        }
        return null;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<CodeValue> getCodeValuesByCode(IRequest request, String codeName) {
        Code code = this.getValue(request, codeName);
        if (code != null && "Y".equals(code.getEnabledFlag())) {
            return this.getEnabledCodeValues(code);
        }
        return null;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<CodeValue> getChildCodeValue(IRequest request, String codeName, String value) {
        CodeValue codeValue = this.getCodeValue(request, codeName, value);
        if (codeValue != null) {
            return this.codeValueMapper.selectCodeValuesByParentId(codeValue.getCodeValueId());
        }
        return null;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<CodeValue> getChildCodeValue(IRequest request, String parentCodeName, String value, String childCodeName) {
        Code childCode;
        CodeValue parentCodeValue = this.getCodeValue(request, parentCodeName, value);
        ArrayList<CodeValue> childCodeValues = new ArrayList<CodeValue>();
        if (parentCodeValue != null && (childCode = this.getValue(request, childCodeName)) != null && CollectionUtils.isNotEmpty((Collection)childCode.getCodeValues())) {
            Long parentCodeValueId = parentCodeValue.getCodeValueId();
            for (CodeValue codeValue : childCode.getCodeValues()) {
                if (!parentCodeValueId.equals(codeValue.getParentCodeValueId())) continue;
                childCodeValues.add(codeValue);
            }
        }
        return childCodeValues;
    }

    public Code getValue(IRequest request, String codeName) {
        Code code = this.codeCache.getValue(codeName + "." + request.getLocale());
        if (code == null && (code = this.codeMapper.getByCodeName(codeName)) != null) {
            CodeValue codeValue = new CodeValue();
            codeValue.setCodeId(code.getCodeId());
            List list = this.codeValueMapper.selectCodeValuesByCodeId(codeValue);
            code.setCodeValues(list);
            this.codeCache.setValue(codeName + "." + request.getLocale(), code);
        }
        return code;
    }

    @Transactional(rollbackFor={Exception.class})
    public Code createCode(Code code) {
        this.codeMapper.insertSelective((Object)code);
        if (code.getCodeValues() != null) {
            this.processCodeValues(code);
        }
        this.codeCache.reload(code.getCodeId());
        return code;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean batchDelete(IRequest request, List<Code> codes) {
        for (Code code : codes) {
            CodeValue codeValue = new CodeValue();
            codeValue.setCodeId(code.getCodeId());
            this.codeValueMapper.deleteTlByCodeId(codeValue);
            this.codeValueMapper.deleteByCodeId(codeValue);
            int updateCount = this.codeMapper.deleteByPrimaryKey((Object)code);
            this.checkOvn(updateCount, (Object)code);
            this.codeCache.remove(code.getCode());
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean batchDeleteValues(IRequest request, List<CodeValue> values) {
        HashSet<Long> codeIdSet = new HashSet<Long>();
        for (CodeValue value : values) {
            int updateCount = this.codeValueMapper.deleteByPrimaryKey((Object)value);
            this.checkOvn(updateCount, (Object)value);
            codeIdSet.add(value.getCodeId());
        }
        for (Long codeId : codeIdSet) {
            this.codeCache.reload(codeId);
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public Code updateCode(Code code) {
        int count = this.codeMapper.updateByPrimaryKey((Object)code);
        this.checkOvn(count, (Object)code);
        if (code.getCodeValues() != null) {
            this.processCodeValues(code);
        }
        this.codeCache.remove(code.getCode());
        this.codeCache.reload(code.getCodeId());
        return code;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Code> batchUpdate(IRequest request, List<Code> codes) {
        for (Code code : codes) {
            if (code.getCodeId() == null) {
                ((ICodeService)this.self()).createCode(code);
                continue;
            }
            ((ICodeService)this.self()).updateCode(code);
        }
        return codes;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public CodeValue getCodeValueById(Long codeId) {
        return this.codeValueMapper.getCodeValueById(codeId);
    }

    private List<CodeValue> getEnabledCodeValues(Code code) {
        ArrayList<CodeValue> enabledCodeValues = new ArrayList<CodeValue>();
        List allCodeValues = code.getCodeValues();
        if (allCodeValues != null) {
            for (CodeValue codevalue : allCodeValues) {
                if (!"Y".equals(codevalue.getEnabledFlag())) continue;
                enabledCodeValues.add(codevalue);
            }
        }
        return enabledCodeValues;
    }

    private void processCodeValues(Code code) {
        for (CodeValue codeValue : code.getCodeValues()) {
            if (codeValue.getCodeValueId() == null) {
                codeValue.setCodeId(code.getCodeId());
                this.codeValueMapper.insertSelective((Object)codeValue);
                continue;
            }
            int count = this.codeValueMapper.updateByPrimaryKey((Object)codeValue);
            this.checkOvn(count, (Object)codeValue);
        }
    }
}

