/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.message.websocket.CommandMessage;
import com.hand.hap.message.websocket.WebSocketSessionManager;
import com.hand.hap.system.service.IBadgeService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketSession;

@Service
public class BadgeServiceImpl
implements IBadgeService {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    IMessagePublisher iMessagePublisher;
    @Autowired
    WebSocketSessionManager webSocketSessionManager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String HAP_CACHE_BADGE = "hap:cache:badge:";

    private Map<String, Object> updateBadgeCount(String userName, String badgeCode, Long num) {
        Map<String, Object> map;
        block3: {
            String codes = (String)this.redisTemplate.opsForHash().get((Object)HAP_CACHE_BADGE, (Object)userName);
            map = new HashMap<String, Object>();
            try {
                if (codes != null) {
                    map = (Map)this.objectMapper.readValue(codes, Map.class);
                }
                map.put(badgeCode, num);
                this.redisTemplate.opsForHash().put((Object)HAP_CACHE_BADGE, (Object)userName, (Object)this.objectMapper.writeValueAsString(map));
            }
            catch (IOException e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error(HAP_CACHE_BADGE + userName + ":{} not an object", (Object)codes);
            }
        }
        return map;
    }

    public void sendBadgeMessageToUser(String userName, String badgeCode, Long num) {
        CommandMessage commandMessage = new CommandMessage();
        commandMessage.setUserName(userName);
        commandMessage.setAction("SYS_BADGE");
        Map map = this.updateBadgeCount(userName, badgeCode, num);
        commandMessage.setParameter(map);
        this.iMessagePublisher.publish("channel_badge", (Object)commandMessage);
    }

    public void initBadgeMessage(WebSocketSession session) {
        block5: {
            String userName = session.getPrincipal().getName();
            if (!StringUtils.isEmpty((Object)userName)) {
                String codes = (String)this.redisTemplate.opsForHash().get((Object)HAP_CACHE_BADGE, (Object)userName);
                Map map = new HashMap();
                try {
                    if (codes != null) {
                        map = (Map)this.objectMapper.readValue(codes, Map.class);
                    }
                    if (map != null) {
                        CommandMessage commandMessage = new CommandMessage();
                        commandMessage.setUserName(userName);
                        commandMessage.setAction("SYS_BADGE");
                        commandMessage.setParameter(map);
                        this.webSocketSessionManager.sendCommandMessage(session, commandMessage);
                    }
                }
                catch (IOException e) {
                    if (!this.logger.isErrorEnabled()) break block5;
                    this.logger.error(HAP_CACHE_BADGE + userName + ":{} not an object", (Object)codes);
                }
            }
        }
    }
}

