/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers.sys;

import com.hand.hap.core.ILanguageProvider;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.dto.SysPreferences;
import com.hand.hap.system.service.ISysPreferencesService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.WebUtils;

@Controller
public class SysPreferencesController
extends BaseController {
    @Autowired
    private ISysPreferencesService sysPreferencesService;
    @Autowired
    private ILanguageProvider languageProvider;

    @RequestMapping(value={"/sys/um/sys_preferences.html"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView sysPreferences(HttpServletRequest request) {
        ModelAndView mv = new ModelAndView(this.getViewPath() + "/sys/um/sys_preferences");
        List languages = this.languageProvider.getSupportedLanguages();
        mv.addObject("languages", (Object)languages);
        return mv;
    }

    @RequestMapping(value={"/sys/preferences/savePreferences"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResponseData savePreferences(HttpServletRequest request, HttpServletResponse response, @RequestBody List<SysPreferences> sysPreferences, BindingResult result) {
        this.getValidator().validate(sysPreferences, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        List lists = this.sysPreferencesService.saveSysPreferences(this.createRequestContext(request), sysPreferences);
        for (SysPreferences preference : lists) {
            if ("locale".equalsIgnoreCase(preference.getPreferences())) {
                LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)request);
                if (localeResolver == null) continue;
                localeResolver.setLocale(request, response, StringUtils.parseLocaleString((String)preference.getPreferencesValue()));
                continue;
            }
            if ("theme".equalsIgnoreCase(preference.getPreferences())) {
                ThemeResolver themeResolver = RequestContextUtils.getThemeResolver((HttpServletRequest)request);
                if (themeResolver == null) continue;
                themeResolver.setThemeName(request, response, preference.getPreferencesValue());
                continue;
            }
            if ("timeZone".equalsIgnoreCase(preference.getPreferences())) {
                WebUtils.setSessionAttribute((HttpServletRequest)request, (String)SessionLocaleResolver.TIME_ZONE_SESSION_ATTRIBUTE_NAME, (Object)StringUtils.parseTimeZoneString((String)preference.getPreferencesValue()));
                WebUtils.setSessionAttribute((HttpServletRequest)request, (String)"timeZone", (Object)preference.getPreferencesValue());
                continue;
            }
            if (!"nav".equalsIgnoreCase(preference.getPreferences())) continue;
            WebUtils.setSessionAttribute((HttpServletRequest)request, (String)"nav", (Object)preference.getPreferencesValue());
        }
        return new ResponseData(lists);
    }

    @RequestMapping(value={"/sys/preferences/queryPreferences"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResponseData queryPreferences(HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        SysPreferences preference = new SysPreferences();
        preference.setUserId(requestContext.getUserId());
        List lists = this.sysPreferencesService.querySysPreferencesByDb(requestContext, preference);
        return new ResponseData(lists);
    }
}

