/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers.sys;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.TokenException;
import com.hand.hap.core.util.FormatUtil;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.dto.SysConfig;
import com.hand.hap.system.service.ISysConfigService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.WebUtils;

@Controller
@RequestMapping(value={"/sys/config", "/api/sys/config"})
public class SysConfigController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(SysConfigController.class);
    private static final String SYS_LOGO_FILE_NAME = "logo.png";
    private static final String SYS_FAVICON_FILE_NAME = "favicon.png";
    private static final String MSG_ALERT_UPLOAD_FILE_TYPE_MISMATCH = "hap.upload.file.type.mismatch";
    private static final String MSG_ALERT_UPLOAD_FILE_SIZE_LIMIT_EXCEEDED = "hap.upload.file.size.limit.exceeded";
    private static final String MSG_ALERT_UPLOAD_SUCCESS = "hap.upload.success";
    private static final String MSG_ALERT_UPLOAD_ERROR = "hap.upload.error";
    @Autowired
    private ISysConfigService configService;

    @PostMapping(value={"/query"})
    @ResponseBody
    public ResponseData getConfig(HttpServletRequest request) {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.configService.selectAll(iRequest));
    }

    @PostMapping(value={"/submit"})
    public ResponseData submitConfig(@RequestBody List<SysConfig> config, BindingResult result, HttpServletRequest request) throws TokenException {
        this.checkToken(request, config);
        this.getValidator().validate(config, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestCtx = this.createRequestContext(request);
        for (int i = 0; i < config.size(); ++i) {
            if (!config.get(i).getConfigCode().equals("PASSWORD_MIN_LENGTH")) continue;
            if (Integer.parseInt(config.get(i).getConfigValue()) < 6) {
                config.get(i).setConfigValue("6");
                continue;
            }
            if (Integer.parseInt(config.get(i).getConfigValue()) <= 16) continue;
            config.get(i).setConfigValue("16");
        }
        return new ResponseData(this.configService.batchUpdate(requestCtx, config));
    }

    @RequestMapping(value={"/logo/upload"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String uploadSystemLogo(HttpServletRequest request) {
        return this.uploadSystemImage(request, 500, SYS_LOGO_FILE_NAME, "SYS_LOGO_VERSION");
    }

    @RequestMapping(value={"/favicon/upload"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String uploadFaviconLogo(HttpServletRequest request) {
        return this.uploadSystemImage(request, 100, SYS_FAVICON_FILE_NAME, "SYS_FAVICON_VERSION");
    }

    private String uploadSystemImage(HttpServletRequest request, int fileSizeWithKB, String fileName, String type) {
        Locale locale;
        block30: {
            File uploadFolder = new File(request.getServletContext().getRealPath("/") + "/resources/upload");
            locale = RequestContextUtils.getLocale((HttpServletRequest)request);
            long fileSize = fileSizeWithKB * 1024;
            try {
                FileUtils.forceMkdir((File)uploadFolder);
                DiskFileItemFactory factory = new DiskFileItemFactory();
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                upload.setFileSizeMax(fileSize);
                List items = upload.parseRequest(request);
                for (FileItem fi : items) {
                    if (fi.isFormField()) continue;
                    String contentType = fi.getContentType();
                    if (StringUtils.contains((CharSequence)contentType, (CharSequence)"image/")) {
                        try (InputStream is = fi.getInputStream();
                             FileOutputStream os = new FileOutputStream(new File(uploadFolder, fileName));){
                            IOUtils.copy((InputStream)is, (OutputStream)os);
                        }
                        String logoVersion = this.configService.updateSystemImageVersion(type);
                        WebUtils.setSessionAttribute((HttpServletRequest)request, (String)"sysLogoVersion", (Object)logoVersion);
                        return "<script>window.parent.uploadSuccess('" + this.getMessageSource().getMessage(MSG_ALERT_UPLOAD_SUCCESS, null, locale) + "')</script>";
                    }
                    return "<script>window.parent.showUploadMessage('" + this.getMessageSource().getMessage(MSG_ALERT_UPLOAD_FILE_TYPE_MISMATCH, null, locale) + "')</script>";
                }
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("upload error", (Throwable)e);
                }
                if (!(e instanceof FileUploadBase.FileSizeLimitExceededException)) break block30;
                return "<script>window.parent.showUploadMessage('" + this.getMessageSource().getMessage(MSG_ALERT_UPLOAD_FILE_SIZE_LIMIT_EXCEEDED, (Object[])new String[]{FormatUtil.formatFileSize((Long)fileSize)}, locale) + "')</script>";
            }
        }
        return "<script>window.parent.showUploadMessage('" + this.getMessageSource().getMessage(MSG_ALERT_UPLOAD_ERROR, null, locale) + "')</script>";
    }
}

