/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers.sys;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.TokenException;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.Prompt;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.IPromptService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/prompt", "/api/sys/prompt"})
public class PromptController
extends BaseController {
    @Autowired
    private IPromptService promptService;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData query(HttpServletRequest request, Prompt prompt, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.promptService.select(iRequest, (Object)prompt, page, pagesize));
    }

    @PostMapping(value={"/submit"})
    public ResponseData submit(@RequestBody List<Prompt> prompts, BindingResult result, HttpServletRequest request) throws TokenException {
        this.checkToken(request, prompts);
        this.getValidator().validate(prompts, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.promptService.submit(requestCtx, prompts));
    }

    @PostMapping(value={"/remove"})
    public ResponseData remove(HttpServletRequest request, @RequestBody List<Prompt> prompts) throws TokenException {
        this.checkToken(request, prompts);
        IRequest requestCtx = this.createRequestContext(request);
        this.promptService.submit(requestCtx, prompts);
        return new ResponseData();
    }
}

