/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers.sys;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.Profile;
import com.hand.hap.system.dto.ProfileValue;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.IProfileService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys", "/api/sys"})
public class ProfileController
extends BaseController {
    @Autowired
    private IProfileService profileService;

    @RequestMapping(value={"/profile/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData query(Profile profile, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        return new ResponseData(this.profileService.selectProfiles(profile, page, pagesize));
    }

    @RequestMapping(value={"/profilevalue/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData queryProfileValues(ProfileValue value) {
        return new ResponseData(this.profileService.selectProfileValues(value));
    }

    @RequestMapping(value={"/profilevalue/querylevelvalues"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData queryLevelValues(ProfileValue value, Long levelId, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        return new ResponseData(this.profileService.selectLevelValues(value, levelId, page, pagesize));
    }

    @PostMapping(value={"/profile/submit"})
    public ResponseData submit(@RequestBody List<Profile> profiles, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(profiles, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.profileService.batchUpdate(requestContext, profiles));
    }

    @PostMapping(value={"/profile/remove"})
    public ResponseData remove(@RequestBody List<Profile> profiles, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        this.profileService.batchDelete(requestContext, profiles);
        return new ResponseData();
    }

    @PostMapping(value={"/profilevalue/remove"})
    public ResponseData removeProfileValues(@RequestBody List<ProfileValue> profileValues, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        this.profileService.batchDeleteValues(requestContext, profileValues);
        return new ResponseData();
    }
}

