/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers.sys;

import com.hand.hap.cache.impl.LovCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.mybatis.util.SqlMapper;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.Lov;
import com.hand.hap.system.dto.ParameterConfig;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.ICodeService;
import com.hand.hap.system.service.ILovService;
import com.hand.hap.system.service.IParameterConfigService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/parameter/config", "/api/sys/parameter/config"})
public class ParameterConfigController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(ParameterConfigController.class);
    private static final String UPPER_VALUE = "VALUE";
    private static final String LOWER_VALUE = "value";
    private static final String UPPER_TEXT = "TEXT";
    private static final String LOWER_TEXT = "text";
    @Autowired
    private ILovService commonLovService;
    @Autowired
    private LovCache lovCache;
    @Autowired
    private ICodeService codeService;
    @Autowired
    @Qualifier(value="sqlSessionFactory")
    private SqlSessionFactory sqlSessionFactory;
    @Autowired
    private IParameterConfigService parameterConfigService;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData query(HttpServletRequest request, @RequestParam(required=false) String code, @RequestParam(required=false) Long targetId) {
        IRequest iRequest = RequestHelper.createServiceRequest((HttpServletRequest)request);
        return new ResponseData(this.parameterConfigService.selectByCodeAndTargetId(code, targetId));
    }

    @PostMapping(value={"/submit"})
    public ResponseData update(@RequestBody List<ParameterConfig> parameterConfigs, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(parameterConfigs, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.parameterConfigService.batchUpdate(requestCtx, parameterConfigs));
    }

    @PostMapping(value={"/remove"})
    public ResponseData delete(HttpServletRequest request, @RequestBody List<ParameterConfig> parameterConfigs) {
        this.parameterConfigService.batchDelete(parameterConfigs);
        return new ResponseData();
    }

    @RequestMapping(value={"/getLov"})
    public ResponseData getLov(HttpServletRequest request, @RequestParam(required=false) String sourceCode) throws IOException {
        IRequest requestContext = this.createRequestContext(request);
        Lov lov = this.lovCache.getValue(sourceCode);
        if (null != lov) {
            JSONArray lovData;
            String textField = lov.getTextField();
            String valueField = lov.getValueField();
            if (StringUtils.isNotEmpty((CharSequence)lov.getCustomUrl())) {
                Cookie[] cookies = request.getCookies();
                StringBuilder sb = new StringBuilder();
                for (Cookie cookie : cookies) {
                    sb.append(cookie.getName()).append("=").append(cookie.getValue()).append(";");
                }
                String cookieValue = sb.toString();
                CloseableHttpClient httpclient = HttpClients.createDefault();
                String path = request.getContextPath();
                String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
                HttpGet httpget = new HttpGet(basePath + lov.getCustomUrl());
                httpget.addHeader((Header)new BasicHeader("Cookie", cookieValue));
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);
                HttpEntity entity = response.getEntity();
                JSONObject jsonObject = JSONObject.fromObject((Object)EntityUtils.toString((HttpEntity)entity));
                String rows = String.valueOf(jsonObject.get("rows"));
                lovData = JSONArray.fromObject((Object)rows);
            } else {
                List data = this.commonLovService.selectDatas(requestContext, sourceCode, null, 1, 0);
                if (CollectionUtils.isNotEmpty((Collection)data) && data.get(0) instanceof HashMap) {
                    for (int index = 0; index < data.size(); ++index) {
                        Map map = (Map)data.get(index);
                        map.put("valueField", map.get(valueField));
                        map.put("textField", map.get(textField));
                    }
                    return new ResponseData(data);
                }
                lovData = JSONArray.fromObject((Object)data);
            }
            for (int i = 0; i < lovData.size(); ++i) {
                JSONObject jsonObject = (JSONObject)lovData.get(i);
                jsonObject.put((Object)"valueField", jsonObject.get(valueField));
                jsonObject.put((Object)"textField", jsonObject.get(textField));
                this.initAttribute(jsonObject);
            }
            return new ResponseData((List)lovData);
        }
        return new ResponseData();
    }

    @RequestMapping(value={"/getCode"})
    public ResponseData getCode(HttpServletRequest request, @RequestParam(required=false) String sourceCode, @RequestParam(required=false) String codeValueField) {
        List enabledCodeValues = this.codeService.getCodeValuesByCode(this.createRequestContext(request), sourceCode);
        JSONArray codeData = new JSONArray();
        if (StringUtils.isEmpty((CharSequence)codeValueField)) {
            codeValueField = "codeValueId";
        }
        if (CollectionUtils.isNotEmpty((Collection)enabledCodeValues)) {
            codeData = JSONArray.fromObject((Object)enabledCodeValues);
            int size = codeData.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = (JSONObject)codeData.get(i);
                jsonObject.put((Object)"valueField", jsonObject.get(codeValueField));
                jsonObject.put((Object)"textField", jsonObject.get("meaning"));
                this.initAttribute(jsonObject);
            }
        }
        return new ResponseData((List)codeData);
    }

    @RequestMapping(value={"/queryReportParameter"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData queryByReportCode(HttpServletRequest request, @RequestParam(required=false) String reportCode) {
        IRequest iRequest = this.createRequestContext(request);
        List parameterConfigs = this.parameterConfigService.selectByReportCode(reportCode);
        return this.parseParameter(iRequest, parameterConfigs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/checkDefaultValue"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData checkDefaultValue(HttpServletRequest request, @RequestBody String sql) {
        ResponseData responseData = null;
        if (!StringUtils.isNotEmpty((CharSequence)sql)) return responseData;
        IRequest requestContext = this.createRequestContext(request);
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            responseData = new ResponseData();
            Map result = this.getValueAndText(requestContext, sqlSession, sql);
            responseData.setMessage("\u9ed8\u8ba4Value: " + (String)result.get("defaultValue") + "<br><br>\u9ed8\u8ba4Text: " + (String)result.get("defaultText"));
            ResponseData responseData2 = responseData;
            return responseData2;
        }
        catch (Throwable e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getMessage(), e);
            }
            responseData = new ResponseData(false);
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    private void initAttribute(JSONObject jsonObject) {
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = jsonObject.get(key);
            if (!value.equals("null")) continue;
            jsonObject.replace((Object)key, (Object)"");
        }
    }

    private ResponseData parseParameter(IRequest request, List<ParameterConfig> parameterConfigs) {
        if (CollectionUtils.isNotEmpty(parameterConfigs)) {
            for (ParameterConfig parameterConfig : parameterConfigs) {
                if ("sql".equalsIgnoreCase(parameterConfig.getDefaultType()) && StringUtils.isNotEmpty((CharSequence)parameterConfig.getDefaultValue())) {
                    try {
                        SqlSession sqlSession = this.sqlSessionFactory.openSession();
                        Throwable throwable = null;
                        try {
                            Map result = this.getValueAndText(request, sqlSession, parameterConfig.getDefaultValue());
                            parameterConfig.setDefaultText((String)result.get("defaultText"));
                            parameterConfig.setDefaultValue((String)result.get("defaultValue"));
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (sqlSession == null) continue;
                            if (throwable != null) {
                                try {
                                    sqlSession.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            sqlSession.close();
                            continue;
                        }
                    }
                    catch (Throwable e) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error(e.getMessage(), e);
                        }
                        ResponseData responseData = new ResponseData(false);
                        responseData.setMessage("\u53c2\u6570[" + parameterConfig.getTableFieldName() + "]  \u9ed8\u8ba4\u503csql\u51fa\u9519:<br><br>" + e.getMessage());
                        return responseData;
                    }
                }
                if (!"currentDate".equalsIgnoreCase(parameterConfig.getDefaultType())) continue;
                Date today = new Date();
                parameterConfig.setDefaultValue(new SimpleDateFormat("yyyy-MM-dd").format(today));
            }
        }
        return new ResponseData(parameterConfigs);
    }

    private Map<String, String> getValueAndText(IRequest request, SqlSession sqlSession, String sql) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        SqlMapper sqlMapper = new SqlMapper(sqlSession);
        List results = sqlMapper.selectList("<script>\n\t" + sql + "</script>", (Object)request, HashMap.class);
        String defaultValue = "";
        String defaultText = "";
        if (results.size() == 1) {
            defaultValue = this.getValue((HashMap)results.get(0));
            defaultText = this.getText((HashMap)results.get(0));
        } else if (results.size() > 1) {
            for (HashMap map : results) {
                defaultValue = defaultValue + this.getValue(map) + ",";
            }
        }
        result.put("defaultValue", defaultValue);
        result.put("defaultText", defaultText);
        return result;
    }

    private String getValue(HashMap map) {
        if (null == map.get(UPPER_VALUE) && null == map.get(LOWER_VALUE)) {
            return "";
        }
        if (map.get(UPPER_VALUE) != null) {
            return map.get(UPPER_VALUE).toString();
        }
        if (map.get(LOWER_VALUE) != null) {
            return map.get(LOWER_VALUE).toString();
        }
        return "";
    }

    private String getText(HashMap map) {
        if (null == map.get(UPPER_TEXT) && null == map.get(LOWER_TEXT)) {
            return "";
        }
        if (map.get(UPPER_TEXT) != null) {
            return map.get(UPPER_TEXT).toString();
        }
        if (map.get(LOWER_TEXT) != null) {
            return map.get(LOWER_TEXT).toString();
        }
        return "";
    }
}

