/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers.sys;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.TokenException;
import com.hand.hap.excel.annotation.ExcelExport;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.Code;
import com.hand.hap.system.dto.CodeValue;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.ICodeService;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys", "/api/sys"})
public class CodeController
extends BaseController {
    @Autowired
    private ICodeService codeService;

    @RequestMapping(value={"/code/query"})
    @ExcelExport(table=Code.class)
    @ResponseBody
    public ResponseData getCodes(Code code, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, HttpServletRequest request, HttpServletResponse httpServletResponse) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.codeService.selectCodes(requestContext, code, page, pagesize));
    }

    @RequestMapping(value={"/codevalue/query"})
    @ResponseBody
    public ResponseData getCodeValues(CodeValue value, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.codeService.selectCodeValues(requestContext, value));
    }

    @RequestMapping(value={"/code/remove"}, method={RequestMethod.POST})
    public ResponseData removeCodes(@RequestBody List<Code> codes, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        this.codeService.batchDelete(requestContext, codes);
        return new ResponseData();
    }

    @RequestMapping(value={"/codevalue/remove"}, method={RequestMethod.POST})
    public ResponseData removeValues(@RequestBody List<CodeValue> values, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        this.codeService.batchDeleteValues(requestContext, values);
        return new ResponseData();
    }

    @RequestMapping(value={"/code/submit"}, method={RequestMethod.POST})
    public ResponseData submitCode(@RequestBody List<Code> codes, BindingResult result, HttpServletRequest request) throws TokenException {
        this.checkToken(request, codes);
        this.getValidator().validate(codes, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.codeService.batchUpdate(requestContext, codes));
    }

    @RequestMapping(value={"/code/queryChildCodeValue"})
    @ResponseBody
    public ResponseData getChildCodes(@RequestParam String parentCode, @RequestParam String value, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.codeService.getChildCodeValue(requestContext, parentCode, value));
    }

    @RequestMapping(value={"/code/getCodeValueById"})
    @ResponseBody
    public ResponseData getCodeValueById(@RequestBody CodeValue codeValue, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(Arrays.asList(this.codeService.getCodeValueById(codeValue.getCodeValueId())));
    }
}

