/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheManager;
import com.hand.hap.cache.impl.HotkeyCache;
import com.hand.hap.core.ILanguageProvider;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.DefaultTlTableNameProvider;
import com.hand.hap.core.util.RequestUtil;
import com.hand.hap.message.components.DefaultPromptListener;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.controllers.CommonController;
import com.hand.hap.system.dto.CodeValue;
import com.hand.hap.system.dto.DTOClassInfo;
import com.hand.hap.system.dto.Hotkey;
import com.hand.hap.system.dto.Prompt;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.mapper.MultiLanguageMapper;
import com.hand.hap.system.service.ICodeService;
import com.hand.hap.system.service.ILovService;
import com.hand.hap.system.service.IProfileService;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Table;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

@RestController
public class CommonController
extends BaseController {
    private Logger logger = LoggerFactory.getLogger(CommonController.class);
    @Autowired
    private MultiLanguageMapper multiLanguageMapper;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private DefaultPromptListener promptListener;
    @Autowired
    private ILanguageProvider languageProvider;
    @Autowired
    private ILovService commonLovService;
    @Autowired
    private IProfileService profileService;
    @Autowired
    private ICodeService codeService;
    public static final String PROMPTS = "prompts";
    public static final String LANGUAGE = "language";
    public static final String HOTKEY = "hotkey";
    public static final String CODE = "code";
    public static final String CTRL = "Ctrl";
    public static final String ALT = "Alt";
    public static final String SHIFT = "Shift";

    @RequestMapping(value={"/common/{resource}"}, produces={"application/javascript;charset=utf8"})
    @ResponseBody
    public String getCommonData(@PathVariable String resource, @RequestParam Map<String, String> params, HttpServletRequest request) throws JsonProcessingException {
        StringBuilder sb = new StringBuilder();
        if (PROMPTS.equalsIgnoreCase(resource)) {
            Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
            String lang = locale == null ? null : locale.toString();
            return this.getCommonPrompts(lang);
        }
        if (CODE.equalsIgnoreCase(resource)) {
            params.forEach((k, v) -> {
                block4: {
                    List enabledCodeValues = this.codeService.getCodeValuesByCode(this.createRequestContext(request), v);
                    try {
                        if (enabledCodeValues == null) {
                            this.toJson(sb, k, Collections.emptyList());
                        } else {
                            this.toJson(sb, k, (Object)enabledCodeValues);
                        }
                        sb.append("\n");
                    }
                    catch (JsonProcessingException e) {
                        if (!this.logger.isErrorEnabled()) break block4;
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        } else if (LANGUAGE.equalsIgnoreCase(resource)) {
            List data = this.languageProvider.getSupportedLanguages();
            String var = params.get("var");
            this.toJson(sb, var, (Object)data);
        } else if (HOTKEY.equalsIgnoreCase(resource)) {
            IRequest iRequest = this.createRequestContext(request);
            Cache cache = this.cacheManager.getCache(resource);
            List data = this.getCommonHotkeys(iRequest, (HotkeyCache)cache);
            this.toJson(sb, "hotKeys", (Object)data);
        }
        return sb.toString();
    }

    @RequestMapping(value={"sys/sys_multilanguage_editor.html"})
    public ModelAndView loadMultiLanguageFields(HttpServletRequest request, @RequestParam String id, @RequestParam String dto, @RequestParam String field) {
        ModelAndView view;
        block5: {
            view = new ModelAndView(this.getViewPath() + "/sys/sys_multilanguage_editor");
            if (StringUtils.isNotEmpty((String)id) && StringUtils.isNotEmpty((String)dto) && StringUtils.isNotEmpty((String)field)) {
                try {
                    Class<?> clazz = Class.forName(dto);
                    Table table = clazz.getAnnotation(Table.class);
                    EntityField idField = DTOClassInfo.getIdFields(clazz)[0];
                    EntityField tlField = DTOClassInfo.getEntityField(clazz, (String)field);
                    if (table != null && idField != null && tlField != null) {
                        HashMap<String, String> map = new HashMap<String, String>(4);
                        map.put("table", DefaultTlTableNameProvider.getInstance().getTlTableName(table.name()));
                        map.put("idName", DTOClassInfo.getColumnName((EntityField)idField));
                        map.put("tlName", DTOClassInfo.getColumnName((EntityField)tlField));
                        map.put("id", id);
                        List list = this.multiLanguageMapper.select(map);
                        view.addObject("list", (Object)list);
                    }
                    break block5;
                }
                catch (Exception e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    break block5;
                }
            }
            List list = this.languageProvider.getSupportedLanguages();
            list.sort((a, b) -> a.getLangCode().compareTo(b.getLangCode()));
            view.addObject("list", (Object)list);
        }
        return view;
    }

    @RequestMapping(value={"/sys/multiLanguage"}, method={RequestMethod.GET})
    public Map<String, Object> loadMultiLanguageFields2(HttpServletRequest request, @RequestParam String id, @RequestParam String dto, @RequestParam String field) {
        HashMap<String, Object> result;
        block5: {
            result = new HashMap<String, Object>(1);
            if (StringUtils.isNotEmpty((String)id) && StringUtils.isNotEmpty((String)dto) && StringUtils.isNotEmpty((String)field)) {
                try {
                    Class<?> clazz = Class.forName(dto);
                    Table table = clazz.getAnnotation(Table.class);
                    EntityField idField = DTOClassInfo.getIdFields(clazz)[0];
                    EntityField tlField = DTOClassInfo.getEntityField(clazz, (String)field);
                    if (table != null && idField != null && tlField != null) {
                        HashMap<String, String> map = new HashMap<String, String>(4);
                        map.put("table", DefaultTlTableNameProvider.getInstance().getTlTableName(table.name()));
                        map.put("idName", DTOClassInfo.getColumnName((EntityField)idField));
                        map.put("tlName", DTOClassInfo.getColumnName((EntityField)tlField));
                        map.put("id", id);
                        result.put("multiLanguages", this.multiLanguageMapper.select(map));
                    }
                    break block5;
                }
                catch (Exception e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    break block5;
                }
            }
            List list = this.languageProvider.getSupportedLanguages();
            list.sort((a, b) -> a.getLangCode().compareTo(b.getLangCode()));
            result.put("multiLanguages", list);
        }
        return result;
    }

    @RequestMapping(value={"/common/profile"}, produces={"application/javascript;charset=utf8"})
    @ResponseBody
    public String getProfile(@RequestParam Map<String, String> params, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        StringBuilder sb = new StringBuilder();
        params.forEach((k, v) -> {
            block2: {
                String value = this.profileService.getProfileValue(requestContext, v);
                try {
                    this.toJson(sb, k, (Object)value);
                    sb.append("\n");
                }
                catch (JsonProcessingException e) {
                    if (!this.logger.isErrorEnabled()) break block2;
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        return sb.toString();
    }

    @RequestMapping(value={"/timeout"})
    public Object sessionTimeout(HttpServletRequest request, HttpServletResponse response) {
        if (RequestUtil.isAjaxRequest((HttpServletRequest)request)) {
            ResponseData res = new ResponseData(false);
            res.setCode("sys_session_timeout");
            return res;
        }
        return new ModelAndView("timeout");
    }

    @RequestMapping(value={"/common/code/{code}/"})
    @ResponseBody
    public List<CodeValue> getCommonCode(@PathVariable String code, HttpServletRequest request) throws JsonProcessingException {
        return this.codeService.getCodeValuesByCode(this.createRequestContext(request), code);
    }

    @RequestMapping(value={"/common/lov/{id}"})
    @ResponseBody
    public ResponseData getLovDatas(@PathVariable String id, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, @RequestParam Map<String, String> params, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.commonLovService.selectDatas(requestContext, id, params, page, pagesize));
    }

    @RequestMapping(value={"/access-denied"})
    public Object accessDenied(HttpServletRequest request, HttpServletResponse response) {
        if (request.getSession(false) == null) {
            return this.sessionTimeout(request, response);
        }
        if (RequestUtil.isAjaxRequest((HttpServletRequest)request)) {
            ResponseData res = new ResponseData(false);
            res.setCode("sys_access_denied");
            return res;
        }
        return new ModelAndView("403");
    }

    @RequestMapping(value={"/kendo/export"}, method={RequestMethod.POST})
    @ResponseBody
    public void save(String fileName, String base64, String contentType, HttpServletResponse response) throws IOException {
        response.setHeader("Content-Disposition", "attachment;filename*=UTF-8''" + URLEncoder.encode(fileName, "UTF-8"));
        response.setContentType(contentType);
        byte[] data = DatatypeConverter.parseBase64Binary((String)base64);
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
        response.flushBuffer();
    }

    @RequestMapping(value={"/{folder1}/{name}.html", "/{folder1}/{name}.view"})
    public ModelAndView renderFolder1View(@PathVariable String folder1, @PathVariable String name, Model model) {
        return new ModelAndView(this.getViewPath() + "/" + folder1 + "/" + name);
    }

    @RequestMapping(value={"/{folder1}/{folder2}/{name}.html", "/{folder1}/{folder2}/{name}.view"})
    public ModelAndView renderFolder2View(@PathVariable String folder1, @PathVariable String folder2, @PathVariable String name, Model model) {
        return new ModelAndView(this.getViewPath() + "/" + folder1 + "/" + folder2 + "/" + name);
    }

    @RequestMapping(value={"/{folder1}/{folder2}/{folder3}/{name}.html", "/{folder1}/{folder2}/{folder3}/{name}.view"})
    public ModelAndView renderFolder3View(@PathVariable String folder1, @PathVariable String folder2, @PathVariable String folder3, @PathVariable String name, Model model) {
        return new ModelAndView(this.getViewPath() + "/" + folder1 + "/" + folder2 + "/" + folder3 + "/" + name);
    }

    @RequestMapping(value={"/{folder1}/{folder2}/{folder3}/{folder4}/{name}.html", "/{folder1}/{folder2}/{folder3}/{folder4}/{name}.view"})
    public ModelAndView renderFolder4View(@PathVariable String folder1, @PathVariable String folder2, @PathVariable String folder3, @PathVariable String folder4, @PathVariable String name, Model model) {
        return new ModelAndView(this.getViewPath() + "/" + folder1 + "/" + folder2 + "/" + folder3 + "/" + folder4 + "/" + name);
    }

    @RequestMapping(value={"/{name}.html", "/{name}.view"})
    public ModelAndView renderView(@PathVariable String name, Model model) {
        return new ModelAndView(name);
    }

    private HotkeyData getHotkeyData(Hotkey hotkey) {
        HotkeyData hotkeyData = new HotkeyData(this, null);
        HotkeyValue hotkeyValue = new HotkeyValue(this, null);
        String key = hotkey.getHotkey();
        hotkeyData.setCode(hotkey.getCode());
        hotkeyData.setHotkey(hotkeyValue.initValue(key, hotkeyValue));
        return hotkeyData;
    }

    private List<HotkeyData> getCommonHotkeys(IRequest iRequest, HotkeyCache cache) {
        HashMap<String, HotkeyData> hotkeyDatas = new HashMap<String, HotkeyData>(2);
        ArrayList<HotkeyData> data = new ArrayList<HotkeyData>();
        Hotkey[] hotkeysSys = cache.getValue("system_0");
        Hotkey[] hotkeyUser = cache.getValue("user_" + iRequest.getUserId());
        if (hotkeysSys != null) {
            for (Hotkey hotkey : hotkeysSys) {
                hotkeyDatas.put(hotkey.getCode(), this.getHotkeyData(hotkey));
            }
        }
        if (hotkeyUser != null) {
            for (Hotkey hotkey : hotkeyUser) {
                HotkeyData value = (HotkeyData)hotkeyDatas.get(hotkey.getCode());
                if (value == null) continue;
                hotkeyDatas.put(hotkey.getCode(), this.getHotkeyData(hotkey));
            }
        }
        data.addAll(hotkeyDatas.values());
        return data;
    }

    private String getCommonPrompts(String lang) {
        List list = this.promptListener.getDefaultPrompt(lang);
        if (list == null) {
            return "//null";
        }
        StringBuilder sb = new StringBuilder();
        for (Prompt prompt : list) {
            sb.append("$l('").append(prompt.getPromptCode().toLowerCase()).append("','").append(prompt.getDescription()).append("');\n");
        }
        sb.append("//").append(list.size());
        return sb.toString();
    }

    private void toJson(StringBuilder sb, String var, Object data) throws JsonProcessingException {
        boolean hasVar;
        boolean bl = hasVar = var != null && var.length() > 0;
        if (hasVar) {
            sb.append("var ").append(var).append('=');
        }
        sb.append(this.objectMapper.writeValueAsString(data));
        if (hasVar) {
            sb.append(';');
        }
    }

    @PostMapping(value={"/common/generator/uuid"})
    public String generatorUUID() {
        return UUID.randomUUID().toString();
    }
}

