/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.permission;

import com.github.pagehelper.SqlUtil;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.components.ApplicationContextHelper;
import com.hand.hap.security.permission.dto.Limit;
import com.hand.hap.security.permission.service.impl.DataPermissionParameterMappingTokenHandler;
import com.hand.hap.security.permission.service.impl.DataPermissionRangeFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataPermissionUtil {
    private static Logger logger = LoggerFactory.getLogger(DataPermissionUtil.class);
    static Map<String, DataPermissionRangeFilter> rangeFilter = ApplicationContextHelper.getApplicationContext().getBeansOfType(DataPermissionRangeFilter.class);

    public static String getNewSql(String oldSql, IRequest request) {
        Select select;
        if (null == request || request.getUserId().toString().equals("-1") || request.getAllRoleId().length == 0) {
            return oldSql;
        }
        try {
            select = (Select)CCJSqlParserUtil.parse((String)oldSql);
        }
        catch (Exception e) {
            logger.error("Parse SQL Error,Skip DATA_PERMISSION", (Throwable)e);
            return oldSql;
        }
        try {
            DataPermissionUtil.analysisSql((SelectBody)select.getSelectBody(), (IRequest)request, (String)oldSql);
        }
        catch (Exception e) {
            logger.error("Create New SQL Error,Skip DATA_PERMISSION", (Throwable)e);
            return oldSql;
        }
        net.sf.jsqlparser.statement.select.Limit mit = null;
        if (select.getSelectBody() instanceof SetOperationList) {
            mit = ((SetOperationList)select.getSelectBody()).getLimit();
            if (mit != null) {
                Limit limit = new Limit(mit);
                ((SetOperationList)select.getSelectBody()).setLimit((net.sf.jsqlparser.statement.select.Limit)limit);
            }
        } else if (select.getSelectBody() instanceof PlainSelect && (mit = ((PlainSelect)select.getSelectBody()).getLimit()) != null) {
            Limit limit = new Limit(mit);
            ((PlainSelect)select.getSelectBody()).setLimit((net.sf.jsqlparser.statement.select.Limit)limit);
        }
        return select.toString();
    }

    private static void analysisSql(SelectBody selectBody, IRequest request, String oldSql) throws ExecutionException, JSQLParserException {
        if (selectBody instanceof PlainSelect) {
            DataPermissionUtil.parserSql((PlainSelect)((PlainSelect)selectBody), (IRequest)request, (String)oldSql);
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList list = (SetOperationList)selectBody;
            for (int i = 0; i < list.getSelects().size(); ++i) {
                DataPermissionUtil.parserSql((PlainSelect)((PlainSelect)list.getSelects().get(i)), (IRequest)request, (String)oldSql);
            }
        }
    }

    private static void parserSql(PlainSelect select, IRequest request, String oldSql) throws ExecutionException, JSQLParserException {
        List joins;
        FromItem fromItem = select.getFromItem();
        if (fromItem instanceof SubSelect) {
            DataPermissionUtil.analysisSql((SelectBody)((SubSelect)fromItem).getSelectBody(), (IRequest)request, (String)oldSql);
        }
        if (null != (joins = select.getJoins())) {
            for (Join join : joins) {
                if (!(join.getRightItem() instanceof SubSelect)) continue;
                DataPermissionUtil.analysisSql((SelectBody)((SubSelect)join.getRightItem()).getSelectBody(), (IRequest)request, (String)oldSql);
            }
        }
        DataPermissionUtil.doParserSql((PlainSelect)select, (IRequest)request, (String)oldSql);
    }

    private static void doParserSql(PlainSelect select, IRequest request, String oldSql) throws ExecutionException, JSQLParserException {
        List joins;
        SubSelect subSelect;
        FromItem fromItem = select.getFromItem();
        if (fromItem instanceof Table && null != (subSelect = DataPermissionUtil.getTableView((Table)((Table)fromItem), (IRequest)request, (String)oldSql))) {
            select.setFromItem((FromItem)subSelect);
        }
        if (null != (joins = select.getJoins())) {
            for (Join join : joins) {
                SubSelect subSelect2;
                if (!(join.getRightItem() instanceof Table) || null == (subSelect2 = DataPermissionUtil.getTableView((Table)((Table)join.getRightItem()), (IRequest)request, (String)oldSql))) continue;
                join.setRightItem((FromItem)subSelect2);
            }
        }
    }

    private static void parseWhere(Expression expression, IRequest request, String oldSql) throws ExecutionException, JSQLParserException {
        if (null == expression) {
            return;
        }
        if (expression instanceof BinaryExpression) {
            Expression rightExp = ((BinaryExpression)expression).getRightExpression();
            Expression leftExp = ((BinaryExpression)expression).getLeftExpression();
            DataPermissionUtil.parseWhere((Expression)rightExp, (IRequest)request, (String)oldSql);
            DataPermissionUtil.parseWhere((Expression)leftExp, (IRequest)request, (String)oldSql);
        } else if (expression instanceof InExpression) {
            InExpression inExpression = (InExpression)expression;
            if (null != inExpression.getRightItemsList() && inExpression.getRightItemsList() instanceof SubSelect) {
                DataPermissionUtil.parseWhere((Expression)((SubSelect)inExpression.getRightItemsList()), (IRequest)request, (String)oldSql);
            }
        } else if (expression instanceof SubSelect) {
            DataPermissionUtil.parserSql((PlainSelect)((PlainSelect)((SubSelect)expression).getSelectBody()), (IRequest)request, (String)oldSql);
        }
    }

    private static SubSelect getTableView(Table table, IRequest request, String oldSql) throws JSQLParserException, ExecutionException {
        HashMap map = new HashMap();
        SqlUtil.addPermissionTable((String)oldSql, (String)table.getName().toUpperCase());
        for (Map.Entry entry : rangeFilter.entrySet()) {
            ((DataPermissionRangeFilter)entry.getValue()).doFilter(request, table.getName(), map);
        }
        if (map.size() == 0) {
            return null;
        }
        PlainSelect plainSelect = (PlainSelect)DataPermissionUtil.createTableView(map, (String)table.getName(), (IRequest)request).getSelectBody();
        SubSelect tableView = new SubSelect();
        tableView.setSelectBody((SelectBody)plainSelect);
        if (null != table.getAlias()) {
            tableView.setAlias(table.getAlias());
        } else {
            Alias alias = new Alias(table.getName());
            alias.setUseAs(false);
            tableView.setAlias(alias);
        }
        return tableView;
    }

    private static Select createTableView(Map<String, Set> map, String tableName, IRequest iRequest) throws JSQLParserException {
        String newSql = "SELECT * FROM " + tableName + " WHERE ";
        for (Map.Entry<String, Set> mapEntry : map.entrySet()) {
            int i;
            String[] iSet;
            String in;
            Set inSet = mapEntry.getValue();
            String columnField = mapEntry.getKey();
            if (inSet.size() == 0) continue;
            if (!columnField.equals("_PERMISSION_CUSTOM_SQL")) {
                if (inSet.size() == 1) {
                    newSql = newSql + columnField + " = '" + inSet.toArray()[0].toString() + "'";
                } else {
                    in = "";
                    iSet = inSet.toArray(new String[inSet.size()]);
                    for (i = 0; i < iSet.length; ++i) {
                        in = in + "'" + iSet[i] + "'";
                        if (i == iSet.length - 1) continue;
                        in = in + ",";
                    }
                    newSql = newSql + columnField + " in ( " + in + " )";
                }
            } else {
                in = "";
                iSet = inSet.toArray(new String[inSet.size()]);
                for (i = 0; i < iSet.length; ++i) {
                    in = in + " ( " + DataPermissionUtil.addCriteriaIfDynamicSql((String)iSet[i], (IRequest)iRequest) + " ) ";
                    if (i == iSet.length - 1) continue;
                    in = in + " and ";
                }
                newSql = newSql + in;
            }
            newSql = newSql + " and ";
        }
        newSql = newSql.substring(0, newSql.length() - 5);
        return (Select)CCJSqlParserUtil.parse((String)newSql);
    }

    private static String addCriteriaIfDynamicSql(String oldSql, IRequest iRequest) {
        DataPermissionParameterMappingTokenHandler handler = new DataPermissionParameterMappingTokenHandler(iRequest);
        GenericTokenParser parser = new GenericTokenParser("#{", "}", (TokenHandler)handler);
        return parser.parse(oldSql);
    }
}

