/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.dto;

import java.io.Serializable;
import java.util.Set;

public class User
implements Serializable {
    private static final long serialVersionUID = 8517761026555775283L;
    private String userName;
    private String password;
    private boolean enabled;
    private Set<String> roles;

    public User(String userName, String password, boolean enabled, Set<String> roles) {
        this.userName = userName;
        this.password = password;
        this.enabled = enabled;
        this.roles = roles;
    }

    public User(String userName, String password, Set<String> roles) {
        this(userName, password, true, roles);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public int hashCode() {
        return this.userName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof User) {
            return this.userName.equals(((User)obj).userName);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(": ");
        sb.append("Username: ").append(this.userName).append("; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Enabled: ").append(this.enabled).append("; ");
        if (!this.roles.isEmpty()) {
            sb.append("Granted Authorities: ");
            boolean first = true;
            for (String role : this.roles) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(role);
            }
        } else {
            sb.append("\u8be5\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u7684\u6388\u6743");
        }
        return sb.toString();
    }
}

