/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.crypto.encrypt;

import com.hand.hap.security.crypto.encrypt.BytesEncryptor;
import com.hand.hap.security.crypto.encrypt.CipherUtils;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.keygen.BytesKeyGenerator;
import org.springframework.security.crypto.util.EncodingUtils;

final class AesBytesEncryptor
implements BytesEncryptor {
    private final SecretKey secretKey;
    private final Cipher encryptor;
    private final Cipher decryptor;
    private final BytesKeyGenerator ivGenerator;
    private static final String AES_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String KEY_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final int DEFAULT_KEY_SIZE = 128;
    private static final BytesKeyGenerator NULL_IV_GENERATOR = new /* Unavailable Anonymous Inner Class!! */;

    AesBytesEncryptor(String password, CharSequence salt) {
        this(password, salt, null, 128);
    }

    AesBytesEncryptor(String password, CharSequence salt, int keysize) {
        this(password, salt, null, keysize);
    }

    AesBytesEncryptor(String password, CharSequence salt, BytesKeyGenerator ivGenerator) {
        this(password, salt, ivGenerator, 128);
    }

    AesBytesEncryptor(String password, CharSequence salt, BytesKeyGenerator ivGenerator, int keysize) {
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), Hex.decode((CharSequence)salt), 1024, keysize);
        SecretKey secretKey = CipherUtils.newSecretKey((String)KEY_ALGORITHM, (PBEKeySpec)keySpec);
        this.secretKey = new SecretKeySpec(secretKey.getEncoded(), "AES");
        this.encryptor = CipherUtils.newCipher((String)AES_ALGORITHM);
        this.decryptor = CipherUtils.newCipher((String)AES_ALGORITHM);
        this.ivGenerator = ivGenerator != null ? ivGenerator : NULL_IV_GENERATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] bytes) {
        Cipher cipher = this.encryptor;
        synchronized (cipher) {
            byte[] iv = this.ivGenerator.generateKey();
            CipherUtils.initCipher((Cipher)this.encryptor, (int)1, (SecretKey)this.secretKey, (AlgorithmParameterSpec)new IvParameterSpec(iv));
            byte[] encrypted = CipherUtils.doFinal((Cipher)this.encryptor, (byte[])bytes);
            return this.ivGenerator != NULL_IV_GENERATOR ? EncodingUtils.concatenate((byte[][])new byte[][]{iv, encrypted}) : encrypted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(byte[] encryptedBytes) {
        Cipher cipher = this.decryptor;
        synchronized (cipher) {
            byte[] iv = this.iv(encryptedBytes);
            CipherUtils.initCipher((Cipher)this.decryptor, (int)2, (SecretKey)this.secretKey, (AlgorithmParameterSpec)new IvParameterSpec(iv));
            return CipherUtils.doFinal((Cipher)this.decryptor, (byte[])(this.ivGenerator != NULL_IV_GENERATOR ? this.encrypted(encryptedBytes, iv.length) : encryptedBytes));
        }
    }

    private byte[] iv(byte[] encrypted) {
        return this.ivGenerator != NULL_IV_GENERATOR ? EncodingUtils.subArray((byte[])encrypted, (int)0, (int)this.ivGenerator.getKeyLength()) : NULL_IV_GENERATOR.generateKey();
    }

    private byte[] encrypted(byte[] encryptedBytes, int ivLength) {
        return EncodingUtils.subArray((byte[])encryptedBytes, (int)ivLength, (int)encryptedBytes.length);
    }
}

