/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.crypto.encrypt;

import com.hand.hap.security.crypto.encrypt.AESEncryptors;
import com.hand.hap.security.crypto.encrypt.AesBytesEncryptor;
import com.hand.hap.security.crypto.encrypt.BytesEncryptor;
import com.hand.hap.security.crypto.encrypt.HexEncodingTextEncryptor;
import com.hand.hap.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.crypto.keygen.KeyGenerators;

/*
 * Exception performing whole class analysis ignored.
 */
public class AESEncryptors {
    private String password;
    private String salt;
    private int keySize;
    private TextEncryptor textEncryptor;
    private static final TextEncryptor NO_OP_TEXT_INSTANCE = new NoOpTextEncryptor(null);

    public static TextEncryptor queryableText(CharSequence password, CharSequence salt) {
        return new HexEncodingTextEncryptor((BytesEncryptor)new AesBytesEncryptor(password.toString(), salt));
    }

    public static TextEncryptor queryableText(CharSequence password, CharSequence salt, int keysize) {
        return new HexEncodingTextEncryptor((BytesEncryptor)new AesBytesEncryptor(password.toString(), salt, keysize));
    }

    public static BytesEncryptor standard(CharSequence password, CharSequence salt) {
        return new AesBytesEncryptor(password.toString(), salt, KeyGenerators.secureRandom((int)16));
    }

    public static BytesEncryptor standard(CharSequence password, CharSequence salt, int keysize) {
        return new AesBytesEncryptor(password.toString(), salt, KeyGenerators.secureRandom((int)16), keysize);
    }

    public static TextEncryptor text(CharSequence password, CharSequence salt, int keysize) {
        return new HexEncodingTextEncryptor(AESEncryptors.standard((CharSequence)password, (CharSequence)salt, (int)keysize));
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public static void main(String[] args) {
        TextEncryptor textEncryptor = AESEncryptors.queryableText((CharSequence)"myPassword", (CharSequence)"abc12345", (int)128);
        String rawPassword = "123";
        String encodedPassword = textEncryptor.encrypt(rawPassword);
        textEncryptor = AESEncryptors.queryableText((CharSequence)"myPassword", (CharSequence)"abc12345", (int)128);
        rawPassword = textEncryptor.decrypt(encodedPassword);
        System.out.println(encodedPassword);
        System.out.println(rawPassword);
        encodedPassword = textEncryptor.encrypt(rawPassword);
        System.out.println(encodedPassword);
    }

    public static TextEncryptor noOpText() {
        return NO_OP_TEXT_INSTANCE;
    }

    public String encrypt(String text) {
        this.createTextEncryptor();
        return this.textEncryptor.encrypt(text);
    }

    public String decrypt(String encryptedText) {
        this.createTextEncryptor();
        return this.textEncryptor.decrypt(encryptedText);
    }

    private void createTextEncryptor() {
        if (this.textEncryptor == null) {
            this.textEncryptor = AESEncryptors.queryableText((CharSequence)this.password, (CharSequence)this.salt, (int)this.keySize);
        }
    }
}

