/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.captcha.impl;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import com.hand.hap.security.captcha.ICaptchaManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class DefaultCaptchaManager
implements ICaptchaManager {
    private static final String CAPTCHA_WIDTH = "120";
    private static final String CAPTCHA_HEIGHT = "50";
    private static final String CAPTCHA_CODE_COUNT = "4";
    private static final int CAPTCHA_EXPIRE = 300;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private String category = "hap:cache:captcha";
    private String captchaKeyName = "captcha_key";
    private Integer expire = 300;
    private DefaultKaptcha defaultKaptcha = new DefaultKaptcha();

    public DefaultCaptchaManager() {
        Properties properties = new Properties();
        properties.setProperty("kaptcha.image.width", CAPTCHA_WIDTH);
        properties.setProperty("kaptcha.image.height", CAPTCHA_HEIGHT);
        properties.setProperty("kaptcha.textproducer.char.length", CAPTCHA_CODE_COUNT);
        Config config = new Config(properties);
        this.defaultKaptcha.setConfig(config);
    }

    public String getCaptchaKeyName() {
        return this.captchaKeyName;
    }

    public void setCaptchaKeyName(String captchaKeyName) {
        this.captchaKeyName = captchaKeyName;
    }

    public Integer getExpire() {
        return this.expire;
    }

    public void setExpire(Integer expire) {
        this.expire = expire;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String generateCaptchaCode() {
        return this.defaultKaptcha.createText();
    }

    public String generateCaptchaKey() {
        return UUID.randomUUID().toString();
    }

    public void generateCaptcha(String captchaKey, String captchaCode, OutputStream os) throws IOException {
        this.redisTemplate.opsForValue().set((Object)(this.getCategory() + ":" + captchaKey), (Object)captchaCode, (long)this.getExpire().intValue(), TimeUnit.SECONDS);
        try (OutputStream ignored = os;){
            BufferedImage bi = this.defaultKaptcha.createImage(captchaCode);
            ImageIO.write((RenderedImage)bi, "jpeg", os);
        }
    }

    public boolean checkCaptcha(String captchaKey, String captchaCode) {
        if (captchaCode == null) {
            return false;
        }
        String key = this.getCategory() + ":" + captchaKey;
        String captchaCodeInRedis = (String)this.redisTemplate.opsForValue().get((Object)key);
        this.removeCaptcha(key);
        return captchaCode.equalsIgnoreCase(captchaCodeInRedis);
    }

    public void removeCaptcha(String key) {
        this.redisTemplate.execute(connection -> {
            connection.del((byte[][])new byte[][]{key.getBytes()});
            return null;
        });
    }
}

