/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import com.hand.hap.core.exception.TokenException;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.DTOClassInfo;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class TokenUtils {
    public static final String SECURITY_KEY = "securityKey";
    private static Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    private TokenUtils() {
    }

    public static String getSecurityKey(HttpSession session) {
        if (session == null) {
            return null;
        }
        return (String)session.getAttribute("securityKey");
    }

    public static String setSecurityKey(HttpSession session) {
        String secKey = UUID.randomUUID().toString();
        session.setAttribute("securityKey", (Object)secKey);
        return secKey;
    }

    public static String generateToken(String securityKey, BaseDTO dto) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(securityKey).append(':').append(dto.getClass().getName());
        for (EntityField f : DTOClassInfo.getIdFields(dto.getClass())) {
            try {
                stringBuilder.append(':').append(Objects.toString(PropertyUtils.getProperty((Object)dto, (String)f.getName()), ""));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return DigestUtils.md5Hex((String)stringBuilder.toString());
    }

    public static void generateAndSetToken(String securityKey, BaseDTO dto) {
        String token = TokenUtils.generateToken((String)securityKey, (BaseDTO)dto);
        dto.set_token(token);
        for (EntityField f : DTOClassInfo.getChildrenFields(dto.getClass())) {
            try {
                Object fieldValue = PropertyUtils.getProperty((Object)dto, (String)f.getName());
                if (fieldValue instanceof BaseDTO) {
                    TokenUtils.generateAndSetToken((String)securityKey, (BaseDTO)((BaseDTO)fieldValue));
                    continue;
                }
                if (!(fieldValue instanceof Collection)) continue;
                TokenUtils.generateAndSetToken((String)securityKey, (Collection)((Collection)fieldValue));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void generateAndSetToken(String securityKey, Collection<? extends BaseDTO> dtos) {
        for (BaseDTO baseDTO : dtos) {
            TokenUtils.generateAndSetToken((String)securityKey, (BaseDTO)baseDTO);
        }
    }

    public static void checkToken(String securityKey, BaseDTO dto) throws TokenException {
        String token = dto.get_token();
        if (token == null) {
            throw new TokenException("msg.error.token_not_exists", dto);
        }
        if (!token.equalsIgnoreCase(TokenUtils.generateToken((String)securityKey, (BaseDTO)dto))) {
            if (logger.isDebugEnabled()) {
                logger.debug("token check failed.token:{}, class:{}", (Object)dto.get_token(), (Object)dto.getClass().getName());
            }
            throw new TokenException(dto);
        }
        for (EntityField f : DTOClassInfo.getChildrenFields(dto.getClass())) {
            try {
                Object fieldValue = PropertyUtils.getProperty((Object)dto, (String)f.getName());
                if (fieldValue instanceof BaseDTO) {
                    TokenUtils.checkToken((String)securityKey, (BaseDTO)((BaseDTO)fieldValue));
                    continue;
                }
                if (!(fieldValue instanceof Collection)) continue;
                TokenUtils.checkToken((String)securityKey, (Collection)((Collection)fieldValue));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void checkToken(HttpSession session, BaseDTO dto) throws TokenException {
        String securityKey = TokenUtils.getSecurityKey((HttpSession)session);
        if (securityKey == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("check skipped due to securityKey not exists.");
            }
            return;
        }
        TokenUtils.checkToken((String)securityKey, (BaseDTO)dto);
    }

    public static void checkToken(String securityKey, Collection<? extends BaseDTO> baseDTOs) throws TokenException {
        if (baseDTOs != null && !baseDTOs.isEmpty()) {
            Class<?> clazz = baseDTOs.iterator().next().getClass();
            EntityField[] ids = DTOClassInfo.getIdFields(clazz);
            for (BaseDTO baseDTO : baseDTOs) {
                if (!TokenUtils.hasIDValue((Object)baseDTO, (EntityField[])ids)) continue;
                TokenUtils.checkToken((String)securityKey, (BaseDTO)baseDTO);
            }
        }
    }

    private static boolean hasIDValue(Object obj, EntityField[] ids) {
        for (EntityField f : ids) {
            try {
                if (PropertyUtils.getProperty((Object)obj, (String)f.getName()) != null) continue;
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public static void checkToken(HttpSession session, Collection<? extends BaseDTO> baseDTOs) throws TokenException {
        String securityKey = TokenUtils.getSecurityKey((HttpSession)session);
        if (securityKey == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("check skipped due to securityKey not exists.");
            }
            return;
        }
        TokenUtils.checkToken((String)securityKey, baseDTOs);
    }
}

