/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import com.hand.hap.core.components.CaptchaConfig;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.web.util.WebUtils;

public class LoginFailureHandler
implements AuthenticationFailureHandler {
    private static final Logger log = LoggerFactory.getLogger(LoginFailureHandler.class);
    @Autowired
    private CaptchaConfig captchaConfig;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug("login failed");
        }
        if (this.captchaConfig.getWrongTimes() > 0) {
            this.captchaConfig.updateLoginFailureInfo(WebUtils.getCookie((HttpServletRequest)request, (String)"loginKey"));
        }
        request.setAttribute("error", (Object)true);
        request.setAttribute("code", (Object)"LOGIN_NOT_MATCH");
        request.setAttribute("exception", (Object)exception);
        request.getRequestDispatcher("/login").forward((ServletRequest)request, (ServletResponse)response);
    }
}

