/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.security.CustomUserDetails;
import com.hand.hap.security.oauth.dto.TokenLogs;
import com.hand.hap.security.oauth.service.ITokenLogsService;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;

public class CustomJwtTokenStore
extends JwtTokenStore {
    public static final String REDIS_CATALOG = "hap:cache:oauth_token:";
    @Autowired
    RedisTemplate<String, String> redisTemplate;
    @Autowired
    ITokenLogsService tokenLogsService;
    @Autowired
    ObjectMapper objectMapper;
    private Logger logger = LoggerFactory.getLogger(CustomJwtTokenStore.class);

    public CustomJwtTokenStore(JwtAccessTokenConverter jwtTokenEnhancer) {
        super(jwtTokenEnhancer);
    }

    public OAuth2AccessToken readAccessToken(String tokenValue) {
        String tokenState = (String)this.redisTemplate.opsForValue().get((Object)(REDIS_CATALOG + tokenValue));
        if (StringUtils.isNotEmpty((String)tokenState)) {
            OAuth2AccessToken accessToken = super.readAccessToken(tokenValue);
            return accessToken;
        }
        return null;
    }

    public void removeAccessToken(OAuth2AccessToken token) {
        this.redisTemplate.delete((Object)(REDIS_CATALOG + token.getValue()));
        this.tokenLogsService.revokeToken(token.getValue());
        super.removeAccessToken(token);
    }

    public void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        String clientId = authentication.getOAuth2Request().getClientId();
        if (!StringUtils.equals((String)clientId, (String)"HAP_INNER_CLIENT_ID")) {
            TokenLogs tokenLogs = new TokenLogs();
            Object principal = authentication.getPrincipal();
            if (principal instanceof CustomUserDetails) {
                CustomUserDetails details = (CustomUserDetails)principal;
                tokenLogs.setUserId(details.getUserId());
            }
            tokenLogs.setToken(token.getValue());
            tokenLogs.setClientId(authentication.getOAuth2Request().getClientId());
            tokenLogs.setTokenAccessType(authentication.getOAuth2Request().getGrantType());
            Calendar expiration = Calendar.getInstance();
            expiration.setTime(token.getExpiration());
            expiration.add(13, -token.getExpiresIn());
            tokenLogs.setTokenAccessTime(expiration.getTime());
            tokenLogs.setTokenExpiresTime(token.getExpiration());
            this.tokenLogsService.insertSelective(RequestHelper.getCurrentRequest((boolean)true), (Object)tokenLogs);
            String tokenString = "";
            try {
                tokenString = this.objectMapper.writeValueAsString((Object)tokenLogs);
            }
            catch (JsonProcessingException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            this.redisTemplate.opsForValue().set((Object)(REDIS_CATALOG + token.getValue()), (Object)tokenString, (long)token.getExpiresIn(), TimeUnit.SECONDS);
        }
    }
}

