/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.CorsProcessor;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.cors.DefaultCorsProcessor;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.OncePerRequestFilter;

public class CORSFilter
extends OncePerRequestFilter {
    private CorsProcessor processor = new DefaultCorsProcessor();
    private UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
    private CorsConfiguration config = new CorsConfiguration();
    private CorsConfigurationSource configSource;
    private FilterConfig configConfig;
    private String allowedMappings;
    private String credential;
    private String origin;
    private String method;
    private String exposeHeader;
    private String header;
    private String maxAge;

    protected void initBeanWrapper(BeanWrapper bw) throws BeansException {
        this.configConfig = this.getFilterConfig();
        this.allowedMappings = this.configConfig.getInitParameter("allowedMappings");
        this.credential = this.configConfig.getInitParameter("allowCredentials");
        this.origin = this.configConfig.getInitParameter("allowedOrigin");
        this.header = this.configConfig.getInitParameter("allowedHeader");
        this.method = this.configConfig.getInitParameter("allowedMethod");
        this.exposeHeader = this.configConfig.getInitParameter("exposedHeader");
        this.maxAge = this.configConfig.getInitParameter("maxAge");
        this.initCorsConfig();
    }

    private void initCorsConfig() {
        if (null == this.allowedMappings) {
            this.logger.error((Object)"No mapping with cors filter");
        } else {
            String[] mappings;
            if (null != this.credential) {
                this.config.setAllowCredentials(Boolean.valueOf(Boolean.parseBoolean(this.credential)));
            }
            if (null != this.origin) {
                this.config.setAllowedOrigins(Arrays.asList(this.origin.split(";")));
            } else {
                this.config.addAllowedOrigin("*");
            }
            if (null != this.header) {
                this.config.setAllowedHeaders(Arrays.asList(this.header.split(";")));
            } else {
                this.config.addAllowedHeader("*");
            }
            if (null != this.method) {
                this.config.setAllowedMethods(Arrays.asList(this.method.split(";")));
            } else {
                this.config.addAllowedMethod("*");
            }
            if (null != this.exposeHeader) {
                this.config.setExposedHeaders(Arrays.asList(this.exposeHeader.split(";")));
            }
            if (null != this.maxAge) {
                this.config.setMaxAge(Long.valueOf(Long.parseLong(this.maxAge)));
            }
            for (String mapping : mappings = this.allowedMappings.split(";")) {
                this.source.registerCorsConfiguration(mapping, this.config);
            }
            this.configSource = this.source;
        }
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        boolean isValid;
        CorsConfiguration corsConfiguration;
        if (CorsUtils.isCorsRequest((HttpServletRequest)httpServletRequest) && (corsConfiguration = this.configSource.getCorsConfiguration(httpServletRequest)) != null && (!(isValid = this.processor.processRequest(corsConfiguration, httpServletRequest, httpServletResponse)) || CorsUtils.isPreFlightRequest((HttpServletRequest)httpServletRequest))) {
            return;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

