/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.api.application.dto.ApiAccessLimit;
import com.hand.hap.api.gateway.dto.ApiInterface;
import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.api.gateway.service.IApiServerService;
import com.hand.hap.cache.impl.ApiAccessLimitCache;
import com.hand.hap.intergration.exception.HapApiException;
import com.hand.hap.system.dto.ResponseData;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.web.filter.OncePerRequestFilter;

public class ApiAccessLimitFilter
extends OncePerRequestFilter {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ApiAccessLimitCache apiAccessLimitCache;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private IApiServerService serverService;
    private static final Logger logger = LoggerFactory.getLogger(ApiAccessLimitFilter.class);
    private static final String REDIS_CATALOG = "hap:cache:access_limit:";
    private static final String URL_HEAD = "/api/rest/";
    private static final String CLIENT_ID = "client_id";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        try {
            if (authentication instanceof OAuth2Authentication) {
                OAuth2Authentication oAuth2Authentication = (OAuth2Authentication)authentication;
                String url = StringUtils.substringAfter((String)request.getRequestURI(), (String)request.getContextPath());
                if (url.startsWith(URL_HEAD)) {
                    this.checkAuth(url, oAuth2Authentication);
                }
            }
        }
        catch (HapApiException e) {
            response.setHeader("Content-Type", "application/json");
            ServletOutputStream outputStream = response.getOutputStream();
            ResponseData responseData = new ResponseData();
            responseData.setMessage(e.getMessage());
            responseData.setCode(e.getCode());
            responseData.setSuccess(false);
            outputStream.write(this.objectMapper.writeValueAsString((Object)responseData).getBytes());
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void checkAuth(String url, OAuth2Authentication oAuth2Authentication) throws HapApiException, IOException, ServletException {
        String[] temp = (url = StringUtils.substringAfter((String)url, (String)URL_HEAD)).split("/");
        if (temp.length < 2) {
            throw new HapApiException("API_ACCESS_LIMIT_ERROR", "Request url error");
        }
        String serverUrl = temp[temp.length - 2];
        String interfaceUrl = temp[temp.length - 1];
        ApiServer apiServer = this.serverService.getByMappingUrl(serverUrl, interfaceUrl);
        if (null == apiServer) {
            throw new HapApiException("API_ACCESS_LIMIT_ERROR", "No service found");
        }
        if (!"Y".equalsIgnoreCase(apiServer.getEnableFlag())) {
            throw new HapApiException("API_ACCESS_LIMIT_ERROR", "Service not open");
        }
        if (!oAuth2Authentication.getOAuth2Request().getScope().contains(apiServer.getCode())) {
            throw new HapApiException("API_ACCESS_LIMIT_ERROR", "error.request.url.not.found");
        }
        Map map = oAuth2Authentication.getOAuth2Request().getRequestParameters();
        String clientId = (String)map.get(CLIENT_ID);
        ApiInterface apiInterface = apiServer.getApiInterface();
        ApiAccessLimit apiAccessLimit = null;
        if (null != apiInterface) {
            if (!"Y".equalsIgnoreCase(apiInterface.getEnableFlag())) {
                throw new HapApiException("API_ACCESS_LIMIT_ERROR", "Interface not open");
            }
            Map apiAccessLimitMap = this.apiAccessLimitCache.getValue(clientId, apiServer.getCode());
            if (null != apiAccessLimitMap) {
                String interfaceCode = apiInterface.getCode();
                apiAccessLimit = (ApiAccessLimit)apiAccessLimitMap.get(interfaceCode);
            }
        }
        if (null == apiAccessLimit) {
            return;
        }
        if (!"Y".equalsIgnoreCase(apiAccessLimit.getAccessFlag())) {
            return;
        }
        if (!this.checkAccessLimit(clientId, serverUrl, interfaceUrl, apiAccessLimit)) {
            throw new HapApiException("API_ACCESS_LIMIT_ERROR", "Number of requests exceeded");
        }
    }

    private boolean checkAccessLimit(String clientId, String serverUrl, String interfaceUrl, ApiAccessLimit apiAccessLimit) {
        String key = REDIS_CATALOG + clientId + "_" + serverUrl + "_" + interfaceUrl;
        String visitsStr = (String)this.redisTemplate.opsForValue().get((Object)key);
        Long visits = 0L;
        if (null != apiAccessLimit.getAccessFrequency()) {
            if (null == visitsStr) {
                visits = 1L;
                this.redisTemplate.opsForValue().set((Object)key, (Object)(visits + ""), 1L, TimeUnit.MINUTES);
                return true;
            }
            visits = Long.parseLong(visitsStr);
            if (visits < apiAccessLimit.getAccessFrequency()) {
                this.redisTemplate.opsForValue().increment((Object)key, 1L);
                return true;
            }
            logger.debug("Too many visits");
            return false;
        }
        return true;
    }
}

