/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mybatis.spring;

import com.hand.hap.mybatis.common.Marker;
import com.hand.hap.mybatis.mapperhelper.MapperHelper;
import com.hand.hap.mybatis.spring.MapperFactoryBean;
import com.hand.hap.mybatis.util.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;

public class MapperScannerConfigurer
extends org.mybatis.spring.mapper.MapperScannerConfigurer {
    private MapperHelper mapperHelper = new MapperHelper();
    private Map<String, String> propertiesMap;

    public void setMarkerInterface(Class<?> superClass) {
        super.setMarkerInterface(superClass);
        if (Marker.class.isAssignableFrom(superClass)) {
            this.mapperHelper.registerMapper(superClass);
        }
    }

    public MapperHelper getMapperHelper() {
        return this.mapperHelper;
    }

    public void setMapperHelper(MapperHelper mapperHelper) {
        this.mapperHelper = mapperHelper;
    }

    public void setProperties(Properties properties) {
        this.mapperHelper.setProperties(properties);
    }

    public void setPropertiesMap(Map<String, String> propertiesMap) {
        if (propertiesMap.get("ORDER") == null) {
            if ("JDBC".equalsIgnoreCase(propertiesMap.get("IDENTITY"))) {
                propertiesMap.put("ORDER", "AFTER");
            } else {
                propertiesMap.put("ORDER", "BEFORE");
            }
        }
        this.propertiesMap = propertiesMap;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
        String[] names;
        Properties config = new Properties();
        Properties p = new Properties();
        try {
            config.load(this.getClass().getResourceAsStream("/config.properties"));
            if (this.propertiesMap.get("ORDER") == null) {
                if ("JDBC".equalsIgnoreCase((String)this.propertiesMap.get("IDENTITY"))) {
                    p.put("ORDER", "AFTER");
                } else {
                    p.put("ORDER", "BEFORE");
                }
            }
            this.propertiesMap.forEach((k, v) -> {
                if (v.startsWith("${") && v.endsWith("}")) {
                    p.put(k, config.getProperty(v.substring(2, v.length() - 1), (String)v));
                } else {
                    p.put(k, v);
                }
            });
            this.setProperties(p);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.postProcessBeanDefinitionRegistry(registry);
        this.mapperHelper.ifEmptyRegisterDefaultInterface();
        for (String name : names = registry.getBeanDefinitionNames()) {
            GenericBeanDefinition definition;
            BeanDefinition beanDefinition = registry.getBeanDefinition(name);
            if (!(beanDefinition instanceof GenericBeanDefinition) || !StringUtil.isNotEmpty((String)(definition = (GenericBeanDefinition)beanDefinition).getBeanClassName()) || !definition.getBeanClassName().equals("org.mybatis.spring.mapper.MapperFactoryBean")) continue;
            definition.setBeanClass(MapperFactoryBean.class);
            definition.getPropertyValues().add("mapperHelper", (Object)this.mapperHelper);
        }
    }
}

