/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mybatis.provider.base;

import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.mapperhelper.EntityHelper;
import com.hand.hap.mybatis.mapperhelper.MapperHelper;
import com.hand.hap.mybatis.mapperhelper.MapperTemplate;
import com.hand.hap.mybatis.mapperhelper.SqlHelper;
import com.hand.hap.system.dto.BaseDTO;
import java.util.Map;
import org.apache.ibatis.mapping.MappedStatement;

public class BaseSelectProvider
extends MapperTemplate {
    public BaseSelectProvider() {
    }

    public BaseSelectProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public String selectOne(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        boolean isMl = EntityHelper.getEntityTable((Class)entityClass).isSupportMultiLanguage();
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        if (isMl) {
            sql.append(SqlHelper.selectAllColumns_TL((Class)entityClass));
            sql.append(SqlHelper.fromTable_TL((Class)entityClass, (String)this.tableName(entityClass)));
            sql.append(SqlHelper.whereAllIfColumns_TL((Class)entityClass, (boolean)this.isNotEmpty(), (boolean)true));
        } else {
            sql.append(SqlHelper.selectAllColumns((Class)entityClass));
            sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
            sql.append(SqlHelper.whereAllIfColumns((Class)entityClass, (boolean)this.isNotEmpty()));
        }
        return sql.toString();
    }

    public String select(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        boolean isMl = EntityHelper.getEntityTable((Class)entityClass).isSupportMultiLanguage();
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        if (isMl) {
            sql.append(SqlHelper.selectAllColumns_TL((Class)entityClass));
            sql.append(SqlHelper.fromTable_TL((Class)entityClass, (String)this.tableName(entityClass)));
            sql.append(SqlHelper.whereAllIfColumns_TL((Class)entityClass, (boolean)this.isNotEmpty(), (boolean)false));
            sql.append(SqlHelper.orderByDefault_TL((Class)entityClass));
        } else {
            sql.append(SqlHelper.selectAllColumns((Class)entityClass));
            sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
            sql.append(SqlHelper.whereAllIfColumns((Class)entityClass, (boolean)this.isNotEmpty()));
            sql.append(SqlHelper.orderByDefault((Class)entityClass));
        }
        return sql.toString();
    }

    public String selectByRowBounds(MappedStatement ms) {
        return this.select(ms);
    }

    public String selectByPrimaryKey(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        boolean isMl = EntityHelper.getEntityTable((Class)entityClass).isSupportMultiLanguage();
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        if (isMl) {
            sql.append(SqlHelper.selectAllColumns_TL((Class)entityClass));
            sql.append(SqlHelper.fromTable_TL((Class)entityClass, (String)this.tableName(entityClass)));
            sql.append(SqlHelper.wherePKColumns_TL((Class)entityClass));
        } else {
            sql.append(SqlHelper.selectAllColumns((Class)entityClass));
            sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
            sql.append(SqlHelper.wherePKColumns((Class)entityClass));
        }
        return sql.toString();
    }

    public String selectCount(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.selectCount((Class)entityClass));
        sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append(SqlHelper.whereAllIfColumns((Class)entityClass, (boolean)this.isNotEmpty()));
        return sql.toString();
    }

    public String selectAll(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        boolean isMl = EntityHelper.getEntityTable((Class)entityClass).isSupportMultiLanguage();
        return this.selectAllResult(ms, Boolean.valueOf(isMl));
    }

    private String selectAllResult(MappedStatement ms, Boolean isMultiLanguage) {
        Class entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        if (isMultiLanguage.booleanValue()) {
            sql.append(SqlHelper.selectAllColumns_TL((Class)entityClass));
            sql.append(SqlHelper.fromTable_TL((Class)entityClass, (String)this.tableName(entityClass)));
            sql.append(SqlHelper.orderByDefault_TL((Class)entityClass));
        } else {
            sql.append(SqlHelper.selectAllColumns((Class)entityClass));
            sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
            sql.append(SqlHelper.orderByDefault((Class)entityClass));
        }
        return sql.toString();
    }

    public String selectAllWithoutMultiLanguage(MappedStatement ms) {
        return this.selectAllResult(ms, Boolean.valueOf(false));
    }

    private void initResultType(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
    }

    public void selectOptions(MappedStatement ms) {
        this.initResultType(ms);
    }

    public void selectOptionsByPrimaryKey(MappedStatement ms) {
        this.initResultType(ms);
    }

    public String selectOptionsByPrimaryKey(BaseDTO dto) {
        return SqlHelper.buildSelectByPrimaryKeySQL((BaseDTO)dto);
    }

    public String selectOptions(Map<String, Object> parameter) {
        BaseDTO dto = (BaseDTO)parameter.get("dto");
        Criteria criteria = (Criteria)parameter.get("criteria");
        return SqlHelper.buildSelectSelectiveSql((BaseDTO)dto, (Criteria)criteria);
    }
}

