/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mybatis.mapperhelper;

import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.mybatis.mapperhelper.FieldHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class FieldHelper {
    private static final IFieldHelper fieldHelper;

    public static List<EntityField> getFields(Class<?> entityClass) {
        return fieldHelper.getFields(entityClass);
    }

    public static List<EntityField> getProperties(Class<?> entityClass) {
        return fieldHelper.getProperties(entityClass);
    }

    public static List<EntityField> getAll(Class<?> entityClass) {
        List fields = fieldHelper.getFields(entityClass);
        List properties = fieldHelper.getProperties(entityClass);
        ArrayList<EntityField> all = new ArrayList<EntityField>();
        HashSet<EntityField> usedSet = new HashSet<EntityField>();
        for (EntityField field : fields) {
            for (EntityField property : properties) {
                if (usedSet.contains(property) || !field.getName().equals(property.getName())) continue;
                field.copyFromPropertyDescriptor(property);
                usedSet.add(property);
                break;
            }
            all.add(field);
        }
        for (EntityField property : properties) {
            if (usedSet.contains(property)) continue;
            all.add(property);
        }
        return all;
    }

    static {
        String version = System.getProperty("java.version");
        fieldHelper = version.contains("1.8.") || version.contains("9.") ? new Jdk8FieldHelper() : new Jdk6_7FieldHelper();
    }
}

