/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.TopicMonitor;
import com.hand.hap.message.websocket.CommandMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

@TopicMonitor(channel={"webSocket"})
public class WebSocketSessionManager
implements IMessageConsumer<CommandMessage> {
    public static final String CHANNEL_WEB_SOCKET = "webSocket";
    private final Logger logger = LoggerFactory.getLogger(WebSocketSessionManager.class);
    private final Map<String, List<WebSocketSession>> webSocketSessionMap = new ConcurrentHashMap();
    @Autowired
    private ObjectMapper objectMapper;

    public void addSession(WebSocketSession session) {
        String userName = session.getPrincipal().getName();
        if (!StringUtils.isEmpty((Object)userName)) {
            ArrayList<WebSocketSession> sessions = (ArrayList<WebSocketSession>)this.webSocketSessionMap.get(userName);
            if (sessions == null) {
                sessions = new ArrayList<WebSocketSession>();
                this.webSocketSessionMap.put(userName, sessions);
            }
            sessions.add(session);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Add webSocketSession {}, total size {}", (Object)session.getId(), (Object)sessions.size());
            }
        }
    }

    public void removeSession(WebSocketSession session) {
        List sessions;
        String userName = session.getPrincipal().getName();
        if (!StringUtils.isEmpty((Object)userName) && (sessions = (List)this.webSocketSessionMap.get(userName)) != null) {
            sessions.remove(session);
            this.logger.debug("Remove webSocketSession {}, total size {}", (Object)session.getId(), (Object)sessions.size());
        }
    }

    public List<WebSocketSession> getSession(String userName) {
        List sessions = (List)this.webSocketSessionMap.get(userName);
        return sessions != null ? sessions : Collections.EMPTY_LIST;
    }

    public void sendCommandMessage(WebSocketSession session, CommandMessage commandMessage) {
        block2: {
            try {
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)this.objectMapper.writeValueAsString((Object)commandMessage)));
            }
            catch (IOException e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error("send commandMessage error! commandMessage: {} ", (Object)commandMessage.toString());
            }
        }
    }

    public void onMessage(CommandMessage commandMessage, String channel) {
        List sessions = this.getSession(commandMessage.getUserName());
        if (sessions != null) {
            String sessionId = commandMessage.getSessionId();
            sessions.stream().filter(ws -> !sessionId.equalsIgnoreCase((String)ws.getAttributes().get("sessionId"))).forEach(webSocketSession -> this.sendCommandMessage(webSocketSession, commandMessage));
        }
    }
}

