/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.components;

import com.hand.hap.core.AppContextInitListener;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.TopicMonitor;
import com.hand.hap.message.profile.GlobalProfileListener;
import com.hand.hap.message.profile.ListenerInitHandler;
import com.hand.hap.message.profile.SystemConfigListener;
import com.hand.hap.mybatis.util.StringUtil;
import com.hand.hap.system.dto.GlobalProfile;
import com.hand.hap.system.service.IProfileService;
import com.hand.hap.system.service.ISysConfigService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
@TopicMonitor(channel={"profile", "config"})
public class GlobalProfileSubscriber
implements IMessageConsumer<GlobalProfile>,
ListenerInitHandler,
AppContextInitListener {
    public static final String PROFILE = "profile";
    public static final String CONFIG = "config";
    private static Map<GlobalProfileListener, List<String>> listenerMap = new HashMap();
    @Autowired
    private IProfileService profileService;
    @Autowired
    private ISysConfigService configService;
    private Logger logger = LoggerFactory.getLogger(GlobalProfileSubscriber.class);

    public void addListener(GlobalProfileListener listener) {
        listenerMap.put(listener, listener.getAcceptedProfiles());
        this.initLoad(listener);
    }

    public void initLoad(GlobalProfileListener listener) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("initial load profile values for:" + listener);
        }
        if (listener instanceof SystemConfigListener) {
            for (String configCode : listener.getAcceptedProfiles()) {
                String configValue = this.configService.getConfigValue(configCode);
                if (!StringUtil.isNotEmpty((String)configValue)) continue;
                listener.updateProfile(configCode, configValue);
            }
        } else {
            IRequest iRequest = RequestHelper.newEmptyRequest();
            iRequest.setUserId(Long.valueOf(-1L));
            iRequest.setRoleId(Long.valueOf(-1L));
            for (String profileName : listener.getAcceptedProfiles()) {
                String profileValue = this.profileService.getProfileValue(iRequest, profileName);
                if (!StringUtil.isNotEmpty((String)profileValue)) continue;
                listener.updateProfile(profileName, profileValue);
            }
        }
    }

    public void onMessage(GlobalProfile message, String pattern) {
        listenerMap.forEach((k, v) -> {
            if (CONFIG.equalsIgnoreCase(pattern)) {
                if (k instanceof SystemConfigListener && v.contains(message.getProfileName())) {
                    k.updateProfile(message.getProfileName(), message.getProfileValue());
                }
            } else if (PROFILE.equalsIgnoreCase(pattern) && !(k instanceof SystemConfigListener) && v.contains(message.getProfileName())) {
                k.updateProfile(message.getProfileName(), message.getProfileValue());
            }
        });
    }

    public void contextInitialized(ApplicationContext applicationContext) {
        Map listeners = applicationContext.getBeansOfType(GlobalProfileListener.class);
        listeners.forEach((k, v) -> this.addListener(v));
    }
}

