/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message;

import com.hand.hap.core.AppContextInitListener;
import com.hand.hap.message.MethodReflectUtils;
import com.hand.hap.message.TopicListenerContainer;
import com.hand.hap.message.TopicMonitor;
import com.hand.hap.message.components.ChannelAndQueuePrefix;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

public class TopicListenerContainer
extends RedisMessageListenerContainer
implements AppContextInitListener {
    private Logger logger = LoggerFactory.getLogger(TopicListenerContainer.class);

    public boolean isAutoStartup() {
        return false;
    }

    public void contextInitialized(ApplicationContext applicationContext) {
        Map monitors = applicationContext.getBeansWithAnnotation(TopicMonitor.class);
        HashMap listeners = new HashMap();
        monitors.forEach((k, v) -> {
            TopicMonitor tm;
            String mn;
            Class<?> clazz = v.getClass();
            List avaMethods = MethodReflectUtils.findMethod(clazz, (MethodReflectUtils.FindDesc)new MethodReflectUtils.FindDesc(mn = MethodReflectUtils.getTopicMethodName((String)(tm = clazz.getAnnotation(TopicMonitor.class)).method(), (Object)v), 2));
            if (avaMethods.isEmpty()) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("can not find proper method of name '{}' for bean {}", (Object)mn, v);
                }
                return;
            }
            SimpleMessageListener adaptor = new SimpleMessageListener(v, (Method)avaMethods.get(0));
            ArrayList<PatternTopic> topics = new ArrayList<PatternTopic>();
            for (String t : tm.channel()) {
                t = ChannelAndQueuePrefix.addPrefix((String)t);
                PatternTopic topic = new PatternTopic(t);
                topics.add(topic);
            }
            listeners.put(adaptor, topics);
        });
        this.setMessageListeners(listeners);
    }
}

