/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message;

import com.hand.hap.core.AppContextInitListener;
import com.hand.hap.message.IQueueMessageListener;
import com.hand.hap.message.MethodReflectUtils;
import com.hand.hap.message.QueueListenerContainer;
import com.hand.hap.message.QueueMonitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.RedisSerializer;

public class QueueListenerContainer
implements AppContextInitListener,
DisposableBean,
SmartLifecycle {
    private Logger logger = LoggerFactory.getLogger(QueueListenerContainer.class);
    private RedisConnectionFactory connectionFactory;
    private static final int PHASE = 9999;
    private static final long MIN_RECOVERY_INTERVAL = 2000L;
    private static final long DEFAULT_RECOVERY_INTERVAL = 5000L;
    private static final long IDLE_SLEEP_TIME = 100L;
    private long recoveryInterval = 5000L;
    private volatile boolean running = false;
    private ExecutorService executorService;
    private List<IQueueMessageListener<?>> listeners;
    private List<MonitorTask> monitorTaskList = new ArrayList();
    private RedisSerializer<String> stringRedisSerializer;

    public RedisConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
        if (recoveryInterval < 2000L) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("minimum for recoveryInterval is {}", (Object)2000L);
            }
            this.recoveryInterval = 2000L;
        }
    }

    public List<IQueueMessageListener<?>> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<IQueueMessageListener<?>> listeners) {
        this.listeners = listeners;
    }

    public RedisSerializer<String> getStringRedisSerializer() {
        return this.stringRedisSerializer;
    }

    @Autowired
    public void setStringRedisSerializer(RedisSerializer<String> stringRedisSerializer) {
        this.stringRedisSerializer = stringRedisSerializer;
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void contextInitialized(ApplicationContext applicationContext) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        Map lts = applicationContext.getBeansWithAnnotation(QueueMonitor.class);
        lts.forEach((k, v) -> {
            Class<?> clazz = v.getClass();
            QueueMonitor qm = clazz.getAnnotation(QueueMonitor.class);
            String queue = qm.queue();
            String mn = MethodReflectUtils.getQueueMethodName((String)qm.method(), (Object)v);
            List methods = MethodReflectUtils.findMethod(clazz, (MethodReflectUtils.FindDesc)new MethodReflectUtils.FindDesc(mn, 2));
            if (methods.isEmpty()) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("can not find proper method of name '{}' for bean {}", (Object)mn, v);
                }
                return;
            }
            Method method = (Method)methods.get(0);
            SimpleQueueListener qml = new SimpleQueueListener(queue, v, method);
            this.listeners.add(qml);
        });
        this.executorService = Executors.newFixedThreadPool(this.listeners.size());
        for (IQueueMessageListener receiver : this.listeners) {
            MonitorTask task = new MonitorTask(this, receiver);
            this.monitorTaskList.add(task);
            this.executorService.execute((Runnable)task);
        }
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("startup success");
            }
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.running = false;
            this.monitorTaskList.forEach(MonitorTask::stop);
            this.executorService.shutdownNow();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("shutdown complete");
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 9999;
    }

    static /* synthetic */ RedisConnectionFactory access$000(QueueListenerContainer x0) {
        return x0.connectionFactory;
    }

    static /* synthetic */ Logger access$100(QueueListenerContainer x0) {
        return x0.logger;
    }

    static /* synthetic */ RedisSerializer access$200(QueueListenerContainer x0) {
        return x0.stringRedisSerializer;
    }
}

