/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mail.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.core.exception.EmailException;
import com.hand.hap.mail.dto.MessageEmailConfig;
import com.hand.hap.mail.service.IMessageEmailConfigService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/messageEmailConfig", "/api/sys/messageEmailConfig"})
public class MessageEmailConfigController
extends BaseController {
    @Autowired
    private IMessageEmailConfigService service;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData getMessageEmailConfig(HttpServletRequest request, MessageEmailConfig example, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.selectMessageEmailConfigs(requestContext, example, page, pagesize));
    }

    @PostMapping(value={"/submit"})
    public ResponseData submitLov(@RequestBody MessageEmailConfig obj, BindingResult result, HttpServletRequest request) throws EmailException {
        this.getValidator().validate((Object)obj, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestContext = this.createRequestContext(request);
        this.service.batchUpdate(requestContext, obj);
        return new ResponseData();
    }

    @PostMapping(value={"/remove"})
    public ResponseData deleteMessageEmailConfig(HttpServletRequest request, @RequestBody List<MessageEmailConfig> objs) throws BaseException {
        IRequest requestContext = this.createRequestContext(request);
        this.service.batchDelete(requestContext, objs);
        return new ResponseData();
    }
}

