/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.job.plugin;

import com.hand.hap.job.listener.JobNoticeListener;
import com.hand.hap.job.listener.JobRunningListener;
import com.hand.hap.job.listener.SchedulerRunningListener;
import com.hand.hap.job.plugin.DefaultSchedulerPlugin;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.impl.matchers.EverythingMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class RunningListenerPlugin
extends DefaultSchedulerPlugin {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean isLogRunningInfo = false;
    private String mailTemplate;
    private ApplicationContext applicationContext;
    private Scheduler scheduler;

    protected Logger getLog() {
        return this.log;
    }

    public void initialize(String pname, Scheduler scheduler, ClassLoadHelper classLoadHelper) throws SchedulerException {
        this.scheduler = scheduler;
    }

    public void start() {
        try {
            this.applicationContext = (ApplicationContext)this.scheduler.getContext().get((Object)"applicationContext");
            ListenerManager listenerManager = this.scheduler.getListenerManager();
            if (this.isLogRunningInfo()) {
                listenerManager.addJobListener((JobListener)new JobRunningListener(this.applicationContext), (Matcher)EverythingMatcher.allJobs());
                listenerManager.addSchedulerListener((SchedulerListener)new SchedulerRunningListener(this.applicationContext));
            }
            if (this.mailTemplate != null && !"".equals(this.mailTemplate)) {
                listenerManager.addJobListener((JobListener)new JobNoticeListener(this.mailTemplate), (Matcher)EverythingMatcher.allJobs());
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
    }

    public boolean isLogRunningInfo() {
        return this.isLogRunningInfo;
    }

    public void setLogRunningInfo(boolean isLogRunningInfo) {
        this.isLogRunningInfo = isLogRunningInfo;
    }

    public String getMailTemplate() {
        return this.mailTemplate;
    }

    public void setMailTemplate(String mailTemplate) {
        this.mailTemplate = mailTemplate;
    }
}

