/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.job.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.FieldRequiredException;
import com.hand.hap.job.dto.JobCreateDto;
import com.hand.hap.job.dto.JobDetailDto;
import com.hand.hap.job.dto.SchedulerDto;
import com.hand.hap.job.dto.TriggerDto;
import com.hand.hap.job.exception.JobException;
import com.hand.hap.job.service.IQuartzService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/job", "/api/job"})
public class JobController
extends BaseController {
    @Autowired
    private IQuartzService quartzService;

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public ResponseData createJob(@RequestBody JobCreateDto jobCreateDto, BindingResult result, HttpServletRequest request) throws SchedulerException, JobException, ClassNotFoundException, FieldRequiredException {
        jobCreateDto.setTriggerGroup(jobCreateDto.getJobGroup());
        jobCreateDto.setTriggerName(jobCreateDto.getJobName() + "_trigger");
        this.getValidator().validate((Object)jobCreateDto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        this.quartzService.createJob(jobCreateDto);
        return new ResponseData();
    }

    @RequestMapping(value={"/pause"})
    public ResponseData pauseJobs(@RequestBody List<JobDetailDto> list) throws SchedulerException {
        this.quartzService.pauseJobs(list);
        return new ResponseData();
    }

    @RequestMapping(value={"/resume"})
    public ResponseData resumeJobs(@RequestBody List<JobDetailDto> list) throws SchedulerException {
        this.quartzService.resumeJobs(list);
        return new ResponseData();
    }

    @RequestMapping(value={"/deletejob"})
    public ResponseData deleteJobs(@RequestBody List<JobDetailDto> list) throws SchedulerException {
        this.quartzService.deleteJobs(list);
        return new ResponseData();
    }

    @RequestMapping(value={"/pausetrigger"})
    public ResponseData pauseTrigger(@RequestBody List<TriggerDto> list) throws SchedulerException {
        this.quartzService.pauseTriggers(list);
        return new ResponseData();
    }

    @RequestMapping(value={"/resumetrigger"})
    public ResponseData resumeTrigger(@RequestBody List<TriggerDto> list) throws SchedulerException {
        this.quartzService.resumeTriggers(list);
        return new ResponseData();
    }

    @RequestMapping(value={"/query"})
    public ResponseData queryJobs(@ModelAttribute JobDetailDto example, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, HttpServletRequest request) throws SchedulerException {
        return this.qj(example, page, pagesize, request);
    }

    @RequestMapping(value={"/queryInfo"})
    public ResponseData query(@RequestBody JobDetailDto example, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, HttpServletRequest request) throws SchedulerException {
        return this.qj(example, page, pagesize, request);
    }

    private ResponseData qj(JobDetailDto example, int page, int pagesize, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.quartzService.getJobInfoDetails(requestCtx, example, page, pagesize));
    }

    @RequestMapping(value={"/trigger"})
    public ResponseData queryTrigger(@RequestParam(required=true) String triggerName, @RequestParam(required=true) String triggerGroup, @RequestParam(required=true) String triggerType) throws SchedulerException {
        if ("CRON".equalsIgnoreCase(triggerType)) {
            return new ResponseData(Arrays.asList(this.quartzService.getCronTrigger(triggerName, triggerGroup)));
        }
        if ("SIMPLE".equalsIgnoreCase(triggerType)) {
            return new ResponseData(Arrays.asList(this.quartzService.getSimpleTrigger(triggerName, triggerGroup)));
        }
        return new ResponseData();
    }

    @RequestMapping(value={"/trigger/query"})
    public ResponseData queryTriggers(@ModelAttribute TriggerDto example, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, HttpServletRequest request) throws SchedulerException {
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.quartzService.getTriggers(requestCtx, example, page, pagesize));
    }

    @RequestMapping(value={"/scheduler/query"})
    public ResponseData querySchedulers(@ModelAttribute SchedulerDto example, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) throws SchedulerException {
        return new ResponseData(this.quartzService.selectSchedulers(example, page, pagesize));
    }

    @RequestMapping(value={"/scheduler/info"})
    public ResponseData schedulerInformation() throws SchedulerException {
        Map infoMap = this.quartzService.schedulerInformation();
        ResponseData responseData = new ResponseData();
        responseData.setRows(Arrays.asList(infoMap));
        return responseData;
    }

    @RequestMapping(value={"/scheduler/start"})
    public ResponseData startScheduler() throws SchedulerException {
        return new ResponseData(Arrays.asList(this.quartzService.start()));
    }

    @RequestMapping(value={"/scheduler/standby"})
    public ResponseData standbyScheduler() throws SchedulerException {
        return new ResponseData(Arrays.asList(this.quartzService.standby()));
    }

    @RequestMapping(value={"/scheduler/pauseall"})
    public ResponseData schedulerPauseAll() throws SchedulerException {
        return new ResponseData(Arrays.asList(this.quartzService.pauseAll()));
    }

    @RequestMapping(value={"/scheduler/resumeall"})
    public ResponseData schedulerResumeAll() throws SchedulerException {
        return new ResponseData(Arrays.asList(this.quartzService.resumeAll()));
    }
}

