/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.job;

import com.hand.hap.job.AbstractJob;
import com.hand.hap.script.service.IScriptService;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ScriptBasedJob
extends AbstractJob {
    private Logger logger = LoggerFactory.getLogger(ScriptBasedJob.class);
    @Autowired
    private IScriptService scriptService;
    private Exception exception = null;

    public String initFileFormat(String scriptFile) {
        String sf = scriptFile.trim().replace('\\', '/');
        if (!sf.startsWith("/")) {
            sf = "/" + sf;
        }
        return sf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void safeExecute(JobExecutionContext context) throws Exception {
        Object ret;
        block10: {
            ret = null;
            try {
                String scriptName = context.getMergedJobDataMap().getString("scriptName");
                String script = context.getMergedJobDataMap().getString("script");
                String scriptFile = context.getMergedJobDataMap().getString("scriptFile");
                if (script != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("begin execute script,scriptName:{}  Script:{}", (Object)scriptName, (Object)script);
                    }
                    ret = this.scriptService.execute(scriptName, script, null);
                } else {
                    if (scriptFile == null) throw new Exception("both script and scriptFile is blank");
                    InputStream inputStream = ScriptBasedJob.class.getResourceAsStream(this.initFileFormat(scriptFile));
                    if (inputStream == null) throw new Exception("scriptFile is blank");
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOUtils.copyLarge((InputStream)inputStream, (OutputStream)baos);
                    IOUtils.closeQuietly((OutputStream)baos);
                    byte[] bytes = baos.toByteArray();
                    String scriptContent = new String(bytes, "UTF-8");
                    IOUtils.closeQuietly((InputStream)inputStream);
                    ret = this.scriptService.execute(scriptName, scriptContent, null);
                }
                if (this.exception == null) break block10;
            }
            catch (Exception e) {
                try {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    this.exception = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (this.exception != null) {
                        this.setExecutionSummary(this.exception.getClass().getName() + ":" + this.exception.getMessage());
                        throw throwable;
                    } else {
                        if (ret == null) throw throwable;
                        this.setExecutionSummary("execution result:" + ret);
                    }
                    throw throwable;
                }
            }
            this.setExecutionSummary(this.exception.getClass().getName() + ":" + this.exception.getMessage());
            return;
        }
        if (ret == null) return;
        this.setExecutionSummary("execution result:" + ret);
        return;
    }

    public boolean isRefireImmediatelyWhenException() {
        return false;
    }
}

