/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.ws.interceptor;

import com.hand.hap.intergration.dto.HapInterfaceInbound;
import com.hand.hap.intergration.dto.HapInterfaceOutbound;
import com.hand.hap.intergration.util.HapInvokeLogUtils;
import com.hand.hap.intergration.ws.interceptor.HapInvokeOutInterceptor;
import com.hand.hap.message.IMessagePublisher;
import java.io.OutputStream;
import java.util.Date;
import java.util.logging.Logger;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractLoggingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.Address;
import org.springframework.beans.factory.annotation.Autowired;

@NoJSR250Annotations
public class HapInvokeOutInterceptor
extends AbstractLoggingInterceptor {
    private static final Logger LOG = LogUtils.getLogger(LoggingOutInterceptor.class);
    @Autowired
    private IMessagePublisher messagePublisher;
    public static long DEFAULT_THRESHOLD = 0xA00000L;

    public HapInvokeOutInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) throws Fault {
        HapInterfaceInbound inbound = (HapInterfaceInbound)message.getExchange().get((Object)"HAP_INBOUND");
        if (inbound != null) {
            this.inboundInvoke(inbound, message);
        } else {
            this.outboundInvoke(message);
        }
    }

    public void handleFault(Message message) {
        HapInvokeLogUtils.processCxfHandleFault((Message)message, (IMessagePublisher)this.messagePublisher);
    }

    protected void outboundInvoke(Message message) {
        HapInterfaceOutbound outbound = new HapInterfaceOutbound();
        message.getExchange().put((Object)"HAP_OUTBOUND", (Object)outbound);
        outbound.setRequestTime(new Date());
        Object address = message.get((Object)"http.connection.address");
        String url = address instanceof Address ? ((Address)address).getString() : "";
        outbound.setInterfaceUrl(url);
        Endpoint ep = message.getExchange().getEndpoint();
        EndpointInfo endpoint = ep.getEndpointInfo();
        String serviceName = endpoint.getService().getName().getLocalPart();
        outbound.setInterfaceName(serviceName);
        this.getXmlContent(message);
    }

    protected void inboundInvoke(HapInterfaceInbound inbound, Message message) {
        this.getXmlContent(message);
    }

    protected String getXmlContent(Message message) {
        String content = "";
        try {
            OutputStream os = (OutputStream)message.getContent(OutputStream.class);
            CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
            newOut.setThreshold(DEFAULT_THRESHOLD);
            message.setContent(OutputStream.class, (Object)newOut);
            newOut.registerCallback((CachedOutputStreamCallback)new LoggingCallback(this, message, os));
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        return content;
    }

    private LoggingMessage setupBuffer(Message message) {
        Object headers;
        String ct;
        String address;
        String httpMethod;
        String encoding;
        String id = (String)message.getExchange().get((Object)LoggingMessage.ID_KEY);
        if (id == null) {
            id = LoggingMessage.nextId();
            message.getExchange().put((Object)LoggingMessage.ID_KEY, (Object)id);
        }
        LoggingMessage buffer = new LoggingMessage("Outbound Message\n---------------------------", id);
        Integer responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE);
        if (responseCode != null) {
            buffer.getResponseCode().append(responseCode);
        }
        if ((encoding = (String)message.get((Object)Message.ENCODING)) != null) {
            buffer.getEncoding().append(encoding);
        }
        if ((httpMethod = (String)message.get((Object)"org.apache.cxf.request.method")) != null) {
            buffer.getHttpMethod().append(httpMethod);
        }
        if ((address = (String)message.get((Object)Message.ENDPOINT_ADDRESS)) != null) {
            buffer.getAddress().append(address);
            String uri = (String)message.get((Object)"org.apache.cxf.request.uri");
            if (uri != null && !address.startsWith(uri)) {
                if (!address.endsWith("/") && !uri.startsWith("/")) {
                    buffer.getAddress().append("/");
                }
                buffer.getAddress().append(uri);
            }
        }
        if ((ct = (String)message.get((Object)"Content-Type")) != null) {
            buffer.getContentType().append(ct);
        }
        if ((headers = message.get((Object)Message.PROTOCOL_HEADERS)) != null) {
            buffer.getHeader().append(headers);
        }
        return buffer;
    }

    protected Logger getLogger() {
        return LOG;
    }

    static /* synthetic */ LoggingMessage access$000(HapInvokeOutInterceptor x0, Message x1) {
        return x0.setupBuffer(x1);
    }

    static /* synthetic */ boolean access$100(HapInvokeOutInterceptor x0, String x1) {
        return x0.isBinaryContent(x1);
    }

    static /* synthetic */ boolean access$200(HapInvokeOutInterceptor x0, String x1) {
        return x0.isMultipartContent(x1);
    }

    static /* synthetic */ void access$300(HapInvokeOutInterceptor x0, StringBuilder x1, CachedOutputStream x2, String x3, String x4) throws Exception {
        x0.writePayload(x1, x2, x3, x4);
    }

    static /* synthetic */ IMessagePublisher access$400(HapInvokeOutInterceptor x0) {
        return x0.messagePublisher;
    }
}

