/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.ws.interceptor;

import com.hand.hap.intergration.beans.HapinterfaceBound;
import com.hand.hap.intergration.dto.HapInterfaceInbound;
import com.hand.hap.intergration.dto.HapInterfaceOutbound;
import com.hand.hap.intergration.util.HapInvokeLogUtils;
import com.hand.hap.intergration.ws.interceptor.HapInvokeOutInterceptor;
import com.hand.hap.message.IMessagePublisher;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedWriter;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.springframework.beans.factory.annotation.Autowired;

@NoJSR250Annotations
public class HapInvokeInInterceptor
extends AbstractPhaseInterceptor<Message> {
    @Autowired
    private IMessagePublisher messagePublisher;

    public HapInvokeInInterceptor() {
        super("receive");
    }

    public void handleMessage(Message message) throws Fault {
        HapInterfaceOutbound outbound = (HapInterfaceOutbound)message.getExchange().get((Object)"HAP_OUTBOUND");
        if (outbound == null) {
            this.inboundInvoke(message);
        } else {
            this.outboundInvoke(outbound, message);
        }
    }

    public void handleFault(Message message) {
        HapInvokeLogUtils.processCxfHandleFault((Message)message, (IMessagePublisher)this.messagePublisher);
    }

    protected void inboundInvoke(Message message) {
        HapInterfaceInbound inbound = new HapInterfaceInbound();
        inbound.setRequestTime(new Date());
        message.getExchange().put((Object)"HAP_INBOUND", (Object)inbound);
        this.logRequestInfo(inbound, message);
        this.logRequestBody(message);
    }

    protected void outboundInvoke(HapInterfaceOutbound outbound, Message message) {
        Object responseCode = message.get((Object)Message.RESPONSE_CODE);
        if (responseCode != null) {
            outbound.setResponseCode(responseCode.toString());
        }
        this.logRequestBody(message);
        if ("200".equalsIgnoreCase(outbound.getResponseCode())) {
            outbound.setRequestStatus("success");
        } else {
            outbound.setRequestStatus("failure");
        }
        outbound.setResponseTime(Long.valueOf(System.currentTimeMillis() - outbound.getRequestTime().getTime()));
        this.messagePublisher.message("invoke.outbound", (Object)new HapinterfaceBound(outbound));
    }

    protected void logRequestBody(Message message) {
        try {
            InputStream is = (InputStream)message.getContent(InputStream.class);
            if (is != null) {
                this.logInputStream(message, is);
            } else {
                Reader reader = (Reader)message.getContent(Reader.class);
                if (reader != null) {
                    this.logReader(message, reader);
                }
            }
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    protected void logRequestInfo(HapInterfaceInbound inbound, Message message) {
        String httpMethod = (String)message.get((Object)"org.apache.cxf.request.method");
        if (httpMethod != null) {
            inbound.setRequestMethod(httpMethod);
        }
        String uri = (String)message.get((Object)"org.apache.cxf.request.uri");
        HttpServletRequest http = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        if (uri != null) {
            if (http.getContextPath() != null) {
                uri = uri.replaceAll(http.getContextPath(), "");
            }
            inbound.setInterfaceUrl(uri);
            String query = (String)message.get((Object)Message.QUERY_STRING);
            if (query != null) {
                inbound.setRequestHeaderParameter(query);
            }
        }
        HapInvokeLogUtils.processRequestInfo((HapInterfaceInbound)inbound, (HttpServletRequest)http);
        Endpoint ep = message.getExchange().getEndpoint();
        EndpointInfo endpoint = ep.getEndpointInfo();
        ServiceInfo serviceInfo = endpoint.getService();
        String serviceName = "webService";
        if (serviceInfo != null && serviceInfo.getName() != null && StringUtils.isNotEmpty((CharSequence)serviceInfo.getName().getLocalPart())) {
            serviceName = serviceInfo.getName().getLocalPart();
        }
        inbound.setInterfaceName(serviceName);
    }

    protected void logInputStream(Message message, InputStream is) throws Exception {
        CachedOutputStream bos = new CachedOutputStream(HapInvokeOutInterceptor.DEFAULT_THRESHOLD);
        InputStream bis = is instanceof DelegatingInputStream ? ((DelegatingInputStream)is).getInputStream() : is;
        IOUtils.copy((InputStream)bis, (OutputStream)bos);
        bos.flush();
        bis = bos.getInputStream();
        HapInterfaceOutbound outbound = (HapInterfaceOutbound)message.getExchange().get((Object)"HAP_OUTBOUND");
        HapInterfaceInbound inbound = (HapInterfaceInbound)message.getExchange().get((Object)"HAP_INBOUND");
        if (inbound != null) {
            inbound.setRequestBodyParameter(IOUtils.toString((InputStream)bos.getInputStream()));
        } else if (outbound != null) {
            outbound.setResponseContent(IOUtils.toString((InputStream)bos.getInputStream()));
        }
        if (is instanceof DelegatingInputStream) {
            ((DelegatingInputStream)is).setInputStream(bis);
        } else {
            message.setContent(InputStream.class, (Object)bis);
        }
        bos.close();
    }

    protected void logReader(Message message, Reader reader) throws Exception {
        CachedWriter writer = new CachedWriter(HapInvokeOutInterceptor.DEFAULT_THRESHOLD);
        IOUtils.copyAndCloseInput((Reader)reader, (Writer)writer);
        message.setContent(Reader.class, (Object)writer.getReader());
        HapInterfaceOutbound outbound = (HapInterfaceOutbound)message.getExchange().get((Object)"HAP_OUTBOUND");
        HapInterfaceInbound inbound = (HapInterfaceInbound)message.getExchange().get((Object)"HAP_INBOUND");
        if (outbound == null) {
            inbound.setRequestBodyParameter(IOUtils.toString((Reader)writer.getReader()));
        } else {
            outbound.setResponseContent(IOUtils.toString((Reader)writer.getReader()));
        }
    }
}

