/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.service.impl;

import com.hand.hap.cache.impl.ResourceItemCache;
import com.hand.hap.cache.impl.ResourceItemElementCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.dto.ResourceItem;
import com.hand.hap.function.mapper.ResourceItemAssignMapper;
import com.hand.hap.function.mapper.ResourceItemElementMapper;
import com.hand.hap.function.mapper.ResourceItemMapper;
import com.hand.hap.function.mapper.RoleResourceItemMapper;
import com.hand.hap.function.service.IResourceItemService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResourceItemServiceImpl
extends BaseServiceImpl<ResourceItem>
implements IResourceItemService {
    @Autowired
    private ResourceItemMapper resourceItemMapper;
    @Autowired
    private RoleResourceItemMapper roleResourceItemMapper;
    @Autowired
    private ResourceItemCache resourceItemCache;
    @Autowired
    private ResourceItemElementMapper resourceItemElementMapper;
    @Autowired
    private ResourceItemAssignMapper resourceItemAssignMapper;
    @Autowired
    private ResourceItemElementCache resourceItemElementCache;

    @Transactional(rollbackFor={Exception.class})
    public ResourceItem insertSelective(IRequest request, @StdWho ResourceItem resourceItem) {
        if (null == resourceItem) {
            return null;
        }
        super.insertSelective(request, (Object)resourceItem);
        this.resourceItemCache.load(resourceItem.getOwnerResourceId().toString());
        return resourceItem;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResourceItem updateByPrimaryKey(IRequest request, ResourceItem resourceItem) {
        if (null == resourceItem) {
            return null;
        }
        super.updateByPrimaryKey(request, (Object)resourceItem);
        this.resourceItemCache.load(resourceItem.getOwnerResourceId().toString());
        return resourceItem;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<ResourceItem> selectResourceItems(IRequest request, Resource resource) {
        return this.resourceItemMapper.selectResourceItemsByResourceId(resource);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ResourceItem> batchUpdate(IRequest request, List<ResourceItem> resourceItems) {
        if (CollectionUtils.isEmpty(resourceItems)) {
            return resourceItems;
        }
        for (ResourceItem resourceItem : resourceItems) {
            if (resourceItem.getResourceItemId() == null) {
                ((IResourceItemService)this.self()).insertSelective(request, (Object)resourceItem);
                continue;
            }
            ((IResourceItemService)this.self()).updateByPrimaryKey(request, (Object)resourceItem);
        }
        return resourceItems;
    }

    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(IRequest requestContext, List<ResourceItem> resourceItems) {
        int result = 0;
        if (CollectionUtils.isEmpty(resourceItems)) {
            return result;
        }
        for (ResourceItem resourceItem : resourceItems) {
            int updateCount = this.resourceItemMapper.deleteByPrimaryKey((Object)resourceItem);
            this.checkOvn(updateCount, (Object)resourceItem);
            this.roleResourceItemMapper.deleteByResourceItemId(resourceItem.getResourceItemId());
            this.resourceItemAssignMapper.deleteByResourceItemId(resourceItem.getResourceItemId());
            this.resourceItemElementMapper.deleteByResourceItemId(resourceItem.getResourceItemId());
            this.resourceItemCache.load(resourceItem.getOwnerResourceId().toString());
            this.resourceItemElementCache.remove(resourceItem.getResourceItemId().toString());
            ++result;
        }
        return result;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public ResourceItem selectResourceItemByResourceIdAndItemId(ResourceItem resourceItem) {
        return this.resourceItemMapper.selectResourceItemByResourceIdAndItemId(resourceItem);
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteByResourceId(Resource resource) {
        int result = 0;
        List resourceItems = this.resourceItemMapper.selectResourceItemsByResourceId(resource);
        if (CollectionUtils.isNotEmpty((Collection)resourceItems)) {
            IRequest request = RequestHelper.newEmptyRequest();
            result = ((IResourceItemService)this.self()).batchDelete(request, resourceItems);
        }
        return result;
    }
}

