/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.service.impl;

import com.hand.hap.cache.impl.ResourceCustomizationCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.function.dto.ResourceCustomization;
import com.hand.hap.function.mapper.ResourceCustomizationMapper;
import com.hand.hap.function.service.IResourceCustomizationService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResourceCustomizationServiceImpl
extends BaseServiceImpl<ResourceCustomization>
implements IResourceCustomizationService {
    @Autowired
    private ResourceCustomizationMapper resourceCustomizationMapper;
    @Autowired
    private ResourceCustomizationCache resourceCustomizationCache;

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<ResourceCustomization> selectResourceCustomizationsByResourceId(Long resourceId) {
        return this.resourceCustomizationMapper.selectResourceCustomizationsByResourceId(resourceId);
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteByResourceId(Long resourceId) {
        int result = 0;
        List resourceCustomizations = this.resourceCustomizationMapper.selectResourceCustomizationsByResourceId(resourceId);
        if (CollectionUtils.isNotEmpty((Collection)resourceCustomizations)) {
            result = super.batchDelete(resourceCustomizations);
            this.resourceCustomizationCache.remove(((ResourceCustomization)resourceCustomizations.get(0)).getResourceId().toString());
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ResourceCustomization> batchUpdate(IRequest request, List<ResourceCustomization> list) {
        List result = super.batchUpdate(request, list);
        if (list.size() > 0) {
            this.resourceCustomizationCache.load(list.get(0).getResourceId().toString());
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(List<ResourceCustomization> list) {
        int size = super.batchDelete(list);
        if (list.size() > 0) {
            this.resourceCustomizationCache.load(list.get(0).getResourceId().toString());
        }
        return size;
    }
}

