/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.service.IResourceService;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/resource", "/api/sys/resource"})
public class ResourceController
extends BaseController {
    @Autowired
    private IResourceService resourceService;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData queryResource(HttpServletRequest request, Resource resource, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestContext = this.createRequestContext(request);
        Criteria criteria = new Criteria((Object)resource);
        criteria.select(new String[]{"resourceId", "url", "type", "name", "loginRequire", "accessCheck", "description"});
        criteria.selectExtensionAttribute();
        return new ResponseData(this.resourceService.selectOptions(requestContext, (Object)resource, criteria, Integer.valueOf(page), Integer.valueOf(pagesize)));
    }

    @PostMapping(value={"/submit"})
    public ResponseData submitResource(HttpServletRequest request, @RequestBody List<Resource> resources, BindingResult result) throws BaseException {
        this.getValidator().validate(resources, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.resourceService.batchUpdate(requestContext, resources));
    }

    @PostMapping(value={"/remove"})
    public ResponseData removeResource(HttpServletRequest request, @RequestBody List<Resource> resources) throws BaseException {
        IRequest requestContext = this.createRequestContext(request);
        this.resourceService.batchDelete(requestContext, resources);
        return new ResponseData();
    }
}

