/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.flexfield.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.flexfield.dto.FlexRule;
import com.hand.hap.flexfield.dto.FlexRuleSet;
import com.hand.hap.flexfield.mapper.FlexRuleMapper;
import com.hand.hap.flexfield.mapper.FlexRuleSetMapper;
import com.hand.hap.flexfield.service.IFlexRuleService;
import com.hand.hap.flexfield.service.IFlexRuleSetService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FlexRuleSetServiceImpl
extends BaseServiceImpl<FlexRuleSet>
implements IFlexRuleSetService {
    @Autowired
    FlexRuleSetMapper flexRuleSetMapper;
    @Autowired
    FlexRuleMapper flexRuleMapper;
    @Autowired
    IFlexRuleService iFlexRuleService;

    public List<FlexRuleSet> queryFlexModel(FlexRuleSet model, int page, int pageSize) {
        PageHelper.startPage((int)page, (int)pageSize);
        return this.flexRuleSetMapper.queryFlexRuleSet(model);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteRuleSet(List<FlexRuleSet> flexRuleSets) {
        for (FlexRuleSet ruleSet : flexRuleSets) {
            FlexRule flexRule = new FlexRule();
            flexRule.setRuleSetId(ruleSet.getRuleSetId());
            List flexRules = this.flexRuleMapper.select((Object)flexRule);
            this.iFlexRuleService.deleteRule(flexRules);
            int updateCount = this.flexRuleSetMapper.delete((Object)ruleSet);
            this.checkOvn(updateCount, (Object)ruleSet);
        }
    }
}

