/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.flexfield.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hand.hap.core.IRequest;
import com.hand.hap.flexfield.dto.FlexRule;
import com.hand.hap.flexfield.dto.FlexRuleDetail;
import com.hand.hap.flexfield.dto.FlexRuleField;
import com.hand.hap.flexfield.dto.WarpFlexRuleField;
import com.hand.hap.flexfield.mapper.FlexRuleDetailMapper;
import com.hand.hap.flexfield.mapper.FlexRuleFieldMapper;
import com.hand.hap.flexfield.mapper.FlexRuleMapper;
import com.hand.hap.flexfield.service.IFlexRuleService;
import com.hand.hap.generator.service.impl.FileUtil;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.Lov;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.ILovService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class FlexRuleServiceImpl
extends BaseServiceImpl<FlexRule>
implements IFlexRuleService {
    @Autowired
    FlexRuleMapper ruleMapper;
    @Autowired
    FlexRuleFieldMapper fieldMapper;
    @Autowired
    FlexRuleDetailMapper flexRuleDetailMapper;
    @Autowired
    FlexRuleFieldMapper FlexRuleFieldMapper;
    ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    ILovService lovService;

    public ResponseData matchingRule(String ruleSetCode, Set<Map.Entry<String, String>> model, IRequest iRequest) {
        List flexRules = this.ruleMapper.matchingRule(ruleSetCode);
        Iterator iterator = flexRules.iterator();
        FlexRule baseFlex = null;
        while (iterator.hasNext()) {
            FlexRule fl = (FlexRule)iterator.next();
            if (!fl.getRuleCode().equals("_GLOBAL_FLEX_RULE")) continue;
            baseFlex = fl;
            iterator.remove();
            break;
        }
        if (!flexRules.isEmpty()) {
            FlexRule flexRule = flexRules.stream().filter(flexRule1 -> this.matching(flexRule1, model)).max(Comparator.comparing(flexRule2 -> flexRule2.getFlexRuleDetailList().size())).orElseGet(() -> new FlexRule());
            if (null != flexRule.getRuleId()) {
                FlexRuleField flexRuleField = new FlexRuleField();
                flexRuleField.setRuleId(flexRule.getRuleId());
                List flexRuleFields = this.fieldMapper.queryFlexField(flexRuleField);
                if (null != baseFlex) {
                    flexRuleField.setRuleId(baseFlex.getRuleId());
                    flexRuleFields.addAll(this.fieldMapper.queryFlexField(flexRuleField));
                }
                return new ResponseData(this.classify(flexRuleFields));
            }
        } else if (null != baseFlex) {
            FlexRuleField flexRuleField = new FlexRuleField();
            flexRuleField.setRuleId(baseFlex.getRuleId());
            return new ResponseData(this.classify(this.fieldMapper.queryFlexField(flexRuleField)));
        }
        return new ResponseData();
    }

    public void matchingLovField(String ruleSetCode, Set<Map.Entry<String, String>> model, Object o, IRequest iRequest) throws IllegalAccessException, IOException, InvocationTargetException, NoSuchMethodException {
        FlexRule flexRule;
        List flexRules = this.ruleMapper.matchingRule(ruleSetCode);
        if (!flexRules.isEmpty() && null != (flexRule = flexRules.stream().filter(flexRule1 -> this.matching(flexRule1, model)).max(Comparator.comparing(flexRule2 -> flexRule2.getFlexRuleDetailList().size())).orElseGet(() -> new FlexRule())).getRuleId()) {
            FlexRuleField flexRuleField = new FlexRuleField();
            flexRuleField.setRuleId(flexRule.getRuleId());
            List fields = this.fieldMapper.queryFlexField(flexRuleField);
            for (int i = 0; i < fields.size(); ++i) {
                this.getLovField((FlexRuleField)fields.get(i), o, iRequest);
            }
        }
    }

    public void getLovField(FlexRuleField flexRuleField, Object o, IRequest iRequest) throws IOException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        ObjectNode description = (ObjectNode)this.objectMapper.readValue(flexRuleField.getFieldType(), ObjectNode.class);
        if ("LOV".equals(description.get("type").asText())) {
            String lovCode = description.get("conditionFieldLovCode").asText();
            String text = description.get("conditionFieldSelectTf").asText();
            text = text.substring(text.indexOf(".") + 1);
            String objectValue = BeanUtils.getProperty((Object)o, (String)FileUtil.columnToCamel((String)flexRuleField.getColumnName()));
            if (null != objectValue) {
                Lov lov = new Lov();
                lov.setCode(lovCode);
                lov = (Lov)this.lovService.select(iRequest, (Object)lov, 1, 5).get(0);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(lov.getValueField(), objectValue);
                List list = this.lovService.selectDatas(iRequest, lovCode, map, 1, 10);
                BaseDTO dto = (BaseDTO)o;
                if (list.size() != 0) {
                    Object o1 = list.get(0);
                    String val = BeanUtils.getProperty(o1, (String)lov.getTextField());
                    dto.setAttribute(text, (Object)val);
                } else {
                    dto.setAttribute(text, (Object)"");
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteRule(List<FlexRule> flexRules) {
        for (FlexRule flexRule : flexRules) {
            FlexRuleDetail ruleDetail = new FlexRuleDetail();
            FlexRuleField ruleField = new FlexRuleField();
            ruleField.setRuleId(flexRule.getRuleId());
            ruleDetail.setRuleId(flexRule.getRuleId());
            this.flexRuleDetailMapper.delete((Object)ruleDetail);
            this.FlexRuleFieldMapper.delete((Object)ruleField);
            int updateCount = this.ruleMapper.delete((Object)flexRule);
            this.checkOvn(updateCount, (Object)flexRule);
        }
    }

    private List<WarpFlexRuleField> classify(List<FlexRuleField> flexRuleFields) {
        ArrayList<WarpFlexRuleField> warpFlexRuleFields = new ArrayList<WarpFlexRuleField>();
        flexRuleFields.stream().collect(Collectors.groupingBy(FlexRuleField::getFieldColumnNumber)).forEach((k, v) -> {
            WarpFlexRuleField warpFlexRuleField = new WarpFlexRuleField();
            warpFlexRuleFields.add(warpFlexRuleField.warpField(v));
        });
        return warpFlexRuleFields;
    }

    public static void setPrompt(WarpFlexRuleField warpFlexRuleField, Locale locale, MessageSource messageSource) {
        warpFlexRuleField.getFields().forEach(v -> FlexRuleServiceImpl.doSetPrompt((FlexRuleField)v, (Locale)locale, (MessageSource)messageSource));
    }

    private static void doSetPrompt(FlexRuleField flexRuleField, Locale locale, MessageSource messageSource) {
        JSONObject josn = JSONObject.fromObject((Object)flexRuleField.getFieldType());
        String name = messageSource.getMessage(josn.get("labelName").toString(), null, locale);
        if (!StringUtil.isEmpty((CharSequence)name)) {
            josn.put((Object)"labelName", (Object)name);
            flexRuleField.setFieldType(josn.toString());
        }
    }

    private boolean matching(FlexRule flexRule, Set<Map.Entry<String, String>> model) {
        boolean result = false;
        List flexRuleDetails = flexRule.getFlexRuleDetailList();
        int sameNumber = 0;
        block0: for (FlexRuleDetail flexRuleDetail1 : flexRuleDetails) {
            for (Map.Entry<String, String> entry : model) {
                if (null == entry.getValue() || !flexRuleDetail1.getFieldValue().equalsIgnoreCase(entry.getValue().toString()) || !flexRuleDetail1.getFieldName().equalsIgnoreCase(entry.getKey().toString())) continue;
                ++sameNumber;
                continue block0;
            }
        }
        if (sameNumber == flexRuleDetails.size()) {
            result = true;
        }
        return result;
    }
}

